/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model.dao;

import com.dev63.restoran.db.exception.IllegalSingletoneEmStateException;
import com.dev63.restoran.jpa.JPAUtil;
import com.dev63.restoran.jpa.SingletonEmReference;
import com.dev63.restoran.jpa.ThreadLocalEntityManager;
import com.dev63.restoran.jpa.query.NativeQueryParam;
import com.dev63.restoran.jpa.query.QueryParam;
import com.dev63.restoran.jpa.query.TemporalQueryParam;
import com.dev63.restoran.model.EntityObject;
import com.dev63.restoran.model.dao.internal.BatchMergeActivity;
import com.dev63.restoran.model.dao.internal.BatchMergeAndRefreshActivity;
import com.dev63.restoran.model.dao.internal.BatchPersistActivity;
import com.dev63.restoran.model.dao.internal.BatchRemoveActivity;
import com.dev63.restoran.model.dao.internal.MergeActivity;
import com.dev63.restoran.model.dao.internal.MergeAndRefreshActivity;
import com.dev63.restoran.model.dao.internal.PersistActivity;
import com.dev63.restoran.model.dao.internal.RemoveActivity;
import com.dev63.restoran.model.dao.internal.TransactionalActivity;
import com.dev63.restoran.model.dao.internal.TransactionalBatchActivity;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public abstract class EntityDAO<T extends EntityObject>
implements AutoCloseable {
    protected Class<T> entityType;
    protected static Integer MAX_BATCH_SIZE = 500;
    protected EntityManagerFactory emf;
    protected SingletonEmReference singletonEmReference;
    protected final ThreadLocalEntityManager sessionEm;
    protected final Set<EntityManager> createdEmInstances;
    protected final boolean localSessionEm;

    private EntityManager handleIllegalSingletoneEmStateException(IllegalSingletoneEmStateException isesex, SingletonEmReference singletonEmReference) throws IllegalSingletoneEmStateException {
        throw isesex;
    }

    protected EntityDAO(Class<T> entityType, EntityManagerFactory emf, SingletonEmReference singletonEmReference) {
        if (emf == null) {
            throw new IllegalArgumentException("emf is null");
        }
        if (singletonEmReference == null) {
            throw new IllegalArgumentException("singletonEmReference is null");
        }
        if (entityType == null) {
            throw new IllegalArgumentException("entityType is null");
        }
        this.entityType = entityType;
        this.emf = emf;
        this.singletonEmReference = singletonEmReference;
        this.sessionEm = new ThreadLocalEntityManager(emf);
        this.localSessionEm = true;
        this.createdEmInstances = new HashSet<EntityManager>();
    }

    protected EntityDAO(Class<T> entityType, EntityManagerFactory emf, SingletonEmReference singletonEmReference, ThreadLocalEntityManager sessioneEm) {
        if (emf == null) {
            throw new IllegalArgumentException("emf is null");
        }
        if (singletonEmReference == null) {
            throw new IllegalArgumentException("singletonEmReference is null");
        }
        if (entityType == null) {
            throw new IllegalArgumentException("entityType is null");
        }
        this.entityType = entityType;
        this.emf = emf;
        this.singletonEmReference = singletonEmReference;
        this.sessionEm = sessioneEm;
        this.localSessionEm = true;
        this.createdEmInstances = new HashSet<EntityManager>();
    }

    protected Class<T> getEntityType() {
        return this.entityType;
    }

    protected EntityManager getSingletonEm() {
        try {
            return this.singletonEmReference.get();
        }
        catch (IllegalSingletoneEmStateException isesex) {
            return this.handleIllegalSingletoneEmStateException(isesex, this.singletonEmReference);
        }
    }

    protected EntityManager getEm() {
        EntityManager em = this.emf.createEntityManager();
        this.createdEmInstances.add(em);
        return em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T findByIdInternal(Serializable id, EMScope scope) {
        EntityManager em = this.getEmForScope(scope);
        try {
            EntityObject entityObject = (EntityObject)em.find(this.getEntityType(), (Object)id);
            return (T)entityObject;
        }
        finally {
            this.cleanUpEm(em, scope, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<T> findAllInternal(EMScope scope) {
        EntityManager em = this.getEmForScope(scope);
        try {
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(this.getEntityType());
            Root rootEntry = cq.from(this.getEntityType());
            CriteriaQuery all = cq.select((Selection)rootEntry);
            TypedQuery allQuery = em.createQuery(all);
            List list = allQuery.getResultList();
            return list;
        }
        finally {
            this.cleanUpEm(em, scope, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> R executeTransactionalActivity(T t, TransactionalActivity<T, R> ta, EMScope scope) {
        EntityManager em = this.getEmForScope(scope);
        boolean internallyManagedTransaction = !em.getTransaction().isActive();
        EntityManager entityManager = em;
        synchronized (entityManager) {
            R result;
            try {
                if (internallyManagedTransaction) {
                    em.getTransaction().begin();
                }
                result = ta.execute(em, t);
                if (internallyManagedTransaction) {
                    em.getTransaction().commit();
                } else {
                    em.flush();
                }
            }
            finally {
                this.cleanUpEm(em, scope, internallyManagedTransaction);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> R executeTransactionalBatchActivity(List<T> entities, TransactionalBatchActivity<T, R> ta, EMScope scope) {
        R result;
        EntityManager em = this.getEmForScope(scope);
        boolean internallyManagedTransaction = !em.getTransaction().isActive();
        EntityManager entityManager = em;
        synchronized (entityManager) {
            try {
                if (internallyManagedTransaction) {
                    em.getTransaction().begin();
                }
                result = ta.executeBatch(entities, em, null);
                if (internallyManagedTransaction) {
                    em.getTransaction().commit();
                } else {
                    em.flush();
                }
            }
            finally {
                this.cleanUpEm(em, scope, internallyManagedTransaction);
            }
        }
        return result;
    }

    protected void persistInternal(T entity, EMScope scope) {
        if (entity == null) {
            return;
        }
        this.executeTransactionalActivity(entity, new PersistActivity(), scope);
    }

    protected void batchPersistInternal(List<T> entities, EMScope scope) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        this.executeTransactionalBatchActivity(entities, new BatchPersistActivity(), scope);
    }

    protected T mergeInternal(T entity, EMScope scope) {
        if (entity == null) {
            return entity;
        }
        return (T)((EntityObject)this.executeTransactionalActivity(entity, new MergeActivity(), scope));
    }

    protected List<T> batchMergeInternal(List<T> entities, EMScope scope) {
        if (entities == null || entities.isEmpty()) {
            return entities;
        }
        return (List)this.executeTransactionalBatchActivity(entities, new BatchMergeActivity(), scope);
    }

    protected T mergeAndRefreshInternal(T entity, EMScope scope) {
        if (entity == null) {
            return entity;
        }
        return (T)((EntityObject)this.executeTransactionalActivity(entity, new MergeAndRefreshActivity(), scope));
    }

    protected List<T> batchMergeAndRefreshInternal(List<T> entities, EMScope scope) {
        if (entities == null || entities.isEmpty()) {
            return entities;
        }
        return (List)this.executeTransactionalBatchActivity(entities, new BatchMergeAndRefreshActivity(), scope);
    }

    protected void removeInternal(T entity, EMScope scope) {
        if (entity == null) {
            return;
        }
        this.executeTransactionalActivity(entity, new RemoveActivity(), scope);
    }

    protected void batchRemoveInternal(List<T> entities, EMScope scope) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        this.executeTransactionalBatchActivity(entities, new BatchRemoveActivity(), scope);
    }

    protected <Q extends Query> Q setNamedQueryParams(Q query, QueryParam ... params) {
        for (QueryParam param : params) {
            if (param instanceof TemporalQueryParam) {
                TemporalQueryParam tqp = (TemporalQueryParam)((Object)param);
                TemporalType temporalType = tqp.getTemporalType();
                if (temporalType != null) {
                    Comparable<Calendar> value;
                    if (Calendar.class.equals(param.getParameterType())) {
                        QueryParam calParam = param;
                        value = (Calendar)calParam.getValue();
                        query.setParameter(calParam.getName(), value, temporalType);
                        continue;
                    }
                    if (Date.class.equals(param.getParameterType())) {
                        QueryParam dateParam = param;
                        value = (Date)dateParam.getValue();
                        query.setParameter(dateParam.getName(), (Date)value, temporalType);
                        continue;
                    }
                    query.setParameter(param.getName(), param.getValue());
                    continue;
                }
                query.setParameter(param.getName(), param.getValue());
                continue;
            }
            query.setParameter(param.getName(), param.getValue());
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> List<R> executeNamedQueryInternal(EMScope scope, Class<R> resultClass, String queryName, QueryParam ... params) {
        EntityManager em = this.getEmForScope(scope);
        try {
            TypedQuery tq = em.createNamedQuery(queryName, resultClass);
            if (params != null) {
                this.setNamedQueryParams(tq, params);
            }
            List list = tq.getResultList();
            return list;
        }
        finally {
            this.cleanUpEm(em, scope, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> R executeNamedQueryWithSingleResultInternal(EMScope scope, Class<R> resultClass, String queryName, QueryParam ... params) {
        EntityManager em = this.getEmForScope(scope);
        try {
            TypedQuery tq = em.createNamedQuery(queryName, resultClass);
            if (params != null) {
                this.setNamedQueryParams(tq, params);
            }
            Object object = tq.getSingleResult();
            return (R)object;
        }
        finally {
            this.cleanUpEm(em, scope, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> R executeNativeQueryWithSingleResultInternal(EMScope scope, Class<R> resultClass, String queryString, NativeQueryParam ... params) {
        EntityManager em = this.getEmForScope(scope);
        try {
            Query query = this.createNativeQueryInternal(em, resultClass, queryString, params);
            Object object = query.getSingleResult();
            return (R)object;
        }
        finally {
            this.cleanUpEm(em, scope, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> List<R> executeNativeQueryInternal(EMScope scope, Class<R> resultClass, String queryString, NativeQueryParam ... params) {
        EntityManager em = this.getEmForScope(scope);
        try {
            Query query = this.createNativeQueryInternal(em, resultClass, queryString, params);
            List list = query.getResultList();
            return list;
        }
        finally {
            this.cleanUpEm(em, scope, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeNativeQueryUpdateInternal(EMScope scope, String queryString, NativeQueryParam ... params) {
        EntityManager em = this.getEmForScope(scope);
        boolean internallyManagedTransaction = !em.getTransaction().isActive();
        try {
            Query query = this.createNativeQueryInternal(em, null, queryString, params);
            if (internallyManagedTransaction) {
                em.getTransaction().begin();
            }
            int executeUpdate = query.executeUpdate();
            if (internallyManagedTransaction) {
                em.getTransaction().commit();
            } else {
                em.flush();
            }
            int n = executeUpdate;
            return n;
        }
        finally {
            this.cleanUpEm(em, scope, internallyManagedTransaction);
        }
    }

    protected <R> Query createNativeQueryInternal(EntityManager em, Class<R> resultClass, String queryString, NativeQueryParam ... params) {
        Query query = resultClass == null ? em.createNativeQuery(queryString) : em.createNativeQuery(queryString, resultClass);
        if (params != null) {
            for (NativeQueryParam param : params) {
                if (param instanceof TemporalQueryParam) {
                    TemporalQueryParam tqp = (TemporalQueryParam)((Object)param);
                    TemporalType temporalType = tqp.getTemporalType();
                    if (temporalType != null) {
                        Comparable<Calendar> value;
                        if (Calendar.class.equals(param.getParameterType())) {
                            NativeQueryParam calParam = param;
                            value = (Calendar)calParam.getValue();
                            query.setParameter(calParam.getPosition().intValue(), value, temporalType);
                            continue;
                        }
                        if (Date.class.equals(param.getParameterType())) {
                            NativeQueryParam dateParam = param;
                            value = (Date)dateParam.getValue();
                            query.setParameter(dateParam.getPosition().intValue(), (Date)value, temporalType);
                            continue;
                        }
                        query.setParameter((Parameter)param, param.getValue());
                        continue;
                    }
                    query.setParameter((Parameter)param, param.getValue());
                    continue;
                }
                query.setParameter((Parameter)param, param.getValue());
            }
        }
        return query;
    }

    protected T refreshEntityInSingleton(T entity) {
        try {
            return this.refreshEntityInEm(entity, this.getSingletonEm());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    protected T refreshEntityInSession(T entity) {
        return this.refreshEntityInEm(entity, this.sessionEm);
    }

    protected T refreshEntityInEm(T entity, EntityManager em) {
        if (entity == null) {
            return null;
        }
        try {
            if (!em.contains(entity)) {
                entity = (EntityObject)em.getReference(this.getEntityType(), entity.getId());
            }
            if (entity == null) {
                return null;
            }
            em.refresh(entity);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return entity;
    }

    protected T refreshEntity(T entity, EMScope scope) {
        switch (scope) {
            case ACTION: {
                return this.refreshEntityInSession(entity);
            }
            case SESSION: {
                return this.refreshEntityInSingleton(entity);
            }
        }
        return entity;
    }

    protected void detachEntityInSingleton(EntityObject entity) {
        try {
            this.detachEntityInEm(entity, this.getSingletonEm());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    protected void detachEntityInSession(EntityObject entity) {
        this.detachEntityInEm(entity, this.sessionEm);
    }

    protected void detachEntityInEm(EntityObject entity, EntityManager em) {
        if (entity == null) {
            return;
        }
        try {
            if (!em.contains((Object)entity)) {
                entity = (EntityObject)em.getReference(entity.getClass(), entity.getId());
            }
            em.detach((Object)entity);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    protected void detachEntity(EntityObject entity, EMScope scope) {
        switch (scope) {
            case ACTION: {
                this.detachEntityInSession(entity);
            }
            case SESSION: {
                this.detachEntityInSingleton(entity);
            }
        }
    }

    protected void closeEm(EntityManager em) {
        try {
            JPAUtil.closeEm(em);
            this.createdEmInstances.remove(em);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    protected void cleanUpEm(EntityManager em, EMScope scope, boolean checkTransaction) {
        switch (scope) {
            case ACTION: {
                this.closeEm(em);
                break;
            }
            default: {
                if (!checkTransaction) break;
                JPAUtil.safeCloseTransaction(em);
            }
        }
    }

    protected EntityManager getEmForScope(EMScope scope) {
        EntityManager em;
        switch (scope) {
            case SINGLETON: {
                em = this.getSingletonEm();
                break;
            }
            case SESSION: {
                em = this.sessionEm;
                break;
            }
            default: {
                em = this.getEm();
            }
        }
        return em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void flushInternal(EMScope scope) {
        switch (scope) {
            case SESSION: 
            case SINGLETON: {
                EntityManager em = this.getEmForScope(scope);
                if (!em.getTransaction().isActive()) {
                    EntityManager entityManager = em;
                    // MONITORENTER : entityManager
                    try {
                        em.getTransaction().begin();
                        em.flush();
                        em.getTransaction().commit();
                        return;
                    }
                    finally {
                        this.cleanUpEm(em, scope, true);
                    }
                }
                em.flush();
                return;
            }
        }
    }

    public T findById(Serializable id) {
        return this.findByIdInternal(id, EMScope.ACTION);
    }

    public T findByIdFromSingleton(Serializable id) throws IllegalSingletoneEmStateException {
        return this.findByIdInternal(id, EMScope.SINGLETON);
    }

    public T findByIdFromSession(Serializable id) throws IllegalSingletoneEmStateException {
        return this.findByIdInternal(id, EMScope.SESSION);
    }

    public List<T> findAll() {
        return this.findAllInternal(EMScope.ACTION);
    }

    public List<T> findAllFromSingleton() throws IllegalSingletoneEmStateException {
        return this.findAllInternal(EMScope.SINGLETON);
    }

    public List<T> findAllFromSession() throws IllegalSingletoneEmStateException {
        return this.findAllInternal(EMScope.SESSION);
    }

    public void persist(T entity) {
        this.persistInternal(entity, EMScope.ACTION);
    }

    public void persistInSingleton(T entity) throws IllegalSingletoneEmStateException {
        this.persistInternal(entity, EMScope.SINGLETON);
    }

    public void persistInSession(T entity) throws IllegalSingletoneEmStateException {
        this.persistInternal(entity, EMScope.SESSION);
    }

    public void batchPersist(List<T> entities) {
        this.batchPersistInternal(entities, EMScope.ACTION);
    }

    public void batchPersistInSingleton(List<T> entities) throws IllegalSingletoneEmStateException {
        this.batchPersistInternal(entities, EMScope.SINGLETON);
    }

    public void batchPersistInSession(List<T> entities) throws IllegalSingletoneEmStateException {
        this.batchPersistInternal(entities, EMScope.SESSION);
    }

    public T merge(T entity) {
        return this.mergeInternal(entity, EMScope.ACTION);
    }

    public T mergeInSingleton(T entity) throws IllegalSingletoneEmStateException {
        return this.mergeInternal(entity, EMScope.SINGLETON);
    }

    public T mergeInSession(T entity) throws IllegalSingletoneEmStateException {
        return this.mergeInternal(entity, EMScope.SESSION);
    }

    public List<T> batchMerge(List<T> entities) {
        return this.batchMergeInternal(entities, EMScope.ACTION);
    }

    public List<T> batchMergeInSingleton(List<T> entities) throws IllegalSingletoneEmStateException {
        return this.batchMergeInternal(entities, EMScope.SINGLETON);
    }

    public List<T> batchMergeInSession(List<T> entities) throws IllegalSingletoneEmStateException {
        return this.batchMergeInternal(entities, EMScope.SESSION);
    }

    public void remove(T entity) {
        this.removeInternal(entity, EMScope.ACTION);
    }

    public void removeInSingleton(T entity) throws IllegalSingletoneEmStateException {
        this.removeInternal(entity, EMScope.SINGLETON);
    }

    public void removeInSession(T entity) throws IllegalSingletoneEmStateException {
        this.removeInternal(entity, EMScope.SESSION);
    }

    public void batchRemove(List<T> entities) {
        this.batchRemoveInternal(entities, EMScope.ACTION);
    }

    public void batchRemoveInSingleton(List<T> entities) throws IllegalSingletoneEmStateException {
        this.batchRemoveInternal(entities, EMScope.SINGLETON);
    }

    public void batchRemoveInSession(List<T> entities) throws IllegalSingletoneEmStateException {
        this.batchRemoveInternal(entities, EMScope.SESSION);
    }

    public <R> List<R> executeNamedQuery(Class<R> resultClass, String queryName, QueryParam ... params) {
        return this.executeNamedQueryInternal(EMScope.ACTION, resultClass, queryName, params);
    }

    public <R> List<R> executeNamedQueryInSingleton(Class<R> resultClass, String queryName, QueryParam ... params) throws IllegalSingletoneEmStateException {
        return this.executeNamedQueryInternal(EMScope.SINGLETON, resultClass, queryName, params);
    }

    public <R> List<R> executeNamedQueryInSession(Class<R> resultClass, String queryName, QueryParam ... params) {
        return this.executeNamedQueryInternal(EMScope.SESSION, resultClass, queryName, params);
    }

    public <R> R executeNamedQueryWithSingleResult(Class<R> resultClass, String queryName, QueryParam ... params) {
        return this.executeNamedQueryWithSingleResultInternal(EMScope.ACTION, resultClass, queryName, params);
    }

    public <R> R executeNamedQueryWithSingleResultInSingleton(Class<R> resultClass, String queryName, QueryParam ... params) throws IllegalSingletoneEmStateException {
        return this.executeNamedQueryWithSingleResultInternal(EMScope.SINGLETON, resultClass, queryName, params);
    }

    public <R> R executeNamedQueryWithSingleResultInSession(Class<R> resultClass, String queryName, QueryParam ... params) {
        return this.executeNamedQueryWithSingleResultInternal(EMScope.SESSION, resultClass, queryName, params);
    }

    public <R> R executeNativeQueryWithSingleResult(Class<R> resultClass, String queryName, NativeQueryParam ... params) {
        return this.executeNativeQueryWithSingleResultInternal(EMScope.ACTION, resultClass, queryName, params);
    }

    public <R> R executeNativeQueryWithSingleResultInSingleton(Class<R> resultClass, String queryName, NativeQueryParam ... params) throws IllegalSingletoneEmStateException {
        return this.executeNativeQueryWithSingleResultInternal(EMScope.SINGLETON, resultClass, queryName, params);
    }

    public <R> R executeNativeQueryWithSingleResultInSession(Class<R> resultClass, String queryName, NativeQueryParam ... params) {
        return this.executeNativeQueryWithSingleResultInternal(EMScope.SESSION, resultClass, queryName, params);
    }

    public int executeNativeQueryUpdate(String query, NativeQueryParam ... params) {
        return this.executeNativeQueryUpdateInternal(EMScope.ACTION, query, params);
    }

    public int executeNativeQueryUpdateInSingleton(String query, NativeQueryParam ... params) throws IllegalSingletoneEmStateException {
        return this.executeNativeQueryUpdateInternal(EMScope.SINGLETON, query, params);
    }

    public int executeNativeQueryUpdateInSession(String query, NativeQueryParam ... params) {
        return this.executeNativeQueryUpdateInternal(EMScope.SESSION, query, params);
    }

    public T refreshInSingleton(T entity) throws IllegalSingletoneEmStateException {
        return this.refreshEntityInSingleton(entity);
    }

    public T refreshInSession(T entity) {
        return this.refreshEntityInSession(entity);
    }

    public void flushSingletone() {
        this.flushInternal(EMScope.SINGLETON);
    }

    public void flushSession() {
        this.flushInternal(EMScope.SESSION);
    }

    public void startSessionTransaction() {
        if (!this.sessionEm.getTransaction().isActive()) {
            this.sessionEm.getTransaction().begin();
        }
    }

    public void commitSessionTransaction() {
        this.sessionEm.getTransaction().commit();
    }

    public void rollbackSessionTransaction() {
        this.sessionEm.getTransaction().rollback();
    }

    public void setRollBackOnlySessionTransaction() {
        this.sessionEm.getTransaction().setRollbackOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.sessionEm != null && this.localSessionEm) {
            ThreadLocalEntityManager threadLocalEntityManager = this.sessionEm;
            synchronized (threadLocalEntityManager) {
                this.sessionEm.close();
            }
        }
        Iterator<EntityManager> it = this.createdEmInstances.iterator();
        while (it.hasNext()) {
            EntityManager entityManager = it.next();
            JPAUtil.closeEmQuiet(entityManager);
            it.remove();
        }
    }

    protected static enum EMScope {
        SINGLETON,
        SESSION,
        ACTION;

    }
}

