/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model;

import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Tura;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TuraGet {
    public static List<Tura> getTureRastavljanjeQuery(Integer sto, RestoranServer server) {
        String query = "SELECT * FROM tura t WHERE t.brojStola = ? AND t.RACUN_ID IS NULL";
        ArrayList<Tura> ture = new ArrayList<Tura>();
        try {
            PreparedStatement ps = server.getConnection().prepareStatement(query);
            ps.setInt(1, sto);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Tura tura = new Tura();
                tura.setId(rs.getLong("id"));
                tura.setREZERVACIJA_ID(rs.getLong("REZERVACIJA_ID"));
                tura.setBrojStola(rs.getInt("brojStola"));
                tura.setBrojTure(rs.getInt("brojTure"));
                tura.setDatum(rs.getTimestamp("datum"));
                tura.setPripremljena(rs.getBoolean("pripremljena"));
                tura.setuPripremi(rs.getBoolean("uPripremi"));
                tura.setPocetak(rs.getTimestamp("pocetak"));
                tura.setKraj(rs.getTimestamp("kraj"));
                tura.setNapomena(rs.getString("napomena"));
                tura.setProcitana(rs.getBoolean("procitana"));
                tura.setSaStola(rs.getString("saStola"));
                tura.setStavke(TuraGet.getStavkeRacunaQuery(tura.getId(), server));
                ture.add(tura);
            }
            return ture;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<StavkaRacuna> getStavkeRacunaQuery(long turaId, RestoranServer server) {
        String query = "SELECT * FROM stavkaracuna sr WHERE sr.TURA_ID =? ";
        ArrayList<StavkaRacuna> stavke = new ArrayList<StavkaRacuna>();
        try {
            PreparedStatement ps = server.getConnection().prepareStatement(query);
            ps.setLong(1, turaId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                StavkaRacuna stavka = new StavkaRacuna();
                stavka.setId(rs.getLong("id"));
                stavka.setBrojStola(rs.getInt("brojStola"));
                stavka.setCena(rs.getDouble("cena"));
                stavka.setKolicina(rs.getDouble("kolicina"));
                stavka.setNaziv(rs.getString("naziv"));
                stavka.setArtikal(server.getArtikal(rs.getLong("ARTIKAL_ID")));
                if (rs.getLong("GLAVNASTAVKA_ID") > 0L) {
                    stavka.setGlavnaStavka(TuraGet.getGlavnaStavka(rs.getLong("GLAVNASTAVKA_ID"), server));
                }
                stavka.setPocetak(rs.getTimestamp("pocetak"));
                stavka.setKraj(rs.getTimestamp("kraj"));
                stavka.setOpis(rs.getString("opis"));
                stavke.add(stavka);
            }
            return stavke;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static StavkaRacuna getGlavnaStavka(long stavkaId, RestoranServer server) {
        String query = "SELECT * FROM stavkaracuna sr WHERE sr.id =? ";
        try {
            PreparedStatement ps = server.getConnection().prepareStatement(query);
            ps.setLong(1, stavkaId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            StavkaRacuna stavka = new StavkaRacuna();
            stavka.setId(rs.getLong("id"));
            stavka.setBrojStola(rs.getInt("brojStola"));
            stavka.setCena(rs.getDouble("cena"));
            stavka.setKolicina(rs.getDouble("kolicina"));
            stavka.setNaziv(rs.getString("naziv"));
            stavka.setArtikal(server.getArtikal(rs.getLong("ARTIKAL_ID")));
            stavka.setPocetak(rs.getTimestamp("pocetak"));
            stavka.setKraj(rs.getTimestamp("kraj"));
            stavka.setOpis(rs.getString("opis"));
            return stavka;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

