/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model;

import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.BObject;
import com.dev63.restoran.model.HacapMagacini;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.model.Trebovanje;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class TrebovanjeStavka
extends BObject
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.REFRESH})
    private Artikal artikal;
    private Double kolicina;
    private Double komad;
    private Double komadBPDV;
    private Double rabat;
    private Double komBPDVsaRbt;
    private Double ukupno;
    private Double ukupnoBPDV;
    private Double pdv;
    private Double prodajnaVrednost;
    @Column
    private Integer redniBroj;
    @ManyToOne(optional=false, cascade={CascadeType.DETACH, CascadeType.REFRESH, CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(nullable=true)
    private Trebovanje trebovanje;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    private PrijemnicaStavka stavkaPrijemnice;
    private String hacapTemp;
    private Boolean usaglaseno;
    @ManyToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private HacapMagacini hacapMagacin;
    private String korektivnaMera;
    private static int pcInheritedFieldCount = BObject.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$BObject;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Artikal;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$HacapMagacini;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Double;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$PrijemnicaStavka;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Trebovanje;
    static /* synthetic */ Class class$Ljava$lang$Boolean;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$TrebovanjeStavka;

    @Override
    public int hashCode() {
        int hash = 0;
        return hash += BObject.pcGetid(this) != null ? BObject.pcGetid(this).hashCode() : 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrebovanjeStavka other = (TrebovanjeStavka)obj;
        if (!(BObject.pcGetid(this) == BObject.pcGetid(other) || BObject.pcGetid(this) != null && BObject.pcGetid(this).equals(BObject.pcGetid(other)))) {
            return false;
        }
        if (!(TrebovanjeStavka.pcGetartikal(this) == TrebovanjeStavka.pcGetartikal(other) || TrebovanjeStavka.pcGetartikal(this) != null && TrebovanjeStavka.pcGetartikal(this).equals(TrebovanjeStavka.pcGetartikal(other)))) {
            return false;
        }
        if (!(TrebovanjeStavka.pcGetkolicina(this) == TrebovanjeStavka.pcGetkolicina(other) || TrebovanjeStavka.pcGetkolicina(this) != null && TrebovanjeStavka.pcGetkolicina(this).equals(TrebovanjeStavka.pcGetkolicina(other)))) {
            return false;
        }
        if (!(TrebovanjeStavka.pcGetkomad(this) == TrebovanjeStavka.pcGetkomad(other) || TrebovanjeStavka.pcGetkomad(this) != null && TrebovanjeStavka.pcGetkomad(this).equals(TrebovanjeStavka.pcGetkomad(other)))) {
            return false;
        }
        if (!(TrebovanjeStavka.pcGetpdv(this) == TrebovanjeStavka.pcGetpdv(other) || TrebovanjeStavka.pcGetpdv(this) != null && TrebovanjeStavka.pcGetpdv(this).equals(TrebovanjeStavka.pcGetpdv(other)))) {
            return false;
        }
        if (!(TrebovanjeStavka.pcGetredniBroj(this) == TrebovanjeStavka.pcGetredniBroj(other) || TrebovanjeStavka.pcGetredniBroj(this) != null && TrebovanjeStavka.pcGetredniBroj(this).equals(TrebovanjeStavka.pcGetredniBroj(other)))) {
            return false;
        }
        if (!(TrebovanjeStavka.pcGettrebovanje(this) == TrebovanjeStavka.pcGettrebovanje(other) || TrebovanjeStavka.pcGettrebovanje(this) != null && TrebovanjeStavka.pcGettrebovanje(this).equals(TrebovanjeStavka.pcGettrebovanje(other)))) {
            return false;
        }
        return TrebovanjeStavka.pcGetstavkaPrijemnice(this) == TrebovanjeStavka.pcGetstavkaPrijemnice(other) || TrebovanjeStavka.pcGetstavkaPrijemnice(this) != null && TrebovanjeStavka.pcGetstavkaPrijemnice(this).equals(TrebovanjeStavka.pcGetstavkaPrijemnice(other));
    }

    @Override
    public String toString() {
        return "";
    }

    public Double getRabat() {
        return TrebovanjeStavka.pcGetrabat(this);
    }

    public void setRabat(Double rabat) {
        TrebovanjeStavka.pcSetrabat(this, rabat);
    }

    public Double getKomBPDVsaRbt() {
        return TrebovanjeStavka.pcGetkomBPDVsaRbt(this);
    }

    public void setKomBPDVsaRbt(Double komBPDVsaRbt) {
        TrebovanjeStavka.pcSetkomBPDVsaRbt(this, komBPDVsaRbt);
    }

    public Artikal getArtikal() {
        return TrebovanjeStavka.pcGetartikal(this);
    }

    public void setArtikalId(Artikal artikal) {
        TrebovanjeStavka.pcSetartikal(this, artikal);
    }

    public Double getKolicina() {
        return TrebovanjeStavka.pcGetkolicina(this);
    }

    public void setKolicina(Double kolicina) {
        TrebovanjeStavka.pcSetkolicina(this, kolicina);
    }

    public Double getVrednost() {
        if (TrebovanjeStavka.pcGetukupno(this) != null) {
            return TrebovanjeStavka.pcGetukupno(this);
        }
        if (TrebovanjeStavka.pcGetpdv(this) != null) {
            double kol = TrebovanjeStavka.pcGetkolicina(this) != null ? TrebovanjeStavka.pcGetkolicina(this) : 0.0;
            double cena = TrebovanjeStavka.pcGetkomad(this) != null ? TrebovanjeStavka.pcGetkomad(this) : 0.0;
            cena = StatLogic.round(cena / (1.0 + TrebovanjeStavka.pcGetpdv(this) / 100.0), 4);
            double raba = TrebovanjeStavka.pcGetrabat(this) != null ? TrebovanjeStavka.pcGetrabat(this) : 0.0;
            double ukupno = 0.0;
            ukupno = raba > 0.0 ? kol * cena * 100.0 / (100.0 + TrebovanjeStavka.pcGetrabat(this)) * (1.0 + TrebovanjeStavka.pcGetpdv(this) / 100.0) : cena * kol * (1.0 + TrebovanjeStavka.pcGetpdv(this) / 100.0);
            return StatLogic.round(ukupno, 2);
        }
        double kol = TrebovanjeStavka.pcGetkolicina(this) != null ? TrebovanjeStavka.pcGetkolicina(this) : 0.0;
        double cena = TrebovanjeStavka.pcGetkomad(this) != null ? TrebovanjeStavka.pcGetkomad(this) : 0.0;
        return kol * cena;
    }

    public double getVrednostBezPDV() {
        if (TrebovanjeStavka.pcGetukupnoBPDV(this) != null) {
            return TrebovanjeStavka.pcGetukupnoBPDV(this);
        }
        if (TrebovanjeStavka.pcGetpdv(this) == null) {
            return -1.0;
        }
        double kol = TrebovanjeStavka.pcGetkolicina(this) != null ? TrebovanjeStavka.pcGetkolicina(this) : 0.0;
        double cena = TrebovanjeStavka.pcGetkomad(this) != null ? TrebovanjeStavka.pcGetkomad(this) : 0.0;
        return kol * cena * 100.0 / (100.0 + TrebovanjeStavka.pcGetpdv(this));
    }

    public double getVrednostSaRabatom() {
        if (TrebovanjeStavka.pcGetrabat(this) == null) {
            return TrebovanjeStavka.pcGetukupnoBPDV(this);
        }
        if (TrebovanjeStavka.pcGetpdv(this) == null) {
            return -1.0;
        }
        double kol = TrebovanjeStavka.pcGetkolicina(this) != null ? TrebovanjeStavka.pcGetkolicina(this) : 0.0;
        double cena = TrebovanjeStavka.pcGetkomad(this) != null ? TrebovanjeStavka.pcGetkomad(this) : 0.0;
        return kol * cena * 100.0 / (100.0 + TrebovanjeStavka.pcGetrabat(this));
    }

    public Double getKomad() {
        return TrebovanjeStavka.pcGetkomad(this);
    }

    public void setKomad(Double komad) {
        TrebovanjeStavka.pcSetkomad(this, komad);
    }

    public Trebovanje getTrebovanje() {
        return TrebovanjeStavka.pcGettrebovanje(this);
    }

    public void setTrebovanje(Trebovanje trebovanje) {
        TrebovanjeStavka.pcSettrebovanje(this, trebovanje);
    }

    public Double getPdvStopa() {
        return TrebovanjeStavka.pcGetpdv(this);
    }

    public void setPdvStopa(Double pdv) {
        TrebovanjeStavka.pcSetpdv(this, pdv);
    }

    public PrijemnicaStavka getStavkaPrijemnice() {
        return TrebovanjeStavka.pcGetstavkaPrijemnice(this);
    }

    public void setStavkaPrijemnice(PrijemnicaStavka stavkaPrijemnice) {
        TrebovanjeStavka.pcSetstavkaPrijemnice(this, stavkaPrijemnice);
    }

    public Integer getRedniBroj() {
        return TrebovanjeStavka.pcGetredniBroj(this);
    }

    public void setRedniBroj(Integer redniBroj) {
        TrebovanjeStavka.pcSetredniBroj(this, redniBroj);
    }

    public Double getKomadBPDV() {
        return TrebovanjeStavka.pcGetkomadBPDV(this);
    }

    public void setKomadBPDV(Double komadBPDV) {
        TrebovanjeStavka.pcSetkomadBPDV(this, komadBPDV);
    }

    public Double getUkupno() {
        return TrebovanjeStavka.pcGetukupno(this);
    }

    public void setUkupno(Double ukupno) {
        TrebovanjeStavka.pcSetukupno(this, ukupno);
    }

    public Double getUkupnoBPDV() {
        return TrebovanjeStavka.pcGetukupnoBPDV(this);
    }

    public void setUkupnoBPDV(Double ukupnoBPDV) {
        TrebovanjeStavka.pcSetukupnoBPDV(this, ukupnoBPDV);
    }

    public Double getPdv() {
        return TrebovanjeStavka.pcGetpdv(this);
    }

    public void setPdv(Double pdv) {
        TrebovanjeStavka.pcSetpdv(this, pdv);
    }

    public Double getProdajnaVrednost() {
        return TrebovanjeStavka.pcGetprodajnaVrednost(this);
    }

    public void setProdajnaVrednost(Double prodajnaVrednost) {
        TrebovanjeStavka.pcSetprodajnaVrednost(this, prodajnaVrednost);
    }

    public String getHacapTemp() {
        return TrebovanjeStavka.pcGethacapTemp(this);
    }

    public void setHacapTemp(String hacapTemp) {
        TrebovanjeStavka.pcSethacapTemp(this, hacapTemp);
    }

    public Boolean getUsaglaseno() {
        return TrebovanjeStavka.pcGetusaglaseno(this);
    }

    public void setUsaglaseno(Boolean usaglaseno) {
        TrebovanjeStavka.pcSetusaglaseno(this, usaglaseno);
    }

    public HacapMagacini getHacapMagacin() {
        return TrebovanjeStavka.pcGethacapMagacin(this);
    }

    public void setHacapMagacin(HacapMagacini hacapMagacin) {
        TrebovanjeStavka.pcSethacapMagacin(this, hacapMagacin);
    }

    public String getKorektivnaMera() {
        return TrebovanjeStavka.pcGetkorektivnaMera(this);
    }

    public void setKorektivnaMera(String korektivnaMera) {
        TrebovanjeStavka.pcSetkorektivnaMera(this, korektivnaMera);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1300381;
    }

    static {
        Class clazz = class$Lcom$dev63$restoran$model$BObject != null ? class$Lcom$dev63$restoran$model$BObject : (class$Lcom$dev63$restoran$model$BObject = TrebovanjeStavka.class$("com.dev63.restoran.model.BObject"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"artikal", "hacapMagacin", "hacapTemp", "kolicina", "komBPDVsaRbt", "komad", "komadBPDV", "korektivnaMera", "pdv", "prodajnaVrednost", "rabat", "redniBroj", "stavkaPrijemnice", "trebovanje", "ukupno", "ukupnoBPDV", "usaglaseno"};
        Class[] classArray = new Class[17];
        Class clazz2 = class$Lcom$dev63$restoran$model$Artikal != null ? class$Lcom$dev63$restoran$model$Artikal : (class$Lcom$dev63$restoran$model$Artikal = TrebovanjeStavka.class$("com.dev63.restoran.model.Artikal"));
        classArray[0] = clazz2;
        Class clazz3 = class$Lcom$dev63$restoran$model$HacapMagacini != null ? class$Lcom$dev63$restoran$model$HacapMagacini : (class$Lcom$dev63$restoran$model$HacapMagacini = TrebovanjeStavka.class$("com.dev63.restoran.model.HacapMagacini"));
        classArray[1] = clazz3;
        Class clazz4 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = TrebovanjeStavka.class$("java.lang.String"));
        classArray[2] = clazz4;
        Class clazz5 = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = TrebovanjeStavka.class$("java.lang.Double"));
        classArray[3] = clazz5;
        classArray[4] = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = TrebovanjeStavka.class$("java.lang.Double"));
        classArray[5] = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = TrebovanjeStavka.class$("java.lang.Double"));
        classArray[6] = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = TrebovanjeStavka.class$("java.lang.Double"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = TrebovanjeStavka.class$("java.lang.String"));
        classArray[8] = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = TrebovanjeStavka.class$("java.lang.Double"));
        classArray[9] = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = TrebovanjeStavka.class$("java.lang.Double"));
        classArray[10] = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = TrebovanjeStavka.class$("java.lang.Double"));
        Class clazz6 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = TrebovanjeStavka.class$("java.lang.Integer"));
        classArray[11] = clazz6;
        Class clazz7 = class$Lcom$dev63$restoran$model$PrijemnicaStavka != null ? class$Lcom$dev63$restoran$model$PrijemnicaStavka : (class$Lcom$dev63$restoran$model$PrijemnicaStavka = TrebovanjeStavka.class$("com.dev63.restoran.model.PrijemnicaStavka"));
        classArray[12] = clazz7;
        Class clazz8 = class$Lcom$dev63$restoran$model$Trebovanje != null ? class$Lcom$dev63$restoran$model$Trebovanje : (class$Lcom$dev63$restoran$model$Trebovanje = TrebovanjeStavka.class$("com.dev63.restoran.model.Trebovanje"));
        classArray[13] = clazz8;
        classArray[14] = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = TrebovanjeStavka.class$("java.lang.Double"));
        classArray[15] = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = TrebovanjeStavka.class$("java.lang.Double"));
        Class clazz9 = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = TrebovanjeStavka.class$("java.lang.Boolean"));
        classArray[16] = clazz9;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz10 = class$Lcom$dev63$restoran$model$TrebovanjeStavka != null ? class$Lcom$dev63$restoran$model$TrebovanjeStavka : (class$Lcom$dev63$restoran$model$TrebovanjeStavka = TrebovanjeStavka.class$("com.dev63.restoran.model.TrebovanjeStavka"));
        PCRegistry.register((Class)clazz10, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"TrebovanjeStavka", (PersistenceCapable)new TrebovanjeStavka());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.artikal = null;
        this.hacapMagacin = null;
        this.hacapTemp = null;
        this.kolicina = null;
        this.komBPDVsaRbt = null;
        this.komad = null;
        this.komadBPDV = null;
        this.korektivnaMera = null;
        this.pdv = null;
        this.prodajnaVrednost = null;
        this.rabat = null;
        this.redniBroj = null;
        this.stavkaPrijemnice = null;
        this.trebovanje = null;
        this.ukupno = null;
        this.ukupnoBPDV = null;
        this.usaglaseno = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        TrebovanjeStavka trebovanjeStavka = new TrebovanjeStavka();
        if (bl) {
            trebovanjeStavka.pcClearFields();
        }
        trebovanjeStavka.pcStateManager = stateManager;
        trebovanjeStavka.pcCopyKeyFieldsFromObjectId(object);
        return trebovanjeStavka;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        TrebovanjeStavka trebovanjeStavka = new TrebovanjeStavka();
        if (bl) {
            trebovanjeStavka.pcClearFields();
        }
        trebovanjeStavka.pcStateManager = stateManager;
        return trebovanjeStavka;
    }

    protected static int pcGetManagedFieldCount() {
        return 17 + BObject.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.artikal = (Artikal)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.hacapMagacin = (HacapMagacini)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.hacapTemp = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.kolicina = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.komBPDVsaRbt = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.komad = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.komadBPDV = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.korektivnaMera = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.pdv = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.prodajnaVrednost = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.rabat = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.redniBroj = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.stavkaPrijemnice = (PrijemnicaStavka)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.trebovanje = (Trebovanje)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.ukupno = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.ukupnoBPDV = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.usaglaseno = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.artikal);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.hacapMagacin);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.hacapTemp);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.kolicina);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.komBPDVsaRbt);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.komad);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.komadBPDV);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.korektivnaMera);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pdv);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.prodajnaVrednost);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.rabat);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.redniBroj);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.stavkaPrijemnice);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.trebovanje);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.ukupno);
                return;
            }
            case 15: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.ukupnoBPDV);
                return;
            }
            case 16: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.usaglaseno);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(TrebovanjeStavka trebovanjeStavka, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(trebovanjeStavka, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.artikal = trebovanjeStavka.artikal;
                return;
            }
            case 1: {
                this.hacapMagacin = trebovanjeStavka.hacapMagacin;
                return;
            }
            case 2: {
                this.hacapTemp = trebovanjeStavka.hacapTemp;
                return;
            }
            case 3: {
                this.kolicina = trebovanjeStavka.kolicina;
                return;
            }
            case 4: {
                this.komBPDVsaRbt = trebovanjeStavka.komBPDVsaRbt;
                return;
            }
            case 5: {
                this.komad = trebovanjeStavka.komad;
                return;
            }
            case 6: {
                this.komadBPDV = trebovanjeStavka.komadBPDV;
                return;
            }
            case 7: {
                this.korektivnaMera = trebovanjeStavka.korektivnaMera;
                return;
            }
            case 8: {
                this.pdv = trebovanjeStavka.pdv;
                return;
            }
            case 9: {
                this.prodajnaVrednost = trebovanjeStavka.prodajnaVrednost;
                return;
            }
            case 10: {
                this.rabat = trebovanjeStavka.rabat;
                return;
            }
            case 11: {
                this.redniBroj = trebovanjeStavka.redniBroj;
                return;
            }
            case 12: {
                this.stavkaPrijemnice = trebovanjeStavka.stavkaPrijemnice;
                return;
            }
            case 13: {
                this.trebovanje = trebovanjeStavka.trebovanje;
                return;
            }
            case 14: {
                this.ukupno = trebovanjeStavka.ukupno;
                return;
            }
            case 15: {
                this.ukupnoBPDV = trebovanjeStavka.ukupnoBPDV;
                return;
            }
            case 16: {
                this.usaglaseno = trebovanjeStavka.usaglaseno;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        TrebovanjeStavka trebovanjeStavka = (TrebovanjeStavka)object;
        if (trebovanjeStavka.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(trebovanjeStavka, nArray[n]);
            ++n;
        }
    }

    private static final Artikal pcGetartikal(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.artikal;
        }
        int n = pcInheritedFieldCount + 0;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.artikal;
    }

    private static final void pcSetartikal(TrebovanjeStavka trebovanjeStavka, Artikal artikal) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.artikal = artikal;
            return;
        }
        trebovanjeStavka.pcStateManager.settingObjectField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 0, (Object)trebovanjeStavka.artikal, (Object)artikal, 0);
    }

    private static final HacapMagacini pcGethacapMagacin(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.hacapMagacin;
        }
        int n = pcInheritedFieldCount + 1;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.hacapMagacin;
    }

    private static final void pcSethacapMagacin(TrebovanjeStavka trebovanjeStavka, HacapMagacini hacapMagacini) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.hacapMagacin = hacapMagacini;
            return;
        }
        trebovanjeStavka.pcStateManager.settingObjectField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 1, (Object)trebovanjeStavka.hacapMagacin, (Object)hacapMagacini, 0);
    }

    private static final String pcGethacapTemp(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.hacapTemp;
        }
        int n = pcInheritedFieldCount + 2;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.hacapTemp;
    }

    private static final void pcSethacapTemp(TrebovanjeStavka trebovanjeStavka, String string) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.hacapTemp = string;
            return;
        }
        trebovanjeStavka.pcStateManager.settingStringField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 2, trebovanjeStavka.hacapTemp, string, 0);
    }

    private static final Double pcGetkolicina(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.kolicina;
        }
        int n = pcInheritedFieldCount + 3;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.kolicina;
    }

    private static final void pcSetkolicina(TrebovanjeStavka trebovanjeStavka, Double d) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.kolicina = d;
            return;
        }
        trebovanjeStavka.pcStateManager.settingObjectField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 3, (Object)trebovanjeStavka.kolicina, (Object)d, 0);
    }

    private static final Double pcGetkomBPDVsaRbt(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.komBPDVsaRbt;
        }
        int n = pcInheritedFieldCount + 4;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.komBPDVsaRbt;
    }

    private static final void pcSetkomBPDVsaRbt(TrebovanjeStavka trebovanjeStavka, Double d) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.komBPDVsaRbt = d;
            return;
        }
        trebovanjeStavka.pcStateManager.settingObjectField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 4, (Object)trebovanjeStavka.komBPDVsaRbt, (Object)d, 0);
    }

    private static final Double pcGetkomad(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.komad;
        }
        int n = pcInheritedFieldCount + 5;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.komad;
    }

    private static final void pcSetkomad(TrebovanjeStavka trebovanjeStavka, Double d) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.komad = d;
            return;
        }
        trebovanjeStavka.pcStateManager.settingObjectField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 5, (Object)trebovanjeStavka.komad, (Object)d, 0);
    }

    private static final Double pcGetkomadBPDV(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.komadBPDV;
        }
        int n = pcInheritedFieldCount + 6;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.komadBPDV;
    }

    private static final void pcSetkomadBPDV(TrebovanjeStavka trebovanjeStavka, Double d) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.komadBPDV = d;
            return;
        }
        trebovanjeStavka.pcStateManager.settingObjectField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 6, (Object)trebovanjeStavka.komadBPDV, (Object)d, 0);
    }

    private static final String pcGetkorektivnaMera(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.korektivnaMera;
        }
        int n = pcInheritedFieldCount + 7;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.korektivnaMera;
    }

    private static final void pcSetkorektivnaMera(TrebovanjeStavka trebovanjeStavka, String string) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.korektivnaMera = string;
            return;
        }
        trebovanjeStavka.pcStateManager.settingStringField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 7, trebovanjeStavka.korektivnaMera, string, 0);
    }

    private static final Double pcGetpdv(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.pdv;
        }
        int n = pcInheritedFieldCount + 8;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.pdv;
    }

    private static final void pcSetpdv(TrebovanjeStavka trebovanjeStavka, Double d) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.pdv = d;
            return;
        }
        trebovanjeStavka.pcStateManager.settingObjectField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 8, (Object)trebovanjeStavka.pdv, (Object)d, 0);
    }

    private static final Double pcGetprodajnaVrednost(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.prodajnaVrednost;
        }
        int n = pcInheritedFieldCount + 9;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.prodajnaVrednost;
    }

    private static final void pcSetprodajnaVrednost(TrebovanjeStavka trebovanjeStavka, Double d) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.prodajnaVrednost = d;
            return;
        }
        trebovanjeStavka.pcStateManager.settingObjectField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 9, (Object)trebovanjeStavka.prodajnaVrednost, (Object)d, 0);
    }

    private static final Double pcGetrabat(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.rabat;
        }
        int n = pcInheritedFieldCount + 10;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.rabat;
    }

    private static final void pcSetrabat(TrebovanjeStavka trebovanjeStavka, Double d) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.rabat = d;
            return;
        }
        trebovanjeStavka.pcStateManager.settingObjectField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 10, (Object)trebovanjeStavka.rabat, (Object)d, 0);
    }

    private static final Integer pcGetredniBroj(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.redniBroj;
        }
        int n = pcInheritedFieldCount + 11;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.redniBroj;
    }

    private static final void pcSetredniBroj(TrebovanjeStavka trebovanjeStavka, Integer n) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.redniBroj = n;
            return;
        }
        trebovanjeStavka.pcStateManager.settingObjectField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 11, (Object)trebovanjeStavka.redniBroj, (Object)n, 0);
    }

    private static final PrijemnicaStavka pcGetstavkaPrijemnice(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.stavkaPrijemnice;
        }
        int n = pcInheritedFieldCount + 12;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.stavkaPrijemnice;
    }

    private static final void pcSetstavkaPrijemnice(TrebovanjeStavka trebovanjeStavka, PrijemnicaStavka prijemnicaStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.stavkaPrijemnice = prijemnicaStavka;
            return;
        }
        trebovanjeStavka.pcStateManager.settingObjectField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 12, (Object)trebovanjeStavka.stavkaPrijemnice, (Object)prijemnicaStavka, 0);
    }

    private static final Trebovanje pcGettrebovanje(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.trebovanje;
        }
        int n = pcInheritedFieldCount + 13;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.trebovanje;
    }

    private static final void pcSettrebovanje(TrebovanjeStavka trebovanjeStavka, Trebovanje trebovanje) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.trebovanje = trebovanje;
            return;
        }
        trebovanjeStavka.pcStateManager.settingObjectField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 13, (Object)trebovanjeStavka.trebovanje, (Object)trebovanje, 0);
    }

    private static final Double pcGetukupno(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.ukupno;
        }
        int n = pcInheritedFieldCount + 14;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.ukupno;
    }

    private static final void pcSetukupno(TrebovanjeStavka trebovanjeStavka, Double d) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.ukupno = d;
            return;
        }
        trebovanjeStavka.pcStateManager.settingObjectField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 14, (Object)trebovanjeStavka.ukupno, (Object)d, 0);
    }

    private static final Double pcGetukupnoBPDV(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.ukupnoBPDV;
        }
        int n = pcInheritedFieldCount + 15;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.ukupnoBPDV;
    }

    private static final void pcSetukupnoBPDV(TrebovanjeStavka trebovanjeStavka, Double d) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.ukupnoBPDV = d;
            return;
        }
        trebovanjeStavka.pcStateManager.settingObjectField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 15, (Object)trebovanjeStavka.ukupnoBPDV, (Object)d, 0);
    }

    private static final Boolean pcGetusaglaseno(TrebovanjeStavka trebovanjeStavka) {
        if (trebovanjeStavka.pcStateManager == null) {
            return trebovanjeStavka.usaglaseno;
        }
        int n = pcInheritedFieldCount + 16;
        trebovanjeStavka.pcStateManager.accessingField(n);
        return trebovanjeStavka.usaglaseno;
    }

    private static final void pcSetusaglaseno(TrebovanjeStavka trebovanjeStavka, Boolean bl) {
        if (trebovanjeStavka.pcStateManager == null) {
            trebovanjeStavka.usaglaseno = bl;
            return;
        }
        trebovanjeStavka.pcStateManager.settingObjectField((PersistenceCapable)trebovanjeStavka, pcInheritedFieldCount + 16, (Object)trebovanjeStavka.usaglaseno, (Object)bl, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

