/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model;

import com.dev63.restoran.comparators.StavkaRacunaArtikalIDComparator;
import com.dev63.restoran.constants.Constants;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Atribut;
import com.dev63.restoran.model.BObject;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.newmodel.Article;
import com.dev63.restoran.newmodel.Bill;
import com.dev63.restoran.newmodel.BillItem;
import com.dev63.restoran.newmodel.Order;
import com.dev63.restoran.newmodel.OrderItem;
import com.dev63.restoran.util.GenericMutableBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@NamedQueries(value={@NamedQuery(name="StavkaRacuna.countOpenByTuraId", query="SELECT COUNT(sr) FROM StavkaRacuna sr WHERE sr.tura.id = :turaId and sr.racun IS NULL"), @NamedQuery(name="StavkaRacuna.stavkeZaPospremanje", query="SELECT sr FROM StavkaRacuna sr WHERE sr.racun IS NOT NULL AND sr.racun.datum > (SELECT MAX(zd.zakljucenje) FROM ZD zd) AND sr.racun.crnoPlacanje IS NOT NULL")})
public class StavkaRacuna
extends BObject
implements BillItem,
OrderItem,
PersistenceCapable {
    public static final String Q_COUNT_OPEN_BY_TURA_ID = "StavkaRacuna.countOpenByTuraId";
    public static final String Q_STAVKE_ZA_POSPREMANJE = "StavkaRacuna.stavkeZaPospremanje";
    private static final long serialVersionUID = 1L;
    @ManyToOne
    private Artikal artikal;
    @Column(nullable=false)
    private String naziv;
    @Column(nullable=false)
    private Double kolicina = 0.0;
    @Column(nullable=false)
    private Double cena = 0.0;
    @ManyToOne
    private Tura tura;
    @ManyToOne(cascade={CascadeType.ALL})
    private Racun racun;
    @Column(nullable=false)
    private Integer brojStola;
    @Column(nullable=true)
    private boolean pripremljena;
    @Column(nullable=true)
    private Timestamp pocetak;
    @Column(nullable=true)
    private Timestamp kraj;
    @Column(columnDefinition="varchar(255)", nullable=true)
    private String opis;
    @Column(nullable=true)
    private String saStola;
    @Transient
    private List<Atribut> opisniAtributi;
    @Transient
    private BigDecimal kolicinaZaRastavljanjeLevo = BigDecimal.ZERO;
    @Transient
    private BigDecimal kolicinaZaRastavljanjeDesno = BigDecimal.ZERO;
    @Transient
    private BigDecimal kolicinaZaRastavljanjeDesnoPrikaz;
    @ManyToOne(cascade={CascadeType.MERGE, CascadeType.REFRESH}, targetEntity=StavkaRacuna.class)
    @JoinColumn(name="GLAVNASTAVKA_ID", referencedColumnName="ID")
    private StavkaRacuna glavnaStavka = null;
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="glavnaStavka", targetEntity=StavkaRacuna.class)
    private List<StavkaRacuna> podStavke;
    private boolean menipromet = false;
    private static int pcInheritedFieldCount = BObject.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$BObject;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Artikal;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$lang$Double;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$StavkaRacuna;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Racun;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Tura;

    public StavkaRacuna() {
        this.opisniAtributi = new LinkedList<Atribut>();
        this.podStavke = new LinkedList<StavkaRacuna>();
    }

    public StavkaRacuna(StavkaRacuna cloned) {
        this();
        if (cloned != null) {
            this.artikal = cloned.artikal;
            this.brojStola = cloned.brojStola;
            this.cena = cloned.cena;
            this.kolicina = cloned.kolicina;
            this.kolicinaZaRastavljanjeDesno = cloned.kolicinaZaRastavljanjeDesno;
            this.kolicinaZaRastavljanjeDesnoPrikaz = cloned.kolicinaZaRastavljanjeDesnoPrikaz;
            this.kolicinaZaRastavljanjeLevo = cloned.kolicinaZaRastavljanjeLevo;
            this.naziv = cloned.naziv;
            this.opisniAtributi = cloned.opisniAtributi;
            this.racun = cloned.racun;
            this.tura = cloned.tura;
            this.glavnaStavka = cloned.glavnaStavka;
            this.podStavke = cloned.podStavke;
        }
    }

    public Double getKolicina() {
        return StavkaRacuna.pcGetkolicina(this);
    }

    public Double getCena() {
        return this.getPriceWithDiscount().doubleValue();
    }

    public Double getCenaBezPopusta() {
        return StavkaRacuna.pcGetcena(this);
    }

    public Double getCenaBezPopustaSaCenomArtikla() {
        return this.getArtikal() != null ? this.getArtikal().getCena() : StavkaRacuna.pcGetcena(this);
    }

    public Double getVrednost() {
        return this.getValue().doubleValue();
    }

    public Double getVrednostSaPopustom() {
        return this.getValueWithDiscount().doubleValue();
    }

    public void setCena(Double cena) {
        StavkaRacuna.pcSetcena(this, cena != null ? cena : 0.0);
    }

    public void setKolicina(Double kolicina) {
        StavkaRacuna.pcSetkolicina(this, kolicina != null ? kolicina : 0.0);
    }

    public Artikal getArtikal() {
        return StavkaRacuna.pcGetartikal(this);
    }

    public void setArtikal(Artikal artikal) {
        StavkaRacuna.pcSetartikal(this, artikal);
    }

    public Tura getTura() {
        return StavkaRacuna.pcGettura(this);
    }

    public void setTura(Tura porudzbina) {
        StavkaRacuna.pcSettura(this, porudzbina);
    }

    public List<StavkaRacuna> getPodStavke() {
        return StavkaRacuna.pcGetpodStavke(this);
    }

    public void setPodStavke(List<StavkaRacuna> children) {
        StavkaRacuna.pcSetpodStavke(this, children);
    }

    public StavkaRacuna getGlavnaStavka() {
        return StavkaRacuna.pcGetglavnaStavka(this);
    }

    public void setGlavnaStavka(StavkaRacuna parent) {
        StavkaRacuna.pcSetglavnaStavka(this, parent);
    }

    public boolean isMenipromet() {
        return StavkaRacuna.pcGetmenipromet(this);
    }

    public void setMenipromet(boolean menipromet) {
        StavkaRacuna.pcSetmenipromet(this, menipromet);
    }

    @Override
    public String toString() {
        return String.format("ID = %d naziv -> %s kolicina -> %f vrednost -> %f", BObject.pcGetid(this), StavkaRacuna.pcGetnaziv(this), StavkaRacuna.pcGetkolicina(this), this.getVrednost());
    }

    public String getNaziv() {
        return StavkaRacuna.pcGetnaziv(this);
    }

    public void setNaziv(String naziv) {
        StavkaRacuna.pcSetnaziv(this, naziv);
    }

    public Integer getBrojStola() {
        return StavkaRacuna.pcGetbrojStola(this);
    }

    public void setBrojStola(Integer brojStola) {
        StavkaRacuna.pcSetbrojStola(this, brojStola);
    }

    public Racun getRacun() {
        return StavkaRacuna.pcGetracun(this);
    }

    public void setRacun(Racun racun) {
        StavkaRacuna.pcSetracun(this, racun);
    }

    public List<Atribut> getOpisniAtributi() {
        return this.opisniAtributi;
    }

    public void setOpisniAtributi(List<Atribut> opisniAtributi) {
        this.opisniAtributi = opisniAtributi;
    }

    public Double getKolicinaZaRastavljanjeLevo() {
        return this.getSplittingLeftQuantity().doubleValue();
    }

    public void setKolicinaZaRastavljanjeLevo(Double kolicinaZaRastavljanjeLevo) {
        this.setSplittingLeftQuantity(kolicinaZaRastavljanjeLevo != null ? BigDecimal.valueOf(kolicinaZaRastavljanjeLevo) : BigDecimal.ZERO);
    }

    public Double getKolicinaZaRastavljanjeDesno() {
        return this.getSplittingTakenQuantity().doubleValue();
    }

    public void setKolicinaZaRastavljanjeDesno(Double kolicinaZaRastavljanjeDesno) {
        this.setSplittingTakenQuantity(kolicinaZaRastavljanjeDesno != null ? BigDecimal.valueOf(kolicinaZaRastavljanjeDesno) : BigDecimal.ZERO);
    }

    public Double getKolicinaZaRastavljanjeDesnoPrikaz() {
        return this.getSplittingTakenDisplayQuantity().doubleValue();
    }

    public void setKolicinaZaRastavljanjeDesnoPrikaz(Double kolicinaZaRastavljanjeDesnoPrikaz) {
        this.setSplittingTakenDisplayQuantity(kolicinaZaRastavljanjeDesnoPrikaz != null ? BigDecimal.valueOf(kolicinaZaRastavljanjeDesnoPrikaz) : null);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (StavkaRacuna.pcGetartikal(this) != null ? StavkaRacuna.pcGetartikal(this).hashCode() : 0);
        hash = 23 * hash + (StavkaRacuna.pcGetnaziv(this) != null ? StavkaRacuna.pcGetnaziv(this).hashCode() : 0);
        hash = 23 * hash + (StavkaRacuna.pcGetkolicina(this) != null ? StavkaRacuna.pcGetkolicina(this).hashCode() : 0);
        hash = 23 * hash + (StavkaRacuna.pcGetcena(this) != null ? StavkaRacuna.pcGetcena(this).hashCode() : 0);
        hash = 23 * hash + (StavkaRacuna.pcGetpodStavke(this) != null ? StavkaRacuna.pcGetpodStavke(this).hashCode() : 0);
        hash = 23 * hash + (StavkaRacuna.pcGetopis(this) != null ? StavkaRacuna.pcGetopis(this).hashCode() : 0);
        hash = (int)((long)(23 * hash) + (StavkaRacuna.pcGetglavnaStavka(this) != null ? StavkaRacuna.pcGetartikal(StavkaRacuna.pcGetglavnaStavka(this)).getId() : 0L));
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StavkaRacuna other = (StavkaRacuna)obj;
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (!(StavkaRacuna.pcGetartikal(this) == StavkaRacuna.pcGetartikal(other) || StavkaRacuna.pcGetartikal(this) != null && StavkaRacuna.pcGetartikal(this).equals(StavkaRacuna.pcGetartikal(other)))) {
            return false;
        }
        if (StavkaRacuna.pcGetnaziv(this) == null ? StavkaRacuna.pcGetnaziv(other) != null : !StavkaRacuna.pcGetnaziv(this).equals(StavkaRacuna.pcGetnaziv(other))) {
            return false;
        }
        if (!(StavkaRacuna.pcGetkolicina(this) == StavkaRacuna.pcGetkolicina(other) || StavkaRacuna.pcGetkolicina(this) != null && StavkaRacuna.pcGetkolicina(this).equals(StavkaRacuna.pcGetkolicina(other)))) {
            return false;
        }
        if (!(StavkaRacuna.pcGetcena(this) == StavkaRacuna.pcGetcena(other) || StavkaRacuna.pcGetcena(this) != null && StavkaRacuna.pcGetcena(this).equals(StavkaRacuna.pcGetcena(other)))) {
            return false;
        }
        if (StavkaRacuna.pcGetglavnaStavka(this) != StavkaRacuna.pcGetglavnaStavka(other)) {
            if (StavkaRacuna.pcGetglavnaStavka(this) == null || StavkaRacuna.pcGetglavnaStavka(other) == null) {
                return false;
            }
            if (!(StavkaRacuna.pcGetartikal(StavkaRacuna.pcGetglavnaStavka(this)) == StavkaRacuna.pcGetartikal(StavkaRacuna.pcGetglavnaStavka(other)) || StavkaRacuna.pcGetartikal(StavkaRacuna.pcGetglavnaStavka(this)) != null && StavkaRacuna.pcGetartikal(StavkaRacuna.pcGetglavnaStavka(this)).equals(StavkaRacuna.pcGetartikal(StavkaRacuna.pcGetglavnaStavka(other))))) {
                return false;
            }
            if (StavkaRacuna.pcGetnaziv(StavkaRacuna.pcGetglavnaStavka(this)) == null ? StavkaRacuna.pcGetnaziv(StavkaRacuna.pcGetglavnaStavka(other)) != null : !StavkaRacuna.pcGetnaziv(StavkaRacuna.pcGetglavnaStavka(this)).equals(StavkaRacuna.pcGetnaziv(StavkaRacuna.pcGetglavnaStavka(other)))) {
                return false;
            }
            if (!(StavkaRacuna.pcGetkolicina(StavkaRacuna.pcGetglavnaStavka(this)) == StavkaRacuna.pcGetkolicina(StavkaRacuna.pcGetglavnaStavka(other)) || StavkaRacuna.pcGetkolicina(StavkaRacuna.pcGetglavnaStavka(this)) != null && StavkaRacuna.pcGetkolicina(StavkaRacuna.pcGetglavnaStavka(this)).equals(StavkaRacuna.pcGetkolicina(StavkaRacuna.pcGetglavnaStavka(other))))) {
                return false;
            }
            if (!(StavkaRacuna.pcGetcena(StavkaRacuna.pcGetglavnaStavka(this)) == StavkaRacuna.pcGetcena(StavkaRacuna.pcGetglavnaStavka(other)) || StavkaRacuna.pcGetcena(StavkaRacuna.pcGetglavnaStavka(this)) != null && StavkaRacuna.pcGetcena(StavkaRacuna.pcGetglavnaStavka(this)).equals(StavkaRacuna.pcGetcena(StavkaRacuna.pcGetglavnaStavka(other))))) {
                return false;
            }
        }
        if (!(StavkaRacuna.pcGetpodStavke(this) == StavkaRacuna.pcGetpodStavke(other) || StavkaRacuna.pcGetpodStavke(this) != null && StavkaRacuna.pcGetpodStavke(other) != null && StavkaRacuna.pcGetpodStavke(this).containsAll(StavkaRacuna.pcGetpodStavke(other)))) {
            return false;
        }
        return StavkaRacuna.pcGetopis(this) == StavkaRacuna.pcGetopis(other) || StavkaRacuna.pcGetopis(this) != null && StavkaRacuna.pcGetopis(other) != null;
    }

    public boolean equalsNoQuantity(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StavkaRacuna other = (StavkaRacuna)obj;
        if (!(StavkaRacuna.pcGetartikal(this) == StavkaRacuna.pcGetartikal(other) || StavkaRacuna.pcGetartikal(this) != null && StavkaRacuna.pcGetartikal(this).equals(StavkaRacuna.pcGetartikal(other)))) {
            return false;
        }
        if (StavkaRacuna.pcGetnaziv(this) == null ? StavkaRacuna.pcGetnaziv(other) != null : !StavkaRacuna.pcGetnaziv(this).equals(StavkaRacuna.pcGetnaziv(other))) {
            return false;
        }
        if (!(StavkaRacuna.pcGetcena(this) == StavkaRacuna.pcGetcena(other) || StavkaRacuna.pcGetcena(this) != null && StavkaRacuna.pcGetcena(this).equals(StavkaRacuna.pcGetcena(other)))) {
            return false;
        }
        if (StavkaRacuna.pcGetglavnaStavka(this) != StavkaRacuna.pcGetglavnaStavka(other)) {
            if (StavkaRacuna.pcGetglavnaStavka(this) == null || StavkaRacuna.pcGetglavnaStavka(other) == null) {
                return false;
            }
            if (!(StavkaRacuna.pcGetartikal(StavkaRacuna.pcGetglavnaStavka(this)) == StavkaRacuna.pcGetartikal(StavkaRacuna.pcGetglavnaStavka(other)) || StavkaRacuna.pcGetartikal(StavkaRacuna.pcGetglavnaStavka(this)) != null && StavkaRacuna.pcGetartikal(StavkaRacuna.pcGetglavnaStavka(this)).equals(StavkaRacuna.pcGetartikal(StavkaRacuna.pcGetglavnaStavka(other))))) {
                return false;
            }
            if (StavkaRacuna.pcGetnaziv(StavkaRacuna.pcGetglavnaStavka(this)) == null ? StavkaRacuna.pcGetnaziv(StavkaRacuna.pcGetglavnaStavka(other)) != null : !StavkaRacuna.pcGetnaziv(StavkaRacuna.pcGetglavnaStavka(this)).equals(StavkaRacuna.pcGetnaziv(StavkaRacuna.pcGetglavnaStavka(other)))) {
                return false;
            }
            if (!(StavkaRacuna.pcGetcena(StavkaRacuna.pcGetglavnaStavka(this)) == StavkaRacuna.pcGetcena(StavkaRacuna.pcGetglavnaStavka(other)) || StavkaRacuna.pcGetcena(StavkaRacuna.pcGetglavnaStavka(this)) != null && StavkaRacuna.pcGetcena(StavkaRacuna.pcGetglavnaStavka(this)).equals(StavkaRacuna.pcGetcena(StavkaRacuna.pcGetglavnaStavka(other))))) {
                return false;
            }
        }
        if (StavkaRacuna.pcGetpodStavke(this) != StavkaRacuna.pcGetpodStavke(other)) {
            if (StavkaRacuna.pcGetpodStavke(this) == null || StavkaRacuna.pcGetpodStavke(other) == null) {
                return false;
            }
            if (StavkaRacuna.pcGetpodStavke(this).size() != StavkaRacuna.pcGetpodStavke(other).size()) {
                return false;
            }
            LinkedList thisChildren = new LinkedList(StavkaRacuna.pcGetpodStavke(this));
            LinkedList otherChildren = new LinkedList(StavkaRacuna.pcGetpodStavke(other));
            StavkaRacunaArtikalIDComparator srComp = new StavkaRacunaArtikalIDComparator();
            Collections.sort(thisChildren, srComp);
            Collections.sort(otherChildren, srComp);
            BigDecimal thisKol = BigDecimal.valueOf(StavkaRacuna.pcGetkolicina(this));
            BigDecimal otherKol = BigDecimal.valueOf(StavkaRacuna.pcGetkolicina(other));
            for (int i = 0; i < thisChildren.size(); ++i) {
                StavkaRacuna otherChild;
                StavkaRacuna thisChild = (StavkaRacuna)thisChildren.get(i);
                if (!thisChild.equalsNoQuantity(otherChild = (StavkaRacuna)otherChildren.get(i))) {
                    return false;
                }
                BigDecimal thisChildKol = BigDecimal.valueOf(thisChild.getKolicina());
                BigDecimal otherChildKol = BigDecimal.valueOf(otherChild.getKolicina());
                if (thisChildKol.divide(thisKol, 6, RoundingMode.HALF_UP).compareTo(otherChildKol.divide(otherKol, 6, RoundingMode.HALF_UP)) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public Double getKolicinaPrikaz() {
        if (this.getParentItem() != null) {
            return this.getQuantity().divide(this.getParentItem().getQuantity(), 4, 3).doubleValue();
        }
        return this.getQuantity().doubleValue();
    }

    @Override
    public String getName() {
        return StavkaRacuna.pcGetnaziv(this);
    }

    @Override
    public BigDecimal getQuantity() {
        return StavkaRacuna.pcGetkolicina(this) == null ? BigDecimal.ZERO : BigDecimal.valueOf(StavkaRacuna.pcGetkolicina(this));
    }

    @Override
    public BigDecimal getPriceWithDiscount() {
        if (this.getBill() == null) {
            return this.getPrice();
        }
        System.out.println(this.getArticle());
        if (this.getArticle().isDiscountable().booleanValue() || this.getRacun().getMenipromet().booleanValue()) {
            return this.getPrice().multiply(Constants.CBigDecimal.HUNDRED.subtract(this.getBill().getDiscountPercentage())).divide(Constants.CBigDecimal.HUNDRED, 6, 4);
        }
        return this.getPrice();
    }

    @Override
    public BigDecimal getPrice() {
        return BigDecimal.valueOf(StavkaRacuna.pcGetcena(this));
    }

    @Override
    public BigDecimal getValueWithDiscount() {
        return this.getQuantity().multiply(this.getPriceWithDiscount()).setScale(2, 4);
    }

    @Override
    public BigDecimal getValue() {
        return this.getQuantity().multiply(this.getPrice()).setScale(2, 4);
    }

    public BillItem getParentItem() {
        return StavkaRacuna.pcGetglavnaStavka(this);
    }

    public List<StavkaRacuna> getChildrenItems() {
        return StavkaRacuna.pcGetpodStavke(this);
    }

    @Override
    public Bill getBill() {
        return StavkaRacuna.pcGetracun(this);
    }

    @Override
    public Order getOrder() {
        return StavkaRacuna.pcGettura(this);
    }

    @Override
    public BigDecimal getSplittingLeftQuantity() {
        return this.kolicinaZaRastavljanjeLevo == null ? BigDecimal.ZERO : this.kolicinaZaRastavljanjeLevo;
    }

    @Override
    public void setSplittingLeftQuantity(BigDecimal splittingLeftQuantity) {
        this.kolicinaZaRastavljanjeLevo = splittingLeftQuantity == null ? BigDecimal.ZERO : splittingLeftQuantity;
    }

    @Override
    public BigDecimal getSplittingTakenQuantity() {
        return this.kolicinaZaRastavljanjeDesno == null ? BigDecimal.ZERO : this.kolicinaZaRastavljanjeDesno;
    }

    @Override
    public void setSplittingTakenQuantity(BigDecimal splittingTakenQuantity) {
        this.kolicinaZaRastavljanjeDesno = splittingTakenQuantity == null ? BigDecimal.ZERO : splittingTakenQuantity;
    }

    @Override
    public BigDecimal getSplittingTakenDisplayQuantity() {
        return this.kolicinaZaRastavljanjeDesnoPrikaz == null ? this.getSplittingTakenQuantity() : this.kolicinaZaRastavljanjeDesnoPrikaz;
    }

    @Override
    public void setSplittingTakenDisplayQuantity(BigDecimal splittingTakenDisplayQuantity) {
        this.kolicinaZaRastavljanjeDesnoPrikaz = splittingTakenDisplayQuantity;
    }

    @Override
    public Article getArticle() {
        return StavkaRacuna.pcGetartikal(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpis() {
        return StavkaRacuna.pcGetopis(this);
    }

    public void setOpis(String opis) {
        StavkaRacuna.pcSetopis(this, opis);
    }

    public String getSaStola() {
        return StavkaRacuna.pcGetsaStola(this);
    }

    public void setSaStola(String saStola) {
        StavkaRacuna.pcSetsaStola(this, saStola);
    }

    public boolean isPripremljena() {
        return StavkaRacuna.pcGetpripremljena(this);
    }

    public void setPripremljena(boolean pripremljena) {
        StavkaRacuna.pcSetpripremljena(this, pripremljena);
    }

    public Timestamp getPocetak() {
        return StavkaRacuna.pcGetpocetak(this);
    }

    public void setPocetak(Timestamp pocetak) {
        StavkaRacuna.pcSetpocetak(this, pocetak);
    }

    public Timestamp getKraj() {
        return StavkaRacuna.pcGetkraj(this);
    }

    public void setKraj(Timestamp kraj) {
        StavkaRacuna.pcSetkraj(this, kraj);
    }

    static /* synthetic */ Artikal access$102(StavkaRacuna x0, Artikal x1) {
        Artikal artikal = x1;
        StavkaRacuna.pcSetartikal(x0, artikal);
        return artikal;
    }

    static /* synthetic */ Integer access$202(StavkaRacuna x0, Integer x1) {
        Integer n = x1;
        StavkaRacuna.pcSetbrojStola(x0, n);
        return n;
    }

    static /* synthetic */ Double access$302(StavkaRacuna x0, Double x1) {
        Double d = x1;
        StavkaRacuna.pcSetkolicina(x0, d);
        return d;
    }

    static /* synthetic */ Double access$402(StavkaRacuna x0, Double x1) {
        Double d = x1;
        StavkaRacuna.pcSetcena(x0, d);
        return d;
    }

    static /* synthetic */ String access$502(StavkaRacuna x0, String x1) {
        String string = x1;
        StavkaRacuna.pcSetnaziv(x0, string);
        return string;
    }

    static /* synthetic */ Tura access$902(StavkaRacuna x0, Tura x1) {
        Tura tura = x1;
        StavkaRacuna.pcSettura(x0, tura);
        return tura;
    }

    static /* synthetic */ Racun access$1002(StavkaRacuna x0, Racun x1) {
        Racun racun = x1;
        StavkaRacuna.pcSetracun(x0, racun);
        return racun;
    }

    static /* synthetic */ StavkaRacuna access$1202(StavkaRacuna x0, StavkaRacuna x1) {
        StavkaRacuna stavkaRacuna = x1;
        StavkaRacuna.pcSetglavnaStavka(x0, stavkaRacuna);
        return stavkaRacuna;
    }

    static /* synthetic */ List access$1302(StavkaRacuna x0, List x1) {
        List list = x1;
        StavkaRacuna.pcSetpodStavke(x0, list);
        return list;
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1300381;
    }

    static {
        Class clazz = class$Lcom$dev63$restoran$model$BObject != null ? class$Lcom$dev63$restoran$model$BObject : (class$Lcom$dev63$restoran$model$BObject = StavkaRacuna.class$("com.dev63.restoran.model.BObject"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"artikal", "brojStola", "cena", "glavnaStavka", "kolicina", "kraj", "menipromet", "naziv", "opis", "pocetak", "podStavke", "pripremljena", "racun", "saStola", "tura"};
        Class[] classArray = new Class[15];
        Class clazz2 = class$Lcom$dev63$restoran$model$Artikal != null ? class$Lcom$dev63$restoran$model$Artikal : (class$Lcom$dev63$restoran$model$Artikal = StavkaRacuna.class$("com.dev63.restoran.model.Artikal"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = StavkaRacuna.class$("java.lang.Integer"));
        classArray[1] = clazz3;
        Class clazz4 = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = StavkaRacuna.class$("java.lang.Double"));
        classArray[2] = clazz4;
        Class clazz5 = class$Lcom$dev63$restoran$model$StavkaRacuna != null ? class$Lcom$dev63$restoran$model$StavkaRacuna : (class$Lcom$dev63$restoran$model$StavkaRacuna = StavkaRacuna.class$("com.dev63.restoran.model.StavkaRacuna"));
        classArray[3] = clazz5;
        classArray[4] = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = StavkaRacuna.class$("java.lang.Double"));
        Class clazz6 = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = StavkaRacuna.class$("java.sql.Timestamp"));
        classArray[5] = clazz6;
        classArray[6] = Boolean.TYPE;
        Class clazz7 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = StavkaRacuna.class$("java.lang.String"));
        classArray[7] = clazz7;
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = StavkaRacuna.class$("java.lang.String"));
        classArray[9] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = StavkaRacuna.class$("java.sql.Timestamp"));
        Class clazz8 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = StavkaRacuna.class$("java.util.List"));
        classArray[10] = clazz8;
        classArray[11] = Boolean.TYPE;
        Class clazz9 = class$Lcom$dev63$restoran$model$Racun != null ? class$Lcom$dev63$restoran$model$Racun : (class$Lcom$dev63$restoran$model$Racun = StavkaRacuna.class$("com.dev63.restoran.model.Racun"));
        classArray[12] = clazz9;
        classArray[13] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = StavkaRacuna.class$("java.lang.String"));
        Class clazz10 = class$Lcom$dev63$restoran$model$Tura != null ? class$Lcom$dev63$restoran$model$Tura : (class$Lcom$dev63$restoran$model$Tura = StavkaRacuna.class$("com.dev63.restoran.model.Tura"));
        classArray[14] = clazz10;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 10, 26, 26, 26, 26};
        PCRegistry.register((Class)(class$Lcom$dev63$restoran$model$StavkaRacuna != null ? class$Lcom$dev63$restoran$model$StavkaRacuna : (class$Lcom$dev63$restoran$model$StavkaRacuna = StavkaRacuna.class$("com.dev63.restoran.model.StavkaRacuna"))), (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"StavkaRacuna", (PersistenceCapable)new StavkaRacuna());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.artikal = null;
        this.brojStola = null;
        this.cena = null;
        this.glavnaStavka = null;
        this.kolicina = null;
        this.kraj = null;
        this.menipromet = false;
        this.naziv = null;
        this.opis = null;
        this.pocetak = null;
        this.podStavke = null;
        this.pripremljena = false;
        this.racun = null;
        this.saStola = null;
        this.tura = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        StavkaRacuna stavkaRacuna = new StavkaRacuna();
        if (bl) {
            stavkaRacuna.pcClearFields();
        }
        stavkaRacuna.pcStateManager = stateManager;
        stavkaRacuna.pcCopyKeyFieldsFromObjectId(object);
        return stavkaRacuna;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        StavkaRacuna stavkaRacuna = new StavkaRacuna();
        if (bl) {
            stavkaRacuna.pcClearFields();
        }
        stavkaRacuna.pcStateManager = stateManager;
        return stavkaRacuna;
    }

    protected static int pcGetManagedFieldCount() {
        return 15 + BObject.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.artikal = (Artikal)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.brojStola = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.cena = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.glavnaStavka = (StavkaRacuna)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.kolicina = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.kraj = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.menipromet = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.naziv = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.opis = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.pocetak = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.podStavke = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.pripremljena = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.racun = (Racun)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.saStola = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.tura = (Tura)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.artikal);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.brojStola);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.cena);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.glavnaStavka);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.kolicina);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.kraj);
                return;
            }
            case 6: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.menipromet);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.naziv);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.opis);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pocetak);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.podStavke);
                return;
            }
            case 11: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.pripremljena);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.racun);
                return;
            }
            case 13: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.saStola);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.tura);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(StavkaRacuna stavkaRacuna, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(stavkaRacuna, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.artikal = stavkaRacuna.artikal;
                return;
            }
            case 1: {
                this.brojStola = stavkaRacuna.brojStola;
                return;
            }
            case 2: {
                this.cena = stavkaRacuna.cena;
                return;
            }
            case 3: {
                this.glavnaStavka = stavkaRacuna.glavnaStavka;
                return;
            }
            case 4: {
                this.kolicina = stavkaRacuna.kolicina;
                return;
            }
            case 5: {
                this.kraj = stavkaRacuna.kraj;
                return;
            }
            case 6: {
                this.menipromet = stavkaRacuna.menipromet;
                return;
            }
            case 7: {
                this.naziv = stavkaRacuna.naziv;
                return;
            }
            case 8: {
                this.opis = stavkaRacuna.opis;
                return;
            }
            case 9: {
                this.pocetak = stavkaRacuna.pocetak;
                return;
            }
            case 10: {
                this.podStavke = stavkaRacuna.podStavke;
                return;
            }
            case 11: {
                this.pripremljena = stavkaRacuna.pripremljena;
                return;
            }
            case 12: {
                this.racun = stavkaRacuna.racun;
                return;
            }
            case 13: {
                this.saStola = stavkaRacuna.saStola;
                return;
            }
            case 14: {
                this.tura = stavkaRacuna.tura;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        StavkaRacuna stavkaRacuna = (StavkaRacuna)object;
        if (stavkaRacuna.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(stavkaRacuna, nArray[n]);
            ++n;
        }
    }

    private static final Artikal pcGetartikal(StavkaRacuna stavkaRacuna) {
        if (stavkaRacuna.pcStateManager == null) {
            return stavkaRacuna.artikal;
        }
        int n = pcInheritedFieldCount + 0;
        stavkaRacuna.pcStateManager.accessingField(n);
        return stavkaRacuna.artikal;
    }

    private static final void pcSetartikal(StavkaRacuna stavkaRacuna, Artikal artikal) {
        if (stavkaRacuna.pcStateManager == null) {
            stavkaRacuna.artikal = artikal;
            return;
        }
        stavkaRacuna.pcStateManager.settingObjectField((PersistenceCapable)stavkaRacuna, pcInheritedFieldCount + 0, (Object)stavkaRacuna.artikal, (Object)artikal, 0);
    }

    private static final Integer pcGetbrojStola(StavkaRacuna stavkaRacuna) {
        if (stavkaRacuna.pcStateManager == null) {
            return stavkaRacuna.brojStola;
        }
        int n = pcInheritedFieldCount + 1;
        stavkaRacuna.pcStateManager.accessingField(n);
        return stavkaRacuna.brojStola;
    }

    private static final void pcSetbrojStola(StavkaRacuna stavkaRacuna, Integer n) {
        if (stavkaRacuna.pcStateManager == null) {
            stavkaRacuna.brojStola = n;
            return;
        }
        stavkaRacuna.pcStateManager.settingObjectField((PersistenceCapable)stavkaRacuna, pcInheritedFieldCount + 1, (Object)stavkaRacuna.brojStola, (Object)n, 0);
    }

    private static final Double pcGetcena(StavkaRacuna stavkaRacuna) {
        if (stavkaRacuna.pcStateManager == null) {
            return stavkaRacuna.cena;
        }
        int n = pcInheritedFieldCount + 2;
        stavkaRacuna.pcStateManager.accessingField(n);
        return stavkaRacuna.cena;
    }

    private static final void pcSetcena(StavkaRacuna stavkaRacuna, Double d) {
        if (stavkaRacuna.pcStateManager == null) {
            stavkaRacuna.cena = d;
            return;
        }
        stavkaRacuna.pcStateManager.settingObjectField((PersistenceCapable)stavkaRacuna, pcInheritedFieldCount + 2, (Object)stavkaRacuna.cena, (Object)d, 0);
    }

    private static final StavkaRacuna pcGetglavnaStavka(StavkaRacuna stavkaRacuna) {
        if (stavkaRacuna.pcStateManager == null) {
            return stavkaRacuna.glavnaStavka;
        }
        int n = pcInheritedFieldCount + 3;
        stavkaRacuna.pcStateManager.accessingField(n);
        return stavkaRacuna.glavnaStavka;
    }

    private static final void pcSetglavnaStavka(StavkaRacuna stavkaRacuna, StavkaRacuna stavkaRacuna2) {
        if (stavkaRacuna.pcStateManager == null) {
            stavkaRacuna.glavnaStavka = stavkaRacuna2;
            return;
        }
        stavkaRacuna.pcStateManager.settingObjectField((PersistenceCapable)stavkaRacuna, pcInheritedFieldCount + 3, (Object)stavkaRacuna.glavnaStavka, (Object)stavkaRacuna2, 0);
    }

    private static final Double pcGetkolicina(StavkaRacuna stavkaRacuna) {
        if (stavkaRacuna.pcStateManager == null) {
            return stavkaRacuna.kolicina;
        }
        int n = pcInheritedFieldCount + 4;
        stavkaRacuna.pcStateManager.accessingField(n);
        return stavkaRacuna.kolicina;
    }

    private static final void pcSetkolicina(StavkaRacuna stavkaRacuna, Double d) {
        if (stavkaRacuna.pcStateManager == null) {
            stavkaRacuna.kolicina = d;
            return;
        }
        stavkaRacuna.pcStateManager.settingObjectField((PersistenceCapable)stavkaRacuna, pcInheritedFieldCount + 4, (Object)stavkaRacuna.kolicina, (Object)d, 0);
    }

    private static final Timestamp pcGetkraj(StavkaRacuna stavkaRacuna) {
        if (stavkaRacuna.pcStateManager == null) {
            return stavkaRacuna.kraj;
        }
        int n = pcInheritedFieldCount + 5;
        stavkaRacuna.pcStateManager.accessingField(n);
        return stavkaRacuna.kraj;
    }

    private static final void pcSetkraj(StavkaRacuna stavkaRacuna, Timestamp timestamp) {
        if (stavkaRacuna.pcStateManager == null) {
            stavkaRacuna.kraj = timestamp;
            return;
        }
        stavkaRacuna.pcStateManager.settingObjectField((PersistenceCapable)stavkaRacuna, pcInheritedFieldCount + 5, (Object)stavkaRacuna.kraj, (Object)timestamp, 0);
    }

    private static final boolean pcGetmenipromet(StavkaRacuna stavkaRacuna) {
        if (stavkaRacuna.pcStateManager == null) {
            return stavkaRacuna.menipromet;
        }
        int n = pcInheritedFieldCount + 6;
        stavkaRacuna.pcStateManager.accessingField(n);
        return stavkaRacuna.menipromet;
    }

    private static final void pcSetmenipromet(StavkaRacuna stavkaRacuna, boolean bl) {
        if (stavkaRacuna.pcStateManager == null) {
            stavkaRacuna.menipromet = bl;
            return;
        }
        stavkaRacuna.pcStateManager.settingBooleanField((PersistenceCapable)stavkaRacuna, pcInheritedFieldCount + 6, stavkaRacuna.menipromet, bl, 0);
    }

    private static final String pcGetnaziv(StavkaRacuna stavkaRacuna) {
        if (stavkaRacuna.pcStateManager == null) {
            return stavkaRacuna.naziv;
        }
        int n = pcInheritedFieldCount + 7;
        stavkaRacuna.pcStateManager.accessingField(n);
        return stavkaRacuna.naziv;
    }

    private static final void pcSetnaziv(StavkaRacuna stavkaRacuna, String string) {
        if (stavkaRacuna.pcStateManager == null) {
            stavkaRacuna.naziv = string;
            return;
        }
        stavkaRacuna.pcStateManager.settingStringField((PersistenceCapable)stavkaRacuna, pcInheritedFieldCount + 7, stavkaRacuna.naziv, string, 0);
    }

    private static final String pcGetopis(StavkaRacuna stavkaRacuna) {
        if (stavkaRacuna.pcStateManager == null) {
            return stavkaRacuna.opis;
        }
        int n = pcInheritedFieldCount + 8;
        stavkaRacuna.pcStateManager.accessingField(n);
        return stavkaRacuna.opis;
    }

    private static final void pcSetopis(StavkaRacuna stavkaRacuna, String string) {
        if (stavkaRacuna.pcStateManager == null) {
            stavkaRacuna.opis = string;
            return;
        }
        stavkaRacuna.pcStateManager.settingStringField((PersistenceCapable)stavkaRacuna, pcInheritedFieldCount + 8, stavkaRacuna.opis, string, 0);
    }

    private static final Timestamp pcGetpocetak(StavkaRacuna stavkaRacuna) {
        if (stavkaRacuna.pcStateManager == null) {
            return stavkaRacuna.pocetak;
        }
        int n = pcInheritedFieldCount + 9;
        stavkaRacuna.pcStateManager.accessingField(n);
        return stavkaRacuna.pocetak;
    }

    private static final void pcSetpocetak(StavkaRacuna stavkaRacuna, Timestamp timestamp) {
        if (stavkaRacuna.pcStateManager == null) {
            stavkaRacuna.pocetak = timestamp;
            return;
        }
        stavkaRacuna.pcStateManager.settingObjectField((PersistenceCapable)stavkaRacuna, pcInheritedFieldCount + 9, (Object)stavkaRacuna.pocetak, (Object)timestamp, 0);
    }

    private static final List pcGetpodStavke(StavkaRacuna stavkaRacuna) {
        if (stavkaRacuna.pcStateManager == null) {
            return stavkaRacuna.podStavke;
        }
        int n = pcInheritedFieldCount + 10;
        stavkaRacuna.pcStateManager.accessingField(n);
        return stavkaRacuna.podStavke;
    }

    private static final void pcSetpodStavke(StavkaRacuna stavkaRacuna, List list) {
        if (stavkaRacuna.pcStateManager == null) {
            stavkaRacuna.podStavke = list;
            return;
        }
        stavkaRacuna.pcStateManager.settingObjectField((PersistenceCapable)stavkaRacuna, pcInheritedFieldCount + 10, stavkaRacuna.podStavke, (Object)list, 0);
    }

    private static final boolean pcGetpripremljena(StavkaRacuna stavkaRacuna) {
        if (stavkaRacuna.pcStateManager == null) {
            return stavkaRacuna.pripremljena;
        }
        int n = pcInheritedFieldCount + 11;
        stavkaRacuna.pcStateManager.accessingField(n);
        return stavkaRacuna.pripremljena;
    }

    private static final void pcSetpripremljena(StavkaRacuna stavkaRacuna, boolean bl) {
        if (stavkaRacuna.pcStateManager == null) {
            stavkaRacuna.pripremljena = bl;
            return;
        }
        stavkaRacuna.pcStateManager.settingBooleanField((PersistenceCapable)stavkaRacuna, pcInheritedFieldCount + 11, stavkaRacuna.pripremljena, bl, 0);
    }

    private static final Racun pcGetracun(StavkaRacuna stavkaRacuna) {
        if (stavkaRacuna.pcStateManager == null) {
            return stavkaRacuna.racun;
        }
        int n = pcInheritedFieldCount + 12;
        stavkaRacuna.pcStateManager.accessingField(n);
        return stavkaRacuna.racun;
    }

    private static final void pcSetracun(StavkaRacuna stavkaRacuna, Racun racun) {
        if (stavkaRacuna.pcStateManager == null) {
            stavkaRacuna.racun = racun;
            return;
        }
        stavkaRacuna.pcStateManager.settingObjectField((PersistenceCapable)stavkaRacuna, pcInheritedFieldCount + 12, (Object)stavkaRacuna.racun, (Object)racun, 0);
    }

    private static final String pcGetsaStola(StavkaRacuna stavkaRacuna) {
        if (stavkaRacuna.pcStateManager == null) {
            return stavkaRacuna.saStola;
        }
        int n = pcInheritedFieldCount + 13;
        stavkaRacuna.pcStateManager.accessingField(n);
        return stavkaRacuna.saStola;
    }

    private static final void pcSetsaStola(StavkaRacuna stavkaRacuna, String string) {
        if (stavkaRacuna.pcStateManager == null) {
            stavkaRacuna.saStola = string;
            return;
        }
        stavkaRacuna.pcStateManager.settingStringField((PersistenceCapable)stavkaRacuna, pcInheritedFieldCount + 13, stavkaRacuna.saStola, string, 0);
    }

    private static final Tura pcGettura(StavkaRacuna stavkaRacuna) {
        if (stavkaRacuna.pcStateManager == null) {
            return stavkaRacuna.tura;
        }
        int n = pcInheritedFieldCount + 14;
        stavkaRacuna.pcStateManager.accessingField(n);
        return stavkaRacuna.tura;
    }

    private static final void pcSettura(StavkaRacuna stavkaRacuna, Tura tura) {
        if (stavkaRacuna.pcStateManager == null) {
            stavkaRacuna.tura = tura;
            return;
        }
        stavkaRacuna.pcStateManager.settingObjectField((PersistenceCapable)stavkaRacuna, pcInheritedFieldCount + 14, (Object)stavkaRacuna.tura, (Object)tura, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }

    public static class Builder
    extends GenericMutableBuilder<StavkaRacuna> {
        private Builder() {
            this.instance = new StavkaRacuna();
        }

        public Builder from(StavkaRacuna item) {
            if (item != null) {
                StavkaRacuna.access$102((StavkaRacuna)this.instance, StavkaRacuna.pcGetartikal(item));
                StavkaRacuna.access$202((StavkaRacuna)this.instance, StavkaRacuna.pcGetbrojStola(item));
                StavkaRacuna.access$302((StavkaRacuna)this.instance, StavkaRacuna.pcGetkolicina(item));
                StavkaRacuna.access$402((StavkaRacuna)this.instance, StavkaRacuna.pcGetcena(item));
                StavkaRacuna.access$502((StavkaRacuna)this.instance, StavkaRacuna.pcGetnaziv(item));
                ((StavkaRacuna)this.instance).kolicinaZaRastavljanjeLevo = item.kolicinaZaRastavljanjeLevo;
                ((StavkaRacuna)this.instance).kolicinaZaRastavljanjeDesno = item.kolicinaZaRastavljanjeDesno;
                ((StavkaRacuna)this.instance).kolicinaZaRastavljanjeDesnoPrikaz = item.kolicinaZaRastavljanjeDesnoPrikaz;
                StavkaRacuna.access$902((StavkaRacuna)this.instance, StavkaRacuna.pcGettura(item));
                StavkaRacuna.access$1002((StavkaRacuna)this.instance, StavkaRacuna.pcGetracun(item));
                ((StavkaRacuna)this.instance).opisniAtributi = item.opisniAtributi;
                StavkaRacuna.access$1202((StavkaRacuna)this.instance, StavkaRacuna.pcGetglavnaStavka(item));
                StavkaRacuna.access$1302((StavkaRacuna)this.instance, new LinkedList(StavkaRacuna.pcGetpodStavke(item)));
            }
            return this;
        }

        public Builder artikal(Artikal artikal) {
            StavkaRacuna.access$102((StavkaRacuna)this.instance, artikal);
            return this;
        }

        public Builder brojStola(Integer brojStola) {
            StavkaRacuna.access$202((StavkaRacuna)this.instance, brojStola);
            return this;
        }

        public Builder kolicina(BigDecimal kolicina) {
            StavkaRacuna.access$302((StavkaRacuna)this.instance, kolicina != null ? kolicina.doubleValue() : 0.0);
            return this;
        }

        public Builder cena(BigDecimal cena) {
            StavkaRacuna.access$402((StavkaRacuna)this.instance, cena != null ? cena.doubleValue() : 0.0);
            return this;
        }

        public Builder naziv(String naziv) {
            StavkaRacuna.access$502((StavkaRacuna)this.instance, naziv);
            return this;
        }

        public Builder kolicinaZaRastavljanjeLevo(BigDecimal kolicinaZaRastavljanjeLevo) {
            ((StavkaRacuna)this.instance).kolicinaZaRastavljanjeLevo = kolicinaZaRastavljanjeLevo;
            return this;
        }

        public Builder kolicinaZaRastavljanjeDesno(BigDecimal kolicinaZaRastavljanjeDesno) {
            ((StavkaRacuna)this.instance).kolicinaZaRastavljanjeDesno = kolicinaZaRastavljanjeDesno;
            return this;
        }

        public Builder kolicinaZaRastavljanjeDesnoPrikaz(BigDecimal kolicinaZaRastavljanjeDesnoPrikaz) {
            ((StavkaRacuna)this.instance).kolicinaZaRastavljanjeDesnoPrikaz = kolicinaZaRastavljanjeDesnoPrikaz;
            return this;
        }

        public Builder tura(Tura tura) {
            StavkaRacuna.access$902((StavkaRacuna)this.instance, tura);
            return this;
        }

        public Builder racun(Racun racun) {
            StavkaRacuna.access$1002((StavkaRacuna)this.instance, racun);
            return this;
        }

        public Builder glavnaStavka(StavkaRacuna glavnaStavka) {
            StavkaRacuna.access$1202((StavkaRacuna)this.instance, glavnaStavka);
            return this;
        }

        public Builder opisniAtributi(List<Atribut> opisniAtributi) {
            ((StavkaRacuna)this.instance).opisniAtributi = opisniAtributi;
            return this;
        }

        public Builder addOpisniAtribut(Atribut atribut) {
            ((StavkaRacuna)this.instance).opisniAtributi.add(atribut);
            return this;
        }

        public Builder podStavke(List<StavkaRacuna> podStavke) {
            StavkaRacuna.access$1302((StavkaRacuna)this.instance, podStavke);
            return this;
        }

        public Builder addPodStavka(StavkaRacuna podStavka) {
            StavkaRacuna.pcGetpodStavke((StavkaRacuna)this.instance).add(podStavka);
            return this;
        }
    }
}

