/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.model.BObject;
import com.dev63.restoran.model.Knjizenje;
import com.dev63.restoran.model.Knjiziv;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.TipPrijemnice;
import com.dev63.restoran.model.Trebovanje;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class Prijemnica
extends BObject
implements Knjiziv,
PersistenceCapable {
    private static final long serialVersionUID = 1L;
    @Column(nullable=false)
    private String brPrijemnice;
    @ManyToOne
    @JoinColumn
    private StalniGost dobavljac;
    @Temporal(value=TemporalType.DATE)
    private Date datumUnosa;
    @Temporal(value=TemporalType.DATE)
    private Date datumPrijemnice;
    @Column(nullable=false)
    private String uname;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="prijemnica", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PrijemnicaStavka> stavke;
    private String opis;
    private Double total;
    private Boolean crno;
    private String hacapVreme;
    private String regOznaka;
    private String kontrolisao;
    @Column(length=128)
    private String oznakaDokumenta;
    @Enumerated(value=EnumType.STRING)
    private TipPrijemnice tip = TipPrijemnice.PRIJEMNICA;
    @OneToOne(mappedBy="prijemnica")
    private Trebovanje trebovanje;
    @OneToMany(mappedBy="prijemnica")
    private List<Knjizenje> knjizenja = new LinkedList<Knjizenje>();
    @Temporal(value=TemporalType.DATE)
    private Date datumValute;
    @Transient
    private Double totalSaPDV;
    @Transient
    private Double totalBezPDV;
    private static int pcInheritedFieldCount = BObject.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$BObject;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Boolean;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$StalniGost;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$TipPrijemnice;
    static /* synthetic */ Class class$Ljava$lang$Double;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Trebovanje;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Prijemnica;

    public StalniGost getDobavljac() {
        return Prijemnica.pcGetdobavljac(this);
    }

    public void setDobavljac(StalniGost dobavljac) {
        Prijemnica.pcSetdobavljac(this, dobavljac);
    }

    public String getUname() {
        return Prijemnica.pcGetuname(this);
    }

    public void setUname(String uname) {
        Prijemnica.pcSetuname(this, uname);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        return hash += BObject.pcGetid(this) != null ? BObject.pcGetid(this).hashCode() : 0;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Prijemnica)) {
            return false;
        }
        Prijemnica other = (Prijemnica)object;
        return (BObject.pcGetid(this) != null || BObject.pcGetid(other) == null) && (BObject.pcGetid(this) == null || BObject.pcGetid(this).equals(BObject.pcGetid(other)));
    }

    public String getOpis() {
        return Prijemnica.pcGetopis(this);
    }

    public void setOpis(String opis) {
        Prijemnica.pcSetopis(this, opis);
    }

    @Override
    public String toString() {
        return Konstante.getDate(Prijemnica.pcGetdatumPrijemnice(this)) + ",  " + Konstante.getNumber2(Prijemnica.pcGettotal(this)) + " din,  " + Prijemnica.pcGetdobavljac(this).getSkrNaziv() + ",  " + Prijemnica.pcGetuname(this) + ",  " + Konstante.getDate(Prijemnica.pcGetdatumUnosa(this));
    }

    public String getBrPrijemnice() {
        return Prijemnica.pcGetbrPrijemnice(this);
    }

    public void setBrPrijemnice(String brPrijemnice) {
        Prijemnica.pcSetbrPrijemnice(this, brPrijemnice);
    }

    public Date getDatumUnosa() {
        return Prijemnica.pcGetdatumUnosa(this);
    }

    public void setDatumUnosa(Date datumUnosa) {
        Prijemnica.pcSetdatumUnosa(this, datumUnosa);
    }

    public Date getDatumPrijemnice() {
        return Prijemnica.pcGetdatumPrijemnice(this);
    }

    public void setDatumPrijemnice(Date datumPrijemnice) {
        Prijemnica.pcSetdatumPrijemnice(this, datumPrijemnice);
    }

    public Double getTotal() {
        return Prijemnica.pcGettotal(this);
    }

    public void setTotal(Double total) {
        Prijemnica.pcSettotal(this, total);
    }

    public Boolean getCrno() {
        return Prijemnica.pcGetcrno(this);
    }

    public void setCrno(Boolean crno) {
        Prijemnica.pcSetcrno(this, crno);
    }

    public List<PrijemnicaStavka> getStavke() {
        if (Prijemnica.pcGetstavke(this) == null) {
            Prijemnica.pcSetstavke(this, new ArrayList());
        }
        return Prijemnica.pcGetstavke(this);
    }

    public void setStavke(List<PrijemnicaStavka> stavke) {
        Prijemnica.pcSetstavke(this, stavke);
    }

    public TipPrijemnice getTip() {
        return Prijemnica.pcGettip(this);
    }

    public void setTip(TipPrijemnice tip) {
        Prijemnica.pcSettip(this, tip);
    }

    public Trebovanje getTrebovanje() {
        return Prijemnica.pcGettrebovanje(this);
    }

    public void setTrebovanje(Trebovanje trebovanje) {
        Prijemnica.pcSettrebovanje(this, trebovanje);
    }

    @Override
    public boolean getRealizovan() {
        boolean ret = false;
        if (Prijemnica.pcGetknjizenja(this) != null) {
            for (Knjizenje knjizenje : Prijemnica.pcGetknjizenja(this)) {
                if (!knjizenje.getRealizovano().booleanValue()) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    @Override
    public Double getRealizovaniIznos() {
        Double ret = 0.0;
        if (Prijemnica.pcGetknjizenja(this) != null) {
            for (Knjizenje knjizenje : Prijemnica.pcGetknjizenja(this)) {
                ret = ret + (knjizenje.getRealizovaniIznos() != null ? knjizenje.getRealizovaniIznos() : 0.0);
            }
        }
        return ret;
    }

    @Override
    public void setKnjizenja(List<Knjizenje> knjizenja) {
        Prijemnica.pcSetknjizenja(this, knjizenja);
    }

    @Override
    public List<Knjizenje> getKnjizenja() {
        return Prijemnica.pcGetknjizenja(this);
    }

    public String getOznakaDokumenta() {
        return Prijemnica.pcGetoznakaDokumenta(this);
    }

    public void setOznakaDokumenta(String oznakaDokumenta) {
        Prijemnica.pcSetoznakaDokumenta(this, oznakaDokumenta);
    }

    public Double getTotalBezPDV() {
        return this.totalBezPDV;
    }

    public void setTotalBezPDV(Double totalBezPDV) {
        this.totalBezPDV = totalBezPDV;
    }

    public void addTotalBezPDV(double totalBezPDV) {
        if (this.totalBezPDV == null) {
            this.totalBezPDV = 0.0;
        }
        Prijemnica prijemnica = this;
        prijemnica.totalBezPDV = prijemnica.totalBezPDV + totalBezPDV;
    }

    public Double getTotalSaPDV() {
        return this.totalSaPDV;
    }

    public void setTotalSaPDV(Double totalSaPDV) {
        this.totalSaPDV = totalSaPDV;
    }

    public void addTotalSaPDV(double totalSaPDV) {
        if (this.totalSaPDV == null) {
            this.totalSaPDV = 0.0;
        }
        Prijemnica prijemnica = this;
        prijemnica.totalSaPDV = prijemnica.totalSaPDV + totalSaPDV;
    }

    public Date getDatumValute() {
        return Prijemnica.pcGetdatumValute(this);
    }

    public void setDatumValute(Date datumValute) {
        Prijemnica.pcSetdatumValute(this, datumValute);
    }

    public String getHacapVreme() {
        return Prijemnica.pcGethacapVreme(this);
    }

    public void setHacapVreme(String hacapVreme) {
        Prijemnica.pcSethacapVreme(this, hacapVreme);
    }

    public String getRegOznaka() {
        return Prijemnica.pcGetregOznaka(this);
    }

    public void setRegOznaka(String regOznaka) {
        Prijemnica.pcSetregOznaka(this, regOznaka);
    }

    public String getKontrolisao() {
        return Prijemnica.pcGetkontrolisao(this);
    }

    public void setKontrolisao(String kontrolisao) {
        Prijemnica.pcSetkontrolisao(this, kontrolisao);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1300381;
    }

    static {
        Class clazz = class$Lcom$dev63$restoran$model$BObject != null ? class$Lcom$dev63$restoran$model$BObject : (class$Lcom$dev63$restoran$model$BObject = Prijemnica.class$("com.dev63.restoran.model.BObject"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"brPrijemnice", "crno", "datumPrijemnice", "datumUnosa", "datumValute", "dobavljac", "hacapVreme", "knjizenja", "kontrolisao", "opis", "oznakaDokumenta", "regOznaka", "stavke", "tip", "total", "trebovanje", "uname"};
        Class[] classArray = new Class[17];
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Prijemnica.class$("java.lang.String"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = Prijemnica.class$("java.lang.Boolean"));
        classArray[1] = clazz3;
        Class clazz4 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Prijemnica.class$("java.util.Date"));
        classArray[2] = clazz4;
        classArray[3] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Prijemnica.class$("java.util.Date"));
        classArray[4] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Prijemnica.class$("java.util.Date"));
        Class clazz5 = class$Lcom$dev63$restoran$model$StalniGost != null ? class$Lcom$dev63$restoran$model$StalniGost : (class$Lcom$dev63$restoran$model$StalniGost = Prijemnica.class$("com.dev63.restoran.model.StalniGost"));
        classArray[5] = clazz5;
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Prijemnica.class$("java.lang.String"));
        Class clazz6 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Prijemnica.class$("java.util.List"));
        classArray[7] = clazz6;
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Prijemnica.class$("java.lang.String"));
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Prijemnica.class$("java.lang.String"));
        classArray[10] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Prijemnica.class$("java.lang.String"));
        classArray[11] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Prijemnica.class$("java.lang.String"));
        classArray[12] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Prijemnica.class$("java.util.List"));
        Class clazz7 = class$Lcom$dev63$restoran$model$TipPrijemnice != null ? class$Lcom$dev63$restoran$model$TipPrijemnice : (class$Lcom$dev63$restoran$model$TipPrijemnice = Prijemnica.class$("com.dev63.restoran.model.TipPrijemnice"));
        classArray[13] = clazz7;
        Class clazz8 = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = Prijemnica.class$("java.lang.Double"));
        classArray[14] = clazz8;
        Class clazz9 = class$Lcom$dev63$restoran$model$Trebovanje != null ? class$Lcom$dev63$restoran$model$Trebovanje : (class$Lcom$dev63$restoran$model$Trebovanje = Prijemnica.class$("com.dev63.restoran.model.Trebovanje"));
        classArray[15] = clazz9;
        classArray[16] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Prijemnica.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 5, 26, 26, 26, 26, 10, 26, 26, 26, 26};
        Class clazz10 = class$Lcom$dev63$restoran$model$Prijemnica != null ? class$Lcom$dev63$restoran$model$Prijemnica : (class$Lcom$dev63$restoran$model$Prijemnica = Prijemnica.class$("com.dev63.restoran.model.Prijemnica"));
        PCRegistry.register((Class)clazz10, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Prijemnica", (PersistenceCapable)new Prijemnica());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.brPrijemnice = null;
        this.crno = null;
        this.datumPrijemnice = null;
        this.datumUnosa = null;
        this.datumValute = null;
        this.dobavljac = null;
        this.hacapVreme = null;
        this.knjizenja = null;
        this.kontrolisao = null;
        this.opis = null;
        this.oznakaDokumenta = null;
        this.regOznaka = null;
        this.stavke = null;
        this.tip = null;
        this.total = null;
        this.trebovanje = null;
        this.uname = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Prijemnica prijemnica = new Prijemnica();
        if (bl) {
            prijemnica.pcClearFields();
        }
        prijemnica.pcStateManager = stateManager;
        prijemnica.pcCopyKeyFieldsFromObjectId(object);
        return prijemnica;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Prijemnica prijemnica = new Prijemnica();
        if (bl) {
            prijemnica.pcClearFields();
        }
        prijemnica.pcStateManager = stateManager;
        return prijemnica;
    }

    protected static int pcGetManagedFieldCount() {
        return 17 + BObject.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.brPrijemnice = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.crno = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.datumPrijemnice = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.datumUnosa = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.datumValute = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.dobavljac = (StalniGost)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.hacapVreme = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.knjizenja = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.kontrolisao = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.opis = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.oznakaDokumenta = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.regOznaka = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.stavke = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.tip = (TipPrijemnice)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 14: {
                this.total = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.trebovanje = (Trebovanje)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.uname = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.brPrijemnice);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.crno);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.datumPrijemnice);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.datumUnosa);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.datumValute);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.dobavljac);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.hacapVreme);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.knjizenja);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.kontrolisao);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.opis);
                return;
            }
            case 10: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.oznakaDokumenta);
                return;
            }
            case 11: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.regOznaka);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.stavke);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.tip);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.total);
                return;
            }
            case 15: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.trebovanje);
                return;
            }
            case 16: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.uname);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Prijemnica prijemnica, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(prijemnica, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.brPrijemnice = prijemnica.brPrijemnice;
                return;
            }
            case 1: {
                this.crno = prijemnica.crno;
                return;
            }
            case 2: {
                this.datumPrijemnice = prijemnica.datumPrijemnice;
                return;
            }
            case 3: {
                this.datumUnosa = prijemnica.datumUnosa;
                return;
            }
            case 4: {
                this.datumValute = prijemnica.datumValute;
                return;
            }
            case 5: {
                this.dobavljac = prijemnica.dobavljac;
                return;
            }
            case 6: {
                this.hacapVreme = prijemnica.hacapVreme;
                return;
            }
            case 7: {
                this.knjizenja = prijemnica.knjizenja;
                return;
            }
            case 8: {
                this.kontrolisao = prijemnica.kontrolisao;
                return;
            }
            case 9: {
                this.opis = prijemnica.opis;
                return;
            }
            case 10: {
                this.oznakaDokumenta = prijemnica.oznakaDokumenta;
                return;
            }
            case 11: {
                this.regOznaka = prijemnica.regOznaka;
                return;
            }
            case 12: {
                this.stavke = prijemnica.stavke;
                return;
            }
            case 13: {
                this.tip = prijemnica.tip;
                return;
            }
            case 14: {
                this.total = prijemnica.total;
                return;
            }
            case 15: {
                this.trebovanje = prijemnica.trebovanje;
                return;
            }
            case 16: {
                this.uname = prijemnica.uname;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        Prijemnica prijemnica = (Prijemnica)object;
        if (prijemnica.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(prijemnica, nArray[n]);
            ++n;
        }
    }

    private static final String pcGetbrPrijemnice(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.brPrijemnice;
        }
        int n = pcInheritedFieldCount + 0;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.brPrijemnice;
    }

    private static final void pcSetbrPrijemnice(Prijemnica prijemnica, String string) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.brPrijemnice = string;
            return;
        }
        prijemnica.pcStateManager.settingStringField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 0, prijemnica.brPrijemnice, string, 0);
    }

    private static final Boolean pcGetcrno(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.crno;
        }
        int n = pcInheritedFieldCount + 1;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.crno;
    }

    private static final void pcSetcrno(Prijemnica prijemnica, Boolean bl) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.crno = bl;
            return;
        }
        prijemnica.pcStateManager.settingObjectField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 1, (Object)prijemnica.crno, (Object)bl, 0);
    }

    private static final Date pcGetdatumPrijemnice(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.datumPrijemnice;
        }
        int n = pcInheritedFieldCount + 2;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.datumPrijemnice;
    }

    private static final void pcSetdatumPrijemnice(Prijemnica prijemnica, Date date) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.datumPrijemnice = date;
            return;
        }
        prijemnica.pcStateManager.settingObjectField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 2, (Object)prijemnica.datumPrijemnice, (Object)date, 0);
    }

    private static final Date pcGetdatumUnosa(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.datumUnosa;
        }
        int n = pcInheritedFieldCount + 3;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.datumUnosa;
    }

    private static final void pcSetdatumUnosa(Prijemnica prijemnica, Date date) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.datumUnosa = date;
            return;
        }
        prijemnica.pcStateManager.settingObjectField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 3, (Object)prijemnica.datumUnosa, (Object)date, 0);
    }

    private static final Date pcGetdatumValute(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.datumValute;
        }
        int n = pcInheritedFieldCount + 4;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.datumValute;
    }

    private static final void pcSetdatumValute(Prijemnica prijemnica, Date date) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.datumValute = date;
            return;
        }
        prijemnica.pcStateManager.settingObjectField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 4, (Object)prijemnica.datumValute, (Object)date, 0);
    }

    private static final StalniGost pcGetdobavljac(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.dobavljac;
        }
        int n = pcInheritedFieldCount + 5;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.dobavljac;
    }

    private static final void pcSetdobavljac(Prijemnica prijemnica, StalniGost stalniGost) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.dobavljac = stalniGost;
            return;
        }
        prijemnica.pcStateManager.settingObjectField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 5, (Object)prijemnica.dobavljac, (Object)stalniGost, 0);
    }

    private static final String pcGethacapVreme(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.hacapVreme;
        }
        int n = pcInheritedFieldCount + 6;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.hacapVreme;
    }

    private static final void pcSethacapVreme(Prijemnica prijemnica, String string) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.hacapVreme = string;
            return;
        }
        prijemnica.pcStateManager.settingStringField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 6, prijemnica.hacapVreme, string, 0);
    }

    private static final List pcGetknjizenja(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.knjizenja;
        }
        int n = pcInheritedFieldCount + 7;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.knjizenja;
    }

    private static final void pcSetknjizenja(Prijemnica prijemnica, List list) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.knjizenja = list;
            return;
        }
        prijemnica.pcStateManager.settingObjectField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 7, prijemnica.knjizenja, (Object)list, 0);
    }

    private static final String pcGetkontrolisao(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.kontrolisao;
        }
        int n = pcInheritedFieldCount + 8;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.kontrolisao;
    }

    private static final void pcSetkontrolisao(Prijemnica prijemnica, String string) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.kontrolisao = string;
            return;
        }
        prijemnica.pcStateManager.settingStringField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 8, prijemnica.kontrolisao, string, 0);
    }

    private static final String pcGetopis(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.opis;
        }
        int n = pcInheritedFieldCount + 9;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.opis;
    }

    private static final void pcSetopis(Prijemnica prijemnica, String string) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.opis = string;
            return;
        }
        prijemnica.pcStateManager.settingStringField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 9, prijemnica.opis, string, 0);
    }

    private static final String pcGetoznakaDokumenta(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.oznakaDokumenta;
        }
        int n = pcInheritedFieldCount + 10;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.oznakaDokumenta;
    }

    private static final void pcSetoznakaDokumenta(Prijemnica prijemnica, String string) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.oznakaDokumenta = string;
            return;
        }
        prijemnica.pcStateManager.settingStringField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 10, prijemnica.oznakaDokumenta, string, 0);
    }

    private static final String pcGetregOznaka(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.regOznaka;
        }
        int n = pcInheritedFieldCount + 11;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.regOznaka;
    }

    private static final void pcSetregOznaka(Prijemnica prijemnica, String string) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.regOznaka = string;
            return;
        }
        prijemnica.pcStateManager.settingStringField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 11, prijemnica.regOznaka, string, 0);
    }

    private static final List pcGetstavke(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.stavke;
        }
        int n = pcInheritedFieldCount + 12;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.stavke;
    }

    private static final void pcSetstavke(Prijemnica prijemnica, List list) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.stavke = list;
            return;
        }
        prijemnica.pcStateManager.settingObjectField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 12, prijemnica.stavke, (Object)list, 0);
    }

    private static final TipPrijemnice pcGettip(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.tip;
        }
        int n = pcInheritedFieldCount + 13;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.tip;
    }

    private static final void pcSettip(Prijemnica prijemnica, TipPrijemnice tipPrijemnice) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.tip = tipPrijemnice;
            return;
        }
        prijemnica.pcStateManager.settingObjectField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 13, (Object)prijemnica.tip, (Object)tipPrijemnice, 0);
    }

    private static final Double pcGettotal(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.total;
        }
        int n = pcInheritedFieldCount + 14;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.total;
    }

    private static final void pcSettotal(Prijemnica prijemnica, Double d) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.total = d;
            return;
        }
        prijemnica.pcStateManager.settingObjectField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 14, (Object)prijemnica.total, (Object)d, 0);
    }

    private static final Trebovanje pcGettrebovanje(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.trebovanje;
        }
        int n = pcInheritedFieldCount + 15;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.trebovanje;
    }

    private static final void pcSettrebovanje(Prijemnica prijemnica, Trebovanje trebovanje) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.trebovanje = trebovanje;
            return;
        }
        prijemnica.pcStateManager.settingObjectField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 15, (Object)prijemnica.trebovanje, (Object)trebovanje, 0);
    }

    private static final String pcGetuname(Prijemnica prijemnica) {
        if (prijemnica.pcStateManager == null) {
            return prijemnica.uname;
        }
        int n = pcInheritedFieldCount + 16;
        prijemnica.pcStateManager.accessingField(n);
        return prijemnica.uname;
    }

    private static final void pcSetuname(Prijemnica prijemnica, String string) {
        if (prijemnica.pcStateManager == null) {
            prijemnica.uname = string;
            return;
        }
        prijemnica.pcStateManager.settingStringField((PersistenceCapable)prijemnica, pcInheritedFieldCount + 16, prijemnica.uname, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

