/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.lang;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public enum Language {
    SRPSKI("Srpski", new Locale("sr", "RS")),
    HRVATSKI("Hrvatski", new Locale("hr", "HR")),
    CRNOGORSKI("Crnogorski", new Locale("sr", "ME")),
    ENGLESKI("English", new Locale("en", "US")),
    NEMACKI("Deutsch", new Locale("de", "DE")),
    SLOVENACKI("Sloven\u0161\u010dina", new Locale("sl", "SI")),
    BOSANSKI("Bosanski", new Locale("bs", "BA")),
    SHQIPTAR("Shqiptar", new Locale("al", "AL")),
    MAKEDONSKI("Makedonski", new Locale("mk", "MK"));

    private String name;
    private Locale langLocale;

    private Language(String name, Locale langLocale) {
        this.name = name;
        this.langLocale = langLocale;
    }

    public String getName() {
        return this.name;
    }

    public Locale getLangLocale() {
        return this.langLocale;
    }

    public static Language findByName(String name) {
        Language lang = null;
        for (Language language : Language.values()) {
            if (!language.getName().equals(name)) continue;
            lang = language;
            break;
        }
        return lang;
    }

    public static List<Language> listPrioritizedByLocales(Locale[] locales) {
        LinkedList<Language> list = new LinkedList<Language>();
        for (Language language : Language.values()) {
            for (Locale loc : locales) {
                if (!language.getLangLocale().equals(loc) || list.contains((Object)language)) continue;
                list.add(language);
            }
        }
        for (Language language : Language.values()) {
            for (Locale loc : locales) {
                if (!language.getLangLocale().getLanguage().equals(loc.getLanguage()) || !language.getLangLocale().getCountry().equals(loc.getCountry()) || list.contains((Object)language)) continue;
                list.add(language);
            }
        }
        for (Language language : Language.values()) {
            for (Locale loc : locales) {
                if (!language.getLangLocale().getLanguage().equals(loc.getLanguage()) || list.contains((Object)language)) continue;
                list.add(language);
            }
        }
        for (Language language : Language.values()) {
            if (list.contains((Object)language)) continue;
            list.add(language);
        }
        return list;
    }
}

