/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.jpa;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class JPAUtil {
    private static final Logger log = Logger.getLogger(JPAUtil.class.getName());
    private static EntityManagerFactory restoranEmf;
    private static final Map<String, EntityManagerFactory> emfInstances;
    private static final Map<EntityManagerFactory, Set<EntityManager>> persistenceInstances;

    private static EntityManagerFactory createEMF(String dbUser, String dbPass, String dbHost, String schemaName, boolean runtimeUnenhancedSupported) {
        Properties props = new Properties();
        props.setProperty("openjpa.ConnectionUserName", dbUser);
        props.setProperty("openjpa.ConnectionPassword", dbPass);
        props.setProperty("openjpa.ConnectionURL", "jdbc:mysql://" + dbHost + "/" + schemaName + "?useUnicode=true&connectionCollation=utf8_general_ci&characterSetResults=utf8");
        props.setProperty("openjpa.ConnectionDriverName", "com.mysql.jdbc.Driver");
        props.setProperty("openjpa.jdbc.DBDictionary", "TableType=innoDB,blobTypeName=mediumblob");
        props.setProperty("openjpa.jdbc.SynchronizeMappings", "buildSchema(SchemaAction='add',ForeignKeys=true)");
        props.setProperty("openjpa.RuntimeUnenhancedClasses", runtimeUnenhancedSupported ? "supported" : "unsupported");
        props.setProperty("openjpa.Multithreaded", "true");
        final EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"restoran", (Map)props);
        final String key = JPAUtil.toEmfKey(dbUser, dbPass, dbHost, schemaName, runtimeUnenhancedSupported);
        emfInstances.put(key, emf);
        persistenceInstances.put(emf, new HashSet());
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (emf != null && emf.isOpen()) {
                    Iterator iterator = ((Set)persistenceInstances.get(emf)).iterator();
                    while (iterator.hasNext()) {
                        JPAUtil.closeEmInternal((EntityManager)iterator.next());
                        iterator.remove();
                    }
                    emf.close();
                    persistenceInstances.remove(emf);
                    emfInstances.remove(key);
                }
            }
        }));
        return emf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EntityManagerFactory getEmf(String dbUser, String dbPass, String dbHost, String schemaName, boolean runtimeUnenhancedSupported) {
        EntityManagerFactory emf = emfInstances.get(JPAUtil.toEmfKey(dbUser, dbPass, dbHost, schemaName, runtimeUnenhancedSupported));
        if (emf != null) {
            if (emf.isOpen()) return emf;
        }
        Class<JPAUtil> clazz = JPAUtil.class;
        synchronized (JPAUtil.class) {
            if (emf == null) return JPAUtil.createEMF(dbUser, dbPass, dbHost, schemaName, runtimeUnenhancedSupported);
            if (emf.isOpen()) return emf;
            return JPAUtil.createEMF(dbUser, dbPass, dbHost, schemaName, runtimeUnenhancedSupported);
        }
    }

    public static EntityManagerFactory getRestEmf() {
        return JPAUtil.getEmf("root", "928374", "localhost", "restoran", true);
    }

    private static EntityManager getEmInternal(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        persistenceInstances.get(emf).add(em);
        return em;
    }

    public static EntityManager getEm(String dbUser, String dbPass, String dbHost, String schemaName, boolean runtimeUnenhancedSupported) {
        return JPAUtil.getEmInternal(JPAUtil.getEmf(dbUser, dbPass, dbHost, schemaName, runtimeUnenhancedSupported));
    }

    public static EntityManager getRestEm() {
        return JPAUtil.getEmInternal(JPAUtil.getRestEmf());
    }

    private static void closeEmInternal(EntityManager em) {
        if (em == null) {
            return;
        }
        if (em.isOpen()) {
            JPAUtil.safeCloseTransactionInternal(em);
            em.close();
        }
    }

    private static void safeCloseTransactionInternal(EntityManager em) {
        if (em == null || em.getTransaction() == null) {
            return;
        }
        try {
            if (em.getTransaction().isActive()) {
                log.info(MessageFormat.format("Rolling back transaction for safety from {0}.{1}", Thread.currentThread().getStackTrace()[4].getClassName(), Thread.currentThread().getStackTrace()[4].getMethodName()));
                em.getTransaction().rollback();
                log.info("Transaction succesfully rolled back!");
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, MessageFormat.format("Error rolling back transaction.\nMessage: {0}", ex.getMessage()), ex);
        }
    }

    private static void safeCloseTransactionByPass(EntityManager em) {
        JPAUtil.safeCloseTransactionInternal(em);
    }

    public static void safeCloseTransaction(EntityManager em) {
        JPAUtil.safeCloseTransactionByPass(em);
    }

    public static void closeEmQuiet(EntityManager em) {
        try {
            JPAUtil.closeEmInternal(em);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, MessageFormat.format("Error closing entity manager./nMessage: {0}", ex.getMessage()), ex);
        }
    }

    public static void closeEm(EntityManager em) {
        JPAUtil.closeEmInternal(em);
    }

    private static String toEmfKey(String dbUser, String dbPass, String dbHost, String schemaName, boolean runtimeUnenhancedSupported) {
        return Objects.toString(dbUser).concat("~").concat(dbPass).concat("~").concat(dbHost).concat("~").concat(schemaName).concat("~").concat(Boolean.toString(runtimeUnenhancedSupported));
    }

    static {
        emfInstances = new ConcurrentHashMap<String, EntityManagerFactory>();
        persistenceInstances = new ConcurrentHashMap<EntityManagerFactory, Set<EntityManager>>();
    }
}

