/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji.stampa;

import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.nivelacija.NivelacijaRow;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import org.eclipse.nebula.paperclips.core.EmptyPrint;
import org.eclipse.nebula.paperclips.core.ImagePrint;
import org.eclipse.nebula.paperclips.core.LinePrint;
import org.eclipse.nebula.paperclips.core.NoBreakPrint;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.border.Border;
import org.eclipse.nebula.paperclips.core.border.LineBorder;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PageDecoration;
import org.eclipse.nebula.paperclips.core.page.PageNumber;
import org.eclipse.nebula.paperclips.core.page.PageNumberFormat;
import org.eclipse.nebula.paperclips.core.page.PageNumberPrint;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.nebula.paperclips.core.text.StyledTextPrint;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.nebula.paperclips.core.text.TextStyle;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class StampaNivelacijeNPC
extends PagePrint {
    private final String header1 = "Red.\nbr.";
    private final String header2 = "Naziv robe";
    private final String header3 = "Jed.\nmere";
    private final String header4 = "Koli\u010dina";
    private final String header5 = "Stara\ncena";
    private final String header6 = "Nova\ncena";
    private final String header7 = "Pove\u0107anje\ncene\n(6-5)";
    private final String header8 = "PDV\n(6xPDV)";
    private final String header9 = "Pove\u0107anje\nPDV-a";
    private final String header10 = "Stara cena\nsa PDV-om";
    private final String header11 = "Nova cena\nsa PDV-om";
    private final String header12 = "Pove\u0107anje\nrazlike u\nceni";
    private final String header13 = "Pove\u0107anje\nporeza";
    private final String totalHeader1 = "Ukupno";
    private final String totalHeader2 = "Ukupna razlika";
    private final String footerPageNumFormat = "Strana %1$d od %2$d";
    private final String signTitle1 = "Datum";
    private final String signTitle2 = "Odgovorno lice";
    private final String headerDataLine1 = "PIB";
    private final String headerDataLine2 = "Obveznik";
    private final String headerDataLine3 = "Firma - radnje";
    private final String headerDataLine4 = "Sedi\u0161te";
    private final String headerDataLine5 = "\u0160ifra poreskog obveznika";
    private final String headerDataLine6 = "\u0160ifra delatnosti";
    private final String headerTitleLine1 = "NIVELACIJA PRODAJNE CENE";
    private final String headerDocDataLine1 = "ObrazacNC";
    private final String fontName;
    private final FontData titleFont;
    private final FontData textFont;
    private final FontData cellHeaderFont;
    private final FontData cellFont;
    private final FontData footerFont = new FontData(this.fontName, 6, 2);
    private final int normalHeight;
    private final int headerHeight;
    private TextStyle normalText;
    private TextStyle boldText;
    private TextStyle boldHeader;
    private TextStyle normalHeader;
    private RoundingMode rm;
    private GridColumn[] columns;
    private List<NivelacijaRow> data;
    private ImageData titleLogo;
    private String pib;
    private String obveznik;
    private String firmaRadnje;
    private String sediste;
    private String sifraPoreskogObveznika;
    private String sifraDelatnosti;
    private String brojDokumenta;
    private String datumDokumenta;
    private String dobavljac;
    private String brojKalkulacije;
    private Date forDate;

    public StampaNivelacijeNPC(List<NivelacijaRow> input, EnumMap<DataKey, String> data, Date forDate) {
        super((Print)new EmptyPrint());
        this.fontName = "Arial";
        this.normalHeight = 8;
        this.headerHeight = 10;
        this.cellFont = new FontData(this.fontName, 7, 0);
        this.cellHeaderFont = new FontData(this.fontName, 7, 1);
        this.textFont = new FontData(this.fontName, 12, 0);
        this.titleFont = new FontData(this.fontName, 16, 1);
        this.rm = RoundingMode.HALF_UP;
        this.data = input;
        this.forDate = forDate;
        this.initiateTextStyles();
        this.loadData(data);
        this.setHeader(this.makeHeader());
        this.setBody(this.makeBody());
        super.setFooter(this.makeFooter());
    }

    private void loadData(EnumMap<DataKey, String> data) {
        if (data != null) {
            block11: for (DataKey dataKey : DataKey.values()) {
                switch (dataKey) {
                    case LOGO_PATH: {
                        try {
                            this.titleLogo = new ImageData(data.get((Object)dataKey));
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.out);
                        }
                    }
                    case PIB: {
                        this.pib = data.get((Object)dataKey);
                        continue block11;
                    }
                    case OBVEZNIK: {
                        this.obveznik = data.get((Object)dataKey);
                        continue block11;
                    }
                    case FIRMA_RADNJE: {
                        this.firmaRadnje = data.get((Object)dataKey);
                        continue block11;
                    }
                    case SEDISTE: {
                        this.sediste = data.get((Object)dataKey);
                        continue block11;
                    }
                    case SIFRA_PORESKOG_OBVEZNIKA: {
                        this.sifraPoreskogObveznika = data.get((Object)dataKey);
                        continue block11;
                    }
                    case SIFRA_DELATNOSTI: {
                        this.sifraDelatnosti = data.get((Object)dataKey);
                    }
                }
            }
        }
    }

    private void initiateTextStyles() {
        this.normalText = new TextStyle().fontName(this.fontName).fontHeight(this.normalHeight).fontStyle(0);
        this.boldText = new TextStyle().fontName(this.fontName).fontHeight(this.normalHeight).fontStyle(1);
        this.normalHeader = new TextStyle().fontName(this.fontName).fontHeight(this.headerHeight).fontStyle(0);
        this.boldHeader = new TextStyle().fontName(this.fontName).fontHeight(this.headerHeight).fontStyle(1);
    }

    private Print makeBody() {
        GridPrint body = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 100), new GridColumn(16384, 1, 100)});
        body.setLook((GridLook)new DefaultGridLook(0, 5));
        body.add(this.makeDataGrid(this.data), -1);
        body.add((Print)new EmptyPrint(10, 10), -1);
        body.add((Print)new NoBreakPrint(this.makeSignature()), -1);
        return body;
    }

    private Print makeSignature() {
        GridPrint signature = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 1, 50), new GridColumn(0x1000000, 1, 50)});
        signature.add((Print)new EmptyPrint(15, 15), -1);
        signature.add(0x1000000, 0x1000000, (Print)this.normalHeader.create("Datum"));
        signature.add(0x1000000, 0x1000000, (Print)this.normalHeader.create("Odgovorno lice"));
        signature.add(0x1000000, 0x1000000, (Print)this.normalHeader.create(StatLogic.getDateString(this.forDate)));
        signature.add(0x1000000, 0x1000000, (Print)this.normalHeader.create("______________________________"));
        return signature;
    }

    private Print makeDataGrid(List<NivelacijaRow> data) {
        GridPrint main = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 1, 100)}, (GridLook)new DefaultGridLook(0, 15));
        GridPrint gridP = new GridPrint(this.getColumns());
        gridP.setCellClippingEnabled(false);
        DefaultGridLook gl = new DefaultGridLook();
        gl.setCellBorder((Border)new LineBorder(new RGB(64, 64, 64)));
        gl.setHeaderBackground(new RGB(240, 240, 240));
        gridP.setLook((GridLook)gl);
        this.addHeader(gridP);
        this.addContent(gridP, data);
        main.add((Print)gridP);
        return main;
    }

    private GridColumn[] getColumns() {
        if (this.columns == null || this.columns.length == 0) {
            GridColumn[] gridColumnArray = new GridColumn[13];
            int w = 17;
            gridColumnArray[0] = new GridColumn(131072, 17, w);
            w = 60;
            gridColumnArray[1] = new GridColumn(16384, 60, w);
            w = 20;
            gridColumnArray[2] = new GridColumn(0x1000000, 20, w);
            w = 30;
            gridColumnArray[3] = new GridColumn(131072, 30, w);
            w = 30;
            gridColumnArray[4] = new GridColumn(131072, 30, w);
            w = 30;
            gridColumnArray[5] = new GridColumn(131072, 30, w);
            w = 30;
            gridColumnArray[6] = new GridColumn(131072, 30, w);
            w = 33;
            gridColumnArray[7] = new GridColumn(131072, 33, w);
            w = 37;
            gridColumnArray[8] = new GridColumn(131072, 37, w);
            w = 35;
            gridColumnArray[9] = new GridColumn(131072, 35, w);
            w = 40;
            gridColumnArray[10] = new GridColumn(131072, 40, w);
            w = 40;
            gridColumnArray[11] = new GridColumn(131072, 40, w);
            w = 40;
            gridColumnArray[12] = new GridColumn(131072, 40, w);
            this.columns = gridColumnArray;
        }
        return this.columns;
    }

    private void addHeader(GridPrint grid) {
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Red.\nbr."));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Naziv robe"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Jed.\nmere"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Koli\u010dina"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Stara\ncena"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Nova\ncena"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Pove\u0107anje\ncene\n(6-5)"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("PDV\n(6xPDV)"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Pove\u0107anje\nPDV-a"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Stara cena\nsa PDV-om"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Nova cena\nsa PDV-om"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Pove\u0107anje\nrazlike u\nceni"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Pove\u0107anje\nporeza"));
        for (int c = 0; c < grid.getColumns().length; ++c) {
            grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create(Integer.toString(c + 1)));
        }
    }

    private void addContent(GridPrint grid, List<NivelacijaRow> p) {
        if (grid == null || p == null || p.isEmpty()) {
            return;
        }
        BigDecimal uUkupnaRazlika = BigDecimal.ZERO;
        BigDecimal uPovecanjeRazlikeUCeni = BigDecimal.ZERO;
        BigDecimal uPovecanjePoreza = BigDecimal.ZERO;
        for (NivelacijaRow ps : p) {
            BigDecimal povecanjeRazlikeUCeni = ps.povecanjeRazlikeUCeni.setScale(2, this.rm);
            BigDecimal povecanjePoreza = ps.povecanjePoreza.setScale(2, this.rm);
            uPovecanjeRazlikeUCeni = uPovecanjeRazlikeUCeni.add(povecanjeRazlikeUCeni);
            uPovecanjePoreza = uPovecanjePoreza.add(povecanjePoreza);
            uUkupnaRazlika = uUkupnaRazlika.add(povecanjeRazlikeUCeni).add(povecanjePoreza);
            grid.add((Print)this.normalText.create(Integer.toString(ps.redniBroj)));
            grid.add((Print)this.normalText.create(ps.naziv));
            grid.add((Print)this.normalText.create(ps.jedinicaMere));
            grid.add((Print)this.normalText.create(StatLogic.getNumber03NG(ps.kolicina)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(ps.staraCena)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(ps.novaCena)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(ps.povecanjeCene)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(ps.PDV)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(ps.povecanjePDVa)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(ps.staraCenaSaPDVom)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(ps.novaCenaSaPDVom)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(ps.povecanjeRazlikeUCeni)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(ps.povecanjePoreza)));
        }
        grid.add(this.makeTotal(uPovecanjeRazlikeUCeni, uPovecanjePoreza, uUkupnaRazlika), -1);
    }

    private Print makeTotal(BigDecimal uPovecanjeRazlikeUCeni, BigDecimal uPovecanjePoreza, BigDecimal uRazlikaUCeni) {
        GridPrint grid = new GridPrint(this.getColumns());
        grid.add(16384, 1024, (Print)this.boldHeader.create("Ukupno"), this.getColumns().length - 2);
        grid.add(131072, 1024, (Print)this.normalText.create(StatLogic.getNumber02NG(uPovecanjeRazlikeUCeni)));
        grid.add(131072, 1024, (Print)this.normalText.create(StatLogic.getNumber02NG(uPovecanjePoreza)));
        grid.add((Print)new EmptyPrint(), -1);
        grid.add((Print)new LinePrint(256), -1);
        grid.add((Print)new EmptyPrint(), -1);
        grid.add(131072, 1024, (Print)this.boldHeader.create("Ukupna razlika"), this.getColumns().length - 1);
        grid.add(131072, 1024, (Print)this.normalText.create(StatLogic.getNumber02NG(uRazlikaUCeni)));
        grid.add((Print)new EmptyPrint(), -1);
        return grid;
    }

    public List<NivelacijaRow> getInput() {
        return this.data;
    }

    public void setInput(List<NivelacijaRow> input) {
        this.data = input;
    }

    private PageDecoration makeFooter() {
        return new PageDecoration(){

            public Print createPrint(PageNumber pn) {
                GridPrint print = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 50), new GridColumn(131072, -1, 50)});
                print.add(16384, 1024, (Print)new TextPrint(StatLogic.getDateTimeString(new Date()), StampaNivelacijeNPC.this.footerFont, 16384));
                PageNumberPrint pnp = new PageNumberPrint(pn, StampaNivelacijeNPC.this.footerFont, 131072);
                pnp.setPageNumberFormat(new PageNumberFormat(){

                    public String format(PageNumber pn) {
                        return String.format("Strana %1$d od %2$d", pn.getPageNumber() + 1, pn.getPageCount());
                    }
                });
                print.add(131072, 1024, (Print)pnp);
                return print;
            }
        };
    }

    private PageDecoration makeHeader() {
        return new PageDecoration(){

            public Print createPrint(PageNumber pn) {
                GridPrint hgp = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 30), new GridColumn(16384, 1, 55), new GridColumn(16384, 1, 15)});
                Print data = StampaNivelacijeNPC.this.createHeaderDataPrint();
                Print title = StampaNivelacijeNPC.this.createHeaderTitlePrint();
                Print docData = StampaNivelacijeNPC.this.createHeaderDocData();
                hgp.add(16384, 128, data);
                hgp.add(0x1000000, 128, title);
                hgp.add(16384, 128, docData);
                hgp.add((Print)new EmptyPrint(15, 15), -1);
                return hgp;
            }
        };
    }

    private Print createHeaderDataPrint() {
        GridPrint data = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 1)});
        data.add((Print)new EmptyPrint(5, 15));
        data.add(this.createHeaderDataRow("PIB", this.pib));
        data.add(this.createHeaderDataRow("Obveznik", this.obveznik));
        data.add(this.createHeaderDataRow("Firma - radnje", this.firmaRadnje));
        data.add(this.createHeaderDataRow("Sedi\u0161te", this.sediste));
        data.add(this.createHeaderDataRow("\u0160ifra poreskog obveznika", this.sifraPoreskogObveznika));
        data.add(this.createHeaderDataRow("\u0160ifra delatnosti", this.sifraDelatnosti));
        return data;
    }

    private Print createHeaderDataRow(String key, String value) {
        EmptyPrint p;
        if (key != null) {
            StyledTextPrint stp = new StyledTextPrint();
            stp.append(key + "  ", this.boldText);
            if (value != null) {
                stp.append(value, this.normalText);
            }
            p = stp;
        } else {
            p = new EmptyPrint();
        }
        return p;
    }

    private Print createHeaderTitlePrint() {
        ImageData titleImage = this.titleLogo;
        GridPrint title = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 1)});
        DefaultGridLook gl = new DefaultGridLook(3, 3);
        title.setLook((GridLook)gl);
        Point logoSize = new Point(220, 35);
        if (titleImage != null) {
            ImagePrint imagePrint = new ImagePrint(titleImage);
            imagePrint.setSize(logoSize);
            title.add(0x1000000, (Print)imagePrint);
        } else {
            title.add(0x1000000, (Print)new EmptyPrint(logoSize));
        }
        title.add((Print)new EmptyPrint(3, 3));
        title.add(0x1000000, (Print)this.boldHeader.create("NIVELACIJA PRODAJNE CENE"));
        return title;
    }

    private Print createHeaderDocData() {
        GridPrint docData = new GridPrint(new GridColumn[]{new GridColumn(131072, 1, 1)});
        docData.add((Print)new EmptyPrint(5, 15));
        docData.add(131072, (Print)this.boldText.create("ObrazacNC"));
        return docData;
    }

    public static void main(String[] args) {
        EnumMap<DataKey, String> dataMap = new EnumMap<DataKey, String>(DataKey.class);
        dataMap.put(DataKey.LOGO_PATH, "C:\\BARMaster\\image\\barmaster.png");
        dataMap.put(DataKey.PIB, "108520227");
        dataMap.put(DataKey.OBVEZNIK, "Wang Chenghui");
        dataMap.put(DataKey.FIRMA_RADNJE, "Wang Hongli doo, Slavka Miljk");
        dataMap.put(DataKey.SEDISTE, "Slavka Miljkovi\u0107a 47, Beograd");
        dataMap.put(DataKey.SIFRA_PORESKOG_OBVEZNIKA, "");
        dataMap.put(DataKey.SIFRA_DELATNOSTI, "52120");
    }

    public static enum DataKey {
        LOGO_PATH,
        PIB,
        OBVEZNIK,
        FIRMA_RADNJE,
        SEDISTE,
        SIFRA_PORESKOG_OBVEZNIKA,
        SIFRA_DELATNOSTI;

    }
}

