/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji.stampa;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.Pregled.PregledTrebovanja2;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.comparators.PrijemnicaStavkaRedniBrojComparator;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.stampa.ReportPrintBuilder;
import com.dev63.restoran.jpa.JPAUtil;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.TipPrijemnice;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.sistem.PoreskeStope;
import com.dev63.restoran.taxes.TaxFunctions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.eclipse.nebula.paperclips.core.EmptyPrint;
import org.eclipse.nebula.paperclips.core.ImagePrint;
import org.eclipse.nebula.paperclips.core.LinePrint;
import org.eclipse.nebula.paperclips.core.NoBreakPrint;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintJob;
import org.eclipse.nebula.paperclips.core.border.Border;
import org.eclipse.nebula.paperclips.core.border.LineBorder;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PageDecoration;
import org.eclipse.nebula.paperclips.core.page.PageNumber;
import org.eclipse.nebula.paperclips.core.page.PageNumberFormat;
import org.eclipse.nebula.paperclips.core.page.PageNumberPrint;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.nebula.paperclips.core.text.StyledTextPrint;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.nebula.paperclips.core.text.TextStyle;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class StampaKalkulacijeNPC2
extends PagePrint {
    private final String headerGroup2 = "PDV";
    private final String header1 = "Red.br.";
    private final String header2 = "Naziv robe";
    private final String header3 = "Jed. mere";
    private final String header4 = "Koli\u010dina";
    private final String header5 = "Cena po jed. mere";
    private final String header6 = "Vrednost robe\n( 4 X 5 )";
    private final String header7 = "Zavisni tro\u0161kovi";
    private final String header8 = "Razlika u ceni";
    private final String header9 = "Prodajna vred. robe bez PDV\n( 6 + 7 + 8 )";
    private final String header10 = "Stopa";
    private final String header11 = "Obra\u010dunat iznos";
    private final String header12 = "Prod. vred robe sa obr. PDV\n( 9 + 11 )";
    private final String header13 = "Prod. cena po jed. mere";
    private final String totalHeader1 = "Ukupno";
    private final String totalHeader2 = "Zavisni tro\u0161kovi";
    private final String totalHeader3 = "PDV";
    private final String totalHeader4 = "Iznos PDV";
    private final String totalHeader5 = "Ukupno";
    private final String totalHeader6 = "Preneti porez";
    private final String totalHeader7 = "Ukupno";
    private final String totalHeader8 = "Dobavlja\u010du";
    private final String totalHeader9 = "Prodajna vrednost";
    private final String totalPoPart = "po ";
    private final String footerPageNumFormat = "Strana %1$d od %2$d";
    private final String signTitle1 = "Datum";
    private final String signTitle2 = "Odgovorno lice";
    private final String headerDataLine2 = "Obveznik";
    private final String headerDataLine3 = "Firma - radnje";
    private final String headerDataLine4 = "Sedi\u0161te";
    private final String headerDataLine5 = "\u0160ifra poreskog obveznika";
    private final String headerDataLine6 = "\u0160ifra delatnosti";
    private final String headerTitleLine1 = "KALKULACIJA PRODAJNIH CENA";
    private final String headerTitleLine2 = "Po dokumentu br. {0} od {1} godine";
    private final String headerTitleLine3 = "Dobavlja\u010d {0}";
    private final String headerTitleLine4 = "Kalkulacija {0}  {1}";
    private final String headerDocDataLine1 = "ObrazacKL";
    private final String headerDataLine1 = "PIB";
    private final String headerGroup1 = "Po fakturi dobavlja\u010da";
    private final String fontName;
    private final FontData titleFont;
    private final FontData textFont;
    private final FontData cellHeaderFont;
    private final FontData cellFont;
    private final FontData footerFont;
    private final int normalHeight;
    private final int headerHeight;
    private TextStyle normalText;
    private TextStyle boldText;
    private TextStyle boldHeader;
    private TextStyle normalHeader;
    private RoundingMode rm;
    private GridColumn[] columns;
    private static Restoran restoran;
    RestoranServer server;
    private PregledTrebovanja2.PregledTrebovanja2Input pregledTrebovanja;
    private Trebovanje trebovanje;
    private Prijemnica prijemnica;
    private ImageData titleLogo;
    private String pib;
    private String obveznik;
    private String firmaRadnje;
    private String odeljenje;
    private String sediste;
    private String sifraPoreskogObveznika;
    private String sifraDelatnosti;
    private String brojDokumenta;
    private String datumDokumenta;
    private String dobavljac;
    private String brojKalkulacije;
    private Boolean firmaUPDV;
    private Date forDate;
    private Boolean sifre1;

    public StampaKalkulacijeNPC2(Prijemnica prijemnica, TipPrijemnice tip, boolean firmaUPDV, EnumMap<DataKey, String> data, Restoran restoran) {
        super((Print)new EmptyPrint());
        StampaKalkulacijeNPC2.restoran = restoran;
        this.server = restoran.getServer();
        this.fontName = "Arial";
        this.normalHeight = 8;
        this.headerHeight = 10;
        this.footerFont = new FontData(this.fontName, 6, 2);
        this.cellFont = new FontData(this.fontName, 7, 0);
        this.cellHeaderFont = new FontData(this.fontName, 7, 1);
        this.textFont = new FontData(this.fontName, 12, 0);
        this.titleFont = new FontData(this.fontName, 16, 1);
        this.prijemnica = prijemnica;
        this.rm = RoundingMode.HALF_UP;
        this.firmaUPDV = firmaUPDV;
        this.forDate = prijemnica.getDatumPrijemnice();
        this.brojDokumenta = prijemnica.getOznakaDokumenta();
        this.brojKalkulacije = prijemnica.getBrPrijemnice();
        if (this.brojDokumenta == null) {
            this.brojDokumenta = prijemnica.getOpis();
        }
        this.datumDokumenta = StatLogic.getDateString(prijemnica.getDatumPrijemnice());
        this.dobavljac = prijemnica.getDobavljac().getNaziv();
        try {
            this.odeljenje = "Odeljenje: " + prijemnica.getTrebovanje().getU().getNaziv();
            if (this.odeljenje.equals(null)) {
                this.odeljenje = this.pregledTrebovanja.dajGrupu();
            }
        }
        catch (NullPointerException e) {
            this.odeljenje = "";
        }
        try {
            this.sifre1 = this.server.getSetting(Option.STAMPA_SIFARA_ARTIKAL_DOKUMENTI).booleanValue();
        }
        catch (Exception e) {
            this.sifre1 = false;
        }
        this.initiateTextStyles();
        this.loadData(data);
        this.setHeader(this.makeHeader());
        this.setBody(this.makeBody());
        super.setFooter(this.makeFooter());
    }

    private void loadData(EnumMap<DataKey, String> data) {
        if (data != null) {
            block11: for (DataKey dataKey : DataKey.values()) {
                switch (dataKey) {
                    case LOGO_PATH: {
                        try {
                            this.titleLogo = new ImageData(data.get((Object)dataKey));
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.out);
                        }
                    }
                    case PIB: {
                        this.pib = data.get((Object)dataKey);
                        continue block11;
                    }
                    case OBVEZNIK: {
                        this.obveznik = data.get((Object)dataKey);
                        continue block11;
                    }
                    case FIRMA_RADNJE: {
                        this.firmaRadnje = data.get((Object)dataKey);
                        continue block11;
                    }
                    case SEDISTE: {
                        this.sediste = data.get((Object)dataKey);
                        continue block11;
                    }
                    case SIFRA_PORESKOG_OBVEZNIKA: {
                        this.sifraPoreskogObveznika = data.get((Object)dataKey);
                        continue block11;
                    }
                    case SIFRA_DELATNOSTI: {
                        this.sifraDelatnosti = data.get((Object)dataKey);
                    }
                }
            }
        }
    }

    private void initiateTextStyles() {
        this.normalText = new TextStyle().fontName(this.fontName).fontHeight(this.normalHeight).fontStyle(0);
        this.boldText = new TextStyle().fontName(this.fontName).fontHeight(this.normalHeight).fontStyle(1);
        this.normalHeader = new TextStyle().fontName(this.fontName).fontHeight(this.headerHeight).fontStyle(0);
        this.boldHeader = new TextStyle().fontName(this.fontName).fontHeight(this.headerHeight).fontStyle(1);
    }

    private Print makeBody() {
        GridPrint body = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 100), new GridColumn(16384, 1, 100)});
        body.setLook((GridLook)new DefaultGridLook(0, 5));
        body.add(this.makeDataGrid(this.prijemnica, this.firmaUPDV), -1);
        body.add((Print)new EmptyPrint(10, 10), -1);
        body.add((Print)new NoBreakPrint(this.makeSignature()), -1);
        return body;
    }

    private Print makeSignature() {
        GridPrint signature = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 1, 50), new GridColumn(0x1000000, 1, 50)});
        signature.add((Print)new EmptyPrint(15, 15), -1);
        signature.add(0x1000000, 0x1000000, (Print)this.normalHeader.create("Datum"));
        signature.add(0x1000000, 0x1000000, (Print)this.normalHeader.create("Odgovorno lice"));
        signature.add(0x1000000, 0x1000000, (Print)this.normalHeader.create(StatLogic.getDateString(this.forDate)));
        signature.add(0x1000000, 0x1000000, (Print)this.normalHeader.create("______________________________"));
        return signature;
    }

    private Print makeDataGrid(Prijemnica p, boolean kupacUPDV) {
        LinkedList<PrijemnicaStavka> stavke = new LinkedList<PrijemnicaStavka>();
        stavke.addAll(p.getStavke());
        Collections.sort(stavke, new PrijemnicaStavkaRedniBrojComparator());
        GridPrint main = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 1, 100)}, (GridLook)new DefaultGridLook(0, 15));
        GridPrint gridP = new GridPrint(this.getColumns());
        gridP.setCellClippingEnabled(false);
        DefaultGridLook gl = new DefaultGridLook();
        gl.setCellBorder((Border)new LineBorder(new RGB(64, 64, 64)));
        gl.setHeaderBackground(new RGB(240, 240, 240));
        gridP.setLook((GridLook)gl);
        this.addHeader(gridP);
        this.addContent(gridP, stavke, kupacUPDV, p.getDobavljac().getPoreskiObveznik());
        main.add((Print)gridP);
        return main;
    }

    private GridColumn[] getColumns() {
        if (this.columns == null || this.columns.length == 0) {
            GridColumn[] gridColumnArray = new GridColumn[13];
            int w = 17;
            gridColumnArray[0] = new GridColumn(131072, 17, w);
            w = 60;
            gridColumnArray[1] = new GridColumn(16384, 60, w);
            w = 20;
            gridColumnArray[2] = new GridColumn(0x1000000, 20, w);
            w = 30;
            gridColumnArray[3] = new GridColumn(131072, 30, w);
            w = 30;
            gridColumnArray[4] = new GridColumn(131072, 30, w);
            w = 40;
            gridColumnArray[5] = new GridColumn(131072, 40, w);
            w = 30;
            gridColumnArray[6] = new GridColumn(131072, 30, w);
            w = 33;
            gridColumnArray[7] = new GridColumn(131072, 33, w);
            w = 40;
            gridColumnArray[8] = new GridColumn(131072, 40, w);
            w = 22;
            gridColumnArray[9] = new GridColumn(131072, 22, w);
            w = 40;
            gridColumnArray[10] = new GridColumn(131072, 40, w);
            w = 40;
            gridColumnArray[11] = new GridColumn(131072, 40, w);
            w = 40;
            gridColumnArray[12] = new GridColumn(131072, 40, w);
            this.columns = gridColumnArray;
        }
        return this.columns;
    }

    private void addHeader(GridPrint grid) {
        grid.addHeader(0x1000000, 0x1000000, (Print)new EmptyPrint(), 3);
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Po fakturi dobavlja\u010da"), 3);
        grid.addHeader(0x1000000, 0x1000000, (Print)new EmptyPrint(), 3);
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("PDV"), 2);
        grid.addHeader(0x1000000, 0x1000000, (Print)new EmptyPrint(), 2);
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Red.br."));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Naziv robe"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Jed. mere"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Koli\u010dina"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Cena po jed. mere"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Vrednost robe\n( 4 X 5 )"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Zavisni tro\u0161kovi"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Razlika u ceni"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Prodajna vred. robe bez PDV\n( 6 + 7 + 8 )"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Stopa"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Obra\u010dunat iznos"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Prod. vred robe sa obr. PDV\n( 9 + 11 )"));
        grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create("Prod. cena po jed. mere"));
        for (int c = 0; c < grid.getColumns().length; ++c) {
            grid.addHeader(0x1000000, 0x1000000, (Print)this.boldText.align(0x1000000).create(Integer.toString(c + 1)));
        }
    }

    private void addContent(GridPrint grid, List<PrijemnicaStavka> p, boolean kupacUPDV, boolean prodavacUPDV) {
        if (grid == null || p == null || p.isEmpty()) {
            return;
        }
        EnumMap<PoreskaGrupa, BigDecimal> uObracunatPDV = new EnumMap<PoreskaGrupa, BigDecimal>(PoreskaGrupa.class);
        uObracunatPDV.put(PoreskaGrupa.GRUPA_E, BigDecimal.ZERO);
        uObracunatPDV.put(PoreskaGrupa.GRUPA_DJ, BigDecimal.ZERO);
        EnumMap<PoreskaGrupa, BigDecimal> uPrenetPDV = new EnumMap<PoreskaGrupa, BigDecimal>(PoreskaGrupa.class);
        uPrenetPDV.put(PoreskaGrupa.GRUPA_E, BigDecimal.ZERO);
        uPrenetPDV.put(PoreskaGrupa.GRUPA_DJ, BigDecimal.ZERO);
        EnumMap<PoreskaGrupa, BigDecimal> uObracunatPDVOsnovica = new EnumMap<PoreskaGrupa, BigDecimal>(PoreskaGrupa.class);
        uObracunatPDVOsnovica.put(PoreskaGrupa.GRUPA_E, BigDecimal.ZERO);
        uObracunatPDVOsnovica.put(PoreskaGrupa.GRUPA_DJ, BigDecimal.ZERO);
        EnumMap<PoreskaGrupa, BigDecimal> uPrenetPDVOsnovica = new EnumMap<PoreskaGrupa, BigDecimal>(PoreskaGrupa.class);
        uPrenetPDVOsnovica.put(PoreskaGrupa.GRUPA_E, BigDecimal.ZERO);
        uPrenetPDVOsnovica.put(PoreskaGrupa.GRUPA_DJ, BigDecimal.ZERO);
        BigDecimal uVrednost = BigDecimal.ZERO;
        BigDecimal uRazlikaUCeni = BigDecimal.ZERO;
        BigDecimal uProdVrednostSPDV = BigDecimal.ZERO;
        BigDecimal uZavisniTroskovi = BigDecimal.ZERO;
        BigDecimal uPDVProcenat = BigDecimal.ZERO;
        BigDecimal uPDVIznos = BigDecimal.ZERO;
        for (PrijemnicaStavka ps : p) {
            BigDecimal uPrenetPDVOsnovicaPG;
            BigDecimal uPrenetPDVPG;
            BigDecimal uObracunatPDVOsnovicaPG;
            BigDecimal prodCenaSPDV;
            BigDecimal prodPDVPrcnt;
            BigDecimal kolicina = BigDecimal.valueOf(ps.getKolicina()).setScale(3, this.rm);
            BigDecimal nabVredSPDV = BigDecimal.valueOf(ps.getVrednostSPDV()).setScale(2, this.rm);
            BigDecimal nabVredBPDV = BigDecimal.valueOf(ps.getVrednost()).setScale(2, this.rm);
            BigDecimal nabCenaSPDV = BigDecimal.valueOf(ps.getKomadSPDV()).setScale(2, this.rm);
            BigDecimal nabCenaBPDV = BigDecimal.valueOf(ps.getKomad()).setScale(2, this.rm);
            BigDecimal nabCena = kupacUPDV ? nabCenaBPDV : nabCenaSPDV;
            BigDecimal nabVrednost = kupacUPDV ? nabVredBPDV : nabVredSPDV;
            BigDecimal zavisniTroskovi = BigDecimal.valueOf(ps.getZavisniTroskovi()).setScale(2, this.rm);
            BigDecimal normativMera = ps.getArtikal().getMera() == null ? BigDecimal.ONE : BigDecimal.valueOf(ps.getArtikal().getMera());
            PoreskaGrupa pg = ps.getArtikal().getPoreskaGrupa() == PoreskaGrupa.GRUPA_A ? PoreskaGrupa.GRUPA_A : PoreskaGrupa.getGrupaByPdvStopa((double)ps.getPdvStopa());
            BigDecimal bigDecimal = prodPDVPrcnt = ps.getPrijemnica().getDobavljac().getPoljoGazdinstvo() != false ? BigDecimal.valueOf(8.0) : TaxFunctions.getTGRatePercent(pg);
            if (!kupacUPDV) {
                pg = PoreskeStope.getDefaultNonVatStopa().getPg();
                prodPDVPrcnt = BigDecimal.ZERO;
            }
            switch (ps.getArtikal().getTip()) {
                case SIRO: {
                    prodCenaSPDV = BigDecimal.valueOf(ps.getProdajnaCena() != null ? ps.getProdajnaCena() : ps.getArtikal().getCena());
                    break;
                }
                case POTR: {
                    prodCenaSPDV = BigDecimal.valueOf(ps.getProdajnaCena() != null ? ps.getProdajnaCena() : ps.getArtikal().getCena());
                    break;
                }
                default: {
                    prodCenaSPDV = BigDecimal.valueOf(ps.getProdajnaCena() != null ? ps.getProdajnaCena() : ps.getArtikal().getCena());
                }
            }
            prodCenaSPDV = prodCenaSPDV.divide(normativMera, 2, this.rm);
            BigDecimal prodVredSPDV = prodCenaSPDV.multiply(kolicina).setScale(2, this.rm);
            BigDecimal prodVrednostBPDV = TaxFunctions.getNettoFromBrutto(prodPDVPrcnt, prodVredSPDV).setScale(2, this.rm);
            BigDecimal razlikaUCeni = ps.getArtikal().getTip().equals((Object)TipArtikla.SIRO) || ps.getArtikal().getTip().equals((Object)TipArtikla.POTR) ? BigDecimal.ZERO : prodVrednostBPDV.subtract(nabVrednost).subtract(zavisniTroskovi);
            BigDecimal stopaPdv = prodPDVPrcnt.setScale(2, this.rm);
            BigDecimal obracunatPDV = prodVredSPDV.subtract(prodVrednostBPDV);
            BigDecimal prenetPDV = nabVredSPDV.subtract(nabVredBPDV);
            uVrednost = uVrednost.add(nabVrednost);
            uRazlikaUCeni = uRazlikaUCeni.add(razlikaUCeni);
            BigDecimal uObracunatPDVPG = uObracunatPDV.get(pg);
            if (uObracunatPDVPG != null) {
                uObracunatPDVPG = uObracunatPDVPG.add(obracunatPDV);
                uObracunatPDV.put(pg, uObracunatPDVPG);
            }
            if ((uObracunatPDVOsnovicaPG = uObracunatPDVOsnovica.get(pg)) != null) {
                uObracunatPDVOsnovicaPG = uObracunatPDVOsnovicaPG.add(prodVrednostBPDV);
                uObracunatPDVOsnovica.put(pg, uObracunatPDVOsnovicaPG);
            }
            if ((uPrenetPDVPG = uPrenetPDV.get(pg)) != null) {
                uPrenetPDVPG = uPrenetPDVPG.add(prenetPDV);
                uPrenetPDV.put(pg, uPrenetPDVPG);
            }
            if ((uPrenetPDVOsnovicaPG = uPrenetPDVOsnovica.get(pg)) != null) {
                uPrenetPDVOsnovicaPG = uPrenetPDVOsnovicaPG.add(nabVredBPDV);
                uPrenetPDVOsnovica.put(pg, uPrenetPDVOsnovicaPG);
            }
            uProdVrednostSPDV = uProdVrednostSPDV.add(prodVredSPDV);
            uZavisniTroskovi = uZavisniTroskovi.add(zavisniTroskovi);
            grid.add((Print)this.normalText.create(ps.getRedniBroj() != null ? ps.getRedniBroj().toString() : ""));
            grid.add((Print)this.normalText.create(this.sifre1.booleanValue() ? (ps.getArtikal().getSifra().isEmpty() ? ps.getArtikal().getName() : "(" + ps.getArtikal().getSifra() + ")" + ps.getArtikal().getName()) : ps.getArtikal().getName()));
            grid.add((Print)this.normalText.create(ps.getArtikal().getJedinicaMere()));
            grid.add((Print)this.normalText.create(StatLogic.getNumber03NG(kolicina)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(nabCena)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(nabVrednost)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(zavisniTroskovi)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(razlikaUCeni)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(prodVrednostBPDV)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(stopaPdv)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(obracunatPDV)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(prodVredSPDV)));
            grid.add((Print)this.normalText.create(StatLogic.getNumber02NG(prodCenaSPDV)));
        }
        grid.add(this.makeTotal(uVrednost, uRazlikaUCeni, uObracunatPDV, uObracunatPDVOsnovica, uProdVrednostSPDV, uZavisniTroskovi, uPDVProcenat, uPDVIznos, uPrenetPDV, uPrenetPDVOsnovica), -1);
    }

    private Print makeTotal(BigDecimal uVrednost, BigDecimal uRazlikaUCeni, EnumMap<PoreskaGrupa, BigDecimal> uObracunatPDV, EnumMap<PoreskaGrupa, BigDecimal> uObracunatPDVOsnovica, BigDecimal uProdVrednostSPDV, BigDecimal uZavisniTroskovi, BigDecimal uPDVProcenat, BigDecimal uPDVIznos, EnumMap<PoreskaGrupa, BigDecimal> uPrenetPDV, EnumMap<PoreskaGrupa, BigDecimal> uPrenetPDVOsnovica) {
        GridPrint grid = new GridPrint(this.getColumns());
        grid.add(16384, 1024, (Print)this.boldHeader.create("Ukupno"), 5);
        grid.add(131072, 1024, (Print)this.normalText.create(StatLogic.getNumber02NG(uVrednost)));
        grid.add(131072, 1024, (Print)this.normalText.create(StatLogic.getNumber02NG(uRazlikaUCeni)), 2);
        GridPrint gpStope = new GridPrint(new GridColumn[]{new GridColumn(131072, 1, 1)});
        gpStope.add((Print)this.normalText.create("po ".concat(StatLogic.getNumber02NG(TaxFunctions.getTGRatePercent(PoreskaGrupa.GRUPA_E, this.forDate))).concat("%")));
        gpStope.add((Print)this.normalText.create("po ".concat(StatLogic.getNumber02NG(TaxFunctions.getTGRatePercent(PoreskaGrupa.GRUPA_DJ, this.forDate))).concat("%")));
        GridPrint gpPDV = new GridPrint(new GridColumn[]{new GridColumn(131072, 1, 1), new GridColumn(131072, 1, 1)});
        gpPDV.add((Print)this.normalText.create(StatLogic.getNumber02NG(uObracunatPDVOsnovica.get(PoreskaGrupa.GRUPA_E))));
        gpPDV.add((Print)this.normalText.create(StatLogic.getNumber02NG(uObracunatPDV.get(PoreskaGrupa.GRUPA_E))));
        gpPDV.add((Print)this.normalText.create(StatLogic.getNumber02NG(uObracunatPDVOsnovica.get(PoreskaGrupa.GRUPA_DJ))));
        gpPDV.add((Print)this.normalText.create(StatLogic.getNumber02NG(uObracunatPDV.get(PoreskaGrupa.GRUPA_DJ))));
        grid.add(131072, 1024, (Print)gpStope, 2);
        grid.add(131072, 1024, (Print)gpPDV, 2);
        grid.add(131072, 1024, (Print)this.normalText.create(StatLogic.getNumber02NG(uProdVrednostSPDV)));
        grid.add(131072, 1024, (Print)new EmptyPrint());
        grid.add((Print)new EmptyPrint(3, 3), -1);
        grid.add((Print)new LinePrint(256, 1.0), -1);
        grid.add((Print)new EmptyPrint(3, 3), -1);
        grid.add(131072, (Print)this.boldText.create("Zavisni tro\u0161kovi"), 6);
        grid.add(131072, (Print)this.normalText.create(StatLogic.getNumber02NG(uZavisniTroskovi)));
        grid.add((Print)new EmptyPrint(), -1);
        grid.add(131072, (Print)this.boldText.create("PDV"), 6);
        grid.add(131072, (Print)this.normalText.create(StatLogic.getNumber02NG(uPDVProcenat).concat("%")));
        grid.add((Print)new EmptyPrint(), -1);
        grid.add(131072, (Print)this.boldText.create("Iznos PDV"), 6);
        grid.add(131072, (Print)this.normalText.create(StatLogic.getNumber02NG(uPDVIznos)));
        grid.add((Print)new EmptyPrint(), -1);
        grid.add((Print)new EmptyPrint(3, 3), -1);
        grid.add((Print)new LinePrint(256, 1.0), -1);
        grid.add((Print)new EmptyPrint(3, 3), -1);
        grid.add(16384, 1024, (Print)this.boldHeader.create("Ukupno"), 5);
        grid.add(131072, 1024, (Print)this.normalText.create(StatLogic.getNumber02NG(uVrednost)));
        grid.add(131072, 1024, (Print)this.normalText.create(StatLogic.getNumber02NG(uRazlikaUCeni)), 2);
        grid.add((Print)new EmptyPrint(), -1);
        grid.add((Print)new EmptyPrint(3, 3), -1);
        grid.add((Print)new LinePrint(256, 1.0), -1);
        grid.add((Print)new EmptyPrint(3, 3), -1);
        grid.add(16384, 128, (Print)this.boldHeader.create("Preneti porez"), 2);
        GridPrint gpInner = new GridPrint(new GridColumn[]{new GridColumn(131072, 1, 1)});
        if (this.prijemnica.getDobavljac().getPoljoGazdinstvo() == null) {
            this.prijemnica.getDobavljac().setPoljoGazdinstvo(false);
        }
        if (this.prijemnica.getDobavljac().getPoljoGazdinstvo().booleanValue()) {
            gpInner.add((Print)this.normalHeader.create("po ".concat("8").concat("%")));
        }
        if (!this.prijemnica.getDobavljac().getPoljoGazdinstvo().booleanValue()) {
            gpInner.add((Print)this.normalHeader.create("po ".concat(StatLogic.getNumber02NG(PoreskeStope.getPoreskaStopa(PoreskaGrupa.GRUPA_E).getStopa())).concat("%")));
        }
        if (!this.prijemnica.getDobavljac().getPoljoGazdinstvo().booleanValue()) {
            gpInner.add((Print)this.normalHeader.create("po ".concat(StatLogic.getNumber02NG(PoreskeStope.getPoreskaStopa(PoreskaGrupa.GRUPA_DJ).getStopa())).concat("%")));
        }
        gpInner.add((Print)this.boldHeader.create("Ukupno"));
        gpInner.add((Print)new EmptyPrint(10, 10));
        gpInner.add((Print)this.boldHeader.create("Dobavlja\u010du"));
        grid.add(131072, 0x1000000, (Print)gpInner, 2);
        gpInner = new GridPrint(new GridColumn[]{new GridColumn(131072, 1, 1), new GridColumn(131072, 1, 1)});
        BigDecimal ppNiza = null;
        BigDecimal ppVisa = null;
        BigDecimal osam = BigDecimal.valueOf(8.0);
        if (this.prijemnica.getDobavljac().getPoljoGazdinstvo().booleanValue()) {
            gpInner.add((Print)this.normalHeader.create(StatLogic.getNumber02NG(uVrednost.multiply(osam).divide(BigDecimal.valueOf(100.0)))));
        }
        if (this.prijemnica.getDobavljac().getPoljoGazdinstvo().booleanValue()) {
            gpInner.add((Print)this.normalHeader.create(StatLogic.getNumber02NG(uVrednost.multiply(osam).divide(BigDecimal.valueOf(100.0)))));
        }
        if (!this.prijemnica.getDobavljac().getPoljoGazdinstvo().booleanValue()) {
            gpInner.add((Print)this.normalHeader.create(StatLogic.getNumber02NG(uPrenetPDVOsnovica.get(PoreskaGrupa.GRUPA_E))));
        }
        if (!this.prijemnica.getDobavljac().getPoljoGazdinstvo().booleanValue()) {
            ppNiza = uPrenetPDV.get(PoreskaGrupa.GRUPA_E);
            gpInner.add((Print)this.normalHeader.create(StatLogic.getNumber02NG(ppNiza)));
        }
        if (!this.prijemnica.getDobavljac().getPoljoGazdinstvo().booleanValue()) {
            gpInner.add((Print)this.normalHeader.create(StatLogic.getNumber02NG(uPrenetPDVOsnovica.get(PoreskaGrupa.GRUPA_DJ))));
        }
        if (!this.prijemnica.getDobavljac().getPoljoGazdinstvo().booleanValue()) {
            ppVisa = uPrenetPDV.get(PoreskaGrupa.GRUPA_DJ);
            gpInner.add((Print)this.normalHeader.create(StatLogic.getNumber02NG(ppVisa)));
        }
        gpInner.add((Print)new EmptyPrint(10, 10));
        if (!this.prijemnica.getDobavljac().getPoljoGazdinstvo().booleanValue()) {
            gpInner.add((Print)this.normalHeader.create(StatLogic.getNumber02NG(ppNiza.add(ppVisa))));
        }
        gpInner.add((Print)new EmptyPrint(10, 10));
        gpInner.add((Print)new EmptyPrint(10, 10));
        gpInner.add((Print)new EmptyPrint(10, 10));
        gpInner.add((Print)(this.prijemnica.getDobavljac().getPoljoGazdinstvo() == false ? this.boldHeader.create(StatLogic.getNumber02NG(uVrednost.add(ppNiza).add(ppVisa))) : this.boldHeader.create("")));
        gpInner.add((Print)(this.prijemnica.getDobavljac().getPoljoGazdinstvo() == false ? this.boldHeader.create(StatLogic.getNumber02NG(uVrednost.add(ppNiza).add(ppVisa))) : this.boldHeader.create(StatLogic.getNumber02NG(uVrednost.add(uVrednost.multiply(osam).divide(BigDecimal.valueOf(100.0)))))));
        grid.add(131072, 0x1000000, (Print)gpInner, 2);
        gpInner = new GridPrint(new GridColumn[]{new GridColumn(131072, 1, 1)});
        gpInner.add((Print)this.boldHeader.create("Prodajna vrednost"));
        grid.add(131072, 128, (Print)gpInner, 2);
        gpInner = new GridPrint(new GridColumn[]{new GridColumn(131072, 1, 1)});
        gpInner.add((Print)this.normalHeader.create("po ".concat(StatLogic.getNumber02NG(PoreskeStope.getPoreskaStopa(PoreskaGrupa.GRUPA_E).getStopa())).concat("%")));
        gpInner.add((Print)this.normalHeader.create("po ".concat(StatLogic.getNumber02NG(PoreskeStope.getPoreskaStopa(PoreskaGrupa.GRUPA_DJ).getStopa())).concat("%")));
        gpInner.add((Print)this.boldHeader.create("Ukupno"));
        grid.add(131072, 128, (Print)gpInner, 2);
        gpInner = new GridPrint(new GridColumn[]{new GridColumn(131072, 1, 1), new GridColumn(131072, 1, 1)});
        gpInner.add((Print)this.normalText.create(StatLogic.getNumber02NG(uObracunatPDVOsnovica.get(PoreskaGrupa.GRUPA_E))));
        gpInner.add((Print)this.normalText.create(StatLogic.getNumber02NG(uObracunatPDV.get(PoreskaGrupa.GRUPA_E))));
        gpInner.add((Print)this.normalText.create(StatLogic.getNumber02NG(uObracunatPDVOsnovica.get(PoreskaGrupa.GRUPA_DJ))));
        gpInner.add((Print)this.normalText.create(StatLogic.getNumber02NG(uObracunatPDV.get(PoreskaGrupa.GRUPA_DJ))));
        grid.add(131072, 128, (Print)gpInner, 2);
        gpInner = new GridPrint(new GridColumn[]{new GridColumn(131072, 1, 1)});
        double ukupno10 = uObracunatPDVOsnovica.get(PoreskaGrupa.GRUPA_E).doubleValue() + uObracunatPDV.get(PoreskaGrupa.GRUPA_E).doubleValue();
        double ukupno20 = uObracunatPDVOsnovica.get(PoreskaGrupa.GRUPA_DJ).doubleValue() + uObracunatPDV.get(PoreskaGrupa.GRUPA_DJ).doubleValue();
        gpInner.add((Print)this.boldHeader.create(StatLogic.getNumber02NG(ukupno10)));
        gpInner.add((Print)this.boldHeader.create(StatLogic.getNumber02NG(ukupno20)));
        gpInner.add((Print)this.boldHeader.create(StatLogic.getNumber02NG(uProdVrednostSPDV)));
        grid.add(131072, 128, (Print)gpInner, 1);
        grid.add((Print)new EmptyPrint(), -1);
        return grid;
    }

    public Prijemnica getPrijemnica() {
        return this.prijemnica;
    }

    public void setPrijemnica(Prijemnica trebovanje) {
        this.prijemnica = trebovanje;
    }

    private PageDecoration makeFooter() {
        return new PageDecoration(){

            public Print createPrint(PageNumber pn) {
                GridPrint print = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 50), new GridColumn(131072, -1, 50)});
                print.add(16384, 1024, (Print)new TextPrint(StatLogic.getDateTimeString(new Date()), StampaKalkulacijeNPC2.this.footerFont, 16384));
                PageNumberPrint pnp = new PageNumberPrint(pn, StampaKalkulacijeNPC2.this.footerFont, 131072);
                pnp.setPageNumberFormat(new PageNumberFormat(){

                    public String format(PageNumber pn) {
                        return String.format("Strana %1$d od %2$d", pn.getPageNumber() + 1, pn.getPageCount());
                    }
                });
                print.add(131072, 1024, (Print)pnp);
                return print;
            }
        };
    }

    private PageDecoration makeHeader() {
        return new PageDecoration(){

            public Print createPrint(PageNumber pn) {
                GridPrint hgp = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 30), new GridColumn(16384, 1, 55), new GridColumn(16384, 1, 15)});
                Print data = StampaKalkulacijeNPC2.this.createHeaderDataPrint();
                Print title = StampaKalkulacijeNPC2.this.createHeaderTitlePrint();
                Print docData = StampaKalkulacijeNPC2.this.createHeaderDocData();
                hgp.add(16384, 128, data);
                hgp.add(0x1000000, 128, title);
                hgp.add(16384, 128, docData);
                hgp.add((Print)new EmptyPrint(15, 15), -1);
                return hgp;
            }
        };
    }

    private Print createHeaderDataPrint() {
        GridPrint data = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 1)});
        data.add((Print)new EmptyPrint(5, 15));
        data.add(this.createHeaderDataRow("PIB", this.pib));
        data.add(this.createHeaderDataRow("Obveznik", this.obveznik));
        data.add(this.createHeaderDataRow("Firma - radnje", this.firmaRadnje));
        data.add(this.createHeaderDataRow("Sedi\u0161te", this.sediste));
        data.add(this.createHeaderDataRow("\u0160ifra poreskog obveznika", this.sifraPoreskogObveznika));
        data.add(this.createHeaderDataRow("\u0160ifra delatnosti", this.sifraDelatnosti));
        return data;
    }

    private Print createHeaderDataRow(String key, String value) {
        EmptyPrint p;
        if (key != null) {
            StyledTextPrint stp = new StyledTextPrint();
            stp.append(key + "  ", this.boldText);
            if (value != null) {
                stp.append(value, this.normalText);
            }
            p = stp;
        } else {
            p = new EmptyPrint();
        }
        return p;
    }

    private Print createHeaderTitlePrint() {
        ImageData titleImage = this.titleLogo;
        String docNum = StatLogic.defaultIfNull(this.brojDokumenta, "");
        String docDate = StatLogic.defaultIfNull(this.datumDokumenta, "");
        String supplier = StatLogic.defaultIfNull(this.dobavljac, "");
        GridPrint title = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 1)});
        DefaultGridLook gl = new DefaultGridLook(3, 3);
        title.setLook((GridLook)gl);
        Point logoSize = new Point(220, 35);
        if (titleImage != null) {
            ImagePrint imagePrint = new ImagePrint(titleImage);
            imagePrint.setSize(logoSize);
            title.add(0x1000000, (Print)imagePrint);
        } else {
            title.add(0x1000000, (Print)new EmptyPrint(logoSize));
        }
        title.add((Print)new EmptyPrint(3, 3));
        title.add(0x1000000, (Print)this.boldHeader.create("KALKULACIJA PRODAJNIH CENA"));
        title.add(0x1000000, (Print)this.boldHeader.create(MessageFormat.format("Po dokumentu br. {0} od {1} godine", docNum, docDate)));
        title.add(0x1000000, (Print)this.boldHeader.create(MessageFormat.format("Dobavlja\u010d {0}", supplier)));
        title.add(0x1000000, (Print)this.boldHeader.create(MessageFormat.format("Kalkulacija {0}  {1}", this.brojKalkulacije, this.odeljenje)));
        return title;
    }

    private Print createHeaderDocData() {
        GridPrint docData = new GridPrint(new GridColumn[]{new GridColumn(131072, 1, 1)});
        docData.add((Print)new EmptyPrint(5, 15));
        docData.add(131072, (Print)this.boldText.create("ObrazacKL"));
        return docData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Prijemnica p = null;
        Trebovanje t = null;
        EntityManager em = null;
        try {
            em = JPAUtil.getRestEm();
            TypedQuery pQ = em.createQuery("SELECT p FROM Prijemnica p ORDER BY p.id DESC", Prijemnica.class);
            pQ.setMaxResults(1);
            p = (Prijemnica)pQ.getSingleResult();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        try {
            em = JPAUtil.getRestEm();
            TypedQuery tQ = em.createQuery("SELECT t.U_ID FROM Trebovanje t ORDER BY t.id DESC", Trebovanje.class);
            tQ.setMaxResults(1);
            t = (Trebovanje)tQ.getSingleResult();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
        EnumMap<DataKey, String> dataMap = new EnumMap<DataKey, String>(DataKey.class);
        dataMap.put(DataKey.LOGO_PATH, "C:\\BARMaster\\image\\barmaster.png");
        dataMap.put(DataKey.PIB, "108520227");
        dataMap.put(DataKey.OBVEZNIK, "Wang Chenghui");
        dataMap.put(DataKey.FIRMA_RADNJE, "Wang Hongli doo, Slavka Miljk");
        dataMap.put(DataKey.SEDISTE, "Slavka Miljkovi\u0107a 47, Beograd");
        dataMap.put(DataKey.SIFRA_PORESKOG_OBVEZNIKA, "");
        dataMap.put(DataKey.SIFRA_DELATNOSTI, "52120");
        StampaKalkulacijeNPC2 n = new StampaKalkulacijeNPC2(p, p.getTip(), false, dataMap, restoran);
        Display d = new Display();
        ReportPrintBuilder.printPreview(d, new PrintJob("Kalkulacija", (Print)n));
        d.dispose();
        System.out.println("ODELJENJE ______" + t.getU().getNaziv());
    }

    public static enum DataKey {
        LOGO_PATH,
        PIB,
        OBVEZNIK,
        FIRMA_RADNJE,
        SEDISTE,
        SIFRA_PORESKOG_OBVEZNIKA,
        SIFRA_DELATNOSTI;

    }
}

