/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji.knjigasanka;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Odeljenje;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class KnjigaSankaServer {
    RestoranServer server;
    private Date datum;
    private Odeljenje odeljenje;
    private boolean osnovno;
    private boolean dodatno;
    private double pocetnoOsnovno;
    private double pocetnoDodatno;
    private double zavrsnoOsnovno;
    private double zavrsnoDodatno;
    private double ulazOsnovno;
    private double ulazDodatno;
    private double pocetno;
    private double zavrsno;
    private double ulaz;
    private double izlaz;
    private double prodajnaCena;
    private double prodajnaVrednost;

    public KnjigaSankaServer(RestoranServer server, Date datum, Odeljenje odeljenje, boolean osnovno, boolean dodatno) {
        this.server = server;
        this.datum = datum;
        this.odeljenje = odeljenje;
        this.osnovno = osnovno;
        this.dodatno = dodatno;
    }

    public void popuniRedove(Table table) {
        TableColumn[] kolone = table.getColumns();
        List<Artikal> artikli = this.getArtikliZaKnjiguSanka(this.odeljenje);
        for (Artikal artikal : artikli) {
            this.izracunajVrednosti(artikal, this.osnovno, this.dodatno);
            if (this.isBlokiran(artikal)) continue;
            TableItem item = new TableItem(table, 0);
            item.setText(this.getRed(table, artikal, kolone));
        }
    }

    private void izracunajVrednosti(Artikal artikal, boolean osnovno, boolean dodatno) {
        this.pocetnoOsnovno = 0.0;
        this.pocetnoDodatno = 0.0;
        this.ulazOsnovno = 0.0;
        this.ulazDodatno = 0.0;
        this.zavrsnoOsnovno = 0.0;
        this.zavrsnoDodatno = 0.0;
        if (osnovno) {
            this.pocetnoOsnovno = this.server.getSumBelo(Konstante.getYesterdayDate(this.datum), this.odeljenje, artikal, false, true);
            this.ulazOsnovno = this.server.getNabavljenaKolicina(artikal, this.datum, this.datum, this.odeljenje, false);
            this.zavrsnoOsnovno = this.server.getSumBelo(this.datum, this.odeljenje, artikal, false, false);
        }
        if (dodatno) {
            this.pocetnoDodatno = this.server.getSumBelo(Konstante.getYesterdayDate(this.datum), this.odeljenje, artikal, true, true);
            this.ulazDodatno = this.server.getNabavljenaKolicina(artikal, this.datum, this.datum, this.odeljenje, true);
            this.zavrsnoDodatno = this.server.getSumBelo(this.datum, this.odeljenje, artikal, true, false);
        }
        this.pocetno = this.pocetnoOsnovno + this.pocetnoDodatno;
        this.ulaz = this.ulazOsnovno + this.ulazDodatno;
        this.zavrsno = this.zavrsnoOsnovno + this.zavrsnoDodatno;
        this.izlaz = this.pocetno + this.ulaz - this.zavrsno;
    }

    private boolean isBlokiran(Artikal artikal) {
        return artikal.getBlokiran() != false && this.ulaz == 0.0 && this.izlaz == 0.0;
    }

    private String[] getRed(Table table, Artikal artikal, TableColumn[] kolone) {
        String[] red = new String[kolone.length];
        block18: for (int i = 0; i < kolone.length; ++i) {
            switch (kolone[i].getText()) {
                case "Naziv artikla": {
                    red[i] = artikal.getName();
                    continue block18;
                }
                case "Po\u010detno": {
                    red[i] = String.valueOf(Konstante.round(this.pocetno, 4));
                    continue block18;
                }
                case "Ulaz": {
                    red[i] = String.valueOf(Konstante.round(this.ulaz, 4));
                    continue block18;
                }
                case "Izlaz": {
                    red[i] = String.valueOf(Konstante.round(this.izlaz, 4));
                    continue block18;
                }
                case "Zavr\u0161no": {
                    red[i] = String.valueOf(Konstante.round(this.zavrsno, 4));
                    continue block18;
                }
                case "Prodajna cena": {
                    red[i] = String.valueOf(Konstante.round(artikal.getCena(), 2));
                    continue block18;
                }
                case "Prodajna vrednost": {
                    red[i] = String.valueOf(Konstante.round(this.zavrsno / artikal.getMera() * artikal.getCena(), 2));
                    continue block18;
                }
            }
        }
        return red;
    }

    private List<Artikal> getArtikliZaKnjiguSanka(Odeljenje o) {
        String query = "SELECT a.id, a.name,a.jedinicaMere, a.barCode, a.tip, a.poreskaGrupa from artikal a WHERE a.id IN (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID =?)  AND a.tiP NOT IN ('SLOZ', 'DODA') order by field (tip,'PROD','POLU','SIRO'),name ";
        ArrayList<Artikal> artikli = new ArrayList<Artikal>();
        try {
            PreparedStatement ps = this.server.getConnection().prepareStatement(query);
            ps.setLong(1, o.getId());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Artikal artikal = this.server.getArtikal(rs.getLong("id"));
                artikli.add(artikal);
            }
            return artikli;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

