/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji.knjigasanka;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.izvestaji.knjigasanka.KnjigaSanka;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class KnjigaSankaInput {
    RestoranServer server;
    Display display;
    Shell knjigaSankaShell;
    private final ResourceBundle barmasterText;
    private List<Odeljenje> odeljenja;
    Image img;
    private String naslov;
    private String datumOdeljenje;
    private String naciniPlacanja;
    private String unosDatuma;
    private String izborOdeljenja;
    private String osnovnaPlacanja;
    private String dodatnaPlacanja;
    private DateInput2 dateInput;
    private Combo odeljenjaCombo;
    private Button osnovna;
    private Button dodatna;
    private boolean magacinVidljiv;

    public KnjigaSankaInput(RestoranServer server, Shell shell) {
        this.server = server;
        this.display = shell.getDisplay();
        this.barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        this.knjigaSankaShell = new Shell(this.display);
        this.magacinVidljiv = Boolean.parseBoolean(server.getSetting(Option.MAGACIN_VIDLJIV).getActual());
        this.odeljenja = this.magacinVidljiv ? server.readOdeljenje() : server.getOdeljenjaBezMagacina();
        try {
            this.img = new Image((Device)this.display, ImagePath.getPath() + "/stanjeZalihaV.gif");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.naslov = this.barmasterText.getString("TEXT_KNJIGA_SANKA");
        this.datumOdeljenje = this.barmasterText.getString("TEXT_IZBOR_DATUM_ODELJEJNE");
        this.naciniPlacanja = this.barmasterText.getString("TEXT_NACINI_PLACANJA");
        this.unosDatuma = this.barmasterText.getString("TEXT_UNOS_DATUMA");
        this.izborOdeljenja = this.barmasterText.getString("TEXT_IZBOR_ODELJENJA");
        this.osnovnaPlacanja = this.barmasterText.getString("TEXT_OSNOVNA_PLACANJA");
        this.dodatnaPlacanja = this.barmasterText.getString("TEXT_DODATNA_PLACANJA");
        this.napraviInput(this.knjigaSankaShell);
        this.knjigaSankaShell.setMaximized(true);
        this.knjigaSankaShell.open();
    }

    private void napraviInput(Shell shell) {
        shell.setLayout((Layout)this.getGridLayout(1, 0, 0));
        shell.setText(this.naslov);
        Composite panel1 = this.makeComposite((Composite)shell, 2, 0, 0);
        Label slika = this.makeLabel(panel1, "", 100, 100, this.img);
        Group grupaZaNaslov = this.makeGroup(panel1, 575, 60, this.naslov, 0, 20, 20);
        Composite panel2 = this.makeComposite((Composite)shell, 1, 0, 0);
        Group grupaZaDatumIOdeljenje = this.makeGroup(panel2, 680, 60, this.datumOdeljenje, 5, 10, 10);
        Label datum = this.makeLabel((Composite)grupaZaDatumIOdeljenje, this.unosDatuma, 70, 15, null);
        this.dateInput = this.makeDateInput((Composite)grupaZaDatumIOdeljenje, shell);
        Label prazanLabel = this.makeLabel((Composite)grupaZaDatumIOdeljenje, " ", 30, 15, null);
        Label odeljenje = this.makeLabel((Composite)grupaZaDatumIOdeljenje, this.izborOdeljenja, 80, 15, null);
        this.odeljenjaCombo = this.makeCombo((Composite)grupaZaDatumIOdeljenje, this.odeljenja);
        Group izborNacinaPlacanja = this.makeGroup(panel2, 680, 60, this.naciniPlacanja, 4, 10, 10);
        this.osnovna = this.makeCheckBox((Composite)izborNacinaPlacanja, this.osnovnaPlacanja);
        prazanLabel = this.makeLabel((Composite)izborNacinaPlacanja, "", 30, 15, null);
        this.dodatna = this.makeCheckBox((Composite)izborNacinaPlacanja, this.dodatnaPlacanja);
        Group potvrdiOdustani = this.makeGroup(panel2, 680, 60, "", 3, 10, 10);
        Button odustani = this.makeCancelButton((Composite)potvrdiOdustani);
        prazanLabel = this.makeLabel((Composite)potvrdiOdustani, " ", 30, 15, null);
        Button potvrdi = this.makeOkButton((Composite)potvrdiOdustani);
    }

    private GridLayout getGridLayout(int colNumber, int leftMargin, int topMargin) {
        GridLayout layout = new GridLayout(colNumber, false);
        layout.marginLeft = leftMargin;
        layout.marginTop = topMargin;
        return layout;
    }

    private Group makeGroup(Composite composite, int width, int height, String text, int colNumber, int leftMargin, int topMargin) {
        Group group = new Group(composite, 0);
        group.setText(text);
        group.setLayoutData((Object)this.makeGrdiData(width, height));
        group.setLayout((Layout)this.getGridLayout(colNumber, leftMargin, topMargin));
        return group;
    }

    private GridData makeGrdiData(int width, int height) {
        GridData data = new GridData();
        data.widthHint = width;
        data.heightHint = height;
        return data;
    }

    private Composite makeComposite(Composite compositeInput, int colNumber, int leftMargin, int topMargin) {
        Composite composite = new Composite(compositeInput, 0);
        composite.setLayout((Layout)this.getGridLayout(colNumber, leftMargin, topMargin));
        return composite;
    }

    private Label makeLabel(Composite composite, String text, int width, int height, Image img) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)this.makeGrdiData(width, height));
        if (img != null) {
            label.setImage(img);
        } else {
            label.setText(text);
        }
        return label;
    }

    private DateInput2 makeDateInput(Composite composite, Shell shell) {
        SWTContainer parent2 = new SWTContainer(composite);
        DateInput2 dateInput = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
        dateInput.getControl().addMouseListener((MouseListener)new CalendarAdapter(dateInput, shell));
        return dateInput;
    }

    private Combo makeCombo(Composite composite, List<Odeljenje> lista) {
        Combo combo = new Combo(composite, 0);
        for (Odeljenje o : lista) {
            combo.add(o.getNaziv());
        }
        if (this.magacinVidljiv) {
            combo.select(1);
        } else {
            combo.select(0);
        }
        combo.select(1);
        return combo;
    }

    private Button makeCheckBox(Composite composite, String text) {
        Button button = new Button(composite, 32);
        button.setText(text);
        if (text.contains("Osnovna")) {
            button.setSelection(true);
        }
        return button;
    }

    private Button makeOkButton(Composite composite) {
        Button okButt = Dugmici.getOkButton(composite);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    KnjigaSankaInput.this.ok();
                }
                catch (InputException e1) {
                    System.out.println("problem sa datumom");
                    e1.printStackTrace();
                }
            }
        });
        return okButt;
    }

    private Button makeCancelButton(Composite composite) {
        Button cancelButt = Dugmici.getCancelButton(composite);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                KnjigaSankaInput.this.cancel();
            }
        });
        return cancelButt;
    }

    private void ok() throws InputException {
        KnjigaSanka kSanka = new KnjigaSanka(this.dateInput.getResult(), this.server.getOdeljenje(this.odeljenjaCombo.getText()), this.osnovna.getSelection(), this.dodatna.getSelection(), this.server, this.knjigaSankaShell);
    }

    private void cancel() {
        this.knjigaSankaShell.close();
    }
}

