/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.sistem.PoreskaStopa;
import com.dev63.restoran.sistem.PoreskeStope;
import java.util.ArrayList;
import java.util.List;

public class ZbirnaFakturaStavka {
    private String naziv;
    private String jedinicaMere;
    private double kolicina;
    private double cena;
    private PoreskaStopa poreskaStopa;
    private double iznosPdv;
    private double vrednostBezPdv;
    private double vrednost;

    public String getNaziv() {
        return this.naziv;
    }

    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    public String getJedinicaMere() {
        return this.jedinicaMere;
    }

    public void setJedinicaMere(String jedinicaMere) {
        this.jedinicaMere = jedinicaMere;
    }

    public double getKolicina() {
        return this.kolicina;
    }

    public void setKolicina(double kolicina) {
        this.kolicina = kolicina;
    }

    public double getCena() {
        return this.cena;
    }

    public void setCena(double cena) {
        this.cena = cena;
    }

    public PoreskaStopa getPoreskaStopa() {
        return this.poreskaStopa;
    }

    public void setPoreskaStopa(PoreskaStopa poreskaStopa) {
        this.poreskaStopa = poreskaStopa;
    }

    public double getIznosPdv() {
        return this.iznosPdv;
    }

    public void setIznosPdv(double iznosPdv) {
        this.iznosPdv = iznosPdv;
    }

    public double getVrednostBezPdv() {
        return this.vrednostBezPdv;
    }

    public void setVrednostBezPdv(double vrednostBezPdv) {
        this.vrednostBezPdv = vrednostBezPdv;
    }

    public double getVrednost() {
        return this.vrednost;
    }

    public void setVrednost(double vrednost) {
        this.vrednost = vrednost;
    }

    public static List<ZbirnaFakturaStavka> stavkeZbirneFakture(List<StavkaRacuna> stavkeFaktura) {
        ArrayList<ZbirnaFakturaStavka> stavkeZbirneFakture = new ArrayList<ZbirnaFakturaStavka>();
        for (StavkaRacuna sr : stavkeFaktura) {
            PoreskaGrupa pg = sr.getArtikal().getPoreskaGrupa();
            PoreskaStopa ps = PoreskeStope.getPoreskaStopa(pg);
            double poreskaStopa = ps.getStopa();
            double kolicina = sr.getKolicina();
            double cenaSaPDV = sr.getCena();
            double cenaBezPDV = Konstante.round(cenaSaPDV / (1.0 + poreskaStopa / 100.0), 2);
            double vrednostSaPdv = Konstante.round(cenaSaPDV * kolicina, 2);
            double vrednostBezPdv = Konstante.round(cenaBezPDV * kolicina, 2);
            double pdv = Konstante.round(vrednostSaPdv - vrednostBezPdv, 2);
            ZbirnaFakturaStavka zfStavka = new ZbirnaFakturaStavka();
            zfStavka.setNaziv(sr.getNaziv());
            zfStavka.setJedinicaMere(sr.getArtikal().getJedinicaMere());
            zfStavka.setPoreskaStopa(ps);
            zfStavka.setKolicina(kolicina);
            zfStavka.setCena(cenaSaPDV);
            zfStavka.setIznosPdv(pdv);
            zfStavka.setVrednost(vrednostSaPdv);
            zfStavka.setVrednostBezPdv(vrednostBezPdv);
            stavkeZbirneFakture.add(zfStavka);
        }
        return stavkeZbirneFakture;
    }
}

