/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.izvestaji.ZbirnaFakturaStavka;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.ZbirnaFakturaModel;
import com.dev63.restoran.stampa.PodaciZaFakturu;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JasperViewer;

public class ZbirnaFakturaStampa {
    private RestoranServer server;
    private List<Racun> fakture;
    private StalniGost stalniGost;
    private ZbirnaFakturaModel zbirnaFaktura;
    private PodaciZaFakturu podaciZaFakturu;

    public ZbirnaFakturaStampa(RestoranServer server, ZbirnaFakturaModel zbirnaFaktura) {
        this.server = server;
        this.zbirnaFaktura = zbirnaFaktura;
        this.fakture = server.getPripadajuciRacuniZbirna(zbirnaFaktura.getId());
        this.stalniGost = this.fakture.get(0).getStalniGost();
        this.podaciZaFakturu = new PodaciZaFakturu(server);
    }

    public void Stampaj() {
        List<StavkaRacuna> lista = this.stavkeZaStampu();
        List<ZbirnaFakturaStavka> stavkeZbirneFakture = ZbirnaFakturaStavka.stavkeZbirneFakture(lista);
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put("stalniGost", this.stalniGost);
        reportParameters.put("objekat", this.podaciZaFakturu);
        reportParameters.put("zbirna", this.zbirnaFaktura);
        JRBeanCollectionDataSource datasource = new JRBeanCollectionDataSource(stavkeZbirneFakture);
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)"com/dev63/restoran/reports/templates/ZbirnaFaktura.jasper"));
            JasperPrint jp = JasperFillManager.fillReport((JasperReport)report, reportParameters, (JRDataSource)datasource);
            JasperViewer.viewReport((JasperPrint)jp, (boolean)false);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void StampajSpecifikaciju() {
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put("stalniGost", this.stalniGost);
        reportParameters.put("objekat", this.podaciZaFakturu);
        reportParameters.put("zbirna", this.zbirnaFaktura);
        JRBeanCollectionDataSource datasource = new JRBeanCollectionDataSource(this.fakture);
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)"com/dev63/restoran/reports/templates/specifikacijaRacunaZbirnaFaktura.jasper"));
            JasperPrint jp = JasperFillManager.fillReport((JasperReport)report, reportParameters, (JRDataSource)datasource);
            JasperViewer.viewReport((JasperPrint)jp, (boolean)false);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private List<StavkaRacuna> stavkeZaStampu() {
        ArrayList<StavkaRacuna> listaStavki = new ArrayList<StavkaRacuna>();
        String racunIds = this.getRacunIds();
        String query = "SELECT sr.naziv, sum(sr.kolicina) AS kolicina, \r\n(sr.cena - (sr.cena * r.popust/100)) AS cenaStavke, sr.ARTIKAL_ID  \r\nFROM stavkaracuna sr \r\nJOIN racun r ON sr.RACUN_ID = r.id\r\nWHERE sr.RACUN_ID IN (" + racunIds + ") \r\nGROUP BY sr.ARTIKAL_ID, cenaStavke";
        try {
            PreparedStatement ps = this.server.getConnection().prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                StavkaRacuna sr = new StavkaRacuna();
                sr.setNaziv(rs.getString("naziv"));
                sr.setKolicina(rs.getDouble("kolicina"));
                sr.setCena(rs.getDouble("cenaStavke"));
                sr.setArtikal(this.server.getArtikal(rs.getLong("ARTIKAL_ID")));
                listaStavki.add(sr);
            }
            return listaStavki;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getRacunIds() {
        StringBuilder sb = new StringBuilder();
        for (Racun r : this.fakture) {
            sb.append(r.getId());
            sb.append(",");
        }
        String racunIds = sb.toString();
        return racunIds.substring(0, racunIds.length() - 1);
    }
}

