/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTModels;
import com.dev63.restoran.izvestaji.ZbirnaFakturaNova;
import com.dev63.restoran.izvestaji.ZbirnaFakturaStampa;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.ZbirnaFakturaModel;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ZbirnaFakturaInput
extends SWTModels {
    private Display display;
    private Shell shell;
    private RestoranServer server;
    private String[] naziviKolona = new String[]{"Datum", "id", "Broj fakture", "Iznos", "Komitent"};
    private int[] sirineKolona = new int[]{110, 0, 80, 80, 310};
    private Table tabela;
    private DateInput2 odDatuma;
    private DateInput2 doDatuma;
    private Combo komitentiCombo;
    private Combo faktureCombo;
    private Button btnZbirna;
    private Button btnPregled;
    private Button btnSpecifikacija;
    private List<ZbirnaFakturaModel> listaRacuna;

    public ZbirnaFakturaInput(RestoranServer server) {
        this.display = ((SWTModels)this).display;
        this.server = server;
        this.listaRacuna = new ArrayList<ZbirnaFakturaModel>();
        this.shell = new Shell(this.display);
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.shell.setText("Zbirna Faktura");
        Composite header = this.makeComposite((Composite)this.shell, 2, 950, 65, 1, 1, 1, 1, 1, 1);
        Group headerGroup = this.makeGroup(header, 920, 40, 1, 1, "Zbirna faktura", 1, 1, 1, 1, 1);
        this.makeLabel((Composite)headerGroup, "Ekran za unos, pregled i ispravku zbirnih faktura", 450, 35, null, 1, 1);
        Composite filter = this.makeComposite((Composite)this.shell, 2, 950, 65, 1, 1, 1, 1, 1, 1);
        Group filteri = this.makeGroup(filter, 920, 40, 1, 1, "Filteri", 10, 5, 5, 5, 5);
        this.makeDateInputs((Composite)filteri);
        this.makeKomitentiCombo((Composite)filteri);
        this.makeFaktureCombo((Composite)filteri);
        this.makeTabelaIDugmici();
        this.popuniTabelu(this.pripremipodatkeOFakturamaZaTabelu());
        this.shell.open();
    }

    private void makeDateInputs(Composite composite) {
        this.makeLabel(composite, "Datum od:", 70, 20, null, 1, 1);
        this.odDatuma = new DateInput2(composite, "Datum od:", new Date(), false, this.server);
        this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
        this.makeLabel(composite, "", 20, 20, null, 1, 1);
        this.makeLabel(composite, "Datum do:", 70, 20, null, 1, 1);
        Text textOd = (Text)this.odDatuma.getControl();
        textOd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZbirnaFakturaInput.this.popuniTabelu(ZbirnaFakturaInput.this.pripremipodatkeOFakturamaZaTabelu());
            }
        });
        this.doDatuma = new DateInput2(composite, "Datum od:", new Date(), false, this.server);
        this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, this.shell));
        Text textDo = (Text)this.doDatuma.getControl();
        textDo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZbirnaFakturaInput.this.popuniTabelu(ZbirnaFakturaInput.this.pripremipodatkeOFakturamaZaTabelu());
            }
        });
    }

    private void makeKomitentiCombo(Composite composite) {
        this.makeLabel(composite, "", 20, 20, null, 1, 1);
        this.makeLabel(composite, "Komitenti:", 70, 20, null, 1, 1);
        GridData data = this.getGrdiData(75, 5, 1, 1);
        this.komitentiCombo = new Combo(composite, 8);
        this.komitentiCombo.setLayoutData((Object)data);
        List<StalniGost> komitenti = this.server.readStalniGostiFromRacun();
        for (StalniGost sg : komitenti) {
            this.komitentiCombo.add(sg.getNaziv());
        }
        this.komitentiCombo.select(0);
        this.komitentiCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZbirnaFakturaInput.this.popuniTabelu(ZbirnaFakturaInput.this.pripremipodatkeOFakturamaZaTabelu());
            }
        });
    }

    private void makeFaktureCombo(Composite composite) {
        this.makeLabel(composite, "", 50, 20, null, 1, 1);
        this.faktureCombo = new Combo(composite, 0);
        this.faktureCombo.add("Fakture");
        this.faktureCombo.add("Zbirne Fakture");
        this.faktureCombo.select(0);
        this.faktureCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZbirnaFakturaInput.this.popuniTabelu(ZbirnaFakturaInput.this.pripremipodatkeOFakturamaZaTabelu());
            }
        });
    }

    private void makeTabelaIDugmici() {
        Composite table = this.makeComposite((Composite)this.shell, 2, 750, 400, 1, 1, 1, 1, 1, 1);
        this.tabela = this.makeTableWithCheckBox(table, this.naziviKolona, this.sirineKolona, 1, 1);
        Composite buttons = this.makeComposite(table, 1, 150, 400, 1, 1, 1, 1, 1, 1);
        this.btnZbirna = this.makeButton(buttons, 100, 40, 1, 1, "Nova zbirna");
        this.btnZbirna.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                List faktureZaZbirnu = ZbirnaFakturaInput.this.preuzmiFaktureZaZbirnu();
                if (faktureZaZbirnu.size() < 1) {
                    Konstante.prikaziMessageBox(ZbirnaFakturaInput.this.shell, "Morate izabrati minimum jednu fakturu kako bi kreirali zbirnu");
                    return;
                }
                ZbirnaFakturaNova novaZbirna = new ZbirnaFakturaNova(faktureZaZbirnu, ZbirnaFakturaInput.this.server, ZbirnaFakturaInput.this.shell);
                novaZbirna.napraviZbirnuFakturu();
                ZbirnaFakturaInput.this.popuniTabelu(ZbirnaFakturaInput.this.pripremipodatkeOFakturamaZaTabelu());
            }
        });
        this.btnPregled = this.makeButton(buttons, 100, 40, 1, 1, "Pregled");
        this.btnPregled.setEnabled(false);
        this.btnPregled.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                List zbirneFakture = ZbirnaFakturaInput.this.preuzmiFaktureZaZbirnu();
                if (zbirneFakture.size() < 1) {
                    Konstante.prikaziMessageBox(ZbirnaFakturaInput.this.shell, "Morate izabrati fakture koje \u017eelite da pregledate");
                    return;
                }
                for (ZbirnaFakturaModel zfm : zbirneFakture) {
                    ZbirnaFakturaStampa zbStampa = new ZbirnaFakturaStampa(ZbirnaFakturaInput.this.server, zfm);
                    zbStampa.Stampaj();
                    if (!ZbirnaFakturaInput.this.btnSpecifikacija.getSelection()) continue;
                    zbStampa.StampajSpecifikaciju();
                }
            }
        });
        this.btnSpecifikacija = this.makeCheckBox(buttons, "specifikacija");
    }

    private List<String[]> pripremipodatkeOFakturamaZaTabelu() {
        long zdBrojOd = 1L;
        long zdBrojDo = 1L;
        Date datumOd = null;
        Date datumDo = null;
        try {
            datumOd = this.odDatuma.getResult();
            datumDo = this.doDatuma.getResult();
        }
        catch (InputException e) {
            e.printStackTrace();
        }
        String naziv = this.komitentiCombo.getText();
        zdBrojOd = this.server.getZDbyDatum(datumOd).getZdBroj();
        zdBrojDo = this.server.getZDbyDatum(datumDo).getZdBroj();
        if (this.faktureCombo.getText().equals("Zbirne Fakture")) {
            this.listaRacuna = ZbirnaFakturaNova.getZbirne(this.server, datumOd, datumDo, naziv);
            this.btnZbirna.setEnabled(false);
            this.btnPregled.setEnabled(true);
            this.btnSpecifikacija.setEnabled(true);
        } else {
            this.listaRacuna = ZbirnaFakturaNova.getFaktureZaZbirnu(this.server, zdBrojOd, zdBrojDo, naziv);
            this.btnZbirna.setEnabled(true);
            this.btnPregled.setEnabled(false);
            this.btnSpecifikacija.setEnabled(false);
        }
        ArrayList<String[]> podaciZaTabelu = new ArrayList<String[]>();
        for (ZbirnaFakturaModel model : this.listaRacuna) {
            String[] podaci = new String[this.naziviKolona.length];
            podaci[0] = model.getDatumZbirneFakture().toString();
            podaci[1] = String.valueOf(model.getId());
            podaci[2] = model.getBrojZbirneFakture();
            podaci[3] = String.valueOf(model.getIznosZbirneFakture());
            podaci[4] = model.getNazivKomitenta();
            podaciZaTabelu.add(podaci);
        }
        return podaciZaTabelu;
    }

    private void popuniTabelu(List<String[]> podaci) {
        this.tabela.removeAll();
        for (String[] red : podaci) {
            TableItem noviRed = new TableItem(this.tabela, 0);
            noviRed.setText(red);
        }
    }

    private List<ZbirnaFakturaModel> preuzmiFaktureZaZbirnu() {
        ArrayList<ZbirnaFakturaModel> faktureZaZbirnu = new ArrayList<ZbirnaFakturaModel>();
        int i = 0;
        for (TableItem item : this.tabela.getItems()) {
            if (item.getChecked()) {
                faktureZaZbirnu.add(this.listaRacuna.get(i));
            }
            ++i;
        }
        return faktureZaZbirnu;
    }
}

