/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.FakturaRacun;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ZbirnaFaktura2018 {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    SWTContainer parent;
    Shell shell;
    Composite composite;
    List<StavkaRacuna> stavkeRacuna;
    List<Racun> fakture;
    List<Racun> faktureZaZbirnu;
    StalniGost stalniGost;
    Date day1;
    Date day2;

    private ZbirnaFaktura2018(SWTContainer owner, Restoran r, Date date1, Date date2, StalniGost sg) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.stalniGost = sg;
        this.shell = this.parent.getControl().getShell();
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout());
        this.day1 = date1;
        this.day2 = date2;
        this.fakture = this.server.getFaktureZbirnaFaktura(this.day1, this.day2, this.stalniGost);
        this.stavkeRacuna = new ArrayList<StavkaRacuna>();
        this.table = new Table((Composite)this.shell, 66338);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        Composite control = new Composite((Composite)this.shell, 0);
        control.setLayout((Layout)new GridLayout(7, false));
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        GridData gd = new GridData();
        gd.heightHint = 50;
        gd.widthHint = 150;
        GridData gd1 = new GridData();
        gd1.heightHint = 50;
        gd1.widthHint = 150;
        gd1.horizontalAlignment = 131072;
        gd1.grabExcessHorizontalSpace = true;
        Button export = new Button(control, 8);
        export.setLayoutData((Object)gd);
        export.setText(String.format(Konstante.getBundle().getString("TEXT_ZBIRNA_FAKTURA"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ZbirnaFaktura2018.this.faktureZaZbirnu = new ArrayList<Racun>();
                int i = 0;
                for (TableItem t : ZbirnaFaktura2018.this.table.getItems()) {
                    if (t.getChecked()) {
                        Racun r = ZbirnaFaktura2018.this.fakture.get(i);
                        ZbirnaFaktura2018.this.faktureZaZbirnu.add(r);
                    }
                    ++i;
                }
                int brojKopija = ZbirnaFaktura2018.this.server.getSetting(Option.BROJ_KOPIJA_ZBIRINE_FAKTURE).intValue();
                new FakturaRacun(ZbirnaFaktura2018.this.shell.getDisplay(), ZbirnaFaktura2018.this.restoran, null, null, brojKopija, "", true, ZbirnaFaktura2018.this.faktureZaZbirnu);
                ZbirnaFaktura2018.this.shell.close();
            }
        });
        Button izlaz = new Button(control, 8);
        izlaz.setLayoutData((Object)gd1);
        izlaz.setText(String.format(Konstante.getBundle().getString("TEXT_ZATVORI"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ZbirnaFaktura2018.this.shell.close();
            }
        });
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public void makeHeaders() {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setText("");
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText(String.format(Konstante.getBundle().getString("TEXT_DATUM"), new Object[0]));
        tc1.setWidth(80);
        TableColumn tc6 = new TableColumn(this.table, 131072);
        tc6.setText(String.format(Konstante.getBundle().getString("TEXT_VREME"), new Object[0]));
        tc6.setWidth(80);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(String.format(Konstante.getBundle().getString("TEXT_BROJ_FAKTURE"), new Object[0]));
        tc4.setWidth(60);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(String.format(Konstante.getBundle().getString("TEXT_UKUPAN_PROMET"), new Object[0]));
        tc2.setWidth(100);
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText(String.format(Konstante.getBundle().getString("TEXT_KOMITENT"), new Object[0]));
        tc5.setWidth(250);
        TableColumn tc7 = new TableColumn(this.table, 131072);
        tc7.setText(String.format(Konstante.getBundle().getString("TEXT_POPUST"), new Object[0]));
        tc7.setWidth(60);
    }

    public void insertRows() {
        TableItem ti = null;
        double sum = 0.0;
        for (Racun r : this.fakture) {
            ti = new TableItem(this.table, 0);
            ti.setText(new String[]{"", "" + Konstante.getDate(r.getDatum()), "" + Konstante.getTime(r.getDatum()), "" + r.getBrojFakture(), "" + (r.getMenipromet() != false ? r.getMeniPromet().getTotal() : r.total()), r.getStalniGost().getNaziv(), "" + r.getPopust()});
            sum += r.getMenipromet() != false ? r.getMeniPromet().getTotal() : r.total();
        }
        ti = new TableItem(this.table, 0);
        ti.setGrayed(true);
        ti.setText(new String[]{"", "", "", "Ukupno: ", "" + sum, "", ""});
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32 && !(event.item.getData() instanceof TableItem)) {
                    event.detail = 0;
                    event.type = 0;
                    try {
                        ZbirnaFaktura2018.this.table.setRedraw(false);
                        TableItem item = (TableItem)event.item;
                        if (item.getGrayed()) {
                            item.setChecked(!item.getChecked());
                        }
                    }
                    finally {
                        ZbirnaFaktura2018.this.table.setRedraw(true);
                    }
                }
            }
        });
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
    }

    public static class ZbirnaFaktura2018Input {
        private Shell shell;
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        SWTContainer parent;
        private Combo stalni;
        List<StalniGost> gosti;

        public ZbirnaFaktura2018Input(SWTContainer owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.gosti = this.server.readStalniGostiFromRacun();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)this.shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)this.shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/dpuV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_ZBIRNA_FAKTURA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText("Ekran za unos, pregled i ispravku.\n Za vise informacija kliknite na ikonicu tehnickog uputstva ->");
            Button uputstvo = new Button(panel1, 8);
            uputstvo.setImage(new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_FILTER"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, this.shell));
            Label kon = new Label((Composite)grupa1, 0);
            kon.setText(String.format(Konstante.getBundle().getString("TEXT_STALNI_GOST"), new Object[0]) + ":");
            this.stalni = new Combo((Composite)grupa1, 8);
            this.stalni.add(String.format(Konstante.getBundle().getString("TEXT_SVI_STALNIGOSTI"), new Object[0]));
            for (StalniGost ko : this.gosti) {
                this.stalni.add(ko.getNaziv());
            }
            this.stalni.select(0);
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            kon.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            this.stalni.setLayoutData((Object)data);
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                if (this.stalni.getSelectionIndex() == 0) {
                    Konstante.getPoruka3(this.shell, "Morate odabrati jednog komitenta!");
                    return;
                }
                Date d1 = this.odDatuma.getResult();
                Date d2 = this.doDatuma.getResult();
                StalniGost sg = null;
                if (this.stalni.getSelectionIndex() > 0) {
                    sg = this.gosti.get(this.stalni.getSelectionIndex() - 1);
                }
                String tekst = sg != null ? ", za stalnog " + sg.getNaziv() : ", SVI KOMITENTI";
                this.server.log("Zbirna faktura: od datuma -> " + Konstante.getDate(d1) + " do datuma -> " + Konstante.getDate(d2) + tekst);
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText("Zbirna faktura: od datuma -> " + Konstante.getDate(d1) + " -> " + Konstante.getDate(d2) + tekst);
                SWTContainer parent2 = new SWTContainer((Composite)shell2);
                new ZbirnaFaktura2018(parent2, this.restoran, Konstante.getPocetniDatum(d1, this.server), Konstante.getKrajnjiDatum(d2, this.server), sg);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), "Greska", 2);
            }
        }
    }
}

