/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.controller.SettingController;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.stampa.StringAlign;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class XMLprintPrometPoKonobaru {
    static final String FILE_DATE_FORMAT = "yyyy-MM-dd_HH-mm-ss-SS";
    static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SS");
    public static final DateFormat format = new SimpleDateFormat("dd.MM.yy");
    static String path = SettingController.loadString(OptionBO.RMI_PUTANJA);
    static String tmp = SettingController.loadString(OptionBO.RMI_TEMP_PUTANJA);
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());

    public XMLprintPrometPoKonobaru(Konobar konobar, Map<NacinPlacanja, Double> bela, Map<String, Double> crna, Double naplaceno, Double nenaplaceno) throws Exception {
        LinkedList<String> nfBlok = new LinkedList<String>();
        nfBlok.add("");
        nfBlok.add(new StringAlign(25, 99).format((Object)"PROMET PO KONOBARU"));
        nfBlok.add(new StringAlign(25, 99).format((Object)"Sva proizvodna mesta"));
        nfBlok.add("");
        nfBlok.add(new StringAlign(25, 99).format((Object)("KONOBAR: " + konobar)));
        nfBlok.add("******************************************");
        nfBlok.add(new StringAlign(25, 108).format((Object)String.format(this.barmasterText.getString("TEXT_INSTRUMENTI_CAPS"), new Object[0])) + new StringAlign(5, 114).format((Object)String.format(this.barmasterText.getString("TEXT_NETO_CAPS"), new Object[0])));
        nfBlok.add(new StringAlign(25, 108).format((Object)String.format(this.barmasterText.getString("TEXT_PLACANJA_CAPS"), new Object[0])) + new StringAlign(5, 114).format((Object)String.format(this.barmasterText.getString("TEXT_IZNOS_CAPS"), new Object[0])));
        nfBlok.add("******************************************");
        for (NacinPlacanja instrumentBeli : bela.keySet()) {
            nfBlok.add(new StringAlign(25, 108).format((Object)instrumentBeli.getOpis().toUpperCase()) + new StringAlign(5, 114).format((Object)("" + bela.get((Object)instrumentBeli))));
        }
        for (String instrumentCrni : crna.keySet()) {
            nfBlok.add(new StringAlign(25, 108).format((Object)instrumentCrni.toUpperCase()) + new StringAlign(5, 114).format(crna.get(instrumentCrni)));
        }
        nfBlok.add("******************************************");
        nfBlok.add(new StringAlign(25, 108).format((Object)"NAPLACEN") + new StringAlign(5, 114).format((Object)("" + naplaceno)));
        nfBlok.add(new StringAlign(25, 108).format((Object)"NENAPLACEN") + new StringAlign(5, 114).format((Object)("" + nenaplaceno)));
        nfBlok.add(new StringAlign(25, 108).format((Object)String.format(this.barmasterText.getString("TEXT_TOTAL_CAPS"), new Object[0])) + new StringAlign(5, 114).format((Object)("" + (naplaceno + nenaplaceno))));
        nfBlok.add("");
        String d = df.format(new Date());
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("NefislanaStampa");
        newDoc.appendChild(rootElement);
        for (String line : nfBlok) {
            Element c1 = newDoc.createElement("Linija");
            c1.setTextContent(line);
            rootElement.appendChild(c1);
        }
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        while (f.exists()) {
            d = df.format(new Date());
            path1 = tmp + d + ".xml.tmp";
            f = new File(path1);
        }
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        int cnt = 0;
        File f2 = new File(path + d + ".xml");
        while (!f.renameTo(f2)) {
            if (++cnt >= 100) {
                Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", "100 retries failed. Giving up!");
                break;
            }
            Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", MessageFormat.format("Retrying rename of file {0} to {1}", f.getAbsolutePath(), f2.getAbsolutePath()));
            if (cnt % 10 != 0) continue;
            d = df.format(new Date());
            f2 = new File(path + d + ".xml");
        }
    }
}

