/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.print.Block;
import com.dev63.print.Center;
import com.dev63.print.Document;
import com.dev63.print.Element;
import com.dev63.print.Print;
import com.dev63.print.Split;
import com.dev63.print.Table;
import com.dev63.print.TableColumn;
import com.dev63.print.Text;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.SettingException;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.TipPrijemnice;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class StampaPrijemnice {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private final Restoran restoran;
    private NumberFormat format = new DecimalFormat("#0.####");
    SWTContainer parent;
    Panel panel;
    Prijemnica prijemnica;
    double total = 0.0;
    double totalMarza = 0.0;
    double totalProdajna = 0.0;
    double totalPorez = 0.0;
    double ncbpD = 0.0;
    double nvbpD = 0.0;
    double punD = 0.0;
    double pcD = 0.0;
    double pvbpD = 0.0;
    double ppD = 0.0;
    double totalS = 0.0;
    double totalMarzaS = 0.0;
    double totalProdajnaS = 0.0;
    double totalPorezS = 0.0;
    double ncbpDS = 0.0;
    double nvbpDS = 0.0;
    double punDS = 0.0;
    double pcDS = 0.0;
    double pvbpDS = 0.0;
    double ppDS = 0.0;
    List<PrijemnicaStavka> sirovine = new ArrayList<PrijemnicaStavka>();
    List<PrijemnicaStavka> prod = new ArrayList<PrijemnicaStavka>();
    Shell shell;

    public StampaPrijemnice(SWTContainer owner, Prijemnica prijemnica, Restoran r) throws SettingException {
        this.restoran = r;
        this.parent = owner;
        this.prijemnica = prijemnica;
        this.shell = this.parent.getControl().getShell();
        Document doc = new Document(true);
        this.makeHeader(doc);
        List<PrijemnicaStavka> stavke = this.restoran.getServer().readStavkePrijemnice(prijemnica);
        for (PrijemnicaStavka ps : stavke) {
            double procenat = Konstante.getPdvPoPG(ps.getArtikal().getPoreskaGrupa());
            double kontra = Konstante.getKontraPdvPoPG(ps.getArtikal().getPoreskaGrupa());
            this.ncbpD += ps.getKomad().doubleValue();
            this.nvbpD += ps.getKomad() * ps.getKolicina();
            this.punD += ps.getKomad() * ps.getKolicina() * procenat;
            if (ps.getArtikal().getTip() == TipArtikla.SIRO) {
                this.sirovine.add(ps);
                this.totalProdajna += ps.getKolicina() * ps.getKomad() * (1.0 + procenat);
                this.pvbpD += ps.getKomad() * ps.getKolicina();
                this.ppD += ps.getKomad() * ps.getKolicina() * procenat;
            } else {
                this.prod.add(ps);
                this.pcD += ps.getArtikal().getCena() * (1.0 / ps.getArtikal().getMera());
                this.ppD += ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * kontra;
                this.pvbpD += ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * (1.0 - kontra);
                this.totalProdajna += ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera());
                this.totalMarza += ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * (1.0 - kontra) - ps.getKomad() * ps.getKolicina();
                this.totalPorez += ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * kontra - ps.getKomad() * ps.getKolicina() * procenat;
            }
            this.total += ps.getKolicina() * ps.getKomad() * (1.0 + procenat);
        }
        if (this.prod.size() > 0) {
            PrijemnicaTableModel model = new PrijemnicaTableModel(this.prod);
            ArrayList<TableColumn> list = new ArrayList<TableColumn>();
            list.add(new TableColumn("sifra", "Sifra artikla", "left"));
            list.add(new TableColumn("artikal", "Naziv artikla", "left"));
            list.add(new TableColumn("jm", "Jed. mere", "left"));
            list.add(new TableColumn("porStopa", "Poreska stopa", "right"));
            list.add(new TableColumn("kol", "Kolicina", "right"));
            list.add(new TableColumn("kom", "Nabavna cena bez poreza", "right"));
            list.add(new TableColumn("nvbp", "Nabavna vrednost bez poreza", "right"));
            list.add(new TableColumn("nabPorez", "Porez u nabavci", "right"));
            list.add(new TableColumn("vred", "Nabavna vrednost", "right"));
            list.add(new TableColumn("marza", "Marza", "right"));
            list.add(new TableColumn("ukupanPorez", "Ukupan porez", "right"));
            list.add(new TableColumn("mpCena", "Prodajna cena", "right"));
            list.add(new TableColumn("pvbp", "Prodajna vrednost bez poreza", "right"));
            list.add(new TableColumn("mpPorez", "Prodajni porez", "right"));
            list.add(new TableColumn("mpVred", "Prodajna vrednost", "right"));
            Table table = new Table((TableModel)model, list);
            table.setHeaderBorder(true);
            doc.addElement((Element)table);
        }
        if (this.sirovine.size() > 0) {
            Block b = new Block();
            Block c = new Block("Tahoma", 6, false, true);
            c.addElement((Element)new Text(""));
            Center center = new Center((Element)c);
            center.setContentHeight(6);
            center.setContentWidth(50);
            b.addElement((Element)center);
            doc.addElement((Element)b);
            PrijemnicaTableModel model = new PrijemnicaTableModel(this.sirovine);
            ArrayList<TableColumn> list = new ArrayList<TableColumn>();
            list.add(new TableColumn("sifra", String.format(this.barmasterText.getString("TEXT_SIFRA_ARTIKLA"), new Object[0]), "right"));
            list.add(new TableColumn("artikal", String.format(this.barmasterText.getString("TEXT_NAZIV_ARTIKLA"), new Object[0])));
            list.add(new TableColumn("jm", String.format(this.barmasterText.getString("TEXT_JEDINICA_MERE_SKR"), new Object[0])));
            list.add(new TableColumn("porStopa", String.format(this.barmasterText.getString("TEXT_PORESKA_STOPA"), new Object[0]), "right"));
            list.add(new TableColumn("kol", String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]), "right"));
            list.add(new TableColumn("kom", String.format(this.barmasterText.getString("TEXT_NABAVNA_CENA_BEZ_PDV"), new Object[0]), "right"));
            list.add(new TableColumn("nvbp", String.format(this.barmasterText.getString("TEXT_NABAVNA_VREDNOST_BEZ_PDV"), new Object[0]), "right"));
            list.add(new TableColumn("nabPorez", String.format(this.barmasterText.getString("TEXT_PDV"), new Object[0]), "right"));
            list.add(new TableColumn("vred", String.format(this.barmasterText.getString("TEXT_NABAVNA_VREDNOST_SA_PDV"), new Object[0]), "right"));
            list.add(new TableColumn("marza", String.format(this.barmasterText.getString("TEXT_MARZA"), new Object[0]), "right"));
            list.add(new TableColumn("ukupanPorez", String.format(this.barmasterText.getString("TEXT_PDV_RAZLIKA"), new Object[0]), "right"));
            list.add(new TableColumn("mpCena", String.format(this.barmasterText.getString("TEXT_PRODAJNA_CENA"), new Object[0]), "right"));
            list.add(new TableColumn("pvbp", String.format(this.barmasterText.getString("TEXT_PRODAJNA_CENA_BEZ_PDV"), new Object[0]), "right"));
            list.add(new TableColumn("mpPorez", String.format(this.barmasterText.getString("TEXT_PDV"), new Object[0]), "right"));
            list.add(new TableColumn("mpVred", String.format(this.barmasterText.getString("TEXT_PRODAJNA_VREDNOST"), new Object[0]), "right"));
            Table table = new Table((TableModel)model, list);
            table.setHeaderBorder(true);
            doc.addElement((Element)table);
        }
        doc.addElement((Element)this.makePotpisFooter());
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setSize(1150, 700);
        Composite composite = new Composite((Composite)this.shell, 0x1040000);
        try {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        catch (NoSuchMethodError c) {
            // empty catch block
        }
        Frame frame = SWT_AWT.new_Frame((Composite)composite);
        this.panel = new Panel(new BorderLayout()){

            @Override
            public void update(Graphics g) {
                this.paint(g);
            }
        };
        frame.add((Component)Print.printPreview((Document)doc));
        this.shell.setMaximized(true);
        this.shell.open();
    }

    private void makeHeader(Document doc) throws SettingException {
        Block b = new Block();
        Block c = new Block("Tahoma", 16, false, true);
        c.addElement((Element)new Text((this.prijemnica.getTip() != null ? this.prijemnica.getTip() : TipPrijemnice.PRIJEMNICA).getInterName().toUpperCase()));
        Center center = new Center((Element)c);
        center.setContentHeight(6);
        center.setContentWidth(50);
        b.addElement((Element)center);
        Split s = new Split();
        c = new Block("Tahoma", 12, false, false);
        Setting naziv = this.restoran.getServer().getSetting(Option.OBJEKAT_NAZIV);
        String text = String.format(this.barmasterText.getString("TEXT_NAZIV_OBJEKTA"), new Object[0]) + ": ";
        if (naziv == null) {
            Konstante.getPoruka(this.shell, String.format(this.barmasterText.getString("PORUKA_NAZIV_OBJEKTA_NIJE_PODESEN"), new Object[0]));
            text = text + "";
        } else {
            text = text + naziv.stringValue();
        }
        c.addElement((Element)new Text(text));
        s.setLeft((Element)c);
        c = new Block("Tahoma", 12, false, false);
        Setting maticniBroj = this.restoran.getServer().getSetting(Option.OBJEKAT_MATICNI_BROJ);
        text = String.format(this.barmasterText.getString("TEXT_MATICNI_BROJ"), new Object[0]) + ": ";
        if (maticniBroj == null) {
            Konstante.getPoruka(this.shell, String.format(this.barmasterText.getString("PORUKA_MATICNI_BROJ_OBJEKTA_NIJE_PODESEN"), new Object[0]));
            text = text + "";
        } else {
            text = text + maticniBroj.stringValue();
        }
        c.addElement((Element)new Text(text));
        s.setRight((Element)c);
        b.addElement((Element)s);
        Split s2 = new Split();
        c = new Block("Tahoma", 12, false, false);
        Setting adresa = this.restoran.getServer().getSetting(Option.OBJEKAT_ADRESA);
        String text2 = String.format(this.barmasterText.getString("TEXT_ADRESA"), new Object[0]) + ": ";
        if (naziv == null) {
            Konstante.getPoruka(this.shell, String.format(this.barmasterText.getString("PORUKA_ADRESA_NIJE_PODESENA"), new Object[0]));
            text2 = text2 + "";
        } else {
            text2 = text2 + adresa.stringValue();
        }
        c.addElement((Element)new Text(text2));
        s2.setLeft((Element)c);
        c = new Block("Tahoma", 12, false, false);
        Setting pib = this.restoran.getServer().getSetting(Option.OBJEKAT_MATICNI_BROJ);
        text2 = String.format(this.barmasterText.getString("TEXT_PIB"), new Object[0]) + ": ";
        if (pib == null) {
            Konstante.getPoruka(this.shell, String.format(this.barmasterText.getString("PORUKA_PIB_OBJEKTA_NIJE_PODESEN"), new Object[0]));
            text2 = text2 + "";
        } else {
            text2 = text2 + pib.stringValue();
        }
        c.addElement((Element)new Text(text2));
        s2.setRight((Element)c);
        b.addElement((Element)s2);
        b.setBox(true);
        s2 = new Split();
        Block b2 = new Block();
        Block c2 = new Block("Tahoma", 12, false, false);
        String text3 = String.format(this.barmasterText.getString("TEXT_BROJ_PRIJEMNICE"), new Object[0]) + ": ";
        text3 = text3 + this.prijemnica.getBrPrijemnice();
        c2.addElement((Element)new Text(text3));
        s2.setLeft((Element)c2);
        c2 = new Block("Tahoma", 12, false, false);
        text3 = String.format(this.barmasterText.getString("TEXT_DOBAVLJAC"), new Object[0]) + ": ";
        text3 = text3 + this.prijemnica.getDobavljac().getNaziv();
        c2.addElement((Element)new Text(text3));
        s2.setRight((Element)c2);
        b2.addElement((Element)s2);
        s2 = new Split();
        c = new Block("Tahoma", 12, false, false);
        text3 = String.format(this.barmasterText.getString("TEXT_DATUM_PRIJEMNICE"), new Object[0]) + ": " + Konstante.getDate(this.prijemnica.getDatumPrijemnice());
        c.addElement((Element)new Text(text3));
        s2.setLeft((Element)c);
        c = new Block("Tahoma", 12, false, false);
        text3 = String.format(this.barmasterText.getString("TEXT_DATUM_UNOSA"), new Object[0]) + ": " + Konstante.getDate(this.prijemnica.getDatumUnosa());
        c.addElement((Element)new Text(text3));
        s2.setRight((Element)c);
        b2.addElement((Element)s2);
        s2 = new Split();
        c = new Block("Tahoma", 12, false, false);
        text3 = String.format(this.barmasterText.getString("TEXT_NAPOMENA"), new Object[0]) + ": " + this.prijemnica.getOpis();
        c.addElement((Element)new Text(text3));
        s2.setLeft((Element)c);
        b2.addElement((Element)s2);
        b.setPaddingBottom(3);
        b.setPaddingTop(3);
        b2.setPaddingBottom(3);
        b2.setPaddingTop(6);
        Block d = new Block();
        d.addElement((Element)b);
        d.addElement((Element)b2);
        d.setPaddingBottom(3);
        d.setPaddingTop(3);
        doc.addElement((Element)d);
        doc.setDefaultFooter();
    }

    public Block makePotpisFooter() {
        Split s = new Split();
        Split s22 = new Split();
        Split s33 = new Split();
        Split s44 = new Split();
        Block b7 = new Block("Tahoma", 10, false, false);
        Block b72 = new Block("Tahoma", 10, false, false);
        Block b73 = new Block("Tahoma", 10, false, false);
        Block b74 = new Block("Tahoma", 10, false, false);
        String text = String.format(this.barmasterText.getString("TEXT_NABAVNA_VREDNOST_SA_POREZOM_CAPS"), new Object[0]) + ": " + this.format.format(this.total);
        String t2 = String.format(this.barmasterText.getString("TEXT_PRODAJNA_VREDNOST_CAPS"), new Object[0]) + ": " + this.format.format(this.totalProdajna);
        String t3 = String.format(this.barmasterText.getString("TEXT_MARZA_CAPS"), new Object[0]) + ": " + this.format.format(this.totalMarza);
        String t4 = String.format(this.barmasterText.getString("TEXT_RAZLIKA_PDV_CAPS"), new Object[0]) + ": " + this.format.format(this.totalPorez);
        b7.addElement((Element)new Text(text));
        s.setRight((Element)b7);
        b72.addElement((Element)new Text(t2));
        s22.setRight((Element)b72);
        b73.addElement((Element)new Text(t3));
        s33.setRight((Element)b73);
        b74.addElement((Element)new Text(t4));
        s44.setRight((Element)b74);
        b7.setPaddingTop(3);
        b72.setPaddingTop(3);
        b73.setPaddingTop(3);
        b74.setPaddingTop(3);
        Block b = new Block("Arial", 12, false, false);
        Block b1 = new Block("________________________");
        b1.setTextAlign("center");
        Block b2 = new Block("");
        Block b3 = new Block("________________________________");
        b3.setTextAlign("center");
        Split s1 = new Split((Element)b1, (Element)b2, (Element)b3);
        b1.setPaddingTop(32);
        b2.setPaddingTop(32);
        b3.setPaddingTop(32);
        Block b4 = new Block(String.format(this.barmasterText.getString("TEXT_ODGOVORNA_OSOBA"), new Object[0]));
        b4.setTextAlign("center");
        Block b5 = new Block("                      ");
        Block b6 = new Block(String.format(this.barmasterText.getString("TEXT_OVERIO"), new Object[0]));
        b6.setTextAlign("center");
        Split s2 = new Split((Element)b4, (Element)b5, (Element)b6);
        b.addElement((Element)s);
        b.addElement((Element)s22);
        b.addElement((Element)s33);
        b.addElement((Element)s44);
        b.addElement((Element)s1);
        b.addElement((Element)s2);
        return b;
    }

    private class PrijemnicaTableModel
    extends AbstractTableModel {
        private List<PrijemnicaStavka> list;

        public PrijemnicaTableModel(List<PrijemnicaStavka> list) {
            this.list = list;
        }

        @Override
        public int getRowCount() {
            return this.list.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 15;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "sifra";
                }
                case 1: {
                    return "artikal";
                }
                case 2: {
                    return "jm";
                }
                case 3: {
                    return "porStopa";
                }
                case 4: {
                    return "kol";
                }
                case 5: {
                    return "kom";
                }
                case 6: {
                    return "nabPorez";
                }
                case 7: {
                    return "nvbp";
                }
                case 8: {
                    return "vred";
                }
                case 9: {
                    return "marza";
                }
                case 10: {
                    return "ukupanPorez";
                }
                case 11: {
                    return "mpCena";
                }
                case 12: {
                    return "pvbp";
                }
                case 13: {
                    return "mpPorez";
                }
                case 14: {
                    return "mpVred";
                }
            }
            throw new ArrayIndexOutOfBoundsException("columnIndex: " + column);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex > this.list.size() - 1) {
                switch (columnIndex) {
                    case 5: {
                        double temp = StampaPrijemnice.this.ncbpDS;
                        StampaPrijemnice.this.ncbpDS = 0.0;
                        return StatLogic.getNumber02NG(temp);
                    }
                    case 6: {
                        double temp = StampaPrijemnice.this.nvbpDS;
                        StampaPrijemnice.this.nvbpDS = 0.0;
                        return StatLogic.getNumber02NG(temp);
                    }
                    case 7: {
                        double temp = StampaPrijemnice.this.punDS;
                        StampaPrijemnice.this.punDS = 0.0;
                        return StatLogic.getNumber02NG(temp);
                    }
                    case 8: {
                        double temp = StampaPrijemnice.this.totalS;
                        StampaPrijemnice.this.totalS = 0.0;
                        return StatLogic.getNumber02NG(temp);
                    }
                    case 9: {
                        double temp = StampaPrijemnice.this.totalMarzaS;
                        StampaPrijemnice.this.totalMarzaS = 0.0;
                        return StatLogic.getNumber02NG(temp);
                    }
                    case 10: {
                        double temp = StampaPrijemnice.this.totalPorezS;
                        StampaPrijemnice.this.totalPorezS = 0.0;
                        return StatLogic.getNumber02NG(temp);
                    }
                    case 11: {
                        double temp = StampaPrijemnice.this.pcDS;
                        StampaPrijemnice.this.pcDS = 0.0;
                        return StatLogic.getNumber02NG(temp);
                    }
                    case 12: {
                        double temp = StampaPrijemnice.this.pvbpDS;
                        StampaPrijemnice.this.pvbpDS = 0.0;
                        return StatLogic.getNumber02NG(temp);
                    }
                    case 13: {
                        double temp = StampaPrijemnice.this.ppDS;
                        StampaPrijemnice.this.ppDS = 0.0;
                        return StatLogic.getNumber02NG(temp);
                    }
                    case 14: {
                        double temp = StampaPrijemnice.this.totalProdajnaS;
                        StampaPrijemnice.this.totalProdajnaS = 0.0;
                        return StatLogic.getNumber02NG(temp);
                    }
                }
                return "";
            }
            PrijemnicaStavka ps = this.list.get(rowIndex);
            double procenat = Konstante.getPdvPoPG(ps.getArtikal().getPoreskaGrupa());
            double kontra = Konstante.getKontraPdvPoPG(ps.getArtikal().getPoreskaGrupa());
            switch (columnIndex) {
                case 0: {
                    return ps.getArtikal().getBarCode() != null ? ps.getArtikal().getBarCode() : "";
                }
                case 1: {
                    return ps.getArtikal().getName();
                }
                case 2: {
                    return ps.getArtikal().getJedinicaMere();
                }
                case 3: {
                    return (int)(procenat * 100.0) + " %";
                }
                case 4: {
                    return StatLogic.getNumber03NG(ps.getKolicina());
                }
                case 5: {
                    StampaPrijemnice.this.ncbpDS += ps.getKomad().doubleValue();
                    return StatLogic.getNumber02NG(ps.getKomad());
                }
                case 6: {
                    StampaPrijemnice.this.nvbpDS += ps.getKomad() * ps.getKolicina();
                    return StatLogic.getNumber02NG(ps.getKomad() * ps.getKolicina());
                }
                case 7: {
                    StampaPrijemnice.this.punDS += ps.getKomad() * ps.getKolicina() * procenat;
                    return StatLogic.getNumber02NG(ps.getKomad() * ps.getKolicina() * procenat);
                }
                case 8: {
                    StampaPrijemnice.this.totalS += ps.getKolicina() * ps.getKomad() * (1.0 + procenat);
                    return StatLogic.getNumber02NG(ps.getKolicina() * ps.getKomad() * (1.0 + procenat));
                }
                case 9: {
                    if (ps.getArtikal().getTip() == TipArtikla.SIRO) {
                        return StatLogic.getNumber02NG(0.0);
                    }
                    StampaPrijemnice.this.totalMarzaS += ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * (1.0 - kontra) - ps.getKomad() * ps.getKolicina();
                    return StatLogic.getNumber02NG(ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * (1.0 - kontra) - ps.getKomad() * ps.getKolicina());
                }
                case 10: {
                    if (ps.getArtikal().getTip() == TipArtikla.SIRO) {
                        return StatLogic.getNumber02NG(0.0);
                    }
                    StampaPrijemnice.this.totalPorezS += ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * kontra - ps.getKomad() * ps.getKolicina() * procenat;
                    return StatLogic.getNumber02NG(ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * kontra - ps.getKomad() * ps.getKolicina() * procenat);
                }
                case 11: {
                    if (ps.getArtikal().getTip() == TipArtikla.SIRO) {
                        return StatLogic.getNumber02NG(0.0);
                    }
                    StampaPrijemnice.this.pcDS += ps.getArtikal().getCena() * (1.0 / ps.getArtikal().getMera());
                    return StatLogic.getNumber02NG(ps.getArtikal().getCena() * (1.0 / ps.getArtikal().getMera()));
                }
                case 12: {
                    if (ps.getArtikal().getTip() == TipArtikla.SIRO) {
                        StampaPrijemnice.this.pvbpDS += ps.getKomad() * ps.getKolicina();
                        return StatLogic.getNumber02NG(ps.getKomad() * ps.getKolicina());
                    }
                    StampaPrijemnice.this.pvbpDS += ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * (1.0 - kontra);
                    return StatLogic.getNumber02NG(ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * (1.0 - kontra));
                }
                case 13: {
                    if (ps.getArtikal().getTip() == TipArtikla.SIRO) {
                        StampaPrijemnice.this.ppDS += ps.getKomad() * ps.getKolicina() * procenat;
                        return StatLogic.getNumber02NG(ps.getKomad() * ps.getKolicina() * procenat);
                    }
                    StampaPrijemnice.this.ppDS += ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * kontra;
                    return StatLogic.getNumber02NG(ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()) * kontra);
                }
                case 14: {
                    if (ps.getArtikal().getTip() == TipArtikla.SIRO) {
                        StampaPrijemnice.this.totalProdajnaS += ps.getKolicina() * ps.getKomad() * (1.0 + procenat);
                        return StatLogic.getNumber02NG(ps.getKolicina() * ps.getKomad() * (1.0 + procenat));
                    }
                    StampaPrijemnice.this.totalProdajnaS += ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera());
                    return StatLogic.getNumber02NG(ps.getArtikal().getCena() * ps.getKolicina() * (1.0 / ps.getArtikal().getMera()));
                }
            }
            throw new ArrayIndexOutOfBoundsException("columnIndex: " + columnIndex);
        }

        public void setList(List<PrijemnicaStavka> list) {
            this.list = list;
        }

        public List<PrijemnicaStavka> getList() {
            return this.list;
        }
    }
}

