/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.ArtikalTarget;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class RealizacijaPoArtiklima {
    private final ResourceBundle barmasterText = Konstante.getBundle();
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    boolean sifre;
    SimpleDateFormat format3 = new SimpleDateFormat("dd-MM-yyyy");
    private Konobar konobar;

    public RealizacijaPoArtiklima(Shell s, Restoran re, final Date d1, Date d2, Konobar k) {
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.server.refresh();
        this.shell = new Shell(s, 34912);
        this.konobar = k;
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_REALIZACIJA_PLANA_PO_ARTIKLIMA"), new Object[0]) + " za dane " + this.format3.format(d1) + " -> " + this.format3.format(d2));
        if (this.server.isEmptyDateZD(d1, d2) || this.server.isBeforeDateZD(d2)) {
            Konstante.getPoruka3(this.shell, String.format(this.barmasterText.getString("PORUKA_ZA_IZBRANI_PERIOD_NEMA_PODATAKA"), new Object[0]));
            return;
        }
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(7, false));
        this.table = new Table((Composite)this.shell, 66370);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 7;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.inserRows(d1, d2, k);
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 120;
        data.horizontalAlignment = 16384;
        Button printButton = new Button((Composite)this.shell, 72);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_A4"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(RealizacijaPoArtiklima.this.table), false, true, String.format(RealizacijaPoArtiklima.this.barmasterText.getString("TEXT_REALIZACIJA_PLANA_PO_ARTIKLIMA"), new Object[0]) + ": " + StatLogic.getDateString(d1), RealizacijaPoArtiklima.this.shell, RealizacijaPoArtiklima.this.server);
            }
        });
        printButton.setLayoutData((Object)data);
        Button export = new Button((Composite)this.shell, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(RealizacijaPoArtiklima.this.table, RealizacijaPoArtiklima.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(RealizacijaPoArtiklima.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)data);
        Button izlaz = new Button((Composite)this.shell, 72);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                RealizacijaPoArtiklima.this.shell.close();
            }
        });
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        this.shell.setMaximized(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void makeHeaders() {
        TableColumn tc0 = new TableColumn(this.table, 0x1000000);
        tc0.setText(String.format(this.barmasterText.getString("TEXT_KONOBAR"), new Object[0]));
        tc0.setWidth(120);
        TableColumn tc01 = new TableColumn(this.table, 16384);
        tc01.setText(String.format(this.barmasterText.getString("TEXT_PODGRUPA"), new Object[0]));
        tc01.setWidth(120);
        TableColumn tc1 = new TableColumn(this.table, 16384);
        tc1.setText(String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]));
        tc1.setWidth(180);
        TableColumn tc11 = new TableColumn(this.table, 131072);
        tc11.setText(String.format(this.barmasterText.getString("TEXT_CENA"), new Object[0]));
        tc11.setWidth(80);
        TableColumn tc121 = new TableColumn(this.table, 131072);
        tc121.setText(String.format(this.barmasterText.getString("TEXT_PRODATO_KOM"), new Object[0]));
        tc121.setWidth(120);
        TableColumn tc12 = new TableColumn(this.table, 131072);
        tc12.setText(String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]));
        tc12.setWidth(120);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(String.format(this.barmasterText.getString("TEXT_PLAN"), new Object[0]));
        tc4.setWidth(100);
        TableColumn tc41 = new TableColumn(this.table, 131072);
        tc41.setText(String.format(this.barmasterText.getString("TEXT_PLAN_UPROCENTIMA"), new Object[0]));
        tc41.setWidth(180);
        TableColumn tc42 = new TableColumn(this.table, 131072);
        tc42.setText(String.format(this.barmasterText.getString("TEXT_NAGRADA"), new Object[0]));
        tc42.setWidth(100);
    }

    public void inserRows(Date from, Date to, Konobar k) {
        List<Object> sviKonobari = new LinkedList<Konobar>();
        TableItem t1 = new TableItem(this.table, 0);
        t1.setText("");
        if (k == null) {
            sviKonobari = this.server.readKonobarFromArtikalTarget();
        } else {
            sviKonobari.add(k);
        }
        TableItem ti = null;
        double totalUkupno = 0.0;
        Double totalNagrada = 0.0;
        for (Konobar konobar : sviKonobari) {
            double ukupno = 0.0;
            double ukupnoNagrada = 0.0;
            HashMap mapa = new HashMap();
            ti = new TableItem(this.table, 0);
            ti.setText(0, konobar.getPunoime());
            ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
            for (ArtikalTarget at : this.server.getArtikalTarget(konobar)) {
                Artikal a = this.server.getArtikal(at.getArtikal().getName());
                if (mapa.containsKey(a.getPodgrupa().getNaziv())) {
                    ((List)mapa.get(a.getPodgrupa().getNaziv())).add(at);
                    continue;
                }
                LinkedList<ArtikalTarget> lista = new LinkedList<ArtikalTarget>();
                lista.add(at);
                mapa.put(a.getPodgrupa().getNaziv(), lista);
            }
            for (String s : mapa.keySet()) {
                ti = new TableItem(this.table, 0);
                ti.setText(0, "");
                ti.setText(1, s);
                ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
                for (ArtikalTarget ata : (List)mapa.get(s)) {
                    ti = new TableItem(this.table, 0);
                    ti.setText(2, ata.getArtikal().getName());
                    Map<Object, Object> art = new HashMap();
                    art = this.server.getMapZaArtikal(from, to, konobar, ata.getArtikal());
                    double cena = (Double)((List)art.get(ata.getArtikal())).toArray()[0];
                    double kol = (Double)((List)art.get(ata.getArtikal())).toArray()[1];
                    ti.setText(3, "" + cena);
                    ti.setText(4, "" + kol);
                    ti.setText(5, "" + cena * kol);
                    ukupno += cena * kol;
                    ti.setText(6, ata.getNagradaNovac());
                    ti.setText(7, ata.getNagradaProcenat());
                    ti.setForeground(this.shell.getDisplay().getSystemColor(3));
                    if (!(kol > 0.0)) continue;
                    String nagrada = !ata.getNagradaNovac().equals("0") ? "" + kol * Double.parseDouble(ata.getNagradaNovac()) : "" + cena * kol / 100.0 * Double.parseDouble(ata.getNagradaProcenat());
                    ukupnoNagrada += Double.parseDouble(nagrada);
                    ti.setText(8, nagrada);
                    ti.setForeground(this.shell.getDisplay().getSystemColor(2));
                }
            }
            totalUkupno += ukupno;
            totalNagrada = totalNagrada + ukupnoNagrada;
            ti = new TableItem(this.table, 0);
            ti.setText("");
            ti = new TableItem(this.table, 0);
            ti.setText(new String[]{"", "", "", "", String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]), Konstante.getNumber02(ukupno), "", "UKUPNO NAGRADA: ", Konstante.getNumber02(ukupnoNagrada)});
            ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 3));
            ti = new TableItem(this.table, 0);
            ti.setText("");
        }
        ti = new TableItem(this.table, 0);
        ti.setText("");
        ti = new TableItem(this.table, 0);
        ti.setText("");
        ti = new TableItem(this.table, 0);
        ti.setText(new String[]{"", "", "", "", "TOTAL: ", Konstante.getNumber02(totalUkupno), "", "TOTAL NAGRADA: ", Konstante.getNumber02(totalNagrada)});
        ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
    }

    public static class RealizacijaPoArtiklimaInput {
        private final ResourceBundle barmasterText = Konstante.getBundle();
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        Date day1;
        Date day2;
        SWTContainer parent;
        Shell shell;
        Composite mainComposite;
        private Combo cbKonobar;
        private List<Konobar> konobari;
        private Konobar konobar;

        public RealizacijaPoArtiklimaInput(SWTContainer owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new FillLayout());
            ScrolledComposite sc = new ScrolledComposite((Composite)this.shell, 768);
            this.mainComposite = new Composite((Composite)sc, 0);
            sc.setContent((Control)this.mainComposite);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            this.mainComposite.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite(this.mainComposite, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            Composite panel2 = new Composite(this.mainComposite, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            GridData data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)this.mainComposite.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_REALIZACIJA_PLANA_PO_ARTIKLIMA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData(4, 4, false, false);
            data.widthHint = 670;
            data.heightHint = 70;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(2, false));
            grupa21.setText(String.format(this.barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 55;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, this.shell));
            Label izKon = new Label((Composite)grupa21, 0);
            izKon.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_KONOBARA"), new Object[0]) + ":");
            this.konobari = this.server.readKonobarFromArtikalTarget();
            this.cbKonobar = new Combo((Composite)grupa21, 8);
            this.cbKonobar.add("Svi konobari");
            for (Konobar o : this.konobari) {
                this.cbKonobar.add(o.getPunoime());
            }
            this.cbKonobar.select(0);
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 100;
            data.heightHint = 30;
            GridData data1 = new GridData();
            data1.horizontalAlignment = 16384;
            data1.horizontalIndent = 10;
            data1.widthHint = 100;
            data1.heightHint = 20;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            izKon.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data1);
            this.doDatuma.getControl().setLayoutData((Object)data1);
            this.cbKonobar.setLayoutData((Object)data1);
            this.mainComposite.layout();
            sc.setMinSize(this.mainComposite.computeSize(-1, -1));
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        protected void eraseText(TextInput2 text1, TextInput2 text2) {
            try {
                if (text1.getResult().length() > 0) {
                    text2.setResult("");
                }
            }
            catch (InputException e) {
                e.printStackTrace();
            }
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            HashMap<String, Comparable<Date>> hm = new HashMap<String, Comparable<Date>>();
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                this.day1 = this.server.getPocetni(this.day1);
                this.day2 = this.server.getKrajnji(this.day2);
                this.server.log(String.format(this.barmasterText.getString("TEXT_REALIZACIJA_PLANA_PO_ARTIKLIMA"), StatLogic.getDateString(this.day1)));
                this.konobar = this.cbKonobar.getText().equals("Svi konobari") ? null : this.server.getKonobar(this.cbKonobar.getText());
                long k = 0L;
                k = this.konobar == null ? -1L : this.konobar.getId();
                hm.put("datumOd", new Timestamp(this.day1.getTime()));
                hm.put("datumDo", new Timestamp(this.day2.getTime()));
                hm.put("konobar", Long.valueOf(k));
                try {
                    InputStream report = RealizacijaPoArtiklima.class.getClassLoader().getResourceAsStream("com/dev63/restoran/reports/templates/RealizacijaPoArtiklima.jasper");
                    JasperPrint jprint = JasperFillManager.fillReport((InputStream)report, hm, (Connection)this.server.getConnection());
                    JasperViewer.viewReport((JasperPrint)jprint, (boolean)false);
                }
                catch (JRException ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

