/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.izvestaji.RealizacijaPoArtiklima;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.KonobarTarget;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class RealizacijaFinansijskogPlana {
    private final ResourceBundle barmasterText = Konstante.getBundle();
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    boolean sifre;
    SimpleDateFormat format3 = new SimpleDateFormat("dd-MM-yyyy");
    Konobar konobar;
    KonobarTarget target;

    public RealizacijaFinansijskogPlana(Shell s, Restoran re, final Date d1, Date d2, Konobar k, KonobarTarget kt) {
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.server.refresh();
        this.shell = new Shell(s, 34912);
        this.konobar = k;
        this.target = kt;
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_REALIZACIJA_FINANSIJSKOG_PLANA"), new Object[0]) + " za dane " + this.format3.format(d1) + " -> " + this.format3.format(d2));
        if (this.server.isEmptyDateZD(d1, d2) || this.server.isBeforeDateZD(d2)) {
            Konstante.getPoruka3(this.shell, String.format(this.barmasterText.getString("PORUKA_ZA_IZBRANI_PERIOD_NEMA_PODATAKA"), new Object[0]));
            return;
        }
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(7, false));
        this.table = new Table((Composite)this.shell, 66370);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 7;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.popuniTabelu(d1, d2, this.konobar, this.target);
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 120;
        data.horizontalAlignment = 16384;
        Button printButton = new Button((Composite)this.shell, 72);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_A4"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(RealizacijaFinansijskogPlana.this.table), false, true, String.format(RealizacijaFinansijskogPlana.this.barmasterText.getString("TEXT_REALIZACIJA_FINANSIJSKOG_PLANA"), new Object[0]) + ": " + StatLogic.getDateString(d1), RealizacijaFinansijskogPlana.this.shell, RealizacijaFinansijskogPlana.this.server);
            }
        });
        printButton.setLayoutData((Object)data);
        Button export = new Button((Composite)this.shell, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(RealizacijaFinansijskogPlana.this.table, RealizacijaFinansijskogPlana.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)data);
        Button izlaz = new Button((Composite)this.shell, 72);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                RealizacijaFinansijskogPlana.this.shell.close();
            }
        });
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        this.shell.setMaximized(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void makeHeaders() {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setText("Konobar");
        tc0.setWidth(120);
        TableColumn tc01 = new TableColumn(this.table, 131072);
        tc01.setText("Naziv plana");
        tc01.setWidth(150);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText("Plan");
        tc1.setWidth(70);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText("Planirana Nagrada");
        tc2.setWidth(120);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText("Realizovan Iznos");
        tc3.setWidth(120);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText("Nagrada");
        tc4.setWidth(80);
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText("Realizovano?");
        tc5.setWidth(100);
    }

    public void popuniTabelu(Date from, Date to, Konobar konobar, KonobarTarget target) {
        List<Object> listaKonobara = new LinkedList<Konobar>();
        List<Object> listaTargeta = new LinkedList<KonobarTarget>();
        TableItem t1 = new TableItem(this.table, 0);
        t1.setText("");
        if (konobar == null) {
            listaKonobara = this.server.getKonobar_KonobarTarget();
        } else {
            listaKonobara.add(konobar);
        }
        for (Konobar konobar2 : listaKonobara) {
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(0, konobar2.getPunoime());
            ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
            if (target == null) {
                listaTargeta = this.server.readTargete(konobar2);
            } else {
                listaTargeta.add(target);
            }
            double sumPoKonobaru = this.server.getRealizacijaFinansijskogPlana(from, to, konobar2);
            for (KonobarTarget konobarTarget : listaTargeta) {
                double procenatNagrada = 0.0;
                if (konobarTarget.getNagradaNovac().length() == 0) {
                    procenatNagrada = sumPoKonobaru * Double.parseDouble(konobarTarget.getNagradaProcenat()) / 100.0;
                }
                ti = new TableItem(this.table, 0);
                int i = 0;
                ti.setText(i++, "");
                ti.setText(i++, konobarTarget.getNaziv());
                ti.setText(i++, konobarTarget.getTarget());
                ti.setText(i++, konobarTarget.getNagradaNovac().length() != 0 ? konobarTarget.getNagradaNovac() : konobarTarget.getNagradaProcenat() + "%");
                ti.setText(i++, Konstante.getNumber02(sumPoKonobaru));
                ti.setText(i++, sumPoKonobaru > Double.parseDouble(konobarTarget.getTarget()) ? (konobarTarget.getNagradaNovac().length() != 0 ? konobarTarget.getNagradaNovac() : Konstante.getNumber02(procenatNagrada)) : "/");
                ti.setText(i++, sumPoKonobaru > Double.parseDouble(konobarTarget.getTarget()) ? "DA" : "NE");
                if (!(sumPoKonobaru > Double.parseDouble(konobarTarget.getTarget()))) continue;
                ti.setForeground(this.shell.getDisplay().getSystemColor(3));
            }
        }
    }

    public static class RealizacijaFinansijskogPlanaInput {
        private final ResourceBundle barmasterText = Konstante.getBundle();
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        Date day1;
        Date day2;
        SWTContainer parent;
        Shell shell;
        Composite mainComposite;
        private List<Konobar> cvKonobariInput;
        private Combo konobar;
        private ComboViewer cvKonobar;
        private Combo planovi;
        private ComboViewer cvPlanovi;
        private List<KonobarTarget> cvPlanoviInput;
        Konobar kon;
        KonobarTarget plan;

        public RealizacijaFinansijskogPlanaInput(SWTContainer owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new FillLayout());
            ScrolledComposite sc = new ScrolledComposite((Composite)this.shell, 768);
            this.mainComposite = new Composite((Composite)sc, 0);
            sc.setContent((Control)this.mainComposite);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            this.mainComposite.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite(this.mainComposite, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            Composite panel2 = new Composite(this.mainComposite, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            GridData data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)this.mainComposite.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_REALIZACIJA_FINANSIJSKOG_PLANA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData(4, 4, false, false);
            data.widthHint = 670;
            data.heightHint = 70;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(2, false));
            grupa21.setText(String.format(this.barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 55;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, this.shell));
            Label izKon = new Label((Composite)grupa21, 0);
            izKon.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_KONOBARA"), new Object[0]) + ":");
            this.cvKonobariInput = this.server.readKonobarFromKonobarTarget();
            this.cvKonobar = new ComboViewer((Composite)grupa21, 8);
            this.cvKonobar.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Konobar) {
                        Konobar k = (Konobar)element;
                        return k.getPunoime() == null ? "" : k.getPunoime();
                    }
                    if (element.equals(cvKonobar.getInput())) {
                        return String.format(Konstante.getBundle().getString("TEXT_SVI_KONOBARI"), new Object[0]);
                    }
                    return "";
                }
            });
            this.cvKonobar.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    LinkedList<Object> elements = new LinkedList<Object>();
                    elements.add(inputElement);
                    if (inputElement instanceof List) {
                        List list = (List)inputElement;
                        for (Object element : list) {
                            if (!(element instanceof Konobar)) continue;
                            elements.add(element);
                        }
                    }
                    return elements.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.konobar = this.cvKonobar.getCombo();
            this.konobar.setEnabled(true);
            this.cvKonobar.setInput(this.cvKonobariInput);
            this.cvKonobar.setSelection((ISelection)new StructuredSelection(this.cvKonobar.getInput()));
            this.cvKonobar.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    try {
                        Konobar element;
                        StructuredSelection sel = (StructuredSelection)cvKonobar.getSelection();
                        kon = element = (Konobar)sel.getFirstElement();
                        planovi.setEnabled(true);
                        cvPlanoviInput = server.readTargete(element);
                        cvPlanovi.setInput((Object)cvPlanoviInput);
                    }
                    catch (ClassCastException e) {
                        kon = null;
                        plan = null;
                        planovi.setEnabled(false);
                        cvPlanoviInput = new LinkedList();
                        cvPlanoviInput = server.readTargete();
                        cvPlanovi.setInput((Object)cvPlanoviInput);
                    }
                }
            });
            Label pln = new Label((Composite)grupa21, 0);
            pln.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_PLANA"), new Object[0]) + ":");
            this.cvPlanoviInput = this.server.readTargete();
            this.cvPlanovi = new ComboViewer((Composite)grupa21, 8);
            this.cvPlanovi.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof KonobarTarget) {
                        KonobarTarget sgg = (KonobarTarget)element;
                        return sgg.getNaziv() == null ? "" : sgg.getNaziv();
                    }
                    if (element.equals(cvPlanovi.getInput())) {
                        return String.format(Konstante.getBundle().getString("TEXT_SVI_PLANOVI"), new Object[0]);
                    }
                    return "";
                }
            });
            this.cvPlanovi.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    LinkedList<Object> elements = new LinkedList<Object>();
                    elements.add(inputElement);
                    if (inputElement instanceof List) {
                        List list = (List)inputElement;
                        for (Object element : list) {
                            if (!(element instanceof KonobarTarget)) continue;
                            elements.add(element);
                        }
                    }
                    return elements.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.planovi = this.cvPlanovi.getCombo();
            this.planovi.setEnabled(false);
            this.cvPlanovi.setInput(this.cvPlanoviInput);
            this.cvPlanovi.setSelection((ISelection)new StructuredSelection(this.cvPlanovi.getInput()));
            this.cvPlanovi.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    try {
                        KonobarTarget element;
                        StructuredSelection sel = (StructuredSelection)cvPlanovi.getSelection();
                        plan = element = (KonobarTarget)sel.getFirstElement();
                    }
                    catch (ClassCastException e) {
                        e.printStackTrace();
                    }
                }
            });
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 100;
            data.heightHint = 30;
            GridData data1 = new GridData();
            data1.horizontalAlignment = 16384;
            data1.horizontalIndent = 10;
            data1.widthHint = 100;
            data1.heightHint = 20;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            izKon.setLayoutData((Object)data);
            pln.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data1);
            this.doDatuma.getControl().setLayoutData((Object)data1);
            this.cvKonobar.getCombo().setLayoutData((Object)data1);
            this.cvPlanovi.getCombo().setLayoutData((Object)data1);
            this.mainComposite.layout();
            sc.setMinSize(this.mainComposite.computeSize(-1, -1));
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            HashMap<String, Comparable<Date>> hm = new HashMap<String, Comparable<Date>>();
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                this.day1 = this.server.getPocetni(this.day1);
                this.day2 = this.server.getKrajnji(this.day2);
                long k = 0L;
                k = this.kon == null ? -1L : this.kon.getId();
                long p = 0L;
                p = this.plan == null ? -1L : this.plan.getId();
                this.server.log(String.format(this.barmasterText.getString("TEXT_REALIZACIJA_FINANSIJSKOG_PLANA"), StatLogic.getDateString(this.day1)));
                hm.put("datumOd", new Timestamp(this.day1.getTime()));
                hm.put("datumDo", new Timestamp(this.day2.getTime()));
                hm.put("konobar", Long.valueOf(k));
                hm.put("plan", Long.valueOf(p));
                InputStream report = RealizacijaPoArtiklima.class.getClassLoader().getResourceAsStream("com/dev63/restoran/reports/templates/RealizacijaFinansijskogPlana.jasper");
                JasperPrint jprint = JasperFillManager.fillReport((InputStream)report, hm, (Connection)this.server.getConnection());
                JasperViewer.viewReport((JasperPrint)jprint, (boolean)false);
            }
            catch (Exception ex) {
                Konstante.getPoruka3(this.shell, "Nema podataka");
            }
        }
    }
}

