/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.izvestaji.PodaciZaRealizaciju;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.ZD;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class Realizacija {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    SWTContainer parent;
    Shell shell;
    Composite composite;
    private boolean poPosUnetCenama = false;
    private boolean poPosCenamaKombo = false;
    List<StavkaRacuna> stavkeRacuna;
    Date day1;
    Date day2;

    private Realizacija(SWTContainer owner, Restoran r, Date date1, Date date2) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.shell = this.parent.getControl().getShell();
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout());
        Setting poPNC = this.server.getSetting(Option.PO_POSLEDNJIM_UNETIM_CENAMA);
        Setting poPNCKombo = this.server.getSetting(Option.PO_POSLEDNJIM_CENAMA_KOMBINOVANO);
        this.poPosUnetCenama = poPNC == null ? false : poPNC.booleanValue();
        this.poPosCenamaKombo = poPNCKombo == null ? false : poPNCKombo.booleanValue();
        this.day1 = date1;
        this.day2 = date2;
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.popuniRedove();
        Composite control = new Composite((Composite)this.shell, 0);
        control.setLayout((Layout)new GridLayout(7, false));
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        GridData gd = new GridData();
        gd.heightHint = 50;
        gd.widthHint = 150;
        GridData gd1 = new GridData();
        gd1.heightHint = 50;
        gd1.widthHint = 150;
        gd1.horizontalAlignment = 131072;
        gd1.grabExcessHorizontalSpace = true;
        Button printButton = new Button(control, 8);
        printButton.setImage(ImageCache.getImage("print.gif"));
        printButton.setText("Stampa");
        printButton.setLayoutData((Object)gd);
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(Realizacija.this.table), false, true, "Pregled racuna: " + Konstante.getDate(Realizacija.this.day1) + "-->" + Konstante.getDate(Realizacija.this.day2), Realizacija.this.shell, Realizacija.this.server);
            }
        });
        Button export = new Button(control, 8);
        export.setLayoutData((Object)gd);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(Realizacija.this.table, Realizacija.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        Button izlaz = new Button(control, 8);
        izlaz.setLayoutData((Object)gd1);
        izlaz.setText(String.format(Konstante.getBundle().getString("TEXT_ZATVORI"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Realizacija.this.shell.close();
            }
        });
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public void makeHeaders() {
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText(String.format(Konstante.getBundle().getString("TEXT_DATUM"), new Object[0]));
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(String.format(Konstante.getBundle().getString("TEXT_UKUPAN_PROMET"), new Object[0]));
        TableColumn tc16 = new TableColumn(this.table, 131072);
        tc16.setText(String.format(Konstante.getBundle().getString("TEXT_PROSECNA_VREDNOST_PO_RACUNU"), new Object[0]));
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText(String.format(Konstante.getBundle().getString("TEXT_VREDNOST_NABAVKE_ZA_OSTVARENI_PROMET"), new Object[0]));
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText(String.format(Konstante.getBundle().getString("TEXT_UKUPNA_NABAVKA_NA_DAN"), new Object[0]));
        TableColumn tc7 = new TableColumn(this.table, 131072);
        tc7.setText(String.format(Konstante.getBundle().getString("TEXT_OTPISI"), new Object[0]));
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText(String.format(Konstante.getBundle().getString("TEXT_TROSKOVI"), new Object[0]));
        TableColumn tc6 = new TableColumn(this.table, 131072);
        tc6.setText(String.format(Konstante.getBundle().getString("TEXT_TOTAL"), new Object[0]));
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(String.format(Konstante.getBundle().getString("TEXT_SG_POPUST"), new Object[0]));
    }

    public void popuniRedove() {
        Shell poruka1 = null;
        if (this.shell != null && !this.shell.isDisposed()) {
            poruka1 = Konstante.getPoruka2(this.shell, "Molim sacekajte...");
        }
        double prometZaZdBroj = 0.0;
        double brojRacunaZaZdBroj = 0.0;
        double prosecnaVrednostPoRacunu = 0.0;
        double nabavnaVrednostZaZdBroj = 0.0;
        double ukupanTrosakZaDatum = 0.0;
        double ukupnaNabavkaZaDatum = 0.0;
        double ukupanOtpisZaDatum = 0.0;
        double sgPopust = 0.0;
        double total = 0.0;
        double ukupanPromet = 0.0;
        double ukupnaProsecnaVrednostPoRacunu = 0.0;
        double ukupnaNabavnaVrednost = 0.0;
        double ukupanTrosak = 0.0;
        double ukupnaNabavka = 0.0;
        double ukupanOtpis = 0.0;
        double ukupanSgPopust = 0.0;
        double ukupanTotal = 0.0;
        PodaciZaRealizaciju podaci = new PodaciZaRealizaciju(this.server);
        List<ZD> zdDaniRealizacije = podaci.ZdDaniRealizacije(this.day1, this.day2);
        for (ZD zd : zdDaniRealizacije) {
            long zdBroj = zd.getZdBroj();
            Date datum = zd.getDatum();
            String datumText = Konstante.getDate(datum);
            prometZaZdBroj = podaci.ukupanPrometZaZdBroj(zdBroj);
            brojRacunaZaZdBroj = podaci.brojRacunaZaZdBroj(zdBroj);
            prosecnaVrednostPoRacunu = this.izracunajProsecnuVrednostPoRacunu(prometZaZdBroj, brojRacunaZaZdBroj);
            nabavnaVrednostZaZdBroj = podaci.nabavnaVrednostZaZdBroj(zdBroj, datum);
            ukupanTrosakZaDatum = podaci.ukupanTrosakZaDatum(datum);
            ukupnaNabavkaZaDatum = podaci.ukupnaNabavkaZaDatum(datum);
            ukupanOtpisZaDatum = podaci.vrednostOtpisa(datum);
            sgPopust = podaci.sgPopustZaZdBroj(zdBroj);
            total = prometZaZdBroj - nabavnaVrednostZaZdBroj - ukupanOtpisZaDatum - ukupanTrosakZaDatum;
            ukupanPromet += prometZaZdBroj;
            ukupnaProsecnaVrednostPoRacunu += prosecnaVrednostPoRacunu;
            ukupnaNabavnaVrednost += nabavnaVrednostZaZdBroj;
            ukupanTrosak += ukupanTrosakZaDatum;
            ukupnaNabavka += ukupnaNabavkaZaDatum;
            ukupanOtpis += ukupanOtpisZaDatum;
            ukupanSgPopust += sgPopust;
            ukupanTotal += total;
            String[] podaciZaRed = this.popuniRedPodacima(datumText, prometZaZdBroj, prosecnaVrednostPoRacunu, nabavnaVrednostZaZdBroj, ukupnaNabavkaZaDatum, ukupanTrosakZaDatum, ukupanOtpisZaDatum, total, sgPopust);
            this.napraviItem(this.table, podaciZaRed);
        }
        this.napraviPrazanItem(this.table);
        String[] podaciZaRedUkupno = this.popuniRedPodacima("Ukupno:", ukupanPromet, ukupnaProsecnaVrednostPoRacunu, ukupnaNabavnaVrednost, ukupnaNabavka, ukupanTrosak, ukupanOtpis, ukupanTotal, ukupanSgPopust);
        this.napraviItem(this.table, podaciZaRedUkupno);
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
        if (poruka1 != null) {
            poruka1.close();
        }
    }

    private double izracunajProsecnuVrednostPoRacunu(double prometZaZdBroj, double brojRacunaZaZdBroj) {
        return brojRacunaZaZdBroj == 0.0 ? 0.0 : prometZaZdBroj / brojRacunaZaZdBroj;
    }

    private String[] popuniRedPodacima(String datum, double promet, double prosecnaVrednostPoRacunu, double nabavnaVrednost, double ukupnaNabavka, double trosak, double otpis, double total, double sgPopust) {
        int brojKolona = this.table.getColumnCount();
        String[] redSaPodacima = new String[brojKolona];
        redSaPodacima[0] = datum;
        redSaPodacima[1] = Konstante.getNumber02(promet);
        redSaPodacima[2] = Konstante.getNumber02(prosecnaVrednostPoRacunu);
        redSaPodacima[3] = Konstante.getNumber02(nabavnaVrednost);
        redSaPodacima[4] = Konstante.getNumber02(ukupnaNabavka);
        redSaPodacima[5] = Konstante.getNumber02(otpis);
        redSaPodacima[6] = Konstante.getNumber02(trosak);
        redSaPodacima[7] = Konstante.getNumber02(total);
        redSaPodacima[8] = Konstante.getNumber02(sgPopust);
        return redSaPodacima;
    }

    private TableItem napraviItem(Table tabela, String[] podaci) {
        TableItem item = new TableItem(tabela, 0);
        item.setText(podaci);
        return item;
    }

    private TableItem napraviPrazanItem(Table tabela) {
        TableItem item = new TableItem(tabela, 0);
        return item;
    }

    public double getNabavnaCena(Artikal art, double kolicina) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this.server, null, null);
            for (Artikal a : mapa.keySet()) {
                trNv += (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBela(a, new Date())) : a.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(a.getPoreskaGrupa()))) * mapa.get(a);
            }
        } else {
            trNv = (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(art) : this.server.getLastNabavnaCenaBela(art, new Date())) : art.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(art.getPoreskaGrupa()))) * kolicina;
            trNv *= art.getMera().doubleValue();
        }
        return trNv;
    }

    public static class RealizacijaInput {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        SWTContainer parent;

        public RealizacijaInput(SWTContainer owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/prometV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_REALIZACIJA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText("Ekran za unos, pregled i ispravku.\n Za vise informacija kliknite na ikonicu tehnickog uputstva ->");
            Button uputstvo = new Button(panel1, 8);
            uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                Date d1 = this.odDatuma.getResult();
                Date d2 = this.doDatuma.getResult();
                this.server.log("Pregled realizacije: od datuma -> " + Konstante.getDate(d1) + " do datuma -> " + Konstante.getDate(d2));
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText("Pregled realizacije za period: " + Konstante.getDate(d1) + " -> " + Konstante.getDate(d2));
                SWTContainer parent2 = new SWTContainer((Composite)shell2);
                new Realizacija(parent2, this.restoran, d1, d2);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), "Greska", 2);
            }
        }
    }
}

