/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.GrupaArtikala;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.stampa.StampaPrometPoKonobaru;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PrometPoKonobarima2 {
    private static final ResourceBundle barmasterText = Konstante.getBundle();
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    Composite composite;
    List<PodgrupaArtikala> podgrupe = new ArrayList<PodgrupaArtikala>();
    List<GrupaArtikala> grupe = new ArrayList<GrupaArtikala>();
    List<String> crnaPlacanja;
    Map<PodgrupaArtikala, Double> mapaPG = new HashMap<PodgrupaArtikala, Double>();
    Map<GrupaArtikala, Double> mapaP = new HashMap<GrupaArtikala, Double>();
    Map<String, Integer> racuniBR = new HashMap<String, Integer>();
    Map<NacinPlacanja, Double> nacinP;
    Map<NacinPlacanja, Double> servisP = new HashMap<NacinPlacanja, Double>();
    Map<NacinPlacanja, Double> popustP = new HashMap<NacinPlacanja, Double>();
    Map<String, Double> nacinPCrno;
    Map<String, Double> servisPCrno = new HashMap<String, Double>();
    Map<String, Double> popustPCrno = new HashMap<String, Double>();
    boolean blic;
    private StalniGost sg;
    List<StavkaRacuna> stavke;
    List<StavkaRacuna> stavkePoSG;
    NacinPlacanja[] nacini;
    Date day1;
    Date day2;
    boolean crno = false;
    boolean kombPlacanje = false;
    Konobar konobar;
    List<StavkaRacuna> stavkeKonacno = new ArrayList<StavkaRacuna>();
    Odeljenje odeljenje;
    Button printButton4;
    Double medjuzbir = 0.0;
    Double stornoVred = 0.0;
    Integer stornoKol = 0;
    boolean prikaziStorno = false;
    private boolean fastfood;
    private boolean inspektor = false;

    public PrometPoKonobarima2(Shell s, Restoran re, final Date d1, final Date d2, Odeljenje od, Konobar k, boolean bl, List<NacinPlacanja> bela, List<String> cp, boolean prikaziStorno, boolean inspektor) {
        this.shell = new Shell(s, 34912);
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.prikaziStorno = prikaziStorno;
        this.inspektor = inspektor;
        this.fastfood = BMTerminalSettings.getSetting(OptionBO.FAST_FOOD).booleanValue();
        if (this.server.isEmptyDateZD(d1, d2) || this.server.isBeforeDateZD(d2)) {
            Konstante.getPoruka3(this.shell, String.format(barmasterText.getString("PORUKA_ZA_IZBRANI_PERIOD_NEMA_PODATAKA"), new Object[0]));
            return;
        }
        this.day1 = Konstante.getPocetniDatum(d1, this.server);
        this.day2 = Konstante.getKrajnjiDatum(d2, this.server);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(5, false));
        this.konobar = k;
        this.crnaPlacanja = cp;
        this.blic = bl;
        this.odeljenje = od;
        if (this.fastfood) {
            this.shell.setText(String.format(barmasterText.getString("TEXT_PROMET_POOPERATERU"), new Object[0]) + " " + k.getPunoime() + " " + String.format(barmasterText.getString("TEXT_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(d1) + " -> " + StatLogic.getDateString(d2));
        } else {
            this.shell.setText(String.format(barmasterText.getString("TEXT_PROMET_POKONOBARU"), new Object[0]) + " " + k.getPunoime() + " " + String.format(barmasterText.getString("TEXT_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(d1) + " -> " + StatLogic.getDateString(d2));
        }
        if (inspektor && this.crnaPlacanja.size() > 0) {
            this.crno = true;
        }
        this.racuniBR = new HashMap<String, Integer>();
        this.nacinP = new HashMap<NacinPlacanja, Double>();
        this.servisP = new HashMap<NacinPlacanja, Double>();
        this.popustP = new HashMap<NacinPlacanja, Double>();
        for (NacinPlacanja nacinPlacanja : bela) {
            this.racuniBR.put(nacinPlacanja.name(), 0);
            this.nacinP.put(nacinPlacanja, 0.0);
            this.servisP.put(nacinPlacanja, 0.0);
            this.popustP.put(nacinPlacanja, 0.0);
        }
        this.stavke = this.server.getSveStavke(this.day1, this.day2, od, k);
        this.sg = this.server.getStalniGostBySifra(k.getSifra());
        if (this.sg != null) {
            this.stavkePoSG = this.server.getSveStavkePoStalnomGostu(3L, 4L, od, k, this.sg);
        }
        if (this.crno) {
            block13: for (StavkaRacuna stavkaRacuna : this.stavke) {
                if (stavkaRacuna.getRacun() == null || stavkaRacuna.getRacun().getCrnoPlacanje() == null) continue;
                for (String st : this.crnaPlacanja) {
                    if (!st.equals(stavkaRacuna.getRacun().getCrnoPlacanje())) continue;
                    this.stavkeKonacno.add(stavkaRacuna);
                    continue block13;
                }
            }
            for (String string : this.crnaPlacanja) {
                this.racuniBR.put(string, 0);
            }
            this.nacinPCrno = this.makeMapCrno();
            this.servisPCrno = this.makeMapCrno();
            this.popustPCrno = this.makeMapCrno();
        }
        if (bela.size() > 0) {
            if (bela.size() < 4) {
                for (StavkaRacuna stavkaRacuna : this.stavke) {
                    if (stavkaRacuna.getRacun() == null || stavkaRacuna.getRacun().getPlacanja().size() >= 1) continue;
                    Konstante.getPoruka(this.shell, String.format(barmasterText.getString("PORUKA_ZBOG_KOMBINOVANOG_NACINA_NAPLATE_MORATE_IZABRATI_SVA_4_OSNOVNA_TIPA_NAPLATE"), new Object[0]));
                    return;
                }
            } else {
                for (StavkaRacuna stavkaRacuna : this.stavke) {
                    if (stavkaRacuna.getRacun() != null && stavkaRacuna.getRacun().getCrnoPlacanje() != null) continue;
                    this.stavkeKonacno.add(stavkaRacuna);
                }
            }
        }
        if (bela.size() > 0 && bela.size() < 4) {
            for (NacinPlacanja nacinPlacanja : bela) {
                for (StavkaRacuna sr : this.stavke) {
                    if (sr.getRacun() == null) {
                        this.stavkeKonacno.add(sr);
                        continue;
                    }
                    if (!this.getNacine(sr).contains((Object)nacinPlacanja)) continue;
                    this.stavkeKonacno.add(sr);
                }
            }
        }
        if (od != null) {
            for (StavkaRacuna stavkaRacuna : this.stavke) {
                if (stavkaRacuna.getRacun() == null || stavkaRacuna.getRacun().getPlacanja().size() <= 1) continue;
                this.kombPlacanje = true;
                break;
            }
        }
        this.racuniBR.put(String.format(barmasterText.getString("TEXT_KOMBINOVANO"), new Object[0]), 0);
        ArrayList<Racun> racuni = new ArrayList<Racun>();
        for (StavkaRacuna stavkaRacuna : this.stavkeKonacno) {
            if (!this.podgrupe.contains(stavkaRacuna.getArtikal().getPodgrupa())) {
                this.podgrupe.add(stavkaRacuna.getArtikal().getPodgrupa());
                this.mapaPG.put(stavkaRacuna.getArtikal().getPodgrupa(), 0.0);
            }
            if (od != null) continue;
            if (stavkaRacuna.getRacun() != null) {
                if (racuni.contains(stavkaRacuna.getRacun())) continue;
                racuni.add(stavkaRacuna.getRacun());
                continue;
            }
            this.medjuzbir = this.medjuzbir + stavkaRacuna.getVrednost();
        }
        if (!this.kombPlacanje) {
            if (od == null) {
                for (Racun racun : racuni) {
                    double d;
                    double op;
                    double srv;
                    if (!this.crno) {
                        srv = this.servisP.get((Object)racun.getPlacanja().get(0).getNacin());
                        this.servisP.put(racun.getPlacanja().get(0).getNacin(), racun.servis() + srv);
                        op = this.popustP.get((Object)racun.getPlacanja().get(0).getNacin());
                        this.popustP.put(racun.getPlacanja().get(0).getNacin(), racun.obracunatPopust() + op);
                        for (Placanje p : racun.getPlacanja()) {
                            d = this.nacinP.get((Object)p.getNacin());
                            this.nacinP.put(p.getNacin(), p.getIznos() + d);
                        }
                        continue;
                    }
                    if (racun.getCrnoPlacanje() != null) {
                        srv = this.servisPCrno.get(racun.getCrnoPlacanje());
                        this.servisPCrno.put(racun.getCrnoPlacanje(), srv + racun.servis());
                        op = this.popustPCrno.get(racun.getCrnoPlacanje());
                        this.popustPCrno.put(racun.getCrnoPlacanje(), op + racun.obracunatPopust());
                        try {
                            double d3 = this.nacinPCrno.get(racun.getCrnoPlacanje());
                            this.nacinPCrno.put(racun.getCrnoPlacanje(), d3 + racun.total());
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    srv = this.servisP.get((Object)racun.getPlacanja().get(0).getNacin());
                    this.servisP.put(racun.getPlacanja().get(0).getNacin(), racun.servis() + srv);
                    op = this.popustP.get((Object)racun.getPlacanja().get(0).getNacin());
                    this.popustP.put(racun.getPlacanja().get(0).getNacin(), racun.obracunatPopust() + op);
                    for (Placanje p : racun.getPlacanja()) {
                        d = this.nacinP.get((Object)p.getNacin());
                        this.nacinP.put(p.getNacin(), p.getIznos() + d);
                    }
                }
            } else {
                for (StavkaRacuna stavkaRacuna : this.stavkeKonacno) {
                    double d;
                    if (stavkaRacuna.getRacun() == null) continue;
                    if (!this.crno) {
                        for (Placanje p : stavkaRacuna.getRacun().getPlacanja()) {
                            d = this.nacinP.get((Object)p.getNacin());
                            this.nacinP.put(p.getNacin(), stavkaRacuna.getVrednost() + d);
                        }
                        continue;
                    }
                    if (stavkaRacuna.getRacun().getCrnoPlacanje() != null) {
                        try {
                            double d4 = this.nacinPCrno.get(stavkaRacuna.getRacun().getCrnoPlacanje());
                            this.nacinPCrno.put(stavkaRacuna.getRacun().getCrnoPlacanje(), d4 + stavkaRacuna.getVrednost());
                        }
                        catch (Exception d4) {}
                        continue;
                    }
                    for (Placanje p : stavkaRacuna.getRacun().getPlacanja()) {
                        d = this.nacinP.get((Object)p.getNacin());
                        this.nacinP.put(p.getNacin(), stavkaRacuna.getVrednost() + d);
                    }
                }
            }
        }
        for (Racun racun : racuni) {
            if (racun.getCrnoPlacanje() == null) {
                if (racun.getPlacanja().size() > 1) {
                    this.racuniBR.put(String.format(barmasterText.getString("TEXT_KOMBINOVANO"), new Object[0]), this.racuniBR.get(String.format(barmasterText.getString("TEXT_KOMBINOVANO"), new Object[0])) + 1);
                    continue;
                }
                if (racun.getPlacanja().size() != 1) continue;
                this.racuniBR.put(racun.getPlacanja().get(0).getNacin().name(), this.racuniBR.get(racun.getPlacanja().get(0).getNacin().name()) + 1);
                continue;
            }
            this.racuniBR.put(racun.getCrnoPlacanje(), this.racuniBR.get(racun.getCrnoPlacanje()) + 1);
        }
        for (PodgrupaArtikala podgrupaArtikala : this.podgrupe) {
            if (this.grupe.contains(podgrupaArtikala.getGrupa())) continue;
            this.grupe.add(podgrupaArtikala.getGrupa());
            this.mapaP.put(podgrupaArtikala.getGrupa(), 0.0);
        }
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 200;
        gridData.horizontalSpan = 5;
        this.table.setLayoutData((Object)gridData);
        this.makeHeaders();
        this.insertRows();
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
        GridData gridData2 = new GridData();
        gridData2.heightHint = 50;
        gridData2.widthHint = 150;
        gridData2.horizontalAlignment = 16384;
        Button button = new Button((Composite)this.shell, 8);
        try {
            button.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception d4) {
            // empty catch block
        }
        button.setText(String.format(barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        button.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PrometPoKonobarima2.this.medjuzbir > 0.0) {
                    Konstante.getPoruka(PrometPoKonobarima2.this.shell, String.format(barmasterText.getString("PORUKA_PRE_STAMPE_MORATE_ZAKLJUCITI_SVE_STOLOVE"), new Object[0]));
                    return;
                }
                GridPrinter gp = new GridPrinter(new PrintHandler());
                if (PrometPoKonobarima2.this.fastfood) {
                    gp.printTable(new TableWrapper(PrometPoKonobarima2.this.table), false, true, String.format(barmasterText.getString("TEXT_PROMET_POOPERATERU"), new Object[0]) + " " + PrometPoKonobarima2.this.konobar.getPunoime() + " " + String.format(barmasterText.getString("TEXT_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(d1) + " -> " + StatLogic.getDateString(d2), PrometPoKonobarima2.this.shell, PrometPoKonobarima2.this.server);
                } else {
                    gp.printTable(new TableWrapper(PrometPoKonobarima2.this.table), false, true, String.format(barmasterText.getString("TEXT_PROMET_PO_KONOBARU"), new Object[0]) + " " + PrometPoKonobarima2.this.konobar.getPunoime() + " " + String.format(barmasterText.getString("TEXT_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(d1) + " -> " + StatLogic.getDateString(d2), PrometPoKonobarima2.this.shell, PrometPoKonobarima2.this.server);
                }
            }
        });
        button.setLayoutData((Object)gridData2);
        Button printButton2 = new Button((Composite)this.shell, 8);
        try {
            printButton2.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception p) {
            // empty catch block
        }
        printButton2.setText(String.format(barmasterText.getString("TEXT_USKA_STAMPA"), new Object[0]));
        printButton2.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PrometPoKonobarima2.this.medjuzbir > 0.0) {
                    Konstante.getPoruka(PrometPoKonobarima2.this.shell, String.format(barmasterText.getString("PORUKA_PRE_STAMPE_MORATE_ZAKLJUCITI_SVE_STOLOVE"), new Object[0]));
                    return;
                }
                new StampaPrometPoKonobaru(PrometPoKonobarima2.this.stavkeKonacno, PrometPoKonobarima2.this.stavkePoSG, PrometPoKonobarima2.this.restoran, PrometPoKonobarima2.this.podgrupe, PrometPoKonobarima2.this.grupe, PrometPoKonobarima2.this.mapaPG, PrometPoKonobarima2.this.mapaP, PrometPoKonobarima2.this.nacinP, PrometPoKonobarima2.this.nacinPCrno, PrometPoKonobarima2.this.racuniBR, false, PrometPoKonobarima2.this.day1, PrometPoKonobarima2.this.day2, PrometPoKonobarima2.this.crno, PrometPoKonobarima2.this.kombPlacanje, PrometPoKonobarima2.this.odeljenje, PrometPoKonobarima2.this.konobar, PrometPoKonobarima2.this.medjuzbir, PrometPoKonobarima2.this.stornoVred, PrometPoKonobarima2.this.stornoKol);
            }
        });
        printButton2.setLayoutData((Object)gridData2);
        this.printButton4 = new Button((Composite)this.shell, 8);
        try {
            this.printButton4.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception p) {
            // empty catch block
        }
        this.printButton4.setText(String.format(barmasterText.getString("TEXT_BLIC"), new Object[0]));
        this.printButton4.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PrometPoKonobarima2.this.medjuzbir > 0.0) {
                    Konstante.getPoruka(PrometPoKonobarima2.this.shell, String.format(barmasterText.getString("PORUKA_PRE_STAMPE_MORATE_ZAKLJUCITI_SVE_STOLOVE"), new Object[0]));
                    return;
                }
                new StampaPrometPoKonobaru(PrometPoKonobarima2.this.stavkeKonacno, PrometPoKonobarima2.this.stavkePoSG, PrometPoKonobarima2.this.restoran, PrometPoKonobarima2.this.podgrupe, PrometPoKonobarima2.this.grupe, PrometPoKonobarima2.this.mapaPG, PrometPoKonobarima2.this.mapaP, PrometPoKonobarima2.this.nacinP, PrometPoKonobarima2.this.nacinPCrno, PrometPoKonobarima2.this.racuniBR, true, PrometPoKonobarima2.this.day1, PrometPoKonobarima2.this.day2, PrometPoKonobarima2.this.crno, PrometPoKonobarima2.this.kombPlacanje, PrometPoKonobarima2.this.odeljenje, PrometPoKonobarima2.this.konobar, PrometPoKonobarima2.this.medjuzbir, PrometPoKonobarima2.this.stornoVred, PrometPoKonobarima2.this.stornoKol);
            }
        });
        this.printButton4.setLayoutData((Object)gridData2);
        Button export = new Button((Composite)this.shell, 8);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception tc) {
            // empty catch block
        }
        export.setText(String.format(barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PrometPoKonobarima2.this.table, PrometPoKonobarima2.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)gridData2);
        Button izlaz = new Button((Composite)this.shell, 8);
        izlaz.setText(String.format(barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PrometPoKonobarima2.this.shell.close();
            }
        });
        GridData gridData3 = new GridData();
        gridData3.heightHint = 50;
        gridData3.widthHint = 150;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)gridData3);
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void makeHeaders() {
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(String.format(barmasterText.getString("TEXT_PODGRUPA"), new Object[0]));
        tc4.setWidth(200);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText(String.format(barmasterText.getString("TEXT_ARTIKAL"), new Object[0]));
        tc1.setWidth(170);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(String.format(barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
        tc2.pack();
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText(String.format(barmasterText.getString("TEXT_CENA_KOMAD_SKR"), new Object[0]));
        tc9.setWidth(100);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText(String.format(barmasterText.getString("TEXT_VREDNOST"), new Object[0]));
        tc3.setWidth(120);
        tc3.pack();
    }

    public void insertRows() {
        TableItem ti;
        for (PodgrupaArtikala podgrupaArtikala : this.podgrupe) {
            if (!this.blic) {
                ti = new TableItem(this.table, 0);
                ti.setText(0, podgrupaArtikala.getNaziv());
                ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
            }
            for (StavkaRacuna stavkaRacuna : StavkeSumarno.getSumarnoPopust(this.stavkeKonacno)) {
                if (!stavkaRacuna.getArtikal().getPodgrupa().equals(podgrupaArtikala)) continue;
                double kol = stavkaRacuna.getKolicina();
                double cena = stavkaRacuna.getCena();
                if (!this.blic) {
                    TableItem ti2 = new TableItem(this.table, 0);
                    ti2.setText(new String[]{"", stavkaRacuna.getArtikal().getName().replace("1L", "1l"), StatLogic.getNumber02NG(kol), StatLogic.getNumber02NG(cena), StatLogic.getNumber02NG(kol * cena)});
                }
                double d = this.mapaPG.get(podgrupaArtikala);
                this.mapaPG.put(podgrupaArtikala, d += kol * cena);
            }
            if (this.blic) continue;
            ti = new TableItem(this.table, 0);
            ti.setText(3, String.format(barmasterText.getString("TEXT_UKUPNO"), new Object[0]).toUpperCase() + ":");
            ti.setText(4, StatLogic.getNumber02NG(this.mapaPG.get(podgrupaArtikala)));
            ti = new TableItem(this.table, 0);
        }
        for (PodgrupaArtikala podgrupaArtikala : this.podgrupe) {
            if (this.blic) continue;
            ti = new TableItem(this.table, 0);
            ti.setText(0, podgrupaArtikala.getNaziv());
            ti.setText(4, StatLogic.getNumber02NG(this.mapaPG.get(podgrupaArtikala)));
        }
        TableItem ti3 = new TableItem(this.table, 0);
        for (GrupaArtikala g : this.grupe) {
            for (PodgrupaArtikala pg : this.podgrupe) {
                if (!pg.getGrupa().equals(g)) continue;
                double d = this.mapaP.get(g);
                this.mapaP.put(g, d += this.mapaPG.get(pg).doubleValue());
            }
            ti3 = new TableItem(this.table, 0);
            ti3.setText(0, g.getNaziv());
            ti3.setText(4, StatLogic.getNumber02NG(this.mapaP.get(g)));
        }
        ti3 = new TableItem(this.table, 0);
        if (!this.kombPlacanje) {
            double d = 0.0;
            double d2 = 0.0;
            double ppst = 0.0;
            ti3 = new TableItem(this.table, 0);
            ti3.setText(new String[]{String.format(barmasterText.getString("TEXT_NACIN_PLACANJA"), new Object[0]), String.format(barmasterText.getString("TEXT_NETO"), new Object[0]), String.format(barmasterText.getString("TEXT_POPUST"), new Object[0]), String.format(barmasterText.getString("TEXT_SERVIS"), new Object[0]), String.format(barmasterText.getString("TEXT_BRUTO"), new Object[0])});
            for (NacinPlacanja nacinPlacanja : NacinPlacanja.values()) {
                if (!this.nacinP.containsKey((Object)nacinPlacanja)) continue;
                ti3 = new TableItem(this.table, 0);
                ti3.setText(0, nacinPlacanja.getOpis());
                ti3.setText(1, StatLogic.getNumber02NG(this.nacinP.get((Object)nacinPlacanja) - this.servisP.get((Object)nacinPlacanja) + this.popustP.get((Object)nacinPlacanja)));
                ti3.setText(2, StatLogic.getNumber02NG(this.popustP.get((Object)nacinPlacanja)));
                ti3.setText(3, StatLogic.getNumber02NG(this.servisP.get((Object)nacinPlacanja)));
                ti3.setText(4, StatLogic.getNumber02NG(this.nacinP.get((Object)nacinPlacanja)));
                d += this.nacinP.get((Object)nacinPlacanja).doubleValue();
                d2 += this.servisP.get((Object)nacinPlacanja).doubleValue();
                ppst += this.popustP.get((Object)nacinPlacanja).doubleValue();
            }
            if (this.crno) {
                for (String cp : this.crnaPlacanja) {
                    if (!this.nacinPCrno.containsKey(cp)) continue;
                    ti3 = new TableItem(this.table, 0);
                    ti3.setText(0, cp);
                    ti3.setText(1, StatLogic.getNumber02NG(this.nacinPCrno.get(cp) - this.servisPCrno.get(cp) + this.popustPCrno.get(cp)));
                    ti3.setText(2, StatLogic.getNumber02NG(this.popustPCrno.get(cp)));
                    ti3.setText(3, StatLogic.getNumber02NG(this.servisPCrno.get(cp)));
                    ti3.setText(4, StatLogic.getNumber02NG(this.nacinPCrno.get(cp)));
                    d += this.nacinPCrno.get(cp).doubleValue();
                    d2 += this.servisPCrno.get(cp).doubleValue();
                    ppst += this.popustPCrno.get(cp).doubleValue();
                }
            }
            if (this.medjuzbir > 0.0) {
                ti3 = new TableItem(this.table, 0);
                ti3.setText(0, String.format(barmasterText.getString("TEXT_NENAPLACENO"), new Object[0]));
                ti3.setText(4, Konstante.getNumber2(this.medjuzbir));
                d += this.medjuzbir.doubleValue();
            }
            ti3 = new TableItem(this.table, 0);
            ti3 = new TableItem(this.table, 0);
            ti3.setText(0, String.format(barmasterText.getString("TEXT_UKUPNO"), new Object[0]));
            ti3.setText(1, Konstante.getNumber2(d - d2 + ppst));
            ti3.setText(2, Konstante.getNumber2(ppst));
            ti3.setText(3, Konstante.getNumber2(d2));
            ti3.setText(4, Konstante.getNumber2(d));
            HashMap<String, Integer> mapaBR = new HashMap<String, Integer>(this.racuniBR);
            ti3 = new TableItem(this.table, 0);
            ti3 = new TableItem(this.table, 0);
            ti3.setText(0, String.format(barmasterText.getString("TEXT_NACIN_PLACANJA"), new Object[0]));
            ti3.setText(1, String.format(barmasterText.getString("TEXT_KOLICINA_RACUNA"), new Object[0]));
            int ukupnoRacuna = 0;
            for (NacinPlacanja np : NacinPlacanja.values()) {
                if (!mapaBR.containsKey(np.name())) continue;
                ti3 = new TableItem(this.table, 0);
                ti3.setText(0, np.name());
                ti3.setText(1, ((Integer)mapaBR.get(np.name())).toString());
                ukupnoRacuna += ((Integer)mapaBR.get(np.name())).intValue();
                mapaBR.remove(np.name());
            }
            for (String string : this.crnaPlacanja) {
                if (!mapaBR.containsKey(string)) continue;
                ti3 = new TableItem(this.table, 0);
                ti3.setText(0, string);
                ti3.setText(1, ((Integer)mapaBR.get(string)).toString());
                ukupnoRacuna += ((Integer)mapaBR.get(string)).intValue();
                mapaBR.remove(string);
            }
            for (Map.Entry entry : mapaBR.entrySet()) {
                String naziv = (String)entry.getKey();
                Integer brojRacuna = (Integer)entry.getValue();
                ti3 = new TableItem(this.table, 0);
                ti3.setText(0, naziv);
                ti3.setText(1, brojRacuna.toString());
                ukupnoRacuna += ((Integer)mapaBR.get(naziv)).intValue();
                mapaBR.remove(naziv);
            }
            ti3 = new TableItem(this.table, 0);
            ti3 = new TableItem(this.table, 0);
            ti3.setText(0, String.format(barmasterText.getString("TEXT_UKUPNO_RACUNA"), new Object[0]));
            ti3.setText(1, "" + ukupnoRacuna);
        }
        if (this.prikaziStorno) {
            ti3 = new TableItem(this.table, 0);
            ti3 = new TableItem(this.table, 0);
            ti3.setText(0, String.format(barmasterText.getString("TEXT_UKUPNO_STORNO"), new Object[0]));
            this.stornoVred = this.server.getStornoSum(this.day1, this.day2, this.konobar);
            ti3.setText(1, "" + Konstante.getNumber2(this.stornoVred));
            ti3 = new TableItem(this.table, 0);
            ti3.setText(0, String.format(barmasterText.getString("TEXT_BROJ_STORNA"), new Object[0]));
            this.stornoKol = this.server.getStornoCount(this.day1, this.day2, this.konobar);
            ti3.setText(1, "" + this.stornoKol);
        }
        if (this.stavkePoSG != null && !this.stavkePoSG.isEmpty()) {
            ti3 = new TableItem(this.table, 0);
            ti3 = new TableItem(this.table, 0);
            double d = 0.0;
            double d3 = 0.0;
            for (StavkaRacuna sr : this.stavkePoSG) {
                d += sr.getArtikal().getCena() * sr.getKolicina();
                d3 += sr.getCena() * sr.getKolicina();
            }
            ti3 = new TableItem(this.table, 0);
            ti3 = new TableItem(this.table, 0);
            ti3.setText(new String[]{"Promet po stalnom gostu: ", this.sg.getNaziv()});
            ti3 = new TableItem(this.table, 0);
            ti3.setText(0, "Ukupno: ");
            ti3.setText(1, String.valueOf(d));
            ti3 = new TableItem(this.table, 0);
            ti3.setText(0, "Popust: ");
            ti3.setText(1, String.valueOf(this.sg.getPopust()) + "%");
            ti3 = new TableItem(this.table, 0);
            ti3.setText(0, "Ukupno Sa Popustom: ");
            ti3.setText(1, String.valueOf(d3));
            ti3 = new TableItem(this.table, 0);
            ti3.setText(0, "Ostvareni popust: ");
            ti3.setFont(new Font((Device)this.shell.getDisplay(), "", 10, 3));
            ti3.setText(1, String.valueOf(d - d3));
        }
    }

    private Map makeMapCrno() {
        HashMap<String, Double> mapa = new HashMap<String, Double>();
        for (String cp : this.crnaPlacanja) {
            mapa.put(cp, 0.0);
        }
        return mapa;
    }

    private List<NacinPlacanja> getNacine(StavkaRacuna sr) {
        ArrayList<NacinPlacanja> n = new ArrayList<NacinPlacanja>();
        if (sr.getRacun() != null) {
            for (Placanje p : sr.getRacun().getPlacanja()) {
                n.add(p.getNacin());
            }
        }
        return n;
    }

    public static class PrometPoKonobarimaInput2 {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo odeljenje;
        private Combo konobar;
        private Button blic;
        Date day1;
        Date day2;
        Odeljenje o;
        Konobar k;
        List<Odeljenje> odeljenja;
        List<Konobar> konobari;
        SWTContainer parent;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();
        private Shell shell;
        private Button bStorno;
        private boolean inspektor = false;

        public PrometPoKonobarimaInput2(SWTContainer owner, Restoran r, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.inspektor = inspektor;
            this.odeljenja = this.server.readOdeljenjeBezMag();
            for (Odeljenje od : this.odeljenja) {
                od.setArtikli(od.getArtikli());
            }
            this.konobari = this.server.readKonobar();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)this.shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)this.shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(barmasterText.getString("TEXT_PROMET_PO_KONOBARIMA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 110;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 80;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(8, false));
            grupa21.setText(String.format(barmasterText.getString("TEXT_FILTER_NACINA_PLACANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            this.odDatuma.getControl().addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        konobar.removeAll();
                        konobari = server.readKonobarRacun(odDatuma.getResult(), doDatuma.getResult());
                        for (Konobar ko : konobari) {
                            konobar.add(ko.getPunoime());
                        }
                        konobar.select(0);
                    }
                    catch (InputException e1) {
                        e1.printStackTrace();
                    }
                }
            });
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        konobar.removeAll();
                        konobari = server.readKonobarRacun(odDatuma.getResult(), doDatuma.getResult());
                        for (Konobar ko : konobari) {
                            konobar.add(ko.getPunoime());
                        }
                        konobar.select(0);
                    }
                    catch (InputException e1) {
                        e1.printStackTrace();
                    }
                }
            });
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, this.shell));
            Label art = new Label((Composite)grupa2, 0);
            art.setText(String.format(barmasterText.getString("TEXT_ODELJENJE"), new Object[0]) + ":");
            this.odeljenje = new Combo((Composite)grupa2, 8);
            this.odeljenje.add(String.format(barmasterText.getString("TEXT_SVA_PROIZVODNA_MESTA"), new Object[0]));
            for (Odeljenje odeljenje : this.odeljenja) {
                this.odeljenje.add(odeljenje.getNaziv());
            }
            this.odeljenje.select(0);
            Label kon = new Label((Composite)grupa2, 0);
            kon.setText(String.format(barmasterText.getString("TEXT_KONOBAR"), new Object[0]) + ":");
            this.konobar = new Combo((Composite)grupa2, 8);
            for (Konobar ko : this.konobari) {
                this.konobar.add(ko.getPunoime());
            }
            this.konobar.select(0);
            Label label = new Label((Composite)grupa2, 0);
            label.setText(String.format(barmasterText.getString("TEXT_SINTETIKA"), new Object[0]) + ":");
            this.blic = new Button((Composite)grupa2, 32);
            for (int i = 0; i < NacinPlacanja.values().length; ++i) {
                Button b = new Button((Composite)grupa21, 32);
                b.setText(NacinPlacanja.values()[i].getOpis());
                b.setSelection(true);
                this.belaDugmici.add(b);
            }
            if (inspektor) {
                for (CrnoPlacanje cp : this.server.readCrnaPlacanjaIzvestaji()) {
                    Button b = new Button((Composite)grupa21, 32);
                    b.setText(cp.getNaziv());
                    if (cp.getNaziv().equals("Medjuzbir")) {
                        b.setSelection(true);
                        b.setEnabled(false);
                    }
                    this.crnaDugmici.add(b);
                }
            }
            this.bStorno = new Button((Composite)grupa21, 32);
            this.bStorno.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_STORNIRANO"));
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            label.setLayoutData((Object)data);
            this.blic.setLayoutData((Object)data);
            this.konobar.setLayoutData((Object)data);
            this.odeljenje.setLayoutData((Object)data);
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                this.o = this.odeljenje.getSelectionIndex() == 0 ? null : this.odeljenja.get(this.odeljenje.getSelectionIndex() - 1);
                this.k = this.konobari.get(this.konobar.getSelectionIndex());
                ArrayList<NacinPlacanja> bela = new ArrayList<NacinPlacanja>();
                for (int i = 0; i < this.belaDugmici.size(); ++i) {
                    Button b = this.belaDugmici.get(i);
                    if (!b.getSelection()) continue;
                    bela.add(NacinPlacanja.values()[i]);
                }
                ArrayList<String> crna = new ArrayList<String>();
                for (Button b : this.crnaDugmici) {
                    if (!b.getSelection()) continue;
                    crna.add(b.getText());
                }
                this.server.log(String.format(barmasterText.getString("TEXT_PREGLED_PROMETA_PO_KONOBARIMA"), new Object[0]) + ": " + String.format(barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + " -> " + this.day1 + " " + String.format(barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + " -> " + this.day2);
                new PrometPoKonobarima2(this.shell, this.restoran, this.day1, this.day2, this.o, this.k, this.blic.getSelection(), bela, crna, this.bStorno != null && this.bStorno.getSelection(), this.inspektor);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

