/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.GrupaArtikala;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.ProdajnoMesto;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.parts.XMLWriterHCP;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.IzborPodgrua2;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.stampa.StampaPrometPoArtiklimaBlicArtikliNovi;
import com.dev63.restoran.stampa.StampaPrometPoArtiklimaNovi;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import com.dev63.restoran.swt.components.TimeInput2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PrometPoArtiklimaPoSatima {
    private final ResourceBundle barmasterText = Konstante.getBundle();
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    boolean sifre;
    List<Map<String, Object>> ppaArtData;
    List<Map<String, Object>> ppaFinanceData;
    boolean okidac = false;

    public PrometPoArtiklimaPoSatima(Shell s, Restoran re, final Date d1, final Date d2, Odeljenje od, boolean bl, boolean nc, List<NacinPlacanja> bela, final List<CrnoPlacanje> cp, List<PodgrupaArtikala> pgs, int tpg, List<Kasa> kase, boolean mz) {
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.server.refresh();
        this.shell = new Shell(s, 34912);
        this.ppaArtData = new LinkedList<Map<String, Object>>();
        this.ppaFinanceData = new LinkedList<Map<String, Object>>();
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_PROMET_PO_ARTIKLIMA_I_PO_SATIMA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(d1) + " -> " + StatLogic.getDateString(d2));
        if (this.server.isBeforeDateZD(d2)) {
            Konstante.getPoruka3(this.shell, String.format(this.barmasterText.getString("PORUKA_ZA_IZBRANI_PERIOD_NEMA_PODATAKA"), new Object[0]));
            return;
        }
        try {
            this.sifre = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
        }
        catch (Exception e) {
            this.sifre = false;
        }
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(7, false));
        if (!bela.isEmpty() && bela.size() < NacinPlacanja.values().length) {
            try {
                if (this.server.hasCombinedPayments(d1, d2)) {
                    SWTMessage.showLocalizedMessageDialog(this.shell, this.barmasterText.getString("PORUKA_ZBOG_KOMBINOVANOG_NACINA_NAPLATE_MORATE_DA_IZABERETE_SVA_4_OSNOVNA_TIPA_NAPLATE"));
                    return;
                }
            }
            catch (Exception ex) {
                Logger.getLogger(PrometPoArtiklimaPoSatima.class.getName()).log(Level.SEVERE, null, ex);
                SWTMessage.showLocalizedWarningDialog(this.shell, Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_PROVERE_KOMBINOVANE_NAPLATE"));
            }
        }
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 7;
        this.table.setLayoutData((Object)data);
        this.makeHeaders(nc);
        try {
            this.insertRows(bl, bela, cp, d1, d2, od != null ? Arrays.asList(od) : this.server.readOdeljenjeBezMag(), kase, pgs == null ? this.server.readPodgrupeArtikala() : pgs, nc, this.sifre, mz);
        }
        catch (Exception ex) {
            Logger.getLogger(PrometPoArtiklimaPoSatima.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 120;
        data.horizontalAlignment = 16384;
        Button printButton = new Button((Composite)this.shell, 72);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_A4"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PrometPoArtiklimaPoSatima.this.table), false, true, String.format(PrometPoArtiklimaPoSatima.this.barmasterText.getString("TEXT_PROMET_PO_ARTIKLIMA"), new Object[0]) + ": " + StatLogic.getDateString(d1) + "-->" + StatLogic.getDateString(d2), PrometPoArtiklimaPoSatima.this.shell, PrometPoArtiklimaPoSatima.this.server);
            }
        });
        printButton.setLayoutData((Object)data);
        Button printButton2 = new Button((Composite)this.shell, 72);
        try {
            printButton2.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton2.setText(String.format(this.barmasterText.getString("TEXT_USKA_STAMPA"), new Object[0]));
        printButton2.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    new StampaPrometPoArtiklimaNovi(PrometPoArtiklimaPoSatima.this.ppaArtData, PrometPoArtiklimaPoSatima.this.ppaFinanceData, cp, d1, d2, PrometPoArtiklimaPoSatima.this.server.readIzvestajiStampacObject(), PrometPoArtiklimaPoSatima.this.sifre, PrometPoArtiklimaPoSatima.this.server);
                }
                catch (Exception ex) {
                    Logger.getLogger(PrometPoArtiklimaPoSatima.class.getName()).log(Level.SEVERE, null, ex);
                    SWTMessage.showLocalizedWarningDialog(PrometPoArtiklimaPoSatima.this.shell, String.format(Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STAMPANJA_PROMETA_PO_ARTIKLIMA"), new Object[0]));
                }
            }
        });
        printButton2.setLayoutData((Object)data);
        printButton2.setEnabled(!bl);
        Button printButton3 = new Button((Composite)this.shell, 72);
        try {
            printButton3.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception tc) {
            // empty catch block
        }
        printButton3.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_FP"), new Object[0]));
        printButton3.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    PrometPoArtiklimaPoSatima.this.server.log(String.format(PrometPoArtiklimaPoSatima.this.barmasterText.getString("LOG_ARTIKLI_PRODATI_U_DANU"), new Object[0]));
                    if (Konstante.getTipStampaca() == 1) {
                        XMLWriter.writeReport(2);
                    } else {
                        XMLWriterHCP.writeProdatiArtikli();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        printButton3.setLayoutData((Object)data);
        Button printButton4 = new Button((Composite)this.shell, 72);
        try {
            printButton4.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton4.setText(String.format(this.barmasterText.getString("TEXT_BLIC"), new Object[0]));
        printButton4.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    new StampaPrometPoArtiklimaNovi(null, PrometPoArtiklimaPoSatima.this.ppaFinanceData, cp, d1, d2, PrometPoArtiklimaPoSatima.this.server.readIzvestajiStampacObject(), PrometPoArtiklimaPoSatima.this.sifre, PrometPoArtiklimaPoSatima.this.server);
                }
                catch (Exception ex) {
                    Logger.getLogger(PrometPoArtiklimaPoSatima.class.getName()).log(Level.SEVERE, null, ex);
                    SWTMessage.showLocalizedWarningDialog(PrometPoArtiklimaPoSatima.this.shell, String.format(Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STAMPANJA_PROMETA_PO_ARTIKLIMA"), new Object[0]));
                }
            }
        });
        printButton4.setLayoutData((Object)data);
        Button printU = new Button((Composite)this.shell, 72);
        try {
            printU.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printU.setText(String.format(this.barmasterText.getString("TEXT_BLIC_ARTIKLI"), new Object[0]));
        printU.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    new StampaPrometPoArtiklimaBlicArtikliNovi(PrometPoArtiklimaPoSatima.this.ppaArtData, d1, d2, PrometPoArtiklimaPoSatima.this.server.readIzvestajiStampacObject(), PrometPoArtiklimaPoSatima.this.server);
                }
                catch (Exception ex) {
                    Logger.getLogger(PrometPoArtiklimaPoSatima.class.getName()).log(Level.SEVERE, null, ex);
                    SWTMessage.showLocalizedWarningDialog(PrometPoArtiklimaPoSatima.this.shell, String.format(Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STAMPANJA_PROMETA_PO_ARTIKLIMA"), new Object[0]));
                }
            }
        });
        printU.setLayoutData((Object)data);
        Button export = new Button((Composite)this.shell, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PrometPoArtiklimaPoSatima.this.table, PrometPoArtiklimaPoSatima.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)data);
        Button izlaz = new Button((Composite)this.shell, 72);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PrometPoArtiklimaPoSatima.this.shell.close();
            }
        });
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        this.shell.setMaximized(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void makeHeaders(boolean nabavne) {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setText(String.format(this.barmasterText.getString("TEXT_SAT_OD"), new Object[0]) + "-" + String.format(this.barmasterText.getString("TEXT_DO"), new Object[0]));
        tc0.setWidth(250);
        if (this.sifre) {
            TableColumn tc1 = new TableColumn(this.table, 131072);
            tc1.setText(String.format(this.barmasterText.getString("TEXT_SIFRA"), new Object[0]));
            tc1.setWidth(200);
        }
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]));
        tc2.setWidth(250);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText(String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
        tc3.setWidth(75);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(String.format(this.barmasterText.getString("TEXT_CENA_KOMAD_SKR"), new Object[0]));
        tc4.setWidth(75);
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText(String.format(this.barmasterText.getString("TEXT_VREDNOST"), new Object[0]));
        tc5.setWidth(100);
        TableColumn tcv = new TableColumn(this.table, 131072);
        tcv.setText(String.format(this.barmasterText.getString("TEXT_BROJ_RACUNA"), new Object[0]));
        tcv.setWidth(100);
        TableColumn tcvp = new TableColumn(this.table, 131072);
        tcvp.setText(String.format(this.barmasterText.getString("TEXT_PROSECNA_VREDNOST"), new Object[0]));
        tcvp.setWidth(100);
        if (nabavne) {
            TableColumn tc6 = new TableColumn(this.table, 131072);
            tc6.setText(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_CENA_SKR"), new Object[0]));
            tc6.setWidth(75);
            TableColumn tc7 = new TableColumn(this.table, 131072);
            tc7.setText(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_VREDNOST_SKR"), new Object[0]));
            tc7.setWidth(100);
            TableColumn tc8 = new TableColumn(this.table, 131072);
            tc8.setText(String.format(Konstante.getBundle().getString("TEXT_RAZLIKA"), new Object[0]));
            tc8.setWidth(100);
        }
    }

    private void loadData(boolean bltz, List<NacinPlacanja> belaPlacanja, List<CrnoPlacanje> cp, Date from, Date to, List<Odeljenje> odeljenja, List<Kasa> kase, List<PodgrupaArtikala> podgrupe, List<Map<String, Object>> ppaArtData, List<Map<String, Object>> ppaFinanceData, RestoranServer server, boolean codes, boolean subtotal) throws Exception {
        EnumSet<NacinPlacanja> bp;
        if (ppaArtData == null) {
            throw new NullPointerException("ppaArtData argument is null");
        }
        if (ppaFinanceData == null) {
            throw new NullPointerException("ppaFinanceData argument is null");
        }
        if (server == null) {
            throw new NullPointerException("server argument is null");
        }
        ppaArtData.clear();
        ppaFinanceData.clear();
        EnumSet<NacinPlacanja> enumSet = bp = belaPlacanja.isEmpty() ? EnumSet.noneOf(NacinPlacanja.class) : EnumSet.copyOf(belaPlacanja);
        if (!bltz) {
            server.getNewRevenueByArticlesArticleDataPoSatima(bp, cp, from, to, odeljenja, kase, podgrupe, ppaArtData, codes, subtotal);
        }
    }

    private void insertSubGroupTotalRow(Table table, Double sgQuant, Double sgValue, Double sgBuyingValue, String totalL, boolean codes, int brRacuna) {
        TableItem ti = new TableItem(table, 0);
        int idx = codes ? 2 : 1;
        ti.setText(idx++, totalL + ":");
        ti.setText(idx++, StatLogic.getNumber03NG(sgQuant));
        ti.setText(idx++, totalL + ":");
        ti.setText(idx++, StatLogic.getNumber02NG(sgValue));
        ti.setText(idx++, "" + brRacuna);
        ti.setText(idx++, Konstante.getNumber02(sgValue / (double)brRacuna));
        if (sgBuyingValue != null) {
            ti.setText(idx++, totalL + ":");
            ti.setText(idx++, StatLogic.getNumber02NG(sgBuyingValue));
            ti.setText(idx++, StatLogic.getNumber02NG(sgValue - sgBuyingValue));
        }
        ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
        ti = new TableItem(table, 0);
        this.okidac = false;
    }

    private void insertGroupTotalRow(Table table, Double pice, Double jelo) {
        TableItem ti1 = new TableItem(table, 0);
        ti1.setText("PICE: ");
        ti1.setText(StatLogic.getNumber03NG(pice) + "/n/r");
        ti1.setText("JELA: ");
        ti1.setText(StatLogic.getNumber03NG(jelo) + "/n/r");
        ti1.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
    }

    private void insertRows(boolean bltz, List<NacinPlacanja> belaPlacanja, List<CrnoPlacanje> cp, Date from, Date to, List<Odeljenje> odeljenja, List<Kasa> kase, List<PodgrupaArtikala> podgrupe, boolean buyingPrices, boolean codes, boolean mz) throws Exception {
        TableItem ti;
        this.loadData(bltz, belaPlacanja, cp, from, to, odeljenja, kase, podgrupe, this.ppaArtData, this.ppaFinanceData, this.server, codes, mz);
        String totalL = Konstante.getBundle().getString("TEXT_UKUPNO");
        String total = Konstante.getBundle().getString("TEXT_TOTAL");
        double totalTot = 0.0;
        double totalKom = 0.0;
        ArrayList<Long> listaRacunId = new ArrayList<Long>();
        int brRac = 0;
        int satNo = 0;
        String sat = "00";
        HashMap<String, Long> racuniBR = new HashMap<String, Long>();
        EnumMap<NacinPlacanja, Double> nacinP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
        EnumMap<NacinPlacanja, Double> servisP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
        EnumMap<NacinPlacanja, Double> popustP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
        EnumMap<NacinPlacanja, Double> netoP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
        for (NacinPlacanja np : belaPlacanja) {
            racuniBR.put(np.getOpis(), 0L);
            nacinP.put(np, 0.0);
            servisP.put(np, 0.0);
            popustP.put(np, 0.0);
            netoP.put(np, 0.0);
        }
        if (!bltz) {
            String lastPG = null;
            Double sgCount = 0.0;
            Double sgValue = 0.0;
            Double sgBuyingValue = 0.0;
            HashMap<String, Double> sgValues = new HashMap<String, Double>();
            HashMap<String, Double> sgBuyingValues = new HashMap<String, Double>();
            HashMap<String, Double> sgCounts = new HashMap<String, Double>();
            LinkedList<String> sgList = new LinkedList<String>();
            int idx = 1;
            while (satNo < 24) {
                sat = satNo == 0 ? "00" : (satNo < 10 ? "0" + satNo : "" + satNo);
                ++satNo;
                for (Map<String, Object> row : this.ppaArtData) {
                    String subGroup = (String)row.get("podgrupa");
                    String vreme = row.get("vreme").toString();
                    int a = Integer.parseInt(sat) + 1;
                    String aa = satNo < 10 ? "0" + a : "" + a;
                    String vr = sat + ":00 - " + aa + ":00";
                    if (!vreme.startsWith(sat)) continue;
                    Long racunId = (Long)row.get("racunid");
                    if (!listaRacunId.contains(racunId)) {
                        listaRacunId.add(racunId);
                    }
                    brRac = listaRacunId.size();
                    if (lastPG != null && !vr.equals(lastPG)) {
                        sgList.add(lastPG);
                        sgValues.put(lastPG, sgValue);
                        sgCounts.put(lastPG, sgCount);
                        sgCount = 0.0;
                        sgValue = 0.0;
                        if (buyingPrices) {
                            sgBuyingValues.put(lastPG, sgBuyingValue);
                            sgBuyingValue = 0.0;
                        }
                    }
                    if (lastPG == null || !vr.equals(lastPG)) {
                        ti = new TableItem(this.table, 0);
                        ti.setText(vr);
                        ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
                        lastPG = vr;
                    }
                    ti = new TableItem(this.table, 0);
                    ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 0));
                    if (codes) {
                        String code = (String)row.get("sifra");
                        ti.setText(idx++, code == null ? "" : code);
                    }
                    ti.setText(idx++, (String)row.get("artikal"));
                    Double quant = (Double)row.get("kolicina");
                    Double value = (Double)row.get("vrednost");
                    ti.setText(idx++, StatLogic.getNumber03NG(quant));
                    ti.setText(idx++, StatLogic.getNumber02NG((Double)row.get("cena")));
                    ti.setText(idx++, StatLogic.getNumber02NG(value));
                    sgCount = sgCount + quant;
                    sgValue = sgValue + value;
                    this.okidac = true;
                    if (buyingPrices) {
                        Long artikalId = (Long)row.get("artid");
                        Double mera = (Double)row.get("normativmera");
                        Double buyingPrice = this.server.getLastNabavnaCenaKomboForDateComplexRecursiveMeasure(artikalId, new Date(), (Double)(mera == null ? 1.0 : mera));
                        Double buyingValue = buyingPrice * quant;
                        ti.setText(idx++, StatLogic.getNumber02NG(buyingPrice));
                        ti.setText(idx++, StatLogic.getNumber02NG(buyingValue));
                        ti.setText(idx++, StatLogic.getNumber02NG(value - buyingValue));
                        sgBuyingValue = sgBuyingValue + buyingValue;
                    }
                    idx = 1;
                }
                if (!this.okidac) continue;
                this.insertSubGroupTotalRow(this.table, sgCount, sgValue, buyingPrices ? sgBuyingValue : null, totalL, codes, brRac);
                totalTot += sgValue.doubleValue();
                totalKom += sgCount.doubleValue();
                listaRacunId.clear();
                brRac = 0;
            }
            TableItem t = new TableItem(this.table, 0);
            int idxa = codes ? 2 : 1;
            t.setText(idxa++, total + ":");
            t.setText(idxa++, StatLogic.getNumber03NG(totalKom));
            t.setText(idxa++, total + ":");
            t.setText(idxa++, StatLogic.getNumber03NG(totalTot));
            t.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
        }
        ti = new TableItem(this.table, 0);
        String subtotalL = Konstante.getBundle().getString("TEXT_MEDJUZBIR");
        Object combined = null;
        Double cNetto = 0.0;
        Double cDiscount = 0.0;
        Double cService = 0.0;
        Double cBrutto = 0.0;
    }

    public class NameComparator
    implements Comparator<Artikal> {
        @Override
        public int compare(Artikal o1, Artikal o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class PrometPoSatimaInput {
        private final ResourceBundle barmasterText = Konstante.getBundle();
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private final TimeInput2 odVremena;
        private final TimeInput2 doVremena;
        private Restoran restoran;
        private RestoranServer server;
        private Combo odeljenje;
        private Button blic;
        private Button nabavneCene;
        private ComboViewer prodajnoMesto;
        List<ProdajnoMesto> prodajnaMesta;
        private ComboViewer kasa;
        List<ProdajnoMesto> kase;
        private List<PodgrupaArtikala> podgrupe = new LinkedList<PodgrupaArtikala>();
        Date day1;
        Date day2;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();
        Odeljenje o;
        int totalPodgrupe = 0;
        List<Odeljenje> odeljenja;
        SWTContainer parent;
        Shell shell;
        Composite mainComposite;
        Label bp;
        private boolean medjuzbir;
        private Button jasperIzvestaj = null;
        private Button bOd;
        private Button bDo;

        public PrometPoSatimaInput(SWTContainer owner, Restoran r, boolean inspektor) {
            this.podgrupe = new ArrayList<PodgrupaArtikala>();
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.odeljenja = this.server.readOdeljenjeBezMag();
            this.prodajnaMesta = this.server.findAllProdajnoMesto();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new FillLayout());
            ScrolledComposite sc = new ScrolledComposite((Composite)this.shell, 768);
            this.mainComposite = new Composite((Composite)sc, 0);
            sc.setContent((Control)this.mainComposite);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            this.mainComposite.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite(this.mainComposite, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            Composite panel2 = new Composite(this.mainComposite, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            GridData data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)this.mainComposite.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_PROMET_PO_SATIMA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(4, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData(4, 4, false, false);
            data.widthHint = 670;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, true));
            grupa2.setText(String.format(this.barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 80;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(8, false));
            grupa21.setText(String.format(this.barmasterText.getString("TEXT_FILTER_NACINA_PLACANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 55;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_ZA_DATUM"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_ZA_DATUM"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            this.bOd = new Button((Composite)grupa1, 32);
            this.bOd.setVisible(false);
            this.bOd.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this.odVremena = new TimeInput2((Composite)grupa1, 0);
            this.odVremena.setVisible(false);
            this.odVremena.setEnabled(this.bOd.getSelection());
            try {
                this.odVremena.setDefault(this.server.getPocetniDatumJPA(this.odDatuma.getResult()));
            }
            catch (InputException ex) {
                Logger.getLogger(PrometPoArtiklimaPoSatima.class.getName()).log(Level.SEVERE, null, ex);
                this.odVremena.setDefault(this.server.getPocetniDatumJPA(new Date()));
            }
            this.bOd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    odVremena.setEnabled(bOd.getSelection());
                }
            });
            Label doD = new Label((Composite)grupa1, 0);
            doD.setVisible(false);
            doD.setText(String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.setVisible(false);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, this.shell));
            this.bDo = new Button((Composite)grupa1, 32);
            this.bDo.setVisible(false);
            this.bDo.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this.doVremena = new TimeInput2((Composite)grupa1, 0);
            this.doVremena.setVisible(false);
            this.doVremena.setLayoutData(new GridData(0x1000000, 4, true, false));
            this.doVremena.setEnabled(this.bDo.getSelection());
            try {
                this.doVremena.setDefault(this.server.getKrajnjiDatumJPA(this.doDatuma.getResult()));
            }
            catch (InputException ex) {
                Logger.getLogger(PrometPoArtiklimaPoSatima.class.getName()).log(Level.SEVERE, null, ex);
                this.doVremena.setDefault(new Date());
            }
            this.bDo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    doVremena.setEnabled(bDo.getSelection());
                }
            });
            ((Text)this.odDatuma.getControl()).addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        if (bOd.getSelection()) {
                            Calendar odd = Calendar.getInstance();
                            odd.setTime(odDatuma.getResult());
                            odd.set(11, odVremena.getHours());
                            odd.set(12, odVremena.getMinutes());
                            odd.set(13, odVremena.getSeconds());
                            odVremena.setDefault(odd);
                        } else {
                            odVremena.setDefault(server.getPocetniDatumJPA(odDatuma.getResult()));
                        }
                    }
                    catch (InputException ex) {
                        Logger.getLogger(PrometPoArtiklimaPoSatima.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
            ((Text)this.doDatuma.getControl()).addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        if (bDo.getSelection()) {
                            Calendar dod = Calendar.getInstance();
                            dod.setTime(doDatuma.getResult());
                            dod.set(11, doVremena.getHours());
                            dod.set(12, doVremena.getMinutes());
                            dod.set(13, doVremena.getSeconds());
                            doVremena.setDefault(dod);
                        } else {
                            doVremena.setDefault(server.getKrajnjiDatumJPA(doDatuma.getResult()));
                        }
                    }
                    catch (InputException ex) {
                        Logger.getLogger(PrometPoArtiklimaPoSatima.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
            Label art = new Label((Composite)grupa2, 0);
            art.setText(String.format(this.barmasterText.getString("TEXT_ODELJENJE"), new Object[0]) + ":");
            this.odeljenje = new Combo((Composite)grupa2, 8);
            this.odeljenje.add(String.format(this.barmasterText.getString("TEXT_SVA_PROIZVODNA_MESTA"), new Object[0]));
            for (Odeljenje ode : this.odeljenja) {
                this.odeljenje.add(ode.getNaziv());
            }
            this.odeljenje.select(0);
            LinkedList<ProdajnoMesto> pmInput = new LinkedList<ProdajnoMesto>();
            pmInput.addAll(this.prodajnaMesta);
            Label pm = new Label((Composite)grupa2, 0);
            pm.setText(String.format(this.barmasterText.getString("TEXT_PRODAJNO_MESTO"), new Object[0]) + ":");
            this.prodajnoMesto = new ComboViewer((Composite)grupa2, 12);
            this.prodajnoMesto.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object o) {
                    LinkedList<Object> list = new LinkedList<Object>();
                    list.add(o);
                    if (o instanceof List && !((List)o).isEmpty() && ((List)o).get(0) instanceof ProdajnoMesto) {
                        List pmList = (List)o;
                        list.addAll(pmList);
                    }
                    return list.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object o, Object o1) {
                }
            });
            this.prodajnoMesto.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof List) {
                        return ((List)element).isEmpty() ? String.format(Konstante.getBundle().getString("TEXT_NEMA_PRODAJNIH_MESTA"), new Object[0]) : String.format(Konstante.getBundle().getString("TEXT_SVA_PRODAJNA_MESTA"), new Object[0]);
                    }
                    if (element instanceof ProdajnoMesto) {
                        ProdajnoMesto pm = (ProdajnoMesto)element;
                        return pm.getNaziv();
                    }
                    return "";
                }
            });
            this.prodajnoMesto.setInput(pmInput);
            this.prodajnoMesto.setSelection((ISelection)new StructuredSelection(pmInput));
            Label kL = new Label((Composite)grupa2, 0);
            kL.setText(String.format(this.barmasterText.getString("TEXT_KASA"), new Object[0]) + ":");
            this.kasa = new ComboViewer((Composite)grupa2, 12);
            this.kasa.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object o) {
                    LinkedList<Object> list = new LinkedList<Object>();
                    list.add(o);
                    if (o instanceof List && !((List)o).isEmpty() && ((List)o).get(0) instanceof Kasa) {
                        List pmList = (List)o;
                        list.addAll(pmList);
                    }
                    return list.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object o, Object o1) {
                }
            });
            this.kasa.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof List) {
                        return ((List)element).isEmpty() ? String.format(Konstante.getBundle().getString("TEXT_NEMA_KASE"), new Object[0]) : String.format(Konstante.getBundle().getString("TEXT_SVE_KASE"), new Object[0]);
                    }
                    if (element instanceof Kasa) {
                        Kasa pm = (Kasa)element;
                        return pm.getOznaka() == null ? pm.getHostname() : pm.getOznaka();
                    }
                    return "";
                }
            });
            this.kasa.setInput(new ArrayList());
            this.kasa.setSelection((ISelection)new StructuredSelection(this.kasa.getInput()));
            this.prodajnoMesto.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent sce) {
                    IStructuredSelection iSel = (IStructuredSelection)sce.getSelection();
                    if (!iSel.isEmpty()) {
                        Object sel = iSel.getFirstElement();
                        if (sel instanceof ProdajnoMesto) {
                            ProdajnoMesto pm = (ProdajnoMesto)sel;
                            if (pm.getKase() != null) {
                                kasa.setInput(pm.getKase());
                                kasa.setSelection((ISelection)new StructuredSelection(pm.getKase()));
                                kasa.refresh();
                            } else {
                                kasa.setInput(new ArrayList());
                                kasa.setSelection((ISelection)new StructuredSelection(kasa.getInput()));
                                kasa.refresh();
                            }
                        } else {
                            kasa.setInput(new ArrayList());
                            kasa.setSelection((ISelection)new StructuredSelection(kasa.getInput()));
                            kasa.refresh();
                        }
                    }
                }
            });
            for (NacinPlacanja value : NacinPlacanja.values()) {
                Button b = new Button((Composite)grupa21, 32);
                b.setText(value.getOpis());
                b.setSelection(true);
                this.belaDugmici.add(b);
            }
            if (inspektor) {
                for (CrnoPlacanje cp : this.server.readCrnaPlacanjaIzvestaji()) {
                    Button b = new Button((Composite)grupa21, 32);
                    b.setText(cp.getNaziv());
                    b.setData((Object)cp);
                    this.crnaDugmici.add(b);
                }
            }
            Label bl = new Label((Composite)grupa2, 0);
            bl.setText(String.format(this.barmasterText.getString("TEXT_BLIC_PROMET"), new Object[0]) + ":");
            this.blic = new Button((Composite)grupa2, 32);
            Label nc = new Label((Composite)grupa2, 0);
            nc.setText(String.format(this.barmasterText.getString("TEXT_PO_NABAVNIM_CENAMA"), new Object[0]) + ":");
            this.nabavneCene = new Button((Composite)grupa2, 32);
            Button izborPodgrupa = new Button((Composite)grupa2, 8);
            izborPodgrupa.setText(String.format(this.barmasterText.getString("TEXT_IZBOR_PODGRUPA"), new Object[0]));
            izborPodgrupa.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    podgrupe = new ArrayList();
                    IzborPodgrua2 ip = new IzborPodgrua2(mainComposite.getDisplay(), restoran);
                    podgrupe = ip.getPodgrupe();
                    if (podgrupe.isEmpty()) {
                        for (GrupaArtikala ga : server.readGrupeArtikala()) {
                            for (PodgrupaArtikala pa : server.readPodgrupeArtikala(ga)) {
                                podgrupe.add(pa);
                            }
                        }
                        totalPodgrupe = podgrupe.size();
                    }
                    bp.setText(String.format(barmasterText.getString("TEXT_BROJ_IZABRANIH_PODGRUPA"), new Object[0]) + ": " + podgrupe.size());
                }
            });
            this.bp = new Label((Composite)grupa2, 64);
            if (this.podgrupe.isEmpty()) {
                for (GrupaArtikala ga : this.server.readGrupeArtikala()) {
                    for (PodgrupaArtikala pa : this.server.readPodgrupeArtikala(ga)) {
                        this.podgrupe.add(pa);
                    }
                }
                this.totalPodgrupe = this.podgrupe.size();
            }
            this.bp.setText(String.format(this.barmasterText.getString("TEXT_BROJ_IZABRANIH_PODGRUPA"), new Object[0]) + ": " + this.podgrupe.size());
            Button brisanjePodgrupa = new Button((Composite)grupa2, 8);
            brisanjePodgrupa.setText(String.format(this.barmasterText.getString("TEXT_IZBOR_SVIH_PODGRUPA"), new Object[0]));
            brisanjePodgrupa.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    podgrupe = new ArrayList();
                    for (GrupaArtikala ga : server.readGrupeArtikala()) {
                        for (PodgrupaArtikala pa : server.readPodgrupeArtikala(ga)) {
                            podgrupe.add(pa);
                        }
                    }
                    totalPodgrupe = podgrupe.size();
                    bp.setText(String.format(barmasterText.getString("TEXT_BROJ_IZABRANIH_PODGRUPA"), new Object[0]) + ": " + podgrupe.size());
                }
            });
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            art.setLayoutData((Object)data);
            pm.setLayoutData((Object)data);
            kL.setLayoutData((Object)data);
            this.prodajnoMesto.getCombo().setLayoutData((Object)data);
            this.kasa.getCombo().setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            this.odVremena.setLayoutData(data);
            this.doVremena.setLayoutData(data);
            bl.setLayoutData((Object)data);
            nc.setLayoutData((Object)data);
            this.blic.setLayoutData((Object)data);
            this.nabavneCene.setLayoutData((Object)data);
            this.odeljenje.setLayoutData((Object)data);
            this.bp.setLayoutData((Object)data);
            this.mainComposite.layout();
            sc.setMinSize(this.mainComposite.computeSize(-1, -1));
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                Object sel;
                this.day1 = this.odVremena.getResult().getTime();
                this.day2 = this.doVremena.getResult().getTime();
                this.o = this.odeljenje.getSelectionIndex() == 0 ? null : this.odeljenja.get(this.odeljenje.getSelectionIndex() - 1);
                ArrayList<Kasa> selKase = null;
                IStructuredSelection kSel = (IStructuredSelection)this.kasa.getSelection();
                if (!kSel.isEmpty() && (sel = kSel.getFirstElement()) != null && sel instanceof Kasa) {
                    Kasa k = (Kasa)sel;
                    selKase = new ArrayList<Kasa>();
                    selKase.add(k);
                }
                if (selKase == null) {
                    Object sel2;
                    ProdajnoMesto pmi = null;
                    IStructuredSelection pmSel = (IStructuredSelection)this.prodajnoMesto.getSelection();
                    if (!pmSel.isEmpty() && (sel2 = pmSel.getFirstElement()) != null && sel2 instanceof ProdajnoMesto) {
                        ProdajnoMesto pm;
                        pmi = pm = (ProdajnoMesto)sel2;
                    }
                    if (pmi != null && pmi.getKase() != null) {
                        selKase = new ArrayList();
                        selKase.addAll(pmi.getKase());
                    }
                }
                ArrayList<NacinPlacanja> bela = new ArrayList<NacinPlacanja>();
                for (int i = 0; i < this.belaDugmici.size(); ++i) {
                    Button b = this.belaDugmici.get(i);
                    if (!b.getSelection()) continue;
                    bela.add(NacinPlacanja.values()[i]);
                }
                this.medjuzbir = false;
                ArrayList<CrnoPlacanje> crna = new ArrayList<CrnoPlacanje>();
                for (Button b : this.crnaDugmici) {
                    CrnoPlacanje cp = (CrnoPlacanje)b.getData();
                    if (!b.getSelection()) continue;
                    if (cp.getMedjuZbir() != null && cp.getMedjuZbir().booleanValue()) {
                        this.medjuzbir = true;
                        continue;
                    }
                    crna.add(cp);
                }
                Calendar c = Calendar.getInstance();
                c.setTime(this.day1);
                c.add(5, 1);
                Date novo = c.getTime();
                this.server.log(String.format(this.barmasterText.getString("LOG_PREGLED_PROMETA_PO_ARTIKLIMA_OD_DATUMA_DO_DATUMA"), StatLogic.getDateString(this.day1), StatLogic.getDateString(novo)));
                new PrometPoArtiklimaPoSatima(this.shell, this.restoran, this.day1, novo, this.o, this.blic.getSelection(), this.nabavneCene.getSelection(), bela, crna, this.podgrupe, this.totalPodgrupe, selKase, this.medjuzbir);
            }
            catch (Exception ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

