/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.GrupaOA;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.stampa.NPrintUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PrometPoArtiklimaBoBrza {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    Composite composite;
    List<GrupaOA> grupe = new ArrayList<GrupaOA>();
    List<String> crnaPlacanja;
    Map<GrupaOA, Double> mapaP = new HashMap<GrupaOA, Double>();
    Map<NacinPlacanja, Double> nacinP = new HashMap<NacinPlacanja, Double>();
    Map<String, Double> nacinPCrno = new HashMap<String, Double>();
    boolean blic;
    boolean nabavne;
    List<StavkaRacuna> stavke;
    Date day1;
    Date day2;
    boolean crno;
    boolean kombPlacanje = false;
    List<StavkaRacuna> stavkeKonacno = new ArrayList<StavkaRacuna>();
    List<Artikal> izabraniArtikli = new ArrayList<Artikal>();
    Button printButton4;
    double medjuzbir = 0.0;
    boolean sifre;

    public PrometPoArtiklimaBoBrza(Shell s, Restoran re, boolean blc, boolean poNabavnimCenama, boolean osnovno, boolean dodatno) {
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.grupe = this.server.getGrupeAtributa();
        this.shell = s;
        try {
            this.sifre = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
        }
        catch (Exception e) {
            this.sifre = false;
        }
        this.day1 = this.server.getPoslednjiPocetni();
        this.day2 = Konstante.getKrajnjiDatum(new Date(), this.server);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(6, false));
        if (dodatno) {
            this.crnaPlacanja = new ArrayList<String>();
            for (CrnoPlacanje cp : this.server.readCrnaPlacanjaIzvestaji()) {
                this.crnaPlacanja.add(cp.getNaziv());
            }
        }
        this.blic = blc;
        this.nabavne = poNabavnimCenama;
        this.nacinP = new HashMap<NacinPlacanja, Double>();
        if (osnovno) {
            for (NacinPlacanja np : NacinPlacanja.values()) {
                this.nacinP.put(np, 0.0);
            }
        }
        if (this.crnaPlacanja != null && this.crnaPlacanja.size() > 0) {
            this.crno = true;
        }
        if (this.crno) {
            this.stavke = this.server.getSveStavke(this.day1, this.day2, null);
            block6: for (StavkaRacuna sr : this.stavke) {
                if (sr.getRacun().getCrnoPlacanje() == null) continue;
                for (String st : this.crnaPlacanja) {
                    if (!st.equals(sr.getRacun().getCrnoPlacanje())) continue;
                    this.stavkeKonacno.add(sr);
                    continue block6;
                }
            }
            this.nacinPCrno = this.makeMapCrno();
        } else {
            this.stavke = this.server.getStavke(this.day1, this.day2, null);
        }
        for (StavkaRacuna sr : this.stavke) {
            if (sr.getRacun().getCrnoPlacanje() != null) continue;
            this.stavkeKonacno.add(sr);
        }
        ArrayList<Racun> racuni = new ArrayList<Racun>();
        for (StavkaRacuna a : this.stavkeKonacno) {
            if (racuni.contains(a.getRacun())) continue;
            racuni.add(a.getRacun());
        }
        this.medjuzbir = this.server.getMedjuzbir(null, this.day1, this.day2);
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.makeHeaders();
        this.insertRows();
        try {
            this.uskaTest();
        }
        catch (Exception e) {
            Logger.getLogger(PrometPoArtiklimaBoBrza.class.getName()).log(Level.WARNING, null, e);
        }
        this.table.pack();
    }

    public void uskaTest() throws Exception {
        Stampac stampac = this.server.readIzvestajiStampacObject();
        int bkur = stampac.getTip().getBrojKarakteraURedu();
        String content = "";
        content = content + NPrintUtils.centerSplitToEnds(bkur, StatLogic.getDateString(new Date()), StatLogic.getTimeString(new Date())) + "\n";
        content = content + NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_PREGLED_PRODATIH_ARTIKALA_CAPS"), new Object[0])) + "\n";
        content = content + NPrintUtils.centerSplitToMiddle(bkur, String.format(this.barmasterText.getString("TEXT_OD"), new Object[0]) + " " + StatLogic.getDateString(this.day1) + " ", String.format(this.barmasterText.getString("TEXT_DO"), new Object[0]) + " " + StatLogic.getDateString(this.day2)) + "\n";
        content = content + NPrintUtils.spaceFill(bkur) + "\n";
        if (!this.blic) {
            content = content + NPrintUtils.leftText(bkur, String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0])) + "\n";
            String temp = String.format(this.barmasterText.getString("TEXT_PRODATO"), new Object[0]) + " ";
            int l1 = temp.length();
            content = content + NPrintUtils.leftText(l1, temp) + NPrintUtils.centerSplitToCenter(bkur - l1, String.format(this.barmasterText.getString("TEXT_CENA"), new Object[0]) + " ", String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0])) + "\n";
            int items = this.table.getItemCount();
            for (int i = 0; i < items; ++i) {
                if (this.table.getItem(i).getText(0).length() > 2 && this.table.getItem(i).getText(4).length() == 0) {
                    content = content + NPrintUtils.minusFill(bkur) + "\n";
                    content = content + NPrintUtils.centerText(bkur, this.table.getItem(i).getText(0)) + "\n";
                    content = content + NPrintUtils.minusFill(bkur) + "\n";
                    continue;
                }
                if (this.table.getItem(i).getText(0).length() == 0 && this.table.getItem(i).getText(1).length() > 2) {
                    content = content + NPrintUtils.leftText(bkur, this.table.getItem(i).getText(1)) + "\n";
                    content = content + NPrintUtils.leftText(bkur - 10 - 15, this.table.getItem(i).getText(2)) + NPrintUtils.rightText(10, this.table.getItem(i).getText(3)) + NPrintUtils.rightText(15, this.table.getItem(i).getText(4)) + "\n";
                    continue;
                }
                if (this.table.getItem(i).getText(3).equalsIgnoreCase(String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]) + ":")) {
                    content = content + NPrintUtils.rightText(bkur, "---------") + "\n";
                    content = content + NPrintUtils.rightText(bkur, this.table.getItem(i).getText(4)) + "\n";
                    continue;
                }
                if (this.table.getItem(i).getText(3).equalsIgnoreCase(String.format(this.barmasterText.getString("TEXT_TOTAL"), new Object[0]) + ":")) {
                    content = content + NPrintUtils.minusFill(bkur) + "\n";
                    content = content + NPrintUtils.rightText(bkur, String.format(this.barmasterText.getString("TEXT_TOTAL"), new Object[0]) + ": " + this.table.getItem(i).getText(4)) + "\n";
                    content = content + NPrintUtils.minusFill(bkur) + "\n";
                    continue;
                }
                if (this.table.getItem(i).getText(0).length() <= 2) continue;
                content = content + NPrintUtils.leftText(bkur - 10, this.table.getItem(i).getText(0)) + NPrintUtils.rightText(10, this.table.getItem(i).getText(4)) + "\n";
                if (!this.table.getItem(i).getText(0).startsWith(String.format(this.barmasterText.getString("TEXT_NACIN"), new Object[0]))) continue;
                content = content + NPrintUtils.minusFill(bkur) + "\n";
            }
        } else {
            content = content + NPrintUtils.centerSplitToEnds(bkur, String.format(this.barmasterText.getString("TEXT_GRUPA"), new Object[0]), String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0])) + "\n";
            content = content + NPrintUtils.minusFill(bkur) + "\n";
            int items = this.table.getItemCount();
            for (int i = 0; i < items; ++i) {
                if (this.table.getItem(i).getText(0).length() > 2 && this.table.getItem(i).getText(4).length() == 0) {
                    content = content + NPrintUtils.leftText(bkur - 10, this.table.getItem(i).getText(0)) + NPrintUtils.rightText(10, this.table.getItem(i).getText(4)) + "\n";
                    content = content + NPrintUtils.minusFill(bkur) + "\n";
                    continue;
                }
                if (this.table.getItem(i).getText(3).equalsIgnoreCase(String.format(this.barmasterText.getString("TEXT_TOTAL"), new Object[0]) + ":")) {
                    content = content + NPrintUtils.minusFill(bkur) + "\n";
                    content = content + NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_TOTAL"), new Object[0]) + ": " + this.table.getItem(i).getText(4)) + "\n";
                    content = content + NPrintUtils.minusFill(bkur) + "\n";
                    continue;
                }
                if (this.table.getItem(i).getText(0).length() <= 2) continue;
                content = content + NPrintUtils.leftText(bkur - 10, this.table.getItem(i).getText(0)) + NPrintUtils.rightText(10, this.table.getItem(i).getText(4)) + "\n";
                if (!this.table.getItem(i).getText(0).startsWith(String.format(this.barmasterText.getString("TEXT_NACIN"), new Object[0]))) continue;
                content = content + NPrintUtils.minusFill(bkur) + "\n";
            }
        }
        content = content + NPrintUtils.minusFill(bkur) + "\n";
        NPrintUtils.printContent(content, stampac, 1);
    }

    public void makeHeaders() {
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(String.format(this.barmasterText.getString("TEXT_GRUPA"), new Object[0]));
        tc4.setWidth(200);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText(String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]));
        tc1.setWidth(170);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
        tc2.pack();
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText(String.format(this.barmasterText.getString("TEXT_CENA_KOMAD_SKR"), new Object[0]));
        tc9.setWidth(100);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText(String.format(this.barmasterText.getString("TEXT_VREDNOST"), new Object[0]));
        tc3.setWidth(120);
        tc3.pack();
    }

    public void insertRows() {
        double total = 0.0;
        boolean prikaz = false;
        for (GrupaOA pg : this.grupe) {
            TableItem ti;
            this.izabraniArtikli.clear();
            this.izabraniArtikli.addAll(pg.getAtributi());
            for (StavkaRacuna sr : this.stavke) {
                double d;
                if (!this.izabraniArtikli.contains(sr.getArtikal())) continue;
                if (!sr.getRacun().getPlacanja().isEmpty() && this.nacinP.containsKey((Object)sr.getRacun().getPlacanja().get(0).getNacin())) {
                    d = this.nacinP.get((Object)sr.getRacun().getPlacanja().get(0).getNacin());
                    this.nacinP.put(sr.getRacun().getPlacanja().get(0).getNacin(), d + sr.getKolicina() * sr.getCena());
                    continue;
                }
                if (sr.getRacun().getCrnoPlacanje() == null || !this.nacinPCrno.containsKey(sr.getRacun().getCrnoPlacanje())) continue;
                d = this.nacinPCrno.get(sr.getRacun().getCrnoPlacanje());
                this.nacinPCrno.put(sr.getRacun().getCrnoPlacanje(), d + sr.getKolicina() * sr.getCena());
            }
            double totalGrupe = 0.0;
            for (StavkaRacuna a : StavkeSumarno.getSumarnoPopust(this.stavkeKonacno)) {
                if (!this.izabraniArtikli.contains(a.getArtikal())) continue;
                prikaz = true;
                break;
            }
            if (!this.blic && prikaz) {
                ti = new TableItem(this.table, 0);
                ti.setText(0, pg.getNaziv());
                ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
            }
            for (StavkaRacuna a : StavkeSumarno.getSumarnoPopust(this.stavkeKonacno)) {
                String n;
                if (!this.izabraniArtikli.contains(a.getArtikal())) continue;
                double kol = a.getKolicina();
                double cena = a.getCena();
                totalGrupe += kol * cena;
                if (this.nabavne) {
                    Artikal art = a.getArtikal();
                    if (art.getTip() == TipArtikla.SLOZ) {
                        List<Normativ> norms = this.server.getNormativiByLastNormativiArtikal(art.getId());
                        cena = 0.0;
                        for (Normativ n2 : norms) {
                            Artikal a2 = this.server.getArtikal(n2.getSastojak().getId());
                            if (a2.getTip() == TipArtikla.SLOZ) {
                                List<Normativ> nn2 = this.server.getNormativiByLastNormativiArtikal(a2.getId());
                                double c2 = 0.0;
                                for (Normativ n22 : nn2) {
                                    c2 += this.server.getArtikal(n22.getSastojak().getId()).getTrenutnaNV() * n22.getKolicina();
                                }
                                cena += c2 * n2.getKolicina();
                                continue;
                            }
                            cena += a2.getTrenutnaNV() * n2.getKolicina();
                        }
                    } else {
                        cena = art.getTrenutnaNV() * art.getMera();
                    }
                }
                if (this.blic || !prikaz) continue;
                if (this.sifre) {
                    String s = a.getArtikal().getBarCode() != null ? a.getArtikal().getBarCode() : "";
                    n = s + " (" + a.getArtikal().getName() + ")";
                } else {
                    n = a.getArtikal().getName();
                }
                TableItem ti2 = new TableItem(this.table, 0);
                ti2.setText(new String[]{"", n, Konstante.getNumber02(kol), Konstante.getNumber2(cena), Konstante.getNumber2(kol * cena)});
            }
            if (!this.blic && prikaz) {
                ti = new TableItem(this.table, 0);
                ti.setText(3, String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]) + ":");
                ti.setText(4, Konstante.getNumber2(totalGrupe));
                ti = new TableItem(this.table, 0);
            }
            if (this.blic && prikaz) {
                ti = new TableItem(this.table, 0);
                ti.setText(new String[]{pg.getNaziv(), "", "", String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]) + ":", Konstante.getNumber2(totalGrupe)});
                ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
            }
            prikaz = false;
            total += totalGrupe;
        }
        if (total > 0.0) {
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(3, String.format(this.barmasterText.getString("TEXT_TOTAL"), new Object[0]) + ":");
            ti.setText(4, Konstante.getNumber2(total));
            ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
            ti = new TableItem(this.table, 0);
        }
        TableItem tit = new TableItem(this.table, 0);
        tit = new TableItem(this.table, 0);
        tit.setText(new String[]{String.format(this.barmasterText.getString("TEXT_NACIN_PLACANJA"), new Object[0]), String.format(this.barmasterText.getString("TEXT_NETO"), new Object[0]), String.format(this.barmasterText.getString("TEXT_POPUST"), new Object[0]), String.format(this.barmasterText.getString("TEXT_SERVIS"), new Object[0]), String.format(this.barmasterText.getString("TEXT_BRUTO"), new Object[0])});
        for (NacinPlacanja np : NacinPlacanja.values()) {
            if (!this.nacinP.containsKey((Object)np)) continue;
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(0, np.getOpis());
            ti.setText(4, Konstante.getNumber2(this.nacinP.get((Object)np)));
        }
        if (this.crno) {
            for (String cp : this.nacinPCrno.keySet()) {
                TableItem ti = new TableItem(this.table, 0);
                ti.setText(0, cp);
                ti.setText(4, Konstante.getNumber2(this.nacinPCrno.get(cp)));
            }
        }
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
    }

    public Map makeMapCrno() {
        HashMap<String, Double> mapa = new HashMap<String, Double>();
        for (String cp : this.crnaPlacanja) {
            mapa.put(cp, 0.0);
        }
        return mapa;
    }

    private List<NacinPlacanja> getNacine(StavkaRacuna sr) {
        ArrayList<NacinPlacanja> n = new ArrayList<NacinPlacanja>();
        for (Placanje p : sr.getRacun().getPlacanja()) {
            n.add(p.getNacin());
        }
        return n;
    }

    public class NameComparator
    implements Comparator<Artikal> {
        @Override
        public int compare(Artikal o1, Artikal o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

