/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StalniGostiGrupa;
import com.dev63.restoran.sistem.XLSExporter;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PrikazStalnogGosta {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    SWTContainer parent;
    Shell shell;
    Composite composite;
    String artikli;
    private boolean preduzece;
    private boolean blokirani;
    MenuItem item1;
    private static final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    StalniGostiGrupa sgg;
    private StalniGost sg;
    private List<StalniGost> gosti;

    public PrikazStalnogGosta(SWTContainer owner, Restoran r, StalniGostiGrupa sgg, boolean isBlokiran) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.shell = this.parent.getControl().getShell();
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout());
        this.sgg = sgg;
        this.preduzece = sgg != null ? sgg.isPreduzece() : true;
        this.blokirani = isBlokiran;
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        this.table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.shell.setBackgroundMode(2);
        Composite cc = new Composite((Composite)this.shell, 0);
        cc.setLayoutData((Object)new GridData(4, 4, true, false));
        cc.setLayout((Layout)new GridLayout(10, false));
        GridData rd = new GridData(120, 50);
        Button printButton = new Button(cc, 8);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PrikazStalnogGosta.this.table), false, true, String.format(barmasterText.getString("TEXT_PRIKAZ_STALNOG_GOSTA"), new Object[0]), PrikazStalnogGosta.this.shell, PrikazStalnogGosta.this.server);
            }
        });
        printButton.setLayoutData((Object)rd);
        Button export = new Button(cc, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PrikazStalnogGosta.this.table, PrikazStalnogGosta.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)rd);
        Button izlaz = new Button(cc, 8);
        rd = new GridData(120, 50);
        rd.horizontalAlignment = 131072;
        rd.grabExcessHorizontalSpace = true;
        rd.horizontalSpan = 1;
        izlaz.setLayoutData((Object)rd);
        izlaz.setText(String.format(barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PrikazStalnogGosta.this.shell.close();
            }
        });
        Composite cc1 = new Composite((Composite)this.shell, 0);
        cc1.setLayoutData((Object)new GridData(4, 4, true, false));
        cc1.setLayout((Layout)new GridLayout(10, false));
        GridData rd1 = new GridData(120, 50);
        rd1.horizontalAlignment = 16384;
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    private void makeHeaders() {
        TableColumn tc2 = new TableColumn(this.table, 16384);
        tc2.setText(String.format(barmasterText.getString("TEXT_NAZIV"), new Object[0]));
        tc2.setWidth(140);
        TableColumn tc9 = new TableColumn(this.table, 16384);
        tc9.setText(String.format(barmasterText.getString("TEXT_ADRESA"), new Object[0]));
        tc9.setWidth(140);
        TableColumn tc3 = new TableColumn(this.table, 16384);
        tc3.setText(String.format(barmasterText.getString("TEXT_MESTO"), new Object[0]));
        tc3.setWidth(100);
        TableColumn tc4 = new TableColumn(this.table, 16384);
        tc4.setText(String.format(barmasterText.getString("TEXT_GRUPA"), new Object[0]));
        tc4.setWidth(100);
        TableColumn tc44 = new TableColumn(this.table, 16384);
        tc44.setText(String.format(barmasterText.getString("TEXT_JMBG"), new Object[0]));
        tc44.setWidth(100);
        TableColumn tc77 = new TableColumn(this.table, 16384);
        tc77.setText(String.format(barmasterText.getString("TEXT_EMAIL"), new Object[0]));
        tc77.setWidth(80);
        if (this.preduzece) {
            TableColumn tc2s = new TableColumn(this.table, 16384);
            tc2s.setText(String.format(barmasterText.getString("TEXT_SKR_NAZIV"), new Object[0]));
            tc2s.setWidth(120);
            TableColumn tc114 = new TableColumn(this.table, 16384);
            tc114.setText(String.format(barmasterText.getString("TEXT_SIFRA_DELATNOSTI"), new Object[0]));
            tc114.pack();
            TableColumn tc7 = new TableColumn(this.table, 16384);
            tc7.setText(String.format(barmasterText.getString("TEXT_BANKA"), new Object[0]) + "1");
            tc7.setWidth(80);
            TableColumn tc12 = new TableColumn(this.table, 16384);
            tc12.setText(String.format(barmasterText.getString("TEXT_TEKUCI_RACUN"), new Object[0]) + "1");
            tc12.setWidth(80);
            TableColumn tc13 = new TableColumn(this.table, 16384);
            tc13.setText(String.format(barmasterText.getString("TEXT_BANKA"), new Object[0]) + "2");
            tc13.setWidth(80);
            TableColumn tc14 = new TableColumn(this.table, 16384);
            tc14.setText(String.format(barmasterText.getString("TEXT_TEKUCI_RACUN"), new Object[0]) + "2");
            tc14.setWidth(80);
            TableColumn tc17 = new TableColumn(this.table, 16384);
            tc17.setText(String.format(barmasterText.getString("TEXT_BANKA"), new Object[0]) + "3");
            tc17.setWidth(80);
            TableColumn tc22 = new TableColumn(this.table, 16384);
            tc22.setText(String.format(barmasterText.getString("TEXT_TEKUCI_RACUN"), new Object[0]) + "3");
            tc22.setWidth(80);
            TableColumn tc6 = new TableColumn(this.table, 16384);
            tc6.setText(String.format(barmasterText.getString("TEXT_MATICNI_BROJ"), new Object[0]));
            tc6.pack();
            TableColumn tc16 = new TableColumn(this.table, 16384);
            tc16.setText(String.format(barmasterText.getString("TEXT_PIB"), new Object[0]));
            tc16.setWidth(100);
            TableColumn tc10 = new TableColumn(this.table, 16384);
            tc10.setText(String.format(barmasterText.getString("TEXT_DOBAVLJAC"), new Object[0]));
            tc10.pack();
            TableColumn tc121 = new TableColumn(this.table, 16384);
            tc121.setText(String.format(barmasterText.getString("TEXT_LICE_ZA_KONTAKT"), new Object[0]));
            tc121.setWidth(100);
            TableColumn tc11 = new TableColumn(this.table, 16384);
            tc11.setText(String.format(barmasterText.getString("TEXT_POLJOGAZDINSTVO"), new Object[0]));
            tc11.pack();
            TableColumn tc111 = new TableColumn(this.table, 16384);
            tc111.setText(String.format(barmasterText.getString("TEXT_REGISTRACIJA_SUD"), new Object[0]));
            tc111.pack();
            TableColumn tc112f = new TableColumn(this.table, 16384);
            tc112f.setText(String.format(barmasterText.getString("TEXT_FAX"), new Object[0]));
            tc112f.setWidth(70);
        }
        TableColumn tc11t = new TableColumn(this.table, 16384);
        tc11t.setText(String.format(barmasterText.getString("TEXT_TELEFON"), new Object[0]));
        tc11t.setWidth(80);
        TableColumn tc112 = new TableColumn(this.table, 16384);
        tc112.setText(String.format(barmasterText.getString("TEXT_MOBILNI"), new Object[0]));
        tc112.setWidth(80);
        TableColumn tc113 = new TableColumn(this.table, 16384);
        tc113.setText(String.format(barmasterText.getString("TEXT_POPUST"), new Object[0]));
        tc113.pack();
        TableColumn tc115 = new TableColumn(this.table, 16384);
        tc115.setText(String.format(barmasterText.getString("TEXT_SIFRA"), new Object[0]));
        tc115.setWidth(70);
        TableColumn tc116 = new TableColumn(this.table, 16384);
        tc116.setText(String.format(barmasterText.getString("TEXT_VALUTA_PLACANJA"), new Object[0]));
        tc116.pack();
    }

    private void insertRows() {
        this.gosti = this.server.readStalneGoste(this.sgg, this.blokirani);
        for (StalniGost sg : this.gosti) {
            if (sg.getNaziv().isEmpty()) continue;
            StalniGostiGrupa ssg = sg.getGrupa();
            int idx = 0;
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(idx++, sg.getNaziv());
            ti.setText(idx++, sg.getAdersa() != null ? sg.getAdersa() : "/");
            ti.setText(idx++, sg.getMesto() != null ? sg.getMesto() : "/");
            ti.setText(idx++, ssg != null ? ssg.getNaziv() : "Dobavljac");
            ti.setText(idx++, sg.getJmbg() != null ? sg.getJmbg() : "/");
            ti.setText(idx++, sg.getEmail() != null ? sg.getEmail() : "/");
            if (this.preduzece) {
                ti.setText(idx++, sg.getSkrNaziv() != null ? sg.getSkrNaziv() : "/");
                ti.setText(idx++, sg.getSifraDelatnosti() != null ? sg.getSifraDelatnosti() : "/");
                ti.setText(idx++, sg.getBanka1() != null ? sg.getBanka1() : "/");
                ti.setText(idx++, sg.getTekuciRacun1() != null ? sg.getTekuciRacun1() : "/");
                ti.setText(idx++, sg.getBanka2() != null ? sg.getBanka2() : "/");
                ti.setText(idx++, sg.getTekuciRacun2() != null ? sg.getTekuciRacun2() : "/");
                ti.setText(idx++, sg.getBanka3() != null ? sg.getBanka3() : "/");
                ti.setText(idx++, sg.getTekuciRacun3() != null ? sg.getTekuciRacun3() : "/");
                ti.setText(idx++, sg.getMaticniBroj() != null ? sg.getMaticniBroj() : "/");
                ti.setText(idx++, sg.getPib() != null ? sg.getPib() : "/");
                ti.setText(idx++, sg.getDobavljac() != false ? "Da" : "Ne");
                ti.setText(idx++, sg.getLiceZaKontakt() != null ? sg.getLiceZaKontakt() : "/");
                ti.setText(idx++, sg.getPoljoGazdinstvo() != null ? (sg.getPoljoGazdinstvo().booleanValue() ? "Da" : "Ne") : "Ne");
                ti.setText(idx++, sg.getRegBrUSudu() != null ? sg.getRegBrUSudu() : "/");
                ti.setText(idx++, sg.getFax() != null ? sg.getFax() : "/");
            }
            ti.setText(idx++, sg.getTelefon() != null ? sg.getTelefon() : "/");
            ti.setText(idx++, sg.getMob() != null ? sg.getMob() : "/");
            ti.setText(idx++, "" + sg.getPopust());
            ti.setText(idx++, sg.getSifra() != null ? sg.getSifra() : "/");
            ti.setText(idx++, sg.getValutaPlacanja() != null ? "" + sg.getValutaPlacanja() : "/");
        }
    }

    public static class PrikazStalnogGostaInput {
        private Restoran restoran;
        private RestoranServer server;
        private Combo sggCombo;
        private Button blk;
        StalniGostiGrupa sgg;
        NacinPlacanja np = null;
        List<Artikal> artikli;
        List<StalniGostiGrupa> grupe;
        SWTContainer parent;

        public PrikazStalnogGostaInput(SWTContainer owner, Restoran r, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.grupe = this.server.readGrupeStGosti();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/pregledV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(barmasterText.getString("TEXT_PRIKAZ_STALNOG_GOSTA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 110;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(barmasterText.getString("TEXT_FILTER_PRIKAZA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            Label kon = new Label((Composite)grupa2, 0);
            kon.setText(String.format(barmasterText.getString("TEXT_GRUPA"), new Object[0]) + ":");
            this.sggCombo = new Combo((Composite)grupa2, 8);
            this.sggCombo.add(String.format(barmasterText.getString("TEXT_SVE_GRUPE"), new Object[0]));
            for (StalniGostiGrupa ko : this.grupe) {
                this.sggCombo.add(ko.getNaziv());
            }
            this.sggCombo.select(0);
            Label blok = new Label((Composite)grupa2, 0);
            blok.setText(String.format(barmasterText.getString("TEXT_PRIKAZI_BLOKIRANE"), new Object[0]) + ":");
            this.blk = new Button((Composite)grupa2, 32);
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            kon.setLayoutData((Object)data);
            blok.setLayoutData((Object)data);
            this.sggCombo.setLayoutData((Object)data);
            this.blk.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            this.sgg = this.sggCombo.getSelectionIndex() == 0 ? null : this.grupe.get(this.sggCombo.getSelectionIndex() - 1);
            this.server.log(String.format(barmasterText.getString("TEXT_PRIKAZ_STALNOG_GOSTA"), new Object[0]));
            Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
            shell2.setText(String.format(barmasterText.getString("TEXT_PRIKAZ_STALNOG_GOSTA"), new Object[0]));
            SWTContainer parent2 = new SWTContainer((Composite)shell2);
            new PrikazStalnogGosta(parent2, this.restoran, this.sgg, this.blk.getSelection());
        }
    }
}

