/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.PregledStolova;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PregledZauzetihStolova {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    SWTContainer parent;
    Shell shell;
    Composite composite;
    List<PregledStolova> stolovi;
    Date day1;
    Date day2;

    private PregledZauzetihStolova(SWTContainer owner, Restoran r, Date d1, Date d2) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.shell = this.parent.getControl().getShell();
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(2, false));
        this.day1 = d1;
        this.day2 = d2;
        this.stolovi = this.server.getStolove(Konstante.getPocetniDatum(this.day1, this.server), Konstante.getKrajnjiDatum(this.day2, this.server));
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        Composite control = new Composite((Composite)this.shell, 0);
        control.setLayout((Layout)new GridLayout(3, false));
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        GridData gd = new GridData(16384, 8, false, false);
        gd.widthHint = 120;
        gd.heightHint = 50;
        Button printButton = new Button(control, 8);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setLayoutData((Object)gd);
        printButton.setText(String.format(Konstante.getBundle().getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PregledZauzetihStolova.this.table), false, true, String.format(Konstante.getBundle().getString("TEXT_PREGLED_ZAUZETOSTI_STOLOVA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(PregledZauzetihStolova.this.day1) + "-->" + StatLogic.getDateString(PregledZauzetihStolova.this.day2), PregledZauzetihStolova.this.shell, PregledZauzetihStolova.this.server);
            }
        });
        Button export = new Button(control, 8);
        export.setLayoutData((Object)gd);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PregledZauzetihStolova.this.table, PregledZauzetihStolova.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        Button exitButton = new Button(control, 16777288);
        GridData gd1 = new GridData(131072, 8, true, false);
        gd1.heightHint = 50;
        gd1.widthHint = 150;
        gd1.horizontalAlignment = 131072;
        exitButton.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
        exitButton.setLayoutData((Object)gd1);
        exitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PregledZauzetihStolova.this.shell.dispose();
            }
        });
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public void makeHeaders() {
        TableColumn tc1 = new TableColumn(this.table, 0x1000000);
        tc1.setText(String.format(Konstante.getBundle().getString("TEXT_STO"), new Object[0]));
        tc1.setWidth(70);
        TableColumn tc2 = new TableColumn(this.table, 0x1000000);
        tc2.setText(String.format(Konstante.getBundle().getString("TEXT_TOTAL"), new Object[0]));
        tc2.setWidth(120);
        TableColumn tc9 = new TableColumn(this.table, 0x1000000);
        tc9.setText(String.format(Konstante.getBundle().getString("TEXT_KOLICINA_RACUNA_SKR"), new Object[0]));
        tc9.setWidth(100);
    }

    public void insertRows() {
        for (PregledStolova ps : this.stolovi) {
            double total = 0.0;
            for (Racun r : this.server.getRacune(ps.getBrojStola())) {
                total += r.total();
            }
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(new String[]{ps.getBrojStola().toString(), Konstante.getNumber2(total), ps.getBrojRacuna().toString()});
        }
    }

    public static class PregledZauzetihStolovaInput {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo grupa;
        private Combo zap;
        SWTContainer parent;

        public PregledZauzetihStolovaInput(SWTContainer owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/pregledV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_PREGLED_ZAUZETIH_STOLOVA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]), new Date(), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]), new Date(), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                Date day1 = this.odDatuma.getResult();
                Date day2 = this.doDatuma.getResult();
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText(String.format(Konstante.getBundle().getString("TEXT_PREGLED_ZAUZETOSTI_STOLOVA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(day1) + " -> " + StatLogic.getDateString(day2));
                SWTContainer parent2 = new SWTContainer((Composite)shell2);
                new PregledZauzetihStolova(parent2, this.restoran, day1, day2);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(Konstante.getBundle().getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

