/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTModels;
import com.dev63.restoran.TrosakRekapitulacija;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.GrupaTroskova;
import com.dev63.restoran.sistem.XLSExporter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PregledTroskovaRekapitulacija
extends SWTModels {
    String[] kolone = new String[]{"", "Grupa troska", "Iznos"};
    int[] sirinaKolone = new int[]{200, 200, 200};
    private Connection connection;
    private java.util.Date datumOd;
    private java.util.Date datumDo;
    private Shell shell;
    private List<GrupaTroskova> grupeTroskova;

    public PregledTroskovaRekapitulacija(SWTContainer owner, List<GrupaTroskova> grupeTroskova, final RestoranServer server, final java.util.Date datumOd, final java.util.Date datumDo) {
        this.grupeTroskova = grupeTroskova;
        this.connection = server.getConnection();
        this.datumOd = datumOd;
        this.datumDo = datumDo;
        this.shell = owner.getControl().getShell();
        this.shell.setLayout((Layout)new GridLayout(2, true));
        final Table table = this.makeTable((Composite)this.shell, this.kolone, this.sirinaKolone, 2, 2);
        this.insertRows(table);
        Composite composite = this.makeComposite((Composite)this.shell, 3, 0, 0, 0, 0);
        GridData gd = new GridData(16384, 8, false, false);
        gd.heightHint = 50;
        gd.widthHint = 150;
        Button printButton = new Button(composite, 8);
        printButton.setImage(ImageCache.getImage("print.gif"));
        printButton.setText(String.format(Konstante.getBundle().getString("TEXT_STAMPA"), new Object[0]));
        printButton.setLayoutData((Object)gd);
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(table), false, true, String.format(Konstante.getBundle().getString("TEXT_PREGLED_TROSKOVA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(datumOd) + "-->" + StatLogic.getDateString(datumDo), PregledTroskovaRekapitulacija.this.shell, server);
            }
        });
        Button export = new Button(composite, 8);
        export.setLayoutData((Object)gd);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(table, PregledTroskovaRekapitulacija.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PregledTroskovaRekapitulacija.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        Button exitButton = new Button(composite, 8);
        GridData gd1 = new GridData(131072, 8, true, false);
        gd1.heightHint = 50;
        gd1.widthHint = 150;
        gd1.horizontalAlignment = 131072;
        exitButton.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
        exitButton.setLayoutData((Object)gd1);
        exitButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledTroskovaRekapitulacija.this.shell.dispose();
            }
        });
        this.shell.setMaximized(true);
        this.shell.open();
    }

    private void insertRows(Table table) {
        double ukupnoPodgrupa = 0.0;
        double ukupniTrosak = 0.0;
        boolean prviRed = true;
        List<TrosakRekapitulacija> troskovi = null;
        try {
            troskovi = this.getTroskoviRekapitulacija();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String nadgrupaStari = "";
        String nadgrupaNovi = "";
        for (TrosakRekapitulacija tRek : troskovi) {
            nadgrupaNovi = tRek.getNadGrupa();
            if (!nadgrupaStari.equals(nadgrupaNovi)) {
                if (!prviRed) {
                    this.napraviRedPodgrupaUkupno(table, ukupnoPodgrupa);
                    this.napraviPrazanRed(table);
                    ukupnoPodgrupa = 0.0;
                }
                this.napraviRedPodgrupaNaziv(table, nadgrupaNovi);
                prviRed = false;
            }
            this.napraviRedTrosak(table, tRek.getGrupa(), tRek.getIznos());
            nadgrupaStari = nadgrupaNovi;
            ukupnoPodgrupa += tRek.getIznos();
            ukupniTrosak += tRek.getIznos();
        }
        this.napraviRedPodgrupaUkupno(table, ukupnoPodgrupa);
        this.napraviPrazanRed(table);
        this.napraviRedPodgrupaUkupno(table, ukupniTrosak);
    }

    private TableItem napraviPrazanRed(Table table) {
        TableItem item = new TableItem(table, 0);
        item.setBackground(this.shell.getDisplay().getSystemColor(19));
        return item;
    }

    private TableItem napraviRedPodgrupaUkupno(Table table, double ukupnoPodgrupa) {
        TableItem item = new TableItem(table, 0);
        double ukupno = Konstante.round(ukupnoPodgrupa, 2);
        item.setText(new String[]{"Ukupno:", "", String.valueOf(ukupno)});
        item.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
        return item;
    }

    private TableItem napraviRedPodgrupaNaziv(Table table, String nazivPodgrupe) {
        TableItem item = new TableItem(table, 0);
        item.setText(new String[]{nazivPodgrupe});
        item.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
        return item;
    }

    private TableItem napraviRedTrosak(Table table, String trosak, double iznos) {
        TableItem item = new TableItem(table, 0);
        item.setText(new String[]{"", trosak, String.valueOf(iznos)});
        return item;
    }

    private List<TrosakRekapitulacija> getTroskoviRekapitulacija() throws SQLException {
        ArrayList<TrosakRekapitulacija> troskovi = new ArrayList<TrosakRekapitulacija>();
        Date odDatuma = new Date(this.datumOd.getTime());
        Date doDatuma = new Date(this.datumDo.getTime());
        String filter = this.getFilter();
        String query = "SELECT gt.naziv, ROUND(SUM(t.iznos),2) AS iznos, \r\n(SELECT gt1.naziv FROM grupatroskova gt1 WHERE gt1.id = gt.NADGRUPA_ID) AS nadGrupa\r\nFROM trosak t\r\nJOIN grupatroskova gt ON t.GRUPA_ID = gt.id\r\nWHERE CAST(t.dan AS DATE) BETWEEN ? AND ?\r\n" + filter + "GROUP BY gt.naziv\r\nORDER BY gt.NADGRUPA_ID";
        PreparedStatement ps = this.connection.prepareStatement(query);
        ps.setDate(1, odDatuma);
        ps.setDate(2, doDatuma);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            TrosakRekapitulacija tRek = new TrosakRekapitulacija();
            tRek.setGrupa(rs.getString("naziv"));
            tRek.setNadGrupa(rs.getString("nadGrupa"));
            tRek.setIznos(rs.getDouble("iznos"));
            troskovi.add(tRek);
        }
        return troskovi;
    }

    private String getFilter() {
        StringBuilder sb = new StringBuilder();
        String filter = "";
        if (this.grupeTroskova.size() > 0) {
            for (GrupaTroskova grupa : this.grupeTroskova) {
                if (grupa.getNadGrupa() == null) continue;
                sb.append("'");
                sb.append(grupa.getNaziv());
                sb.append("'");
                sb.append(",");
            }
            String grupe = sb.toString();
            grupe = grupe.substring(0, grupe.length() - 1);
            filter = "AND gt.naziv IN(" + grupe + ")";
        }
        return filter;
    }
}

