/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.Storno;
import com.dev63.restoran.model.StornoStavka;
import com.dev63.restoran.model.TipStorna;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PregledStorna {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    SWTContainer parent;
    Shell shell;
    Composite composite;
    List<Storno> storna;
    String artikli;
    Date day1;
    Date day2;
    TipStorna ts;

    private PregledStorna(SWTContainer owner, Restoran r, final Date d1, final Date d2, Artikal a, Konobar k, TipStorna ts) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.ts = ts;
        this.shell = this.parent.getControl().getShell();
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout());
        if (this.server.isEmptyDateZD(d1, d2) || this.server.isBeforeDateZD(d2)) {
            Konstante.getPoruka3(this.shell, String.format(this.barmasterText.getString("PORUKA_ZA_IZABRANI_PERIOD_NEMA_PODATAKA"), new Object[0]));
            return;
        }
        this.day1 = Konstante.getPocetniDatum(d1, this.server);
        this.day2 = Konstante.getKrajnjiDatum(d2, this.server);
        this.storna = this.server.getStorna(this.day1, this.day2, a, k);
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        Composite cc = new Composite((Composite)this.shell, 0);
        cc.setLayoutData((Object)new GridData(4, 4, true, false));
        cc.setLayout((Layout)new GridLayout(3, false));
        GridData rd = new GridData(120, 50);
        Button printButton = new Button(cc, 72);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PregledStorna.this.table), false, true, String.format(PregledStorna.this.barmasterText.getString("TEXT_PREGLED_STORNA"), new Object[0]) + ": " + StatLogic.getDateString(d1) + "-->" + StatLogic.getDateString(d2), PregledStorna.this.shell, PregledStorna.this.server);
            }
        });
        printButton.setLayoutData((Object)rd);
        Button export = new Button(cc, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PregledStorna.this.table, PregledStorna.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)rd);
        Button izlaz = new Button(cc, 8);
        rd = new GridData(120, 50);
        rd.grabExcessHorizontalSpace = true;
        rd.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)rd);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledStorna.this.shell.close();
            }
        });
        this.table.addListener(35, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        this.table.addListener(12, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public void makeHeaders() {
        TableColumn tc7 = new TableColumn(this.table, 131072);
        tc7.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_KONOBAR"));
        tc7.setWidth(150);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DATUM"));
        tc3.setWidth(90);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_VREME"));
        tc4.pack();
        TableColumn tc6 = new TableColumn(this.table, 131072);
        tc6.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_STO"));
        tc6.setWidth(60);
        TableColumn tc10 = new TableColumn(this.table, 131072);
        tc10.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_TIP"));
        tc10.setWidth(90);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZNOS"));
        tc1.setWidth(90);
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_STORNIRAO"));
        tc9.setWidth(90);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_ARTIKAL"));
        tc2.setWidth(180);
    }

    public void insertRows() {
        for (Storno r : this.storna) {
            double zbirStavki = 0.0;
            if (this.ts != null && r.getTip() != this.ts) continue;
            for (StornoStavka st : r.getStavke()) {
                zbirStavki += st.getKolicina() * st.getArtikal().getCena();
            }
            TableItem ti = new TableItem(this.table, 0);
            if (r.getTip() == TipStorna.RACUN) {
                ti.setForeground(this.shell.getDisplay().getSystemColor(9));
            }
            ti.setText(new String[]{r.getKonobar().getPunoime(), Konstante.getDate(r.getDatum()), Konstante.getTime(r.getDatum()), r.getBrojStola().toString(), r.getTip().getInterName(), r.getTip() == TipStorna.RACUN ? Konstante.getNumber2(r.total()) : Konstante.getNumber2(zbirStavki), r.getUser()});
            for (StornoStavka st : r.getStavke()) {
                ti = new TableItem(this.table, 0);
                if (r.getTip() == TipStorna.RACUN) {
                    ti.setForeground(this.shell.getDisplay().getSystemColor(9));
                }
                ti.setText(7, st.getKolicina() + " x " + st.getArtikal().getName() + " / " + st.getBrojTure());
            }
        }
    }

    public static class PregledStornaInput {
        private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo artikal;
        private Combo tip;
        private Combo konobar;
        Konobar k;
        Artikal a;
        List<Artikal> artikli;
        List<Konobar> konobari;
        SWTContainer parent;

        public PregledStornaInput(SWTContainer owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.artikli = this.server.ArtikliZaFO();
            this.konobari = this.server.readKonobar();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/pregledV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_PREGLED_STORNA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 110;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(this.barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Label art = new Label((Composite)grupa2, 0);
            art.setText(String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]) + ":");
            this.artikal = new Combo((Composite)grupa2, 8);
            this.artikal.add(String.format(this.barmasterText.getString("TEXT_SVI_ARTIKLI"), new Object[0]));
            for (Artikal artikal : this.artikli) {
                this.artikal.add(artikal.getName());
            }
            this.artikal.select(0);
            Label kon = new Label((Composite)grupa2, 0);
            kon.setText(String.format(this.barmasterText.getString("TEXT_KONOBAR"), new Object[0]) + ":");
            this.konobar = new Combo((Composite)grupa2, 8);
            this.konobar.add(String.format(this.barmasterText.getString("TEXT_SVI_KONOBARI"), new Object[0]));
            for (Konobar konobar : this.konobari) {
                this.konobar.add(konobar.getPunoime());
            }
            this.konobar.select(0);
            Label label = new Label((Composite)grupa2, 0);
            label.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_TIP"));
            this.tip = new Combo((Composite)grupa2, 8);
            this.tip.add(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_SVI_TIPOVI"));
            for (TipStorna ts : TipStorna.values()) {
                this.tip.add(ts.getInterName());
            }
            this.tip.select(0);
            Button button = Dugmici.getCancelButton((Composite)grupa3);
            button.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            kon.setLayoutData((Object)data);
            art.setLayoutData((Object)data);
            label.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            this.konobar.setLayoutData((Object)data);
            this.tip.setLayoutData((Object)data);
            this.artikal.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                Date day1 = this.odDatuma.getResult();
                Date day2 = this.doDatuma.getResult();
                this.a = this.artikal.getSelectionIndex() == 0 ? null : this.artikli.get(this.artikal.getSelectionIndex() - 1);
                this.k = this.konobar.getSelectionIndex() == 0 ? null : this.konobari.get(this.konobar.getSelectionIndex() - 1);
                this.server.log(String.format(this.barmasterText.getString("LOG_PREGLED_STORNA_OD_DATUMA_DO_DATUMA"), StatLogic.getDateString(day1), StatLogic.getDateString(day2)));
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText(String.format(this.barmasterText.getString("TEXT_PREGLED_STORNA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(day1) + " -> " + StatLogic.getDateString(day2));
                SWTContainer parent2 = new SWTContainer((Composite)shell2);
                new PregledStorna(parent2, this.restoran, day1, day2, this.a, this.k, this.tip.getSelectionIndex() > 0 ? TipStorna.values()[this.tip.getSelectionIndex() - 1] : null);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

