/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.TipPrijemnice;
import com.dev63.restoran.model.TipTrebovanja;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.RekonstrukcijaSaPrikazom;
import com.dev63.restoran.sistem.StockValue;
import com.dev63.restoran.sistem.UpravljanjePrijemnicom;
import com.dev63.restoran.sistem.UpravljanjeTrebovanjem;
import com.dev63.restoran.sistem.XLSExporter;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PregledRobnihKartica {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    SWTContainer parent;
    Shell shell;
    Composite composite;
    static boolean crno;
    MenuItem item1;
    private static final ResourceBundle barmasterText;
    Map<Integer, Racun> mapaRacuna = new HashMap<Integer, Racun>();
    Date day1;
    Date day2;
    Artikal a;
    private boolean meniEnabled = false;
    int index = 0;
    String brojBI = "";
    List<Kartica> kartice;
    Date d1;
    Date d2;
    Map<String, Boolean> mapa;
    Odeljenje odabranoOdeljenje;
    boolean inspektor;

    public PregledRobnihKartica(SWTContainer owner, Restoran r, final Date d1, final Date d2, Artikal a1, Map<String, Boolean> mapa, Odeljenje odabranoOdeljenje, boolean inspektor) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.shell = this.parent.getControl().getShell();
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout());
        this.day1 = Konstante.getPocetniDatum(d1, this.server);
        this.day2 = Konstante.getKrajnjiDatum(d2, this.server);
        this.a = a1;
        this.d1 = d1;
        this.d2 = d2;
        this.mapa = mapa;
        this.odabranoOdeljenje = odabranoOdeljenje;
        this.inspektor = inspektor;
        if (this.server.isAfterDateZD(d2)) {
            RekonstrukcijaSaPrikazom rek = new RekonstrukcijaSaPrikazom(this.shell, this.restoran, d2);
            rek.reconstruct();
        }
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem ti = (TableItem)e.item;
                PregledRobnihKartica.this.index = ti.getParent().getSelectionIndex();
                ti.getParent().deselect(ti.getParent().indexOf(ti));
                while ((ti.getText(0) == null || ti.getText().equals("")) && PregledRobnihKartica.this.index > 0) {
                    --PregledRobnihKartica.this.index;
                    ti = ti.getParent().getItem(PregledRobnihKartica.this.index);
                }
                ti.getParent().select(ti.getParent().indexOf(ti));
            }
        });
        this.table.addListener(8, (Listener)new DocumentListener(this.shell, this.restoran, inspektor));
        this.shell.setBackgroundMode(2);
        Composite cc = new Composite((Composite)this.shell, 0);
        cc.setLayoutData((Object)new GridData(4, 4, true, false));
        cc.setLayout((Layout)new GridLayout(3, false));
        GridData rd = new GridData(120, 50);
        Button printButton = new Button(cc, 8);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        printButton.setLayoutData((Object)rd);
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PregledRobnihKartica.this.table), false, true, String.format(barmasterText.getString("TEXT_PREGLED_ROBNIH_KARTICA"), new Object[0]) + " za artikal " + PregledRobnihKartica.this.a.getName() + ": " + StatLogic.getDateString(d1) + " --> " + StatLogic.getDateString(d2), PregledRobnihKartica.this.shell, PregledRobnihKartica.this.server);
            }
        });
        Button export = new Button(cc, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PregledRobnihKartica.this.table, PregledRobnihKartica.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)rd);
        Button izlaz = new Button(cc, 8);
        izlaz.setText(String.format(barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledRobnihKartica.this.shell.close();
            }
        });
        izlaz.setLayoutData((Object)rd);
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    private void makeHeaders() {
        TableColumn tc2 = new TableColumn(this.table, 0x1000000);
        tc2.setText(String.format(barmasterText.getString("TEXT_DATUM"), new Object[0]));
        tc2.setWidth(80);
        TableColumn tc9 = new TableColumn(this.table, 0x1000000);
        tc9.setText(String.format(barmasterText.getString("TEXT_ULAZ"), new Object[0]));
        tc9.setWidth(80);
        TableColumn tc3 = new TableColumn(this.table, 0x1000000);
        tc3.setText(String.format(barmasterText.getString("TEXT_IZLAZ"), new Object[0]) + "(" + String.format(barmasterText.getString("TEXT_KOMAD_SKR"), new Object[0]) + ")");
        tc3.pack();
        TableColumn tc4 = new TableColumn(this.table, 0x1000000);
        tc4.setText(String.format(barmasterText.getString("TEXT_IZLAZ"), new Object[0]) + "(" + String.format(barmasterText.getString("TEXT_JEDINICA_MERE_SKR"), new Object[0]) + ")");
        tc4.pack();
        TableColumn tc6 = new TableColumn(this.table, 0x1000000);
        tc6.setText(String.format(barmasterText.getString("TEXT_STANJE"), new Object[0]));
        tc6.pack();
        TableColumn tc44 = new TableColumn(this.table, 0x1000000);
        tc44.setText(String.format(barmasterText.getString("TEXT_NABAVNA_CENA_SKR"), new Object[0]));
        tc44.pack();
        TableColumn tc77 = new TableColumn(this.table, 0x1000000);
        tc77.setText(String.format(barmasterText.getString("TEXT_VREDNOST_ZALIHA_SKR"), new Object[0]));
        tc77.pack();
        TableColumn tc7 = new TableColumn(this.table, 0x1000000);
        tc7.setText(String.format(barmasterText.getString("TEXT_DOKUMENT"), new Object[0]));
        tc7.pack();
    }

    private void insertRows() {
        StockValue stockValue = new StockValue();
        LinkedList<String> magDok = new LinkedList<String>();
        LinkedList<String> odDok = new LinkedList<String>();
        for (TipPrijemnice tipPrijemnice : TipPrijemnice.values()) {
            magDok.add(tipPrijemnice.getDocMark());
        }
        magDok.add("(p)");
        magDok.add(TipTrebovanja.POVRAT_U_MAGACIN.getDocMark());
        for (Enum enum_ : TipTrebovanja.values()) {
            odDok.add(((TipTrebovanja)enum_).getDocMark());
        }
        odDok.add("pr");
        odDok.add("po");
        odDok.add("otm");
        odDok.add("");
        double stanje = 0.0;
        double vrednost = 0.0;
        double nc = 0.0;
        double ukupanUlaz = 0.0;
        double ukupanIzlaz = 0.0;
        boolean osnovne = this.mapa.get(String.format(barmasterText.getString("TEXT_OSNOVNA_STANJA"), new Object[0]));
        boolean dodatne = false;
        if (this.inspektor) {
            dodatne = this.mapa.get(String.format(barmasterText.getString("TEXT_DODATNA_STANJA"), new Object[0]));
        }
        this.kartice = this.server.readKartice(this.a, this.d1, this.d2, dodatne, osnovne, this.odabranoOdeljenje);
        for (Kartica k : this.kartice) {
            Boolean b;
            Object tr22;
            String trazeni = "";
            trazeni = !k.getDokument().equals("") ? (k.getDokument().trim().contains("Popis") ? String.format(barmasterText.getString("TEXT_POPIS"), new Object[0]) : k.getDokument().split("-")[1]) : "";
            String kljuc = "";
            for (Object tr22 : TipTrebovanja.values()) {
                if (!tr22.getDocMark().equals(trazeni)) continue;
                kljuc = tr22.getInterName();
            }
            if (trazeni.equals("pr")) {
                kljuc = "Kalkulacija";
            }
            if (trazeni.equals("po")) {
                kljuc = "Povratnica";
            }
            if (trazeni.equals("otm")) {
                kljuc = "MagacinOtpremnica";
            }
            if (trazeni.equals("Popis")) {
                kljuc = String.format(barmasterText.getString("TEXT_POPIS"), new Object[0]);
            }
            if (trazeni.equals("")) {
                kljuc = String.format(barmasterText.getString("TEXT_RACUN"), new Object[0]);
            }
            if (!(b = this.mapa.get(kljuc)).booleanValue()) continue;
            nc = 0.0;
            String ulaz = "";
            String izlaz = "";
            stanje += k.getKolicina().doubleValue();
            tr22 = odDok.iterator();
            while (tr22.hasNext()) {
                String string = (String)tr22.next();
                if (!k.getDokument().endsWith(string)) continue;
                nc = k.getNabavnaCena() / (1.0 + Konstante.getPdvPoPG(k.getArtikal().getPoreskaGrupa()));
            }
            double pocetnaVrednost = stockValue.getValue();
            if (k.getKolicina() < 0.0) {
                ukupanIzlaz -= k.getKolicina().doubleValue();
                izlaz = Konstante.getNumber4(0.0 - k.getKolicina());
                stockValue.remove(Math.abs(k.getKolicina()));
            } else {
                ukupanUlaz += k.getKolicina().doubleValue();
                ulaz = Konstante.getNumber4(k.getKolicina());
                stockValue.add(Math.abs(k.getKolicina()), nc);
            }
            vrednost = stockValue.getValue();
            TableItem item = new TableItem(this.table, 0);
            if (nc == 0.0) {
                nc = Math.abs(pocetnaVrednost - vrednost) / Math.abs(k.getKolicina());
            }
            if (k.getDokument() != null && k.getDokument().length() > 5 && k.getDokument().substring(0, 5).equals(String.format(barmasterText.getString("TEXT_POPIS"), new Object[0]))) {
                item.setText(new String[]{Konstante.getDate(k.getDatum()), "", "", "", Konstante.getNumber4(stanje), Konstante.getNumber4(nc), Konstante.getNumber4(vrednost), k.getDokument()});
                item.setBackground(this.shell.getDisplay().getSystemColor(15));
                continue;
            }
            item.setText(new String[]{Konstante.getDate(k.getDatum()), ulaz, k.getIzlazKOM() != null ? k.getIzlazKOM().toString() : "", izlaz, Konstante.getNumber4(stanje), Konstante.getNumber4(nc), Konstante.getNumber4(vrednost), k.getDokument()});
        }
        TableItem item = new TableItem(this.table, 0);
        item = new TableItem(this.table, 0);
        item.setText(new String[]{String.format(barmasterText.getString("TEXT_UKUPNO"), new Object[0]) + ":", Konstante.getNumber4(ukupanUlaz), "", Konstante.getNumber4(ukupanIzlaz), "", "", ""});
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
    }

    static {
        barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    }

    public static class DocumentListener
    implements Listener {
        private Shell shell;
        private Restoran rest;
        private boolean inspektor;

        public DocumentListener(Shell shell, Restoran rest, boolean inspektor) {
            this.shell = shell;
            this.rest = rest;
            this.inspektor = inspektor;
        }

        public void handleEvent(Event event) {
            TableItem ti;
            String docMark;
            Table t = (Table)event.widget;
            int colIndex = -1;
            for (TableColumn tableColumn : t.getColumns()) {
                if (tableColumn.getText().equalsIgnoreCase(String.format(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DOKUMENT"), new Object[0]))) {
                    // empty if block
                }
                colIndex = t.indexOf(tableColumn);
            }
            int rowIdx = t.getSelectionIndex();
            if (colIndex > -1 && rowIdx > -1 && rowIdx < t.getItemCount() && (docMark = (ti = t.getItem(rowIdx)).getText(colIndex)) != null && docMark.length() > 0) {
                HashMap<String, Enum> pMarks = new HashMap<String, Enum>();
                HashMap<String, TipTrebovanja> tMarks = new HashMap<String, TipTrebovanja>();
                for (TipTrebovanja tipTrebovanja : TipTrebovanja.values()) {
                    tMarks.put(tipTrebovanja.getDocMark(), tipTrebovanja);
                }
                for (Enum enum_ : TipPrijemnice.values()) {
                    pMarks.put(((TipPrijemnice)enum_).getDocMark(), enum_);
                }
                if (docMark.contains("(")) {
                    int f = docMark.indexOf("(");
                    int l = docMark.indexOf(")");
                    String typ = docMark.substring(f + 1, l);
                    String string = docMark.substring(0, f);
                    Trebovanje treb = this.rest.getServer().findTrebovanjeByDocMark(string, null);
                    if (treb != null) {
                        new UpravljanjeTrebovanjem(this.shell, this.rest, treb, treb.getU(), treb.getIz(), tMarks.containsKey(typ) ? (TipTrebovanja)((Object)tMarks.get(typ)) : TipTrebovanja.DIREKTNO_SA_KNJIZ, null, true, this.inspektor, true);
                    } else {
                        Prijemnica pr = this.rest.getServer().findPrijemnicaByDocMark(docMark, null);
                        if (pr != null) {
                            new UpravljanjePrijemnicom(this.shell, this.rest, pr, pMarks.containsKey(typ) ? (TipPrijemnice)((Object)pMarks.get(typ)) : TipPrijemnice.PRIJEMNICA, null, true, true);
                        }
                    }
                } else if (docMark.contains("-")) {
                    Prijemnica prijemnica;
                    int f = docMark.lastIndexOf("-");
                    String typ = docMark.substring(f + 1, docMark.length());
                    String mark = docMark.substring(0, f);
                    if (tMarks.containsKey(typ)) {
                        Trebovanje trebovanje = this.rest.getServer().findTrebovanjeByDocMark(docMark, (TipTrebovanja)((Object)tMarks.get(typ)));
                        if (trebovanje != null) {
                            new UpravljanjeTrebovanjem(this.shell, this.rest, trebovanje, trebovanje.getU(), trebovanje.getIz(), trebovanje.getTip(), null, true, this.inspektor, true);
                        }
                    } else if (pMarks.containsKey(typ) && (prijemnica = this.rest.getServer().findPrijemnicaByDocMark(docMark, (TipPrijemnice)((Object)pMarks.get(typ)))) != null) {
                        new UpravljanjePrijemnicom(this.shell, this.rest, prijemnica, prijemnica.getTip(), null, true, true);
                    }
                }
            }
        }
    }

    public static class PregledRobnihKarticaInput {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        Artikal a;
        NacinPlacanja np = null;
        List<Artikal> artikli;
        SWTContainer parent;
        private Combo list;
        private Combo odeljenja;
        private Button osn;
        private Button dod;
        private Button bRacun;
        private Button bPopis;
        private Button kalkulacija;
        private Button povratnica;
        private Button otpremnica;
        Map<String, Boolean> mapa = new HashMap<String, Boolean>();
        List<Button> listaDugmica = new LinkedList<Button>();
        final Text tt;
        List<Odeljenje> svaOdeljenja;
        private Odeljenje odabrano;
        boolean inspektor;

        public PregledRobnihKarticaInput(SWTContainer owner, Restoran r, boolean inspektor) {
            Button b;
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.inspektor = inspektor;
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 180;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(barmasterText.getString("TEXT_FILTER_PREGLEDA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 85;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(4, false));
            grupa21.setText(String.format(barmasterText.getString("TEXT_ULAZNI_DOKUMENTI"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 105;
            Group grupa22 = new Group(panel2, 0);
            grupa22.setLayout((Layout)new GridLayout(4, false));
            grupa22.setText(String.format(barmasterText.getString("TEXT_IZLAZNI_DOKUMENTI"), new Object[0]));
            grupa22.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Label ll = new Label((Composite)grupa2, 0);
            ll.setText(String.format(barmasterText.getString("TEXT_PRETRAGA"), new Object[0]) + ":");
            this.tt = new Text((Composite)grupa2, 2048);
            Label aa = new Label((Composite)grupa2, 0);
            aa.setText(String.format(barmasterText.getString("TEXT_ARTIKAL"), new Object[0]) + ":");
            this.list = new Combo((Composite)grupa2, 2572);
            Label odeljenje = new Label((Composite)grupa2, 0);
            odeljenje.setText(String.format(barmasterText.getString("TEXT_ODELJENJE"), new Object[0]) + ":");
            this.odeljenja = new Combo((Composite)grupa2, 2572);
            Label osnovna = new Label((Composite)grupa2, 0);
            osnovna.setText(String.format(barmasterText.getString("TEXT_OSNOVNA_STANJA"), new Object[0]) + ":");
            this.osn = new Button((Composite)grupa2, 32);
            this.osn.setSelection(true);
            Label dodatna = new Label((Composite)grupa2, 0);
            if (inspektor) {
                dodatna.setText(String.format(barmasterText.getString("TEXT_DODATNA_STANJA"), new Object[0]) + ":");
                this.dod = new Button((Composite)grupa2, 32);
            }
            this.tt.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (tt.getText().length() > 2 && (event.keyCode == 13 || event.keyCode == 0x1000050)) {
                        list.removeAll();
                        server.refresh();
                        Set<String> map = server.getArtikliByName(tt.getText()).keySet();
                        if (map.isEmpty()) {
                            list.add("--- " + String.format(barmasterText.getString("TEXT_NEMA_REZULTATA"), new Object[0]) + " ---");
                        } else {
                            list.add("--- " + String.format(barmasterText.getString("TEXT_IZABERITE_ARTIKAL"), new Object[0]) + " ---");
                            for (String s : map) {
                                list.add(s);
                            }
                        }
                        list.select(0);
                    }
                }
            });
            this.svaOdeljenja = this.server.readOdeljenje();
            this.odeljenja.add("Izaberi odeljenje");
            for (Odeljenje o : this.svaOdeljenja) {
                this.odeljenja.add(o.getNaziv());
            }
            this.odeljenja.select(0);
            this.odeljenja.setEnabled(false);
            this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = list.getSelectionIndex();
                    if (index > 0) {
                        a = server.getArtikal2(list.getItem(index));
                    }
                }
            });
            this.list.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (a != null) {
                        odeljenja.setEnabled(true);
                    } else {
                        odeljenja.setEnabled(false);
                    }
                }
            });
            for (TipTrebovanja tp : TipTrebovanja.values()) {
                if (tp.equals((Object)TipTrebovanja.NARUDZBENICA) || !tp.getTipDokumenta().equals((Object)TipTrebovanja.DokumentAtribut.ULAZNI)) continue;
                b = new Button((Composite)grupa21, 32);
                b.setText(tp.getInterName());
                b.setSelection(true);
                this.listaDugmica.add(b);
            }
            for (TipTrebovanja tp : TipTrebovanja.values()) {
                if (tp.equals((Object)TipTrebovanja.NARUDZBENICA) || !tp.getTipDokumenta().equals((Object)TipTrebovanja.DokumentAtribut.IZLAZNI)) continue;
                b = new Button((Composite)grupa22, 32);
                b.setText(tp.getInterName());
                b.setSelection(true);
                this.listaDugmica.add(b);
            }
            this.bPopis = new Button((Composite)grupa21, 32);
            this.bPopis.setText(String.format(barmasterText.getString("TEXT_POPIS"), new Object[0]));
            this.bPopis.setSelection(true);
            this.bRacun = new Button((Composite)grupa22, 32);
            this.bRacun.setText(String.format(barmasterText.getString("TEXT_RACUN"), new Object[0]));
            this.bRacun.setSelection(true);
            this.kalkulacija = new Button((Composite)grupa21, 32);
            this.kalkulacija.setText(String.format(barmasterText.getString("TEXT_KALKULACIJA"), new Object[0]));
            this.kalkulacija.setSelection(true);
            this.povratnica = new Button((Composite)grupa22, 32);
            this.povratnica.setText(String.format(barmasterText.getString("TEXT_POVRATNICA_N"), new Object[0]));
            this.povratnica.setSelection(true);
            this.otpremnica = new Button((Composite)grupa22, 32);
            this.otpremnica.setText(String.format(barmasterText.getString("TEXT_OTPREMNICA_IZ_MAGACINA"), new Object[0]));
            this.otpremnica.setSelection(true);
            Button laznjak1 = new Button((Composite)grupa21, 32);
            laznjak1.setVisible(false);
            Button laznjak2 = new Button((Composite)grupa21, 32);
            laznjak2.setVisible(false);
            Button laznjak3 = new Button((Composite)grupa22, 32);
            laznjak3.setVisible(false);
            Button laznjak4 = new Button((Composite)grupa22, 32);
            laznjak4.setVisible(false);
            Button laznjak5 = new Button((Composite)grupa22, 32);
            laznjak5.setVisible(false);
            Button all = new Button((Composite)grupa21, 8);
            all.setText(String.format(barmasterText.getString("TEXT_SELEKTUJ_SVE"), new Object[0]));
            all.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    for (Button b : listaDugmica) {
                        for (TipTrebovanja t : TipTrebovanja.values()) {
                            if (!t.getInterName().equals(b.getText()) || !t.getTipDokumenta().equals((Object)TipTrebovanja.DokumentAtribut.ULAZNI)) continue;
                            b.setSelection(true);
                        }
                    }
                    osn.setSelection(true);
                    dod.setSelection(true);
                    bPopis.setSelection(true);
                    kalkulacija.setSelection(true);
                }
            });
            Button none = new Button((Composite)grupa21, 8);
            none.setText(String.format(barmasterText.getString("TEXT_DESELEKTUJ_SVE"), new Object[0]));
            none.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    for (Button b : listaDugmica) {
                        for (TipTrebovanja t : TipTrebovanja.values()) {
                            if (!t.getInterName().equals(b.getText()) || !t.getTipDokumenta().equals((Object)TipTrebovanja.DokumentAtribut.ULAZNI)) continue;
                            b.setSelection(false);
                        }
                    }
                    osn.setSelection(false);
                    dod.setSelection(false);
                    bPopis.setSelection(false);
                    kalkulacija.setSelection(false);
                }
            });
            Button allI = new Button((Composite)grupa22, 8);
            allI.setText(String.format(barmasterText.getString("TEXT_SELEKTUJ_SVE"), new Object[0]));
            allI.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    for (Button b : listaDugmica) {
                        for (TipTrebovanja t : TipTrebovanja.values()) {
                            if (!t.getInterName().equals(b.getText()) || !t.getTipDokumenta().equals((Object)TipTrebovanja.DokumentAtribut.IZLAZNI)) continue;
                            b.setSelection(true);
                        }
                    }
                    osn.setSelection(true);
                    dod.setSelection(true);
                    bRacun.setSelection(true);
                    povratnica.setSelection(true);
                    otpremnica.setSelection(true);
                }
            });
            Button noneI = new Button((Composite)grupa22, 8);
            noneI.setText(String.format(barmasterText.getString("TEXT_DESELEKTUJ_SVE"), new Object[0]));
            noneI.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    for (Button b : listaDugmica) {
                        for (TipTrebovanja t : TipTrebovanja.values()) {
                            if (!t.getInterName().equals(b.getText()) || !t.getTipDokumenta().equals((Object)TipTrebovanja.DokumentAtribut.IZLAZNI)) continue;
                            b.setSelection(false);
                        }
                    }
                    osn.setSelection(false);
                    dod.setSelection(false);
                    bRacun.setSelection(false);
                    povratnica.setSelection(false);
                    otpremnica.setSelection(false);
                }
            });
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            ll.setLayoutData((Object)data);
            aa.setLayoutData((Object)data);
            this.tt.setLayoutData((Object)data);
            this.list.setLayoutData((Object)data);
            odeljenje.setLayoutData((Object)data);
            this.odeljenja.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            this.osn.setLayoutData((Object)data);
            if (inspektor) {
                this.dod.setLayoutData((Object)data);
            }
            osnovna.setLayoutData((Object)data);
            dodatna.setLayoutData((Object)data);
            data.horizontalIndent = 0;
            data.widthHint = 140;
            data.heightHint = 30;
            all.setLayoutData((Object)data);
            none.setLayoutData((Object)data);
            allI.setLayoutData((Object)data);
            noneI.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                if (this.a == null) {
                    Konstante.getPoruka3(this.parent.getControl().getShell(), "Niste izabrali artikal");
                }
                Date day1 = this.odDatuma.getResult();
                Date day2 = this.doDatuma.getResult();
                for (Button btn : this.listaDugmica) {
                    this.mapa.put(btn.getText(), btn.getSelection());
                }
                this.mapa.put(String.format(barmasterText.getString("TEXT_OSNOVNA_STANJA"), new Object[0]), this.osn.getSelection());
                if (this.inspektor) {
                    this.mapa.put(String.format(barmasterText.getString("TEXT_DODATNA_STANJA"), new Object[0]), this.dod.getSelection());
                }
                this.mapa.put(this.bRacun.getText(), this.bRacun.getSelection());
                this.mapa.put(this.bPopis.getText(), this.bPopis.getSelection());
                this.mapa.put(this.kalkulacija.getText(), this.kalkulacija.getSelection());
                this.mapa.put(this.povratnica.getText(), this.povratnica.getSelection());
                this.mapa.put(this.otpremnica.getText(), this.otpremnica.getSelection());
                if (this.odeljenja.getSelectionIndex() <= 0) {
                    Konstante.getPoruka3(this.parent.getControl().getShell(), "Odaberite odeljenje");
                    return;
                }
                this.odabrano = this.svaOdeljenja.get(this.odeljenja.getSelectionIndex() - 1);
                this.server.log(String.format(barmasterText.getString("TEXT_PREGLED_ROBNIH_KARTICA"), new Object[0]) + ": " + String.format(barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + " -> " + StatLogic.getDateString(day1) + " " + String.format(barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + " ->" + StatLogic.getDateString(day2));
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText(String.format(barmasterText.getString("TEXT_PREGLED_ROBNIH_KARTICA"), new Object[0]) + ": " + StatLogic.getDateString(day1) + " -> " + StatLogic.getDateString(day2));
                SWTContainer parent2 = new SWTContainer((Composite)shell2);
                new PregledRobnihKartica(parent2, this.restoran, day1, day2, this.a, this.mapa, this.odabrano, this.inspektor);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

