/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Rezervacija;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.RezervacijeCrna;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class PregledRezervacija {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    TableColumnLayout tcl;
    TableViewer tableV;
    SWTContainer parent;
    Shell shell;
    Composite composite;
    List<Rezervacija> rezervacije1;
    List<Rezervacija> rezervacije;
    MenuItem item1;
    Date day1;
    Date day2;

    private PregledRezervacija(SWTContainer owner, Restoran r, final Date day1, final Date day2) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.shell = new Shell(this.parent.getControl().getShell(), 1264);
        this.shell.setText(String.format(Konstante.getBundle().getString("TEXT_PREGLED_REZERVACIJA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(day1) + " --> " + StatLogic.getDateString(day2));
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout());
        this.day1 = day1;
        this.day2 = day2;
        Composite c = new Composite((Composite)this.shell, 0);
        this.tcl = new TableColumnLayout();
        c.setLayout((Layout)this.tcl);
        this.table = new Table(c, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableV = new TableViewer(this.table);
        GridData data = new GridData(4, 4, true, true);
        c.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        Composite control = new Composite((Composite)this.shell, 0);
        control.setLayout((Layout)new GridLayout(3, false));
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        GridData gd = new GridData(16384, 8, false, false);
        gd.heightHint = 50;
        gd.widthHint = 150;
        Button printButton = new Button(control, 72);
        printButton.setImage(ImageCache.getImage("print.gif"));
        printButton.setText(String.format(Konstante.getBundle().getString("TEXT_STAMPA"), new Object[0]));
        printButton.setLayoutData((Object)gd);
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PregledRezervacija.this.table), false, true, String.format(Konstante.getBundle().getString("TEXT_PREGLED_REZERVACIJA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(day1) + "-->" + StatLogic.getDateString(day2), PregledRezervacija.this.shell, PregledRezervacija.this.server);
            }
        });
        Button editButton = new Button(control, 16777288);
        editButton.setText(String.format(Konstante.getBundle().getString("TEXT_IZMENA_REZERVACIJA"), new Object[0]));
        editButton.setLayoutData((Object)gd);
        editButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Rezervacija r = null;
                IStructuredSelection iSel = (IStructuredSelection)PregledRezervacija.this.tableV.getSelection();
                if (iSel.getFirstElement() != null && iSel.getFirstElement() instanceof Rezervacija) {
                    r = (Rezervacija)iSel.getFirstElement();
                }
                if (r != null) {
                    Shell shell2 = new Shell(PregledRezervacija.this.parent.getControl().getShell(), 2144);
                    RezervacijeCrna.RezervacijeDialog re = new RezervacijeCrna.RezervacijeDialog(SWTContainerClass.makeContainer(shell2, String.format(Konstante.getBundle().getString("TEXT_IZMENA_REZERVACIJA"), new Object[0])), r, PregledRezervacija.this.restoran);
                    SWTContainerClass.makeEnd(shell2);
                    if (re.getResult() != null) {
                        PregledRezervacija.this.server.log(String.format(Konstante.getBundle().getString("TEXT_IZMENA_REZERVACIJA"), new Object[0]) + ": " + re.getResult());
                        PregledRezervacija.this.restoran.getServer().updateRezervacija(re.getResult());
                        PregledRezervacija.this.insertRows();
                    }
                }
            }
        });
        Button export = new Button(control, 8);
        GridData gd1 = new GridData(131072, 8, true, false);
        gd1.heightHint = 50;
        gd1.widthHint = 150;
        gd1.horizontalAlignment = 131072;
        export.setLayoutData((Object)gd1);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PregledRezervacija.this.table, PregledRezervacija.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void makeHeaders() {
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText(String.format(Konstante.getBundle().getString("TEXT_DATUM"), new Object[0]));
        TableViewerColumn tvc1 = new TableViewerColumn(this.tableV, tc1);
        tvc1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Rezervacija r = (Rezervacija)element;
                return StatLogic.getDateString(r.getDatum().getTime());
            }
        });
        this.tcl.setColumnData((Widget)tc1, (ColumnLayoutData)new ColumnWeightData(100, true));
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(String.format(Konstante.getBundle().getString("TEXT_VREME"), new Object[0]));
        TableViewerColumn tvc2 = new TableViewerColumn(this.tableV, tc2);
        tvc2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Rezervacija r = (Rezervacija)element;
                return StatLogic.getTimeString(r.getVreme().getTime());
            }
        });
        this.tcl.setColumnData((Widget)tc2, (ColumnLayoutData)new ColumnWeightData(100, true));
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText(String.format(Konstante.getBundle().getString("TEXT_BROJ_STOLA"), new Object[0]));
        TableViewerColumn tvc9 = new TableViewerColumn(this.tableV, tc9);
        tvc9.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Rezervacija r = (Rezervacija)element;
                return "" + r.getBrStola();
            }
        });
        this.tcl.setColumnData((Widget)tc9, (ColumnLayoutData)new ColumnWeightData(60, true));
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText(String.format(Konstante.getBundle().getString("TEXT_IME"), new Object[0]));
        TableViewerColumn tvc3 = new TableViewerColumn(this.tableV, tc3);
        tvc3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Rezervacija r = (Rezervacija)element;
                return r.getIme();
            }
        });
        this.tcl.setColumnData((Widget)tc3, (ColumnLayoutData)new ColumnWeightData(200, true));
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(String.format(Konstante.getBundle().getString("TEXT_TELEFON"), new Object[0]));
        TableViewerColumn tvc4 = new TableViewerColumn(this.tableV, tc4);
        tvc4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Rezervacija r = (Rezervacija)element;
                return r.getTel();
            }
        });
        this.tcl.setColumnData((Widget)tc4, (ColumnLayoutData)new ColumnWeightData(100, true));
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText(String.format(Konstante.getBundle().getString("TEXT_BROJ_OSOBA"), new Object[0]));
        TableViewerColumn tvc5 = new TableViewerColumn(this.tableV, tc5);
        tvc5.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Rezervacija r = (Rezervacija)element;
                return "" + r.getBrOsoba();
            }
        });
        this.tcl.setColumnData((Widget)tc5, (ColumnLayoutData)new ColumnWeightData(60, true));
        TableColumn tc6 = new TableColumn(this.table, 131072);
        tc6.setText(String.format(Konstante.getBundle().getString("TEXT_NAPOMENA"), new Object[0]));
        TableViewerColumn tvc6 = new TableViewerColumn(this.tableV, tc6);
        tvc6.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Rezervacija r = (Rezervacija)element;
                return r.getNapomena();
            }
        });
        this.tcl.setColumnData((Widget)tc6, (ColumnLayoutData)new ColumnWeightData(150, true));
    }

    private void insertRows() {
        Calendar calOd = Calendar.getInstance();
        calOd.setTime(this.day1);
        calOd.set(11, 0);
        calOd.set(12, 0);
        calOd.set(13, 0);
        calOd.set(14, 0);
        Calendar calDo = Calendar.getInstance();
        calDo.setTime(this.day2);
        calDo.set(11, 23);
        calDo.set(12, 59);
        calDo.set(13, 59);
        calDo.set(14, 999);
        this.rezervacije = this.server.findRezervacijaByDate(calOd, calDo);
        this.tableV.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableV.setInput(this.rezervacije);
        this.tableV.refresh();
    }

    public static class PregledRezervacijaInput {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo grupa;
        private Combo zap;
        SWTContainer parent;
        Shell shell;

        public PregledRezervacijaInput(SWTContainer owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/pregledV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_PREGLED_REZERVACIJA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]), new Date(), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]), new Date(), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                Date day1 = this.odDatuma.getResult();
                Date day2 = this.doDatuma.getResult();
                new PregledRezervacija(this.parent, this.restoran, day1, day2);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(Konstante.getBundle().getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

