/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.fiscal.FiscalException;
import com.dev63.fiscal.fp550.SerialIOException;
import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.PostExample;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.exceptions.MenuVATGroupUndefinedException;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Country;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.Komitent;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.LogRecord;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Storno;
import com.dev63.restoran.model.StornoStavka;
import com.dev63.restoran.model.TipStorna;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.FakturaRacun;
import com.dev63.restoran.sistem.GotovinskiRacun;
import com.dev63.restoran.sistem.HotelskiGostNaplata;
import com.dev63.restoran.sistem.IzmenaStavkiRacuna;
import com.dev63.restoran.sistem.KomitentiBela;
import com.dev63.restoran.sistem.RekonstrukcijaPoUtroscima;
import com.dev63.restoran.sistem.StalniGostiStoloviBela2;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.sistem.fpProtocols.FLinkProtocol;
import com.dev63.restoran.sistem.fpProtocols.metalink.MetaLinkProtocol;
import com.dev63.restoran.stampa.FiskalniRacun;
import com.dev63.restoran.stampa.KopijaRacuna;
import com.dev63.restoran.stampa.StampaBrisanjaRacuna;
import com.dev63.restoran.stampa.StampaStorna;
import com.dev63.restoran.swt.components.PregledStavkeRacuna;
import com.dev63.restoran.swt.components.SWTMessage;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.SerializationUtils;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PregledRacuna2 {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    SWTContainer parent;
    Shell shell;
    Composite composite;
    static List<CrnoPlacanje> crnaPlacanja;
    String artikli;
    static boolean crno;
    MenuItem item1;
    private static final ResourceBundle barmasterText;
    Map<Integer, Racun> mapaRacuna = new HashMap<Integer, Racun>();
    Date day1;
    Date day2;
    Artikal a;
    Konobar k;
    List<NacinPlacanja> belaP;
    List<String> crnaP;
    private boolean dozvoliBrisanje;
    private boolean meniEnabled = false;
    int index = 0;
    private StalniGost sg;
    String brojBI = "";
    List<Map<String, Object>> mapa;
    private PostExample postExample = new PostExample();
    private String cPlacanja;
    private String bPlacanja;
    private boolean BMaster;

    public PregledRacuna2(SWTContainer owner, final Restoran r, final Date d1, final Date d2, final Artikal a1, final Konobar k1, List<NacinPlacanja> bela, List<String> crnaPl, boolean dozvoliBrisanje) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.dozvoliBrisanje = dozvoliBrisanje;
        this.shell = this.parent.getControl().getShell();
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout());
        crno = crnaPl.size() > 0;
        this.day1 = Konstante.getPocetniDatum(d1, this.server);
        this.day2 = Konstante.getKrajnjiDatum(d2, this.server);
        this.a = a1;
        this.k = k1;
        this.belaP = bela;
        this.crnaP = crnaPl;
        this.BMaster = this.server.getSetting(Option.B_MASTER).booleanValue();
        Setting menenbld = this.server.getSetting(Option.MENI);
        try {
            this.meniEnabled = menenbld != null && menenbld.booleanValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bPlacanja = "";
        for (NacinPlacanja nacinPlacanja : bela) {
            this.bPlacanja = this.bPlacanja + nacinPlacanja.getOpis() + ",";
        }
        if (this.bPlacanja.length() > 0) {
            this.bPlacanja = this.bPlacanja.substring(0, this.bPlacanja.length() - 1);
        }
        this.cPlacanja = "";
        for (String string : crnaPl) {
            this.cPlacanja = this.cPlacanja + string + ",";
        }
        if (this.cPlacanja.length() > 0) {
            this.cPlacanja = this.cPlacanja.substring(0, this.cPlacanja.length() - 1);
        }
        this.mapa = this.server.getSviRacuni(d1, d2, a1, k1, this.bPlacanja, this.cPlacanja, new LinkedList<Map<String, Object>>());
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        this.table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                Map<String, Object> mapa_racun = PregledRacuna2.this.mapa.get(PregledRacuna2.this.table.getSelectionIndex());
                Racun r = (Racun)PregledRacuna2.this.server.getBase().find(Racun.class, mapa_racun.get("id"));
                new PregledStavkeRacuna(r, PregledRacuna2.this.server);
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem ti = (TableItem)e.item;
                PregledRacuna2.this.index = ti.getParent().getSelectionIndex();
                ti.getParent().deselect(ti.getParent().indexOf(ti));
                while ((ti.getText(0) == null || ti.getText().equals("")) && PregledRacuna2.this.index > 0) {
                    --PregledRacuna2.this.index;
                    ti = ti.getParent().getItem(PregledRacuna2.this.index);
                }
                ti.getParent().select(ti.getParent().indexOf(ti));
            }
        });
        this.shell.setBackgroundMode(2);
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite.setLayout((Layout)new GridLayout(11, false));
        GridData rd = new GridData(120, 50);
        Button printButton = new Button(composite, 8);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        printButton.setLayoutData((Object)rd);
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PregledRacuna2.this.table), false, true, String.format(barmasterText.getString("TEXT_PREGLED_RACUNA"), new Object[0]) + ": " + StatLogic.getDateString(d1) + " --> " + StatLogic.getDateString(d2), PregledRacuna2.this.shell, PregledRacuna2.this.server);
            }
        });
        Button export = new Button(composite, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PregledRacuna2.this.table, PregledRacuna2.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)rd);
        if (!this.BMaster) {
            Button stampFiskala = new Button(composite, 72);
            try {
                stampFiskala.setImage(ImageCache.getImage("print.gif"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            stampFiskala.setText(String.format(barmasterText.getString("TEXT_STAMPA_FISKALNOG_RACUNA"), new Object[0]));
            stampFiskala.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    block4: {
                        if (PregledRacuna2.this.table.getSelectionIndex() == -1) {
                            return;
                        }
                        try {
                            if (!PregledRacuna2.this.table.isSelected(PregledRacuna2.this.index)) break block4;
                            int odgovor = SWTMessage.showLocalizedWarningDialog(PregledRacuna2.this.shell, "Ovo nije kopija fiskalnog ise\u010dka. \u0160tampom ovog ise\u010dka cete ponovo zadu\u017eiti fiskalni uredjaj.");
                            if (odgovor == 32) {
                                PregledRacuna2.this.stampaFiskalnogRacuna();
                                break block4;
                            }
                            return;
                        }
                        catch (NullPointerException ex) {
                            Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            });
            stampFiskala.setLayoutData((Object)rd);
        }
        Button stampKopijeRac = new Button(composite, 72);
        try {
            stampKopijeRac.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        stampKopijeRac.setText(String.format(barmasterText.getString("TEXT_STAMPA_KOPIJE_RACUNA"), new Object[0]));
        stampKopijeRac.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    Map<String, Object> mapa_racun = PregledRacuna2.this.mapa.get(PregledRacuna2.this.table.getSelectionIndex());
                    Racun r = (Racun)PregledRacuna2.this.server.getBase().find(Racun.class, mapa_racun.get("id"));
                    if (r == null) {
                        return;
                    }
                    if (r.getCrnoPlacanje() == null) {
                        Konstante.getPoruka(PregledRacuna2.this.shell, String.format(barmasterText.getString("PORUKA_ZA_IZABRANI_RACUN_KOPIJA_NIJE_DOZVOLJENA"), new Object[0]));
                        return;
                    }
                    try {
                        new KopijaRacuna(PregledRacuna2.this.server, r);
                    }
                    catch (MenuVATGroupUndefinedException ex) {
                        Logger.getLogger(PregledRacuna2.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                catch (NullPointerException npe) {
                    return;
                }
            }
        });
        stampKopijeRac.setLayoutData((Object)rd);
        Button stampFakGotRac = new Button(composite, 72);
        try {
            stampFakGotRac.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        stampFakGotRac.setText(String.format(barmasterText.getString("TEXT_STAMPA_KOPIJE_FAKTURE"), new Object[0]));
        stampFakGotRac.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PregledRacuna2.this.table.getSelectionIndex() == -1) {
                    return;
                }
                Map<String, Object> mapa_racun = PregledRacuna2.this.mapa.get(PregledRacuna2.this.table.getSelectionIndex());
                Racun r = (Racun)PregledRacuna2.this.server.getBase().find(Racun.class, mapa_racun.get("id"));
                if (r.getCrnoPlacanje() == null) {
                    ArrayList<NacinPlacanja> placanja = new ArrayList<NacinPlacanja>();
                    for (Placanje p : PregledRacuna2.this.server.getPlacanja(r)) {
                        placanja.add(p.getNacin());
                    }
                    String string = PregledRacuna2.this.brojBI = r.getBrojBI() != null && r.getBrojBI().length() > 0 ? r.getBrojBI() : "";
                    if (placanja.contains((Object)NacinPlacanja.FAKTURA)) {
                        new FakturaRacun(PregledRacuna2.this.shell.getDisplay(), PregledRacuna2.this.restoran, r, PregledRacuna2.this.restoran.getStope(), 1, PregledRacuna2.this.brojBI, false, null);
                    } else {
                        new GotovinskiRacun(PregledRacuna2.this.shell.getDisplay(), PregledRacuna2.this.restoran, r, PregledRacuna2.this.restoran.getStope(), PregledRacuna2.this.brojBI);
                    }
                }
            }
        });
        stampFakGotRac.setLayoutData((Object)rd);
        Button izmenaKomitenta = new Button(composite, 72);
        izmenaKomitenta.setText(String.format(barmasterText.getString("TEXT_IZMENA_KOMITENTA"), new Object[0]));
        izmenaKomitenta.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PregledRacuna2.this.table.getSelectionIndex() == -1) {
                    return;
                }
                Map<String, Object> mapa_racun = PregledRacuna2.this.mapa.get(PregledRacuna2.this.table.getSelectionIndex());
                Racun racun = (Racun)PregledRacuna2.this.server.getBase().find(Racun.class, mapa_racun.get("id"));
                if (PregledRacuna2.this.table.getSelectionIndex() != -1 && (racun.isFaktura() || racun.getKomitent() != null)) {
                    try {
                        if (racun.getKomitent() != null) {
                            KomitentiBela kb = new KomitentiBela(PregledRacuna2.this.shell.getDisplay(), PregledRacuna2.this.shell, PregledRacuna2.this.restoran, racun, racun.getKonobar());
                            if (kb.getKomitent() == null) {
                                return;
                            }
                            Komitent k = kb.getKomitent();
                            PregledRacuna2.this.server.log("Promena komitenta na racunu br: " + racun.getId() + ", sa " + racun.getStalniGost().getNaziv() + " na " + k.getNaziv() + "");
                            PregledRacuna2.this.promenaKomitenta(racun, k);
                            PregledRacuna2.this.table.removeAll();
                            PregledRacuna2.this.insertRows();
                        } else {
                            StalniGostiStoloviBela2 s = new StalniGostiStoloviBela2(PregledRacuna2.this.shell.getDisplay(), PregledRacuna2.this.shell, r);
                            if (s.getGost() == null) {
                                return;
                            }
                            PregledRacuna2.this.sg = s.getGost();
                            PregledRacuna2.this.server.log("Promena Stalnog gosta na racunu br: " + racun.getId() + ", sa " + racun.getStalniGost().getNaziv() + " na " + PregledRacuna2.this.sg.getNaziv() + "");
                            PregledRacuna2.this.promenaKomitenta(racun, PregledRacuna2.this.sg);
                            PregledRacuna2.this.table.removeAll();
                            PregledRacuna2.this.insertRows();
                        }
                    }
                    catch (NullPointerException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        izmenaKomitenta.setLayoutData((Object)rd);
        Button izmenaRacuna = new Button(composite, 72);
        izmenaRacuna.setText(String.format(barmasterText.getString("TEXT_IZMENA_RACUNA"), new Object[0]));
        izmenaRacuna.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int index = PregledRacuna2.this.table.getSelectionIndex();
                if (index >= 0) {
                    Map<String, Object> mapa_racun = PregledRacuna2.this.mapa.get(index);
                    Racun racun = (Racun)PregledRacuna2.this.server.getBase().find(Racun.class, mapa_racun.get("id"));
                    IzmenaStavkiRacuna izmena = new IzmenaStavkiRacuna(PregledRacuna2.this.server, racun, PregledRacuna2.this.shell);
                    new RekonstrukcijaPoUtroscima(PregledRacuna2.this.shell, racun.getDatum(), PregledRacuna2.this.server, false);
                    PregledRacuna2.this.mapa = PregledRacuna2.this.server.getSviRacuni(d1, d2, a1, k1, PregledRacuna2.this.bPlacanja, PregledRacuna2.this.cPlacanja, new LinkedList<Map<String, Object>>());
                    PregledRacuna2.this.table.removeAll();
                    PregledRacuna2.this.insertRows();
                } else {
                    Konstante.prikaziMessageBox(PregledRacuna2.this.shell, barmasterText.getString("PORUKA_IZABRANI_RACUN_NIJE_VALIDAN"));
                }
            }
        });
        izmenaRacuna.setLayoutData((Object)rd);
        Button izlaz = new Button(composite, 8);
        rd = new GridData(120, 50);
        rd.horizontalAlignment = 131072;
        rd.grabExcessHorizontalSpace = true;
        rd.horizontalSpan = 1 + (crno ? (dozvoliBrisanje ? 0 : 1) : 2);
        izlaz.setLayoutData((Object)rd);
        izlaz.setText(String.format(barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledRacuna2.this.shell.close();
            }
        });
        Composite cc1 = new Composite((Composite)this.shell, 0);
        cc1.setLayoutData((Object)new GridData(4, 4, true, false));
        cc1.setLayout((Layout)new GridLayout(10, false));
        GridData rd1 = new GridData(120, 50);
        rd1.horizontalAlignment = 16384;
        if (crno) {
            Button izmena = new Button(cc1, 8);
            izmena.setText(String.format(barmasterText.getString("TEXT_PROMENA_N.P._SKR"), new Object[0]));
            izmena.setLayoutData((Object)rd1);
            izmena.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    try {
                        Map<String, Object> mapa_racun = PregledRacuna2.this.mapa.get(PregledRacuna2.this.table.getSelectionIndex());
                        Racun r = (Racun)PregledRacuna2.this.server.getBase().find(Racun.class, mapa_racun.get("id"));
                        if (r.getCrnoPlacanje() == null) {
                            return;
                        }
                        PregledRacuna2.this.promenaNacinaPlacanja(r);
                    }
                    catch (NullPointerException npe) {
                        return;
                    }
                }
            });
            if (dozvoliBrisanje) {
                Button brisanje = new Button(cc1, 8);
                brisanje.setLayoutData((Object)rd1);
                brisanje.setText(String.format(barmasterText.getString("TEXT_BRISANJE_RACUNA"), new Object[0]));
                brisanje.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        PregledRacuna2.this.brisanjeRacuna();
                    }
                });
            }
        }
        if (dozvoliBrisanje) {
            final Menu menu = new Menu((Decorations)this.shell, 8);
            if (crno) {
                this.item1 = new MenuItem(menu, 8);
                this.item1.setText(String.format(barmasterText.getString("TEXT_PROMENA_NACINA_PLACANJA"), new Object[0]));
                this.item1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        try {
                            Map<String, Object> mapa_racun = PregledRacuna2.this.mapa.get(PregledRacuna2.this.table.getSelectionIndex());
                            Racun r = (Racun)PregledRacuna2.this.server.getBase().find(Racun.class, mapa_racun.get("id"));
                            if (r.getCrnoPlacanje() == null) {
                                return;
                            }
                            PregledRacuna2.this.promenaNacinaPlacanja(r);
                        }
                        catch (NullPointerException npe) {
                            return;
                        }
                    }
                });
            }
            if (crno) {
                MenuItem it5 = new MenuItem(menu, 8);
                it5.setText(String.format(barmasterText.getString("TEXT_BRISANJE_RACUNA"), new Object[0]));
                it5.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        PregledRacuna2.this.brisanjeRacuna();
                    }
                });
            }
            this.table.addListener(35, new Listener(){

                public void handleEvent(Event event) {
                    if (PregledRacuna2.this.table.getSelectionIndex() != -1) {
                        Map<String, Object> mapa_racun = PregledRacuna2.this.mapa.get(PregledRacuna2.this.table.getSelectionIndex());
                        Racun r = (Racun)PregledRacuna2.this.server.getBase().find(Racun.class, mapa_racun.get("id"));
                        if (r == null || r.getPlacanja() == null || !r.getPlacanja().isEmpty()) {
                            // empty if block
                        }
                        PregledRacuna2.this.table.setMenu(menu);
                    }
                }
            });
            this.table.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    menu.dispose();
                }
            });
        }
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    private void brisanjeRacuna() {
        try {
            Map<String, Object> mapa_racun = this.mapa.get(this.table.getSelectionIndex());
            Racun r = (Racun)this.server.getBase().find(Racun.class, mapa_racun.get("id"));
            boolean attached = this.server.getBase().contains((Object)r);
            System.out.println(attached);
            Date datumBrisanja = r.getDatum();
            if (r.getCrnoPlacanje() != null) {
                Racun rCopy;
                boolean protelStorno = false;
                System.out.println("r.getCrnoPlacanje() " + r.getCrnoPlacanje());
                if (r.getCrnoPlacanje().trim().equals("HOTELSKI GOST")) {
                    if (this.server.getSetting(Option.RECEPCIJA_PROTEL).booleanValue()) {
                        rCopy = (Racun)SerializationUtils.clone((Serializable)r);
                        for (StavkaRacuna stavkaRacuna : rCopy.getStavke1()) {
                            stavkaRacuna.setKolicina(stavkaRacuna.getKolicina() * -1.0);
                        }
                        try {
                            if (rCopy.getNapomena().equals("")) {
                                String placanje = "";
                                for (Placanje nacinPlacanja : rCopy.getPlacanja()) {
                                    String kljuc;
                                    switch (kljuc = nacinPlacanja.getNacin().getOpis().toUpperCase()) {
                                        case "GOTOVINA": {
                                            placanje = placanje + "1";
                                            break;
                                        }
                                        case "KARTICA": {
                                            placanje = placanje + "2";
                                            break;
                                        }
                                        case "FAKTURA": {
                                            placanje = placanje + "3";
                                            break;
                                        }
                                        case "CEK": {
                                            placanje = placanje + "4";
                                            break;
                                        }
                                        default: {
                                            placanje = placanje + "1";
                                        }
                                    }
                                    placanje = placanje + ",";
                                }
                                this.postExample.sendPOSTCloseInvoiceStornoNova(r, "Payment", r.total(), placanje.substring(0, placanje.length() - 1), String.valueOf(r.getKasa().getId()));
                            } else {
                                this.postExample.sendPOSTCloseInvoiceStorno(rCopy, "Payment", rCopy.total(), rCopy.getNapomena(), String.valueOf(rCopy.getKasa().getId()));
                            }
                            System.out.println("postExample.isSuccess() " + this.postExample.isSuccess());
                            if (this.postExample.isSuccess()) {
                                protelStorno = true;
                            }
                        }
                        catch (IOException | NumberFormatException e) {
                            e.printStackTrace();
                        }
                    } else {
                        protelStorno = true;
                    }
                } else {
                    protelStorno = true;
                }
                if (protelStorno) {
                    try {
                        rCopy = (Racun)SerializationUtils.clone((Serializable)r);
                        for (StavkaRacuna stavkaRacuna : rCopy.getStavke1()) {
                            stavkaRacuna.setKolicina(stavkaRacuna.getKolicina() * -1.0);
                        }
                        if (!this.server.upisDnevnogUtroska(rCopy)) {
                            SWTMessage.showMessageDialog(this.shell, "Neuspesan upis utrosaka u tabeli dnevniutrosak", String.format(barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                            return;
                        }
                        Storno s = new Storno();
                        s.setKonobar(r.getKonobar());
                        s.setBrojStola(r.getBrojStola());
                        s.setDatum(r.getDatum());
                        s.setVremeStorniranja(new Date());
                        s.setTip(TipStorna.RACUN);
                        s.setUser(this.server.getUser() != null ? this.server.getUser().getName() : r.getKonobar().getSkrIme());
                        s.setStavke(new LinkedList<StornoStavka>());
                        for (StavkaRacuna sr : r.getStavke()) {
                            StornoStavka ss = new StornoStavka(sr.getArtikal(), sr.getKolicina(), sr.getTura().getBrojTure(), sr.getVrednostSaPopustom());
                            ss.setStorno(s);
                            s.getStavke().add(ss);
                        }
                        attached = this.server.getBase().contains((Object)r);
                        System.out.println(attached);
                        System.out.println("sada radi perzistenciju");
                        this.server.addStornoJPA(s);
                        this.server.deleteTura(r);
                        attached = this.server.getBase().contains((Object)r);
                        System.out.println(attached);
                        this.server.deleteStavkeRacuna(r);
                        attached = this.server.getBase().contains((Object)r);
                        System.out.println(attached);
                        System.out.println("zavrsava perzistenciju");
                        int n = this.table.getSelectionIndex();
                        attached = this.server.getBase().contains((Object)r);
                        System.out.println(attached);
                        if (attached) {
                            this.server.deleteBlackReceiptJPA(r);
                        }
                        new StampaBrisanjaRacuna(r, this.restoran);
                        this.mapa.remove(n);
                        this.table.removeAll();
                        this.insertRows();
                        this.server.log("Brisanje racuna br: " + r.getId() + "");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        SWTOptionPane.showMessageDialog(SWTComponent.getSWTComponent((Control)this.shell), (Object)ex.getMessage(), String.format(barmasterText.getString("TEXT_BARMASTER"), new Object[0]), 0);
                        Logger.getLogger(PregledRacuna2.class.getCanonicalName()).log(Level.WARNING, ex.getMessage(), ex);
                    }
                    this.server.log(String.format(barmasterText.getString("TEXT_OBRISAN"), new Object[0]) + " " + r);
                } else {
                    Konstante.getPoruka(this.shell, "Racun nije obrisan!");
                    return;
                }
            }
            new RekonstrukcijaPoUtroscima(this.shell, datumBrisanja, this.server, false);
        }
        catch (NullPointerException npe) {
            return;
        }
    }

    private void makeHeaders() {
        TableColumn tc2 = new TableColumn(this.table, 0x1000000);
        tc2.setText(String.format(barmasterText.getString("TEXT_IZNOS"), new Object[0]));
        tc2.setWidth(60);
        TableColumn tc9 = new TableColumn(this.table, 0x1000000);
        tc9.setText(String.format(barmasterText.getString("TEXT_KONOBAR"), new Object[0]));
        tc9.setWidth(80);
        TableColumn tc3 = new TableColumn(this.table, 0x1000000);
        tc3.setText(String.format(barmasterText.getString("TEXT_DATUM"), new Object[0]));
        tc3.setWidth(80);
        TableColumn tc4 = new TableColumn(this.table, 0x1000000);
        tc4.setText(String.format(barmasterText.getString("TEXT_VREME"), new Object[0]));
        tc4.setWidth(50);
        TableColumn tc6 = new TableColumn(this.table, 0x1000000);
        tc6.setText(String.format(barmasterText.getString("TEXT_STO"), new Object[0]));
        tc6.setWidth(60);
        TableColumn tc44 = new TableColumn(this.table, 0x1000000);
        tc44.setText(String.format(barmasterText.getString("TEXT_BROJ"), new Object[0]));
        tc44.setWidth(60);
        TableColumn tc77 = new TableColumn(this.table, 0x1000000);
        tc77.setText(String.format(barmasterText.getString("TEXT_KASA"), new Object[0]));
        tc77.setWidth(60);
        TableColumn tc7 = new TableColumn(this.table, 0x1000000);
        tc7.setText(String.format(barmasterText.getString("TEXT_GOTOVINA"), new Object[0]));
        tc7.setWidth(60);
        TableColumn tc12 = new TableColumn(this.table, 0x1000000);
        tc12.setText(String.format(barmasterText.getString("TEXT_CEK"), new Object[0]));
        tc12.setWidth(60);
        TableColumn tc13 = new TableColumn(this.table, 0x1000000);
        tc13.setText(String.format(barmasterText.getString("TEXT_KARTICA"), new Object[0]));
        tc13.setWidth(60);
        TableColumn tc14 = new TableColumn(this.table, 0x1000000);
        tc14.setText(String.format(barmasterText.getString("TEXT_FAKTURA"), new Object[0]));
        tc14.setWidth(60);
        if (crno) {
            TableColumn tc17 = new TableColumn(this.table, 0x1000000);
            tc17.setText(String.format(barmasterText.getString("TEXT_OSTALO"), new Object[0]));
            tc17.pack();
        }
        if (this.meniEnabled) {
            TableColumn tc22 = new TableColumn(this.table, 0x1000000);
            tc22.setText(String.format(barmasterText.getString("TEXT_MENI"), new Object[0]));
            tc22.setWidth(60);
        }
        TableColumn tc16 = new TableColumn(this.table, 0x1000000);
        tc16.setText(String.format(barmasterText.getString("TEXT_ZATVOREN"), new Object[0]));
        tc16.setWidth(60);
        TableColumn tc10 = new TableColumn(this.table, 0x1000000);
        tc10.setText(String.format(barmasterText.getString("TEXT_KOMITENT"), new Object[0]));
        tc10.setWidth(140);
        TableColumn tc121 = new TableColumn(this.table, 0x1000000);
        tc121.setText(String.format(barmasterText.getString("TEXT_BROJ_ISECKA"), new Object[0]));
        tc121.setWidth(100);
        if (this.hotelskiGostCekiran()) {
            TableColumn tc122 = new TableColumn(this.table, 0x1000000);
            tc122.setText(String.format(barmasterText.getString("TEXT_IME_HOTELSKOG_GOSTA"), new Object[0]));
            tc122.setWidth(100);
        }
    }

    private void insertRows() {
        for (Map<String, Object> m : this.mapa) {
            if (!this.racunZatvoren(m)) continue;
            TableItem ti = new TableItem(this.table, 0);
            if (crno) {
                if (this.meniEnabled) {
                    ti.setText(new String[]{Konstante.getNumber2(m.get("total") == null ? 0.0 : (Double)m.get("total")), "" + m.get("konobar"), "" + m.get("datum"), "" + m.get("vreme"), "" + m.get("sto"), "" + m.get("broj"), "" + m.get("kasa"), "" + m.get("gotovina"), "" + m.get("cek"), "" + m.get("kartica"), "" + m.get("faktura"), "" + m.get("crno"), "" + m.get("meni"), "" + m.get("zatvoren"), "" + m.get("komitent"), "" + m.get("brojIsecka"), "", "" + m.get("imeHotelskogGosta")});
                } else {
                    ti.setText(new String[]{Konstante.getNumber2(m.get("total") == null ? 0.0 : (Double)m.get("total")), "" + m.get("konobar"), "" + m.get("datum"), "" + m.get("vreme"), "" + m.get("sto"), "" + m.get("broj"), "" + m.get("kasa"), "" + m.get("gotovina"), "" + m.get("cek"), "" + m.get("kartica"), "" + m.get("faktura"), "" + m.get("crno"), "" + m.get("zatvoren"), "" + m.get("komitent"), "" + m.get("brojIsecka"), "" + m.get("imeHotelskogGosta")});
                }
            } else if (this.meniEnabled) {
                ti.setText(new String[]{Konstante.getNumber2(m.get("total") == null ? 0.0 : (Double)m.get("total")), "" + m.get("konobar"), "" + m.get("datum"), "" + m.get("vreme"), "" + m.get("sto"), "" + m.get("broj"), "" + m.get("kasa"), "" + m.get("gotovina"), "" + m.get("cek"), "" + m.get("kartica"), "" + m.get("faktura"), "" + m.get("meni"), "" + m.get("zatvoren"), "" + m.get("komitent"), "" + m.get("brojIsecka"), "" + m.get("imeHotelskogGosta")});
            } else {
                ti.setText(new String[]{Konstante.getNumber2(m.get("total") == null ? 0.0 : (Double)m.get("total")), "" + m.get("konobar"), "" + m.get("datum"), "" + m.get("vreme"), "" + m.get("sto"), "" + m.get("broj"), "" + m.get("kasa"), "" + m.get("gotovina"), "" + m.get("cek"), "" + m.get("kartica"), "" + m.get("faktura"), "" + m.get("zatvoren"), "" + m.get("komitent"), "" + m.get("brojIsecka"), "" + m.get("imeHotelskogGosta")});
            }
            if (m.get("popust") == null || !((Double)m.get("popust") > 0.0)) continue;
            ti.setForeground(this.shell.getDisplay().getSystemColor(6));
        }
    }

    private boolean racunZatvoren(Map<String, Object> mapa) {
        return ("" + mapa.get("zatvoren")).equals("DA");
    }

    private void promenaKomitenta(Racun racun, Komitent kom) {
        Racun r = (Racun)this.server.getBase().find(Racun.class, (Object)racun.getId());
        r.setKomitent(kom);
        this.mapa.get(this.table.getSelectionIndex()).put("komitent", kom);
        this.server.updateRacun(r);
        this.server.getBase().refresh((Object)r);
    }

    private void promenaKomitenta(Racun racun, StalniGost stalniGost) {
        Racun r = (Racun)this.server.getBase().find(Racun.class, (Object)racun.getId());
        r.setStalniGost(stalniGost);
        this.mapa.get(this.table.getSelectionIndex()).put("komitent", stalniGost);
        this.server.updateRacun(r);
        this.server.getBase().refresh((Object)r);
    }

    private void promenaNacinaPlacanja(final Racun racun) {
        if (!this.checkHotelReceiptUnlocked(racun)) {
            SWTMessage.showMessageDialog(this.shell, String.format(barmasterText.getString("PORUKA_PLACANJE_NE_MOZE_BITI_PROMENJENO_ZA_IZABRANI_RACUN_DOK_SE_ISTI_NE_STORNIRA_NA_RECEPCIJI"), new Object[0]));
            return;
        }
        final Shell shell2 = new Shell(this.shell.getDisplay());
        shell2.setText(String.format(barmasterText.getString("TEXT_IZBOR_PLACANJA"), new Object[0]));
        final Combo placanje = new Combo((Composite)shell2, 8);
        placanje.add(String.format(barmasterText.getString("TEXT_GOTOVINA"), new Object[0]));
        placanje.add(String.format(barmasterText.getString("TEXT_KARTICA"), new Object[0]));
        placanje.add(String.format(barmasterText.getString("TEXT_CEK"), new Object[0]));
        placanje.select(0);
        Button cancelButt = Dugmici.getCancelButton(shell2);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                shell2.close();
            }
        });
        Button okButt = Dugmici.getOkButton(shell2);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Date datumPromene = racun.getDatum();
                ArrayList<Placanje> placanja = new ArrayList<Placanje>();
                Placanje p = new Placanje();
                p.setRacun(racun);
                p.setIznos(racun.total());
                switch (placanje.getSelectionIndex()) {
                    case 0: {
                        p.setNacin(NacinPlacanja.GOTOVINA);
                        break;
                    }
                    case 1: {
                        p.setNacin(NacinPlacanja.KARTICA);
                        break;
                    }
                    case 2: {
                        p.setNacin(NacinPlacanja.CEK);
                    }
                }
                PregledRacuna2.this.server.log(String.format(barmasterText.getString("TEXT_IZMENA_RACUNA_VREME_NAPLATE"), new Object[0]) + ": " + StatLogic.getDateTimeString(racun.getDatum()) + " nacin placanja: " + racun.getCrnoPlacanje() + " -> " + p.getNacin().name());
                p.setVreme(new Date());
                placanja.add(p);
                racun.setPlacanja(placanja);
                racun.setCrnoPlacanje(null);
                racun.setNaOsnovno(false);
                racun.setDatum(new Date());
                racun.setBrojRacuna(PregledRacuna2.this.server.nextFiscalBillNumber());
                racun.setFiskalniOdstampan(false);
                PregledRacuna2.this.server.updateRacunaNPJPA(racun);
                try {
                    new FiskalniRacun(PregledRacuna2.this.restoran).printFiscal(racun, racun.getKonobar().getSkrIme());
                }
                catch (MenuVATGroupUndefinedException ex) {
                    Logger.getLogger(PregledRacuna2.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (FiscalException ex) {
                    PregledRacuna2.this.restoran.fiscalException(PregledRacuna2.this.shell, ex);
                }
                catch (SQLException ex) {
                    PregledRacuna2.this.restoran.sqlException(PregledRacuna2.this.shell, ex);
                }
                catch (SerialIOException ex) {
                    PregledRacuna2.this.restoran.ioException(PregledRacuna2.this.shell, ex);
                }
                PregledRacuna2.this.server.refresh();
                new PregledRacuna2(SWTContainerClass.makeContainer(new Shell(PregledRacuna2.this.shell.getDisplay()), ""), PregledRacuna2.this.restoran, PregledRacuna2.this.day1, PregledRacuna2.this.day2, PregledRacuna2.this.a, PregledRacuna2.this.k, PregledRacuna2.this.belaP, PregledRacuna2.this.crnaP, PregledRacuna2.this.dozvoliBrisanje);
                shell2.close();
                new RekonstrukcijaPoUtroscima(PregledRacuna2.this.shell, datumPromene, PregledRacuna2.this.server, false);
                PregledRacuna2.this.shell.close();
            }
        });
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        shell2.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 16384;
        data.widthHint = 150;
        data.horizontalSpan = 2;
        placanje.setLayoutData((Object)data);
        SWTContainerClass.setDimension(shell2);
        shell2.open();
    }

    private void stampaFiskalnogRacuna() {
        try {
            int row = this.table.getSelectionIndex();
            if (row < 0) {
                return;
            }
            Map<String, Object> mapa_racun = this.mapa.get(row);
            Racun r = (Racun)this.server.getBase().find(Racun.class, mapa_racun.get("id"));
            if (r == null) {
                return;
            }
            if (r.getFiskalniOdstampan().booleanValue()) {
                Konstante.getPoruka(this.shell, String.format(barmasterText.getString("PORUKA_FISKALNI_RACUN_JE_VEC_ODSTAPAN"), new Object[0]));
                return;
            }
            if (r.getCrnoPlacanje() != null) {
                Konstante.getPoruka(this.shell, String.format(barmasterText.getString("PORUKA_ZA_IZABRANI_RACUN_NEMOGUCA_STAMPA_FISKALA"), new Object[0]));
                return;
            }
            new FiskalniRacun(this.restoran).printFiscal(r, r.getKonobar().getSkrIme());
        }
        catch (MenuVATGroupUndefinedException ex) {
            Logger.getLogger(PregledRacuna2.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FiscalException ex) {
            this.restoran.fiscalException(this.shell, ex);
        }
        catch (SQLException ex) {
            this.restoran.sqlException(this.shell, ex);
        }
        catch (SerialIOException ex) {
            this.restoran.ioException(this.shell, ex);
        }
    }

    public Map<NacinPlacanja, Double> makeMap() {
        EnumMap<NacinPlacanja, Double> mapa = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
        mapa.put(NacinPlacanja.GOTOVINA, 0.0);
        mapa.put(NacinPlacanja.CEK, 0.0);
        mapa.put(NacinPlacanja.KARTICA, 0.0);
        mapa.put(NacinPlacanja.FAKTURA, 0.0);
        return mapa;
    }

    private boolean checkHotelReceiptUnlocked(Racun r) {
        if (r.getCrnoPlacanje() == null) {
            return true;
        }
        Pattern pattern = Pattern.compile(".*hotel.*", 2);
        Matcher matcher = pattern.matcher(r.getCrnoPlacanje());
        if (!matcher.find()) {
            return true;
        }
        Setting hotelExists = this.server.getSetting(Option.RECEPCIJA_POVEZIVANJE);
        if (hotelExists == null || !hotelExists.booleanValue()) {
            return true;
        }
        Setting newType = this.server.getSetting(Option.RECEPCIJA_NOVI_TIP);
        if (newType != null && newType.booleanValue()) {
            try {
                boolean unlocked;
                String userName = "sa";
                String password = "928374";
                String hostName = this.server.getSetting(Option.RECEPCIJA_HOST).stringValue();
                String url = "jdbc:sqlserver://" + hostName + "\\SQLEXPRESS;databaseName=recp";
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
                try (Connection conn = DriverManager.getConnection(url, userName, password);
                     Statement stat = conn.createStatement();){
                    ResultSet rs = stat.executeQuery("SELECT status, id FROM dbo.todo WHERE br_rac = " + r.getBrojRacuna() + ";");
                    String status = null;
                    Integer id = null;
                    while (rs.next()) {
                        status = rs.getString("status");
                        id = rs.getInt("id");
                    }
                    unlocked = false;
                    if (status != null) {
                        if (status.equalsIgnoreCase("S")) {
                            unlocked = true;
                        } else if (status.equalsIgnoreCase("N")) {
                            int ret = stat.executeUpdate("UPDATE dbo.todo SET status = 'D' WHERE id = " + id + ";");
                            unlocked = true;
                        } else if (status.equalsIgnoreCase("A")) {
                            unlocked = false;
                        } else if (status.equalsIgnoreCase("D")) {
                            unlocked = true;
                        }
                    } else {
                        unlocked = false;
                    }
                }
                return unlocked;
            }
            catch (ClassNotFoundException | SQLException ex) {
                Logger.getLogger(HotelskiGostNaplata.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }

    private List<NacinPlacanja> getNacine(Racun t) {
        ArrayList<NacinPlacanja> n = new ArrayList<NacinPlacanja>();
        for (Placanje p : t.getPlacanja()) {
            n.add(p.getNacin());
        }
        return n;
    }

    private void stornoBelogRacuna(Racun r) {
        Date datum = r.getDatum();
        if (r == null || r.getId() == null) {
            SWTMessage.showLocalizedMessageDialog(this.shell, String.format(Konstante.getBundle().getString("PORUKA_IZABRANI_RACUN_NIJE_VALIDAN"), new Object[0]));
            return;
        }
        boolean yesno = Konstante.getPorukaDaNe(this.shell, Konstante.getBundle().getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_STORNIRATE_FISKALNI_RACUN")).isOdgovorPozitivan();
        if (!yesno) {
            return;
        }
        try {
            List<NacinPlacanja> npList = this.getNacine(r);
            if (npList.isEmpty()) {
                SWTMessage.showLocalizedMessageDialog(this.shell, String.format(Konstante.getBundle().getString("PORUKA_IZABRANI_RACUN_NEMA_PODATKE_O_PLACANJU"), new Object[0]));
                return;
            }
            if (r.getZdBroj() != 0L) {
                Racun rCopy = (Racun)SerializationUtils.clone((Serializable)r);
                for (StavkaRacuna stavkaRacuna : rCopy.getStavke1()) {
                    stavkaRacuna.setKolicina(stavkaRacuna.getKolicina() * -1.0);
                }
            }
            Country drzava = this.server.getCurrentCountry();
            Storno s = new Storno(r.getBrojStola(), r.getKonobar());
            s.setTip(TipStorna.RACUN);
            s.setUser(this.server.getUser() == null ? "SYSTEM" : this.server.getUser().getName());
            for (StavkaRacuna sr : r.getStavke()) {
                StornoStavka ss = new StornoStavka(sr.getArtikal(), sr.getKolicina(), r.getBrojStola(), sr.getVrednostSaPopustom());
                s.addStavka(ss);
            }
            if (drzava != null) {
                switch (drzava) {
                    case BIH: {
                        if (Konstante.getTipStampaca() == 21 || Konstante.getTipStampaca() == 22) {
                            Integer n = SWTMessage.showIntInputDialog(this.shell, String.format(Konstante.getBundle().getString("TEXT_BROJ_ISECKA"), new Object[0]) + ":", String.format(Konstante.getBundle().getString("PORUKA_UNESITE_BROJ_ISECKA"), new Object[0]));
                            if (n == null) {
                                System.out.println("Otkazana akcija");
                                return;
                            }
                            int resp = SWTMessage.showLocalizedInfoDialog(this.shell, String.format(Konstante.getBundle().getString("TEXT_BROJ_ISECKA_JE"), new Object[0]) + " " + n);
                            if (resp != 256) {
                                if (Konstante.getTipStampaca() == 21) {
                                    FLinkProtocol.getInstance().stornoRacuna(n, r);
                                    break;
                                }
                                if (Konstante.getTipStampaca() != 22) break;
                                MetaLinkProtocol.getInstance().stornoRacuna(n, r);
                                break;
                            }
                            return;
                        }
                    }
                    default: {
                        new StampaStorna(s, this.restoran);
                    }
                }
            }
            LogRecord logRecord = new LogRecord();
            logRecord.setDan(new Date());
            logRecord.setVreme(new Date());
            logRecord.setUname(this.server.getUser().getName());
            logRecord.setWhat(String.format(Konstante.getBundle().getString("LOG_STORNO_BELOG_RACUNA"), StatLogic.getDateString(r.getDatum()), StatLogic.getNumber02NG(r.total()), npList.size() == 1 ? npList.get(0).getOpis() : String.format(Konstante.getBundle().getString("TEXT_KOMBINOVANO"), new Object[0])));
            this.server.storniranjeBelogRacuna(r, s, logRecord);
            this.mapa.remove(this.table.getSelectionIndex());
            this.table.removeAll();
            this.insertRows();
            new RekonstrukcijaPoUtroscima(this.shell, datum, this.server, false);
        }
        catch (Exception ex) {
            Logger.getLogger(PregledRacuna2.class.getName()).log(Level.WARNING, "Doslo je do greske prilikom storniranja belog racuna", ex);
            Konstante.getPoruka3(this.shell, Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STORNIRANJA_RACUNA"));
        }
    }

    private boolean hotelskiGostCekiran() {
        for (String crno : this.crnaP) {
            if (!crno.contains("HOTELSKI")) continue;
            return true;
        }
        return false;
    }

    static {
        barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    }

    public static class PregledRacunaInput2 {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo artikal;
        private Combo konobar;
        Konobar k;
        Artikal a;
        NacinPlacanja np = null;
        List<Artikal> artikli;
        List<Konobar> konobari;
        SWTContainer parent;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();

        /*
         * WARNING - void declaration
         */
        public PregledRacunaInput2(SWTContainer owner, Restoran r, boolean inspektor) {
            void var21_24;
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.artikli = this.server.ArtikliZaFO();
            this.konobari = this.server.readKonobar();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/pregledV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(barmasterText.getString("TEXT_PREGLED_RACUNA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 110;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 80;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(8, false));
            grupa21.setText(String.format(barmasterText.getString("TEXT_FILTER_NACINA_PLACANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Label art = new Label((Composite)grupa2, 0);
            art.setText(String.format(barmasterText.getString("TEXT_ARTIKAL"), new Object[0]) + ":");
            this.artikal = new Combo((Composite)grupa2, 8);
            this.artikal.add(String.format(barmasterText.getString("TEXT_SVI_ARTIKLI"), new Object[0]));
            for (Artikal artikal : this.artikli) {
                this.artikal.add(artikal.getName());
            }
            this.artikal.select(0);
            Label kon = new Label((Composite)grupa2, 0);
            kon.setText(String.format(barmasterText.getString("TEXT_KONOBAR"), new Object[0]) + ":");
            this.konobar = new Combo((Composite)grupa2, 8);
            this.konobar.add(String.format(barmasterText.getString("TEXT_SVI_KONOBARI"), new Object[0]));
            for (Konobar ko : this.konobari) {
                this.konobar.add(ko.getPunoime());
            }
            this.konobar.select(0);
            boolean bl = false;
            while (var21_24 < NacinPlacanja.values().length) {
                Button b = new Button((Composite)grupa21, 32);
                b.setText(NacinPlacanja.values()[var21_24].getOpis());
                b.setSelection(true);
                this.belaDugmici.add(b);
                ++var21_24;
            }
            if (inspektor) {
                for (CrnoPlacanje cp : this.server.readCrnaPlacanjaIzvestaji()) {
                    if (cp.getNaziv().equals("Medjuzbir")) continue;
                    Button b = new Button((Composite)grupa21, 32);
                    b.setText(cp.getNaziv());
                    this.crnaDugmici.add(b);
                }
            }
            Button button = Dugmici.getCancelButton((Composite)grupa3);
            button.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            kon.setLayoutData((Object)data);
            art.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            this.konobar.setLayoutData((Object)data);
            this.artikal.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                Date day1 = this.odDatuma.getResult();
                Date day2 = this.doDatuma.getResult();
                ArrayList<NacinPlacanja> bela = new ArrayList<NacinPlacanja>();
                for (int i = 0; i < this.belaDugmici.size(); ++i) {
                    Button b = this.belaDugmici.get(i);
                    if (!b.getSelection()) continue;
                    bela.add(NacinPlacanja.values()[i]);
                }
                ArrayList<String> crna = new ArrayList<String>();
                for (Button b : this.crnaDugmici) {
                    if (!b.getSelection()) continue;
                    crna.add(b.getText());
                }
                this.a = this.artikal.getSelectionIndex() == 0 ? null : this.artikli.get(this.artikal.getSelectionIndex() - 1);
                this.k = this.konobar.getSelectionIndex() == 0 ? null : this.konobari.get(this.konobar.getSelectionIndex() - 1);
                this.server.log(String.format(barmasterText.getString("TEXT_PREGLED_RACUNA"), new Object[0]) + ": " + String.format(barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + " -> " + StatLogic.getDateString(day1) + " " + String.format(barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + " ->" + StatLogic.getDateString(day2));
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText(String.format(barmasterText.getString("TEXT_PREGLED_RACUNA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(day1) + " -> " + StatLogic.getDateString(day2));
                SWTContainer parent2 = new SWTContainer((Composite)shell2);
                new PregledRacuna2(parent2, this.restoran, day1, day2, this.a, this.k, bela, crna, true);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

