/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.HacapMagacini;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PregledPrijemaRobe {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    SWTContainer parent;
    Shell shell;
    Composite composite;
    List<Prijemnica> trebovanja;
    private static final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    Date day1;
    Date day2;
    HacapMagacini hm;
    int index = 0;
    private boolean poVozilu;

    public PregledPrijemaRobe(SWTContainer owner, Restoran r, final Date d1, final Date d2, HacapMagacini hm, Boolean poVozilu) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.shell = this.parent.getControl().getShell();
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout());
        this.day1 = Konstante.getPocetniDatum(d1, this.server);
        this.day2 = Konstante.getKrajnjiDatum(d2, this.server);
        this.hm = hm;
        this.poVozilu = poVozilu;
        this.trebovanja = this.server.findPrijemnica(d1, d2);
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem ti = (TableItem)e.item;
                PregledPrijemaRobe.this.index = ti.getParent().getSelectionIndex();
                ti.getParent().deselect(ti.getParent().indexOf(ti));
                while ((ti.getText(0) == null || ti.getText().equals("")) && PregledPrijemaRobe.this.index > 0) {
                    --PregledPrijemaRobe.this.index;
                    ti = ti.getParent().getItem(PregledPrijemaRobe.this.index);
                }
                ti.getParent().select(ti.getParent().indexOf(ti));
            }
        });
        this.shell.setBackgroundMode(2);
        Composite cc = new Composite((Composite)this.shell, 0);
        cc.setLayoutData((Object)new GridData(4, 4, true, false));
        cc.setLayout((Layout)new GridLayout(10, false));
        GridData rd = new GridData(120, 50);
        Button printButton = new Button(cc, 8);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        printButton.setLayoutData((Object)rd);
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PregledPrijemaRobe.this.table), false, true, String.format(barmasterText.getString("TEXT_PREGLED_PRIJEMA_ROBE"), new Object[0]) + ": " + StatLogic.getDateString(d1) + " --> " + StatLogic.getDateString(d2), PregledPrijemaRobe.this.shell, PregledPrijemaRobe.this.server);
            }
        });
        Button export = new Button(cc, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PregledPrijemaRobe.this.table, PregledPrijemaRobe.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)rd);
        Button izlaz = new Button(cc, 8);
        rd = new GridData(120, 50);
        rd.horizontalAlignment = 131072;
        rd.grabExcessHorizontalSpace = true;
        rd.horizontalSpan = 3;
        izlaz.setLayoutData((Object)rd);
        izlaz.setText(String.format(barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledPrijemaRobe.this.shell.close();
            }
        });
        Composite cc1 = new Composite((Composite)this.shell, 0);
        cc1.setLayoutData((Object)new GridData(4, 4, true, false));
        cc1.setLayout((Layout)new GridLayout(10, false));
        GridData rd1 = new GridData(120, 50);
        rd1.horizontalAlignment = 16384;
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    private void makeHeaders() {
        if (this.poVozilu) {
            TableColumn tc2 = new TableColumn(this.table, 0x1000000);
            tc2.setText(String.format(barmasterText.getString("TEXT_DATUM_PRIJEMA"), new Object[0]));
            tc2.setWidth(100);
            TableColumn tc9 = new TableColumn(this.table, 0x1000000);
            tc9.setText(String.format(barmasterText.getString("TEXT_DOBAVLJAC"), new Object[0]));
            tc9.setWidth(160);
            TableColumn tc3 = new TableColumn(this.table, 0x1000000);
            tc3.setText(String.format(barmasterText.getString("TEXT_VREME"), new Object[0]));
            tc3.setWidth(80);
            TableColumn tc4 = new TableColumn(this.table, 0x1000000);
            tc4.setText(String.format(barmasterText.getString("TEXT_REGISTARSKA_TABLICA"), new Object[0]));
            tc4.setWidth(160);
            TableColumn tc6 = new TableColumn(this.table, 0x1000000);
            tc6.setText(String.format(barmasterText.getString("TEXT_TEMPERATURA_NA_PRIJEMU"), new Object[0]));
            tc6.setWidth(160);
            TableColumn tc44 = new TableColumn(this.table, 0x1000000);
            tc44.setText(String.format(barmasterText.getString("TEXT_KONTROLISAO"), new Object[0]));
            tc44.setWidth(200);
            TableColumn tc77 = new TableColumn(this.table, 0x1000000);
            tc77.setText(String.format(barmasterText.getString("TEXT_ZAPRIMLJENO"), new Object[0]));
            tc77.setWidth(100);
        } else {
            TableColumn tc2 = new TableColumn(this.table, 0x1000000);
            tc2.setText(String.format(barmasterText.getString("TEXT_DATUM_PRIJEMA"), new Object[0]));
            tc2.setWidth(90);
            TableColumn tc9 = new TableColumn(this.table, 0x1000000);
            tc9.setText(String.format(barmasterText.getString("TEXT_VREME"), new Object[0]));
            tc9.setWidth(60);
            TableColumn tc3 = new TableColumn(this.table, 0x1000000);
            tc3.setText(String.format(barmasterText.getString("TEXT_TREBOVANJE"), new Object[0]));
            tc3.setWidth(90);
            TableColumn tc4 = new TableColumn(this.table, 0x1000000);
            tc4.setText(String.format(barmasterText.getString("TEXT_DOBAVLJAC"), new Object[0]));
            tc4.setWidth(160);
            TableColumn tc6 = new TableColumn(this.table, 0x1000000);
            tc6.setText(String.format(barmasterText.getString("TEXT_ARTIKAL"), new Object[0]));
            tc6.setWidth(160);
            TableColumn tc44 = new TableColumn(this.table, 0x1000000);
            tc44.setText(String.format(barmasterText.getString("TEXT_KOLICINA_SKR"), new Object[0]));
            tc44.setWidth(40);
            TableColumn tc77 = new TableColumn(this.table, 0x1000000);
            tc77.setText(String.format(barmasterText.getString("TEXT_TEMPERATURA_SKR"), new Object[0]));
            tc77.setWidth(50);
            TableColumn tc7 = new TableColumn(this.table, 0x1000000);
            tc7.setText(String.format(barmasterText.getString("TEXT_USAGLASENO"), new Object[0]));
            tc7.setWidth(80);
            TableColumn tc12 = new TableColumn(this.table, 0x1000000);
            tc12.setText(String.format(barmasterText.getString("TEXT_NAZIV_MAGACINA"), new Object[0]));
            tc12.setWidth(100);
            TableColumn tc13 = new TableColumn(this.table, 0x1000000);
            tc13.setText(String.format(barmasterText.getString("TEXT_KOREKTIVNA_MERA"), new Object[0]));
            tc13.setWidth(80);
            TableColumn tc14 = new TableColumn(this.table, 0x1000000);
            tc14.setText(String.format(barmasterText.getString("TEXT_KONTROLISAO"), new Object[0]));
            tc14.setWidth(80);
        }
    }

    private void insertRows() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        if (this.poVozilu) {
            for (Prijemnica t : this.trebovanja) {
                TableItem ti = new TableItem(this.table, 0);
                ti.setText(new String[]{sdf.format(t.getDatumPrijemnice()), t.getDobavljac().getNaziv(), t.getHacapVreme(), t.getRegOznaka() != null ? t.getRegOznaka() : "/", t.getStavke().get(0).getHacapTemp() != null ? t.getStavke().get(0).getHacapTemp() : "/", t.getKontrolisao() != null ? t.getKontrolisao() : "/", "DA"});
            }
        } else {
            for (Prijemnica t : this.trebovanja) {
                for (PrijemnicaStavka ts : t.getStavke()) {
                    TableItem ti = new TableItem(this.table, 0);
                    String[] stringArray = new String[11];
                    stringArray[0] = sdf.format(t.getDatumPrijemnice());
                    stringArray[1] = t.getHacapVreme();
                    stringArray[2] = t.getBrPrijemnice();
                    stringArray[3] = t.getDobavljac().getNaziv();
                    stringArray[4] = ts.getArtikal().getName();
                    stringArray[5] = String.valueOf(ts.getKolicina());
                    String string = stringArray[6] = ts.getHacapTemp() != null ? ts.getHacapTemp() : "/";
                    stringArray[7] = ts.getUsaglaseno() != null ? (ts.getUsaglaseno().booleanValue() ? "DA" : "NE") : "/";
                    stringArray[8] = ts.getHacapMagacin() != null ? ts.getHacapMagacin().getNaziv() : "/";
                    stringArray[9] = ts.getKorektivnaMera() != null ? ts.getKorektivnaMera() : "/";
                    stringArray[10] = t.getKontrolisao() != null ? t.getKontrolisao() : "/";
                    ti.setText(stringArray);
                }
            }
        }
    }

    public static class PregledPrijemaRobeInput {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo magacini;
        HacapMagacini magacin;
        List<HacapMagacini> hMagacini;
        SWTContainer parent;
        private Button poVozilu;

        public PregledPrijemaRobeInput(SWTContainer owner, Restoran r, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.hMagacini = this.server.readHacapMagacine();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/pregledV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(barmasterText.getString("TEXT_PREGLED_PRIJEMA_ROBE"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 110;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Label art = new Label((Composite)grupa2, 0);
            art.setText(String.format(barmasterText.getString("TEXT_HASAP_MAGACINI"), new Object[0]) + ":");
            this.magacini = new Combo((Composite)grupa2, 8);
            this.magacini.add(String.format(barmasterText.getString("TEXT_SVI_MAGACINI"), new Object[0]));
            for (HacapMagacini ar : this.hMagacini) {
                this.magacini.add(ar.getNaziv());
            }
            this.magacini.select(0);
            Label lVozilo = new Label((Composite)grupa2, 0);
            lVozilo.setText(barmasterText.getString("TEXT_PO_DOSTAVNOM_VOZILU"));
            this.poVozilu = new Button((Composite)grupa2, 32);
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            art.setLayoutData((Object)data);
            lVozilo.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            this.magacini.setLayoutData((Object)data);
            this.poVozilu.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                Date day1 = this.odDatuma.getResult();
                Date day2 = this.doDatuma.getResult();
                this.magacin = this.magacini.getSelectionIndex() == 0 ? null : this.hMagacini.get(this.magacini.getSelectionIndex() - 1);
                this.server.log(String.format(barmasterText.getString("TEXT_PREGLED_PRIJEMA_ROBE"), new Object[0]) + ": " + String.format(barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + " -> " + StatLogic.getDateString(day1) + " " + String.format(barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + " ->" + StatLogic.getDateString(day2));
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText(String.format(barmasterText.getString("TEXT_PREGLED_PRIJEMA_ROBE_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(day1) + " -> " + StatLogic.getDateString(day2));
                SWTContainer parent2 = new SWTContainer((Composite)shell2);
                new PregledPrijemaRobe(parent2, this.restoran, day1, day2, this.magacin, this.poVozilu.getSelection());
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

