/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.fiscal.FiscalException;
import com.dev63.fiscal.fp550.SerialIOException;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.FrontOfficeBezNumerik;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.exceptions.MenuVATGroupUndefinedException;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StalniGostiGrupa;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.FakturaRacun;
import com.dev63.restoran.sistem.StalniGostiStoloviBela2;
import com.dev63.restoran.stampa.FiskalniRacun;
import com.dev63.restoran.swt.components.NewNumeric;
import com.dev63.restoran.swt.components.PregledStavkeRacuna;
import com.dev63.restoran.swt.components.SWTMessage;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PregledOdlozenog {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    SWTContainer parent;
    Shell shell;
    Composite composite;
    List<Racun> racuni;
    List<Racun> racuni1 = new LinkedList<Racun>();
    String artikli;
    private final FiskalniRacun fiskalniRacun;
    private static final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    Map<Integer, Racun> mapaRacuna = new HashMap<Integer, Racun>();
    Date day1;
    Date day2;
    Artikal a;
    private boolean meniEnabled = false;
    int index = 0;
    private static StalniGost sg;
    String brojBI = "";

    public PregledOdlozenog(SWTContainer owner, Restoran r, Date d1, Date d2, StalniGost s) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.fiskalniRacun = new FiskalniRacun(this.restoran);
        this.parent = owner;
        this.shell = this.parent.getControl().getShell();
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout());
        this.day1 = Konstante.getPocetniDatum(d1, this.server);
        this.day2 = Konstante.getKrajnjiDatum(d2, this.server);
        sg = s;
        Setting menenbld = this.server.getSetting(Option.MENI);
        try {
            this.meniEnabled = menenbld != null && menenbld.booleanValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.racuni = this.server.getSviRacuniOdlozeno(this.day1, this.day2, sg);
        this.racuni1.addAll(this.racuni);
        Comparator<Racun> SENIORITY_ORDER = null;
        SENIORITY_ORDER = new Comparator<Racun>(){

            @Override
            public int compare(Racun t1, Racun t2) {
                return t1.getDatum().compareTo(t2.getDatum());
            }
        };
        Collections.sort(this.racuni1, SENIORITY_ORDER);
        this.table = new Table((Composite)this.shell, 66338);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        this.table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                if (PregledOdlozenog.this.table.getSelectionIndex() >= 0) {
                    Racun r = PregledOdlozenog.this.racuni.get(PregledOdlozenog.this.table.getSelectionIndex());
                    new PregledStavkeRacuna(r, PregledOdlozenog.this.server);
                }
            }
        });
        this.shell.setBackgroundMode(2);
        final Composite cc = new Composite((Composite)this.shell, 0);
        cc.setLayoutData((Object)new GridData(4, 4, true, false));
        cc.setLayout((Layout)new GridLayout(10, false));
        GridData rd = new GridData(120, 50);
        Button sve = new Button(cc, 8);
        sve.setText(String.format(barmasterText.getString("TEXT_IZABERI_SVE"), new Object[0]));
        sve.setLayoutData((Object)rd);
        sve.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                for (TableItem ti : PregledOdlozenog.this.table.getItems()) {
                    ti.setChecked(true);
                }
            }
        });
        Button sve1 = new Button(cc, 8);
        sve1.setLayoutData((Object)rd);
        sve1.setVisible(false);
        Button got = new Button(cc, 8);
        got.setText(String.format(barmasterText.getString("TEXT_GOTOVINA"), new Object[0]));
        got.setLayoutData((Object)rd);
        got.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int i = 0;
                boolean okidac = false;
                LinkedList<Racun> selected = new LinkedList<Racun>();
                Racun racun = new Racun();
                racun.setDatum(new Date());
                Placanje p = new Placanje();
                p.setVreme(new Date());
                p.setNacin(NacinPlacanja.GOTOVINA);
                p.setRacun(racun);
                LinkedList<Placanje> pList = new LinkedList<Placanje>();
                pList.add(p);
                racun.setPlacanja(pList);
                LinkedList<Tura> ture = new LinkedList<Tura>();
                double total = 0.0;
                LinkedList<StavkaRacuna> stavke = new LinkedList<StavkaRacuna>();
                for (TableItem t : PregledOdlozenog.this.table.getItems()) {
                    if (t.getChecked()) {
                        okidac = true;
                        Racun r = PregledOdlozenog.this.mapaRacuna.get(i);
                        selected.add(r);
                        total += r.total();
                        ture.addAll(r.getTure());
                        stavke.addAll(r.getStavke1());
                        System.out.println("Racun ID " + r.getId() + " - iznos " + r.total());
                    }
                    ++i;
                }
                racun.setTure(ture);
                for (StavkaRacuna st : stavke) {
                    st.setRacun(racun);
                }
                racun.setStavke1(stavke);
                Konobar k = PregledOdlozenog.this.server.getKonobarMeniPromet();
                if (k == null) {
                    Konstante.getPoruka3(PregledOdlozenog.this.shell, "Konobar nije izabran!");
                    return;
                }
                racun.setKonobar(k);
                racun.setStorniran(false);
                racun.setBrojStola(1);
                racun.setBrojGostiju("10");
                racun.setBrojRacuna(PregledOdlozenog.this.server.nextFiscalBillNumber());
                racun.setZatvoren(Boolean.TRUE);
                racun.setFiskalniOdstampan(false);
                if (okidac) {
                    double rTotal = 0.0;
                    for (StavkaRacuna sr : stavke) {
                        rTotal += sr.getArtikal().getCena() * sr.getKolicina();
                    }
                    if (rTotal != total) {
                        double popust = 0.0;
                        popust = 100.0 - total * 100.0 / rTotal;
                        racun.setPopust(popust);
                    }
                    p.setIznos(total);
                    try {
                        PregledOdlozenog.this.fiskalniRacun.printFiscal(racun, k.getSkrIme());
                    }
                    catch (FiscalException | SerialIOException | MenuVATGroupUndefinedException | SQLException mvgue) {
                        Logger.getLogger(FrontOfficeBezNumerik.class.getName()).log(Level.WARNING, mvgue.getMessage(), mvgue);
                        SWTMessage.showMessageDialog(PregledOdlozenog.this.shell, mvgue.getMessage(), String.format(barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                    }
                    try {
                        PregledOdlozenog.this.server.makeForcedRacunAndTura(racun);
                        for (Racun ra : selected) {
                            PregledOdlozenog.this.server.deleteRacun(ra);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    Konstante.getPoruka3(PregledOdlozenog.this.shell, "Niste nista selektovali");
                    return;
                }
                Konstante.getPoruka3(PregledOdlozenog.this.shell, "Operacija uspesno zavrsena!");
                PregledOdlozenog.this.racuni1.clear();
                PregledOdlozenog.this.racuni = PregledOdlozenog.this.server.getSviRacuniOdlozeno(PregledOdlozenog.this.day1, PregledOdlozenog.this.day2, null);
                PregledOdlozenog.this.racuni1.addAll(PregledOdlozenog.this.racuni);
                PregledOdlozenog.this.insertRows();
            }
        });
        Button cek = new Button(cc, 8);
        cek.setText(String.format(barmasterText.getString("TEXT_CEK"), new Object[0]));
        cek.setLayoutData((Object)rd);
        cek.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int i = 0;
                boolean okidac = false;
                LinkedList<Racun> selected = new LinkedList<Racun>();
                Racun racun = new Racun();
                racun.setDatum(new Date());
                Placanje p = new Placanje();
                p.setVreme(new Date());
                p.setNacin(NacinPlacanja.CEK);
                p.setRacun(racun);
                LinkedList<Placanje> pList = new LinkedList<Placanje>();
                pList.add(p);
                racun.setPlacanja(pList);
                LinkedList<Tura> ture = new LinkedList<Tura>();
                double total = 0.0;
                LinkedList<StavkaRacuna> stavke = new LinkedList<StavkaRacuna>();
                for (TableItem t : PregledOdlozenog.this.table.getItems()) {
                    if (t.getChecked()) {
                        okidac = true;
                        Racun r = PregledOdlozenog.this.mapaRacuna.get(i);
                        selected.add(r);
                        total += r.total();
                        ture.addAll(r.getTure());
                        stavke.addAll(r.getStavke1());
                        System.out.println("Racun ID " + r.getId() + " - iznos " + r.total());
                    }
                    ++i;
                }
                racun.setTure(ture);
                for (StavkaRacuna st : stavke) {
                    st.setRacun(racun);
                }
                racun.setStavke1(stavke);
                Konobar k = PregledOdlozenog.this.server.getKonobarMeniPromet();
                if (k == null) {
                    Konstante.getPoruka3(PregledOdlozenog.this.shell, "Konobar nije izabran!");
                    return;
                }
                racun.setKonobar(k);
                racun.setStorniran(false);
                racun.setBrojStola(1);
                racun.setBrojGostiju("10");
                racun.setBrojRacuna(PregledOdlozenog.this.server.nextFiscalBillNumber());
                racun.setZatvoren(Boolean.TRUE);
                racun.setFiskalniOdstampan(false);
                if (okidac) {
                    double rTotal = 0.0;
                    for (StavkaRacuna sr : stavke) {
                        rTotal += sr.getArtikal().getCena() * sr.getKolicina();
                    }
                    if (rTotal != total) {
                        double popust = 0.0;
                        popust = 100.0 - total * 100.0 / rTotal;
                        racun.setPopust(popust);
                    }
                    p.setIznos(total);
                    try {
                        PregledOdlozenog.this.fiskalniRacun.printFiscal(racun, k.getSkrIme());
                    }
                    catch (FiscalException | SerialIOException | MenuVATGroupUndefinedException | SQLException mvgue) {
                        Logger.getLogger(FrontOfficeBezNumerik.class.getName()).log(Level.WARNING, mvgue.getMessage(), mvgue);
                        SWTMessage.showMessageDialog(PregledOdlozenog.this.shell, mvgue.getMessage(), String.format(barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                    }
                    try {
                        PregledOdlozenog.this.server.makeForcedRacunAndTura(racun);
                        for (Racun ra : selected) {
                            PregledOdlozenog.this.server.deleteRacun(ra);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    Konstante.getPoruka3(PregledOdlozenog.this.shell, "Niste nista selektovali");
                    return;
                }
                Konstante.getPoruka3(PregledOdlozenog.this.shell, "Operacija uspesno zavrsena!");
                PregledOdlozenog.this.racuni1.clear();
                PregledOdlozenog.this.racuni = PregledOdlozenog.this.server.getSviRacuniOdlozeno(PregledOdlozenog.this.day1, PregledOdlozenog.this.day2, null);
                PregledOdlozenog.this.racuni1.addAll(PregledOdlozenog.this.racuni);
                PregledOdlozenog.this.insertRows();
            }
        });
        Button kart = new Button(cc, 8);
        kart.setText(String.format(barmasterText.getString("TEXT_KARTICA"), new Object[0]));
        kart.setLayoutData((Object)rd);
        kart.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int i = 0;
                boolean okidac = false;
                LinkedList<Racun> selected = new LinkedList<Racun>();
                Racun racun = new Racun();
                racun.setDatum(new Date());
                Placanje p = new Placanje();
                p.setVreme(new Date());
                p.setNacin(NacinPlacanja.KARTICA);
                p.setRacun(racun);
                LinkedList<Placanje> pList = new LinkedList<Placanje>();
                pList.add(p);
                racun.setPlacanja(pList);
                LinkedList<Tura> ture = new LinkedList<Tura>();
                double total = 0.0;
                LinkedList<StavkaRacuna> stavke = new LinkedList<StavkaRacuna>();
                for (TableItem t : PregledOdlozenog.this.table.getItems()) {
                    if (t.getChecked()) {
                        okidac = true;
                        Racun r = PregledOdlozenog.this.mapaRacuna.get(i);
                        selected.add(r);
                        total += r.total();
                        ture.addAll(r.getTure());
                        stavke.addAll(r.getStavke1());
                        System.out.println("Racun ID " + r.getId() + " - iznos " + r.total());
                    }
                    ++i;
                }
                racun.setTure(ture);
                for (StavkaRacuna st : stavke) {
                    st.setRacun(racun);
                }
                racun.setStavke1(stavke);
                Konobar k = PregledOdlozenog.this.server.getKonobarMeniPromet();
                if (k == null) {
                    Konstante.getPoruka3(PregledOdlozenog.this.shell, "Konobar nije izabran!");
                    return;
                }
                racun.setKonobar(k);
                racun.setStorniran(false);
                racun.setBrojStola(1);
                racun.setBrojGostiju("10");
                racun.setBrojRacuna(PregledOdlozenog.this.server.nextFiscalBillNumber());
                racun.setZatvoren(Boolean.TRUE);
                racun.setFiskalniOdstampan(false);
                if (okidac) {
                    double rTotal = 0.0;
                    for (StavkaRacuna sr : stavke) {
                        rTotal += sr.getArtikal().getCena() * sr.getKolicina();
                    }
                    if (rTotal != total) {
                        double popust = 0.0;
                        popust = 100.0 - total * 100.0 / rTotal;
                        racun.setPopust(popust);
                    }
                    p.setIznos(total);
                    try {
                        PregledOdlozenog.this.fiskalniRacun.printFiscal(racun, k.getSkrIme());
                    }
                    catch (FiscalException | SerialIOException | MenuVATGroupUndefinedException | SQLException mvgue) {
                        Logger.getLogger(FrontOfficeBezNumerik.class.getName()).log(Level.WARNING, mvgue.getMessage(), mvgue);
                        SWTMessage.showMessageDialog(PregledOdlozenog.this.shell, mvgue.getMessage(), String.format(barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                    }
                    try {
                        PregledOdlozenog.this.server.makeForcedRacunAndTura(racun);
                        for (Racun ra : selected) {
                            PregledOdlozenog.this.server.deleteRacun(ra);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    Konstante.getPoruka3(PregledOdlozenog.this.shell, "Niste nista selektovali");
                    return;
                }
                Konstante.getPoruka3(PregledOdlozenog.this.shell, "Operacija uspesno zavrsena!");
                PregledOdlozenog.this.racuni1.clear();
                PregledOdlozenog.this.racuni = PregledOdlozenog.this.server.getSviRacuniOdlozeno(PregledOdlozenog.this.day1, PregledOdlozenog.this.day2, null);
                PregledOdlozenog.this.racuni1.addAll(PregledOdlozenog.this.racuni);
                PregledOdlozenog.this.insertRows();
            }
        });
        Button fakt = new Button(cc, 8);
        fakt.setText(String.format(barmasterText.getString("TEXT_FAKTURA"), new Object[0]));
        fakt.setLayoutData((Object)rd);
        fakt.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String sif;
                StalniGostiStoloviBela2 sgs = new StalniGostiStoloviBela2(PregledOdlozenog.this.shell.getDisplay(), PregledOdlozenog.this.shell, PregledOdlozenog.this.restoran);
                StalniGost sg = sgs.getGost();
                if (sg == null) {
                    Konstante.getPoruka3(cc.getShell(), "Niste odabrali Preduzece");
                    return;
                }
                int i = 0;
                boolean okidac = false;
                LinkedList<Racun> selected = new LinkedList<Racun>();
                Racun racun = new Racun();
                racun.setDatum(new Date());
                Placanje p = new Placanje();
                p.setVreme(new Date());
                p.setNacin(NacinPlacanja.FAKTURA);
                p.setRacun(racun);
                LinkedList<Placanje> pList = new LinkedList<Placanje>();
                pList.add(p);
                racun.setPlacanja(pList);
                LinkedList<Tura> ture = new LinkedList<Tura>();
                double total = 0.0;
                LinkedList<StavkaRacuna> stavke = new LinkedList<StavkaRacuna>();
                for (TableItem t : PregledOdlozenog.this.table.getItems()) {
                    if (t.getChecked()) {
                        okidac = true;
                        Racun r = PregledOdlozenog.this.mapaRacuna.get(i);
                        selected.add(r);
                        total += r.total();
                        ture.addAll(r.getTure());
                        stavke.addAll(r.getStavke1());
                        System.out.println("Racun ID " + r.getId() + " - iznos " + r.total());
                    }
                    ++i;
                }
                racun.setStalniGost(sg);
                racun.setBrojFakture(PregledOdlozenog.this.server.sledeciBrojFakture());
                racun.setTure(ture);
                for (StavkaRacuna st : stavke) {
                    st.setRacun(racun);
                }
                racun.setStavke1(stavke);
                Konobar k = PregledOdlozenog.this.server.getKonobarMeniPromet();
                if (k == null) {
                    Konstante.getPoruka3(PregledOdlozenog.this.shell, "Konobar nije izabran!");
                    return;
                }
                racun.setKonobar(k);
                racun.setStorniran(false);
                racun.setBrojStola(1);
                racun.setBrojGostiju("10");
                racun.setBrojRacuna(PregledOdlozenog.this.server.nextFiscalBillNumber());
                racun.setZatvoren(Boolean.TRUE);
                racun.setFiskalniOdstampan(false);
                if (okidac) {
                    double rTotal = 0.0;
                    for (StavkaRacuna sr : stavke) {
                        rTotal += sr.getArtikal().getCena() * sr.getKolicina();
                    }
                    if (rTotal != total) {
                        double popust = 0.0;
                        popust = 100.0 - total * 100.0 / rTotal;
                        racun.setPopust(popust);
                    }
                    p.setIznos(total);
                    try {
                        PregledOdlozenog.this.fiskalniRacun.printFiscal(racun, k.getSkrIme());
                    }
                    catch (FiscalException | SerialIOException | MenuVATGroupUndefinedException | SQLException mvgue) {
                        Logger.getLogger(FrontOfficeBezNumerik.class.getName()).log(Level.WARNING, mvgue.getMessage(), mvgue);
                        SWTMessage.showMessageDialog(PregledOdlozenog.this.shell, mvgue.getMessage(), String.format(barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                    }
                    NewNumeric nn = new NewNumeric(new HashMap<String, String>());
                    sif = nn.vratiSifru();
                    String napomena = "";
                    napomena = nn.vratiNapomenu();
                    racun.setNapomena(napomena);
                    racun.setBrojBI(sif);
                    try {
                        PregledOdlozenog.this.server.makeForcedRacunAndTura(racun);
                        for (Racun ra : selected) {
                            PregledOdlozenog.this.server.deleteRacun(ra);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    Konstante.getPoruka3(PregledOdlozenog.this.shell, "Niste nista selektovali");
                    return;
                }
                Konstante.getPoruka3(PregledOdlozenog.this.shell, "Operacija uspesno zavrsena!");
                PregledOdlozenog.this.racuni1.clear();
                PregledOdlozenog.this.racuni = PregledOdlozenog.this.server.getSviRacuniOdlozeno(PregledOdlozenog.this.day1, PregledOdlozenog.this.day2, null);
                PregledOdlozenog.this.racuni1.addAll(PregledOdlozenog.this.racuni);
                PregledOdlozenog.this.insertRows();
                racun = (Racun)PregledOdlozenog.this.server.getBase().find(Racun.class, (Object)racun.getId());
                int brojKopija = PregledOdlozenog.this.server.getSetting(Option.BROJ_KOPIJA_FAKTURE).intValue();
                new FakturaRacun(PregledOdlozenog.this.shell.getDisplay(), PregledOdlozenog.this.restoran, racun, PregledOdlozenog.this.restoran.getStope(), brojKopija, sif, false, null);
                PregledOdlozenog.this.server.incrementBrojFakture(String.valueOf(racun.getBrojFakture() + 1));
            }
        });
        Button izlaz = new Button(cc, 8);
        rd = new GridData(120, 50);
        rd.horizontalAlignment = 131072;
        rd.grabExcessHorizontalSpace = true;
        rd.horizontalSpan = 3;
        izlaz.setLayoutData((Object)rd);
        izlaz.setText(String.format(barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledOdlozenog.this.shell.close();
            }
        });
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    private void makeHeaders() {
        TableColumn tc0 = new TableColumn(this.table, 0x1000000);
        tc0.setText("");
        tc0.setWidth(40);
        TableColumn tc2 = new TableColumn(this.table, 0x1000000);
        tc2.setText(String.format(barmasterText.getString("TEXT_IZNOS"), new Object[0]));
        tc2.setWidth(60);
        TableColumn tc9 = new TableColumn(this.table, 0x1000000);
        tc9.setText(String.format(barmasterText.getString("TEXT_KONOBAR"), new Object[0]));
        tc9.setWidth(80);
        TableColumn tc3 = new TableColumn(this.table, 0x1000000);
        tc3.setText(String.format(barmasterText.getString("TEXT_DATUM"), new Object[0]));
        tc3.setWidth(80);
        TableColumn tc4 = new TableColumn(this.table, 0x1000000);
        tc4.setText(String.format(barmasterText.getString("TEXT_VREME"), new Object[0]));
        tc4.setWidth(50);
        TableColumn tc6 = new TableColumn(this.table, 0x1000000);
        tc6.setText(String.format(barmasterText.getString("TEXT_STO"), new Object[0]));
        tc6.setWidth(60);
        TableColumn tc44 = new TableColumn(this.table, 0x1000000);
        tc44.setText(String.format(barmasterText.getString("TEXT_BROJ"), new Object[0]));
        tc44.setWidth(60);
        TableColumn tc77 = new TableColumn(this.table, 0x1000000);
        tc77.setText(String.format(barmasterText.getString("TEXT_KASA"), new Object[0]));
        tc77.setWidth(60);
        TableColumn tc7 = new TableColumn(this.table, 0x1000000);
        tc7.setText(String.format(barmasterText.getString("TEXT_GOTOVINA"), new Object[0]));
        tc7.setWidth(60);
        TableColumn tc12 = new TableColumn(this.table, 0x1000000);
        tc12.setText(String.format(barmasterText.getString("TEXT_CEK"), new Object[0]));
        tc12.setWidth(60);
        TableColumn tc13 = new TableColumn(this.table, 0x1000000);
        tc13.setText(String.format(barmasterText.getString("TEXT_KARTICA"), new Object[0]));
        tc13.setWidth(60);
        TableColumn tc14 = new TableColumn(this.table, 0x1000000);
        tc14.setText(String.format(barmasterText.getString("TEXT_FAKTURA"), new Object[0]));
        tc14.setWidth(60);
        TableColumn tc17 = new TableColumn(this.table, 0x1000000);
        tc17.setText(String.format(barmasterText.getString("TEXT_OSTALO"), new Object[0]));
        tc17.pack();
        if (this.meniEnabled) {
            TableColumn tc22 = new TableColumn(this.table, 0x1000000);
            tc22.setText(String.format(barmasterText.getString("TEXT_MENI"), new Object[0]));
            tc22.setWidth(60);
        }
        TableColumn tc16 = new TableColumn(this.table, 0x1000000);
        tc16.setText(String.format(barmasterText.getString("TEXT_ZATVOREN"), new Object[0]));
        tc16.setWidth(60);
        TableColumn tc10 = new TableColumn(this.table, 0x1000000);
        tc10.setText(String.format(barmasterText.getString("TEXT_KOMITENT"), new Object[0]));
        tc10.setWidth(140);
        TableColumn tc121 = new TableColumn(this.table, 0x1000000);
        tc121.setText(String.format(barmasterText.getString("TEXT_BROJ_ISECKA"), new Object[0]));
        tc121.setWidth(100);
    }

    private void insertRows() {
        this.table.removeAll();
        for (Racun r : this.racuni1) {
            Map<NacinPlacanja, Double> mapa = this.makeMap();
            r.setStavke1(this.server.getStavke(r));
            double total = r.total();
            if (r.getCrnoPlacanje() == null) {
                if (r.getPlacanja().size() > 0) {
                    for (Placanje pl : r.getPlacanja()) {
                        mapa.put(pl.getNacin(), pl.getIznos());
                    }
                } else {
                    for (Placanje pl : r.getPlacanja()) {
                        mapa.put(pl.getNacin(), pl.getIznos());
                        total += pl.getIznos();
                    }
                }
            }
            TableItem ti = new TableItem(this.table, 0);
            this.mapaRacuna.put(this.table.indexOf(ti), r);
            if (r.getPopust() > 0.0) {
                ti.setForeground(this.shell.getDisplay().getSystemColor(6));
            }
            ti.setText(new String[]{"", Konstante.getNumber2(total), r.getKonobar().getPunoime(), Konstante.getDate(r.getDatum()), Konstante.getTime(r.getDatum()), r.getBrojStola().toString(), r.getBrojRacuna() != null ? "" + r.getBrojRacuna() : "", r.getKasa() != null ? "" + r.getKasa().getOznaka() : "", Konstante.getNumber2(mapa.get((Object)NacinPlacanja.GOTOVINA)), Konstante.getNumber2(mapa.get((Object)NacinPlacanja.CEK)), Konstante.getNumber2(mapa.get((Object)NacinPlacanja.KARTICA)), Konstante.getNumber2(mapa.get((Object)NacinPlacanja.FAKTURA))});
            int i = 11;
            if (this.meniEnabled) {
                ti.setText(i++, r.getMeniPromet() != null ? r.getMeniPromet().getNaziv() : "");
            }
            ti.setText(i++, r.getZatvoren() != false ? String.format(barmasterText.getString("TEXT_DA"), new Object[0]) : String.format(barmasterText.getString("TEXT_NE"), new Object[0]));
            ti.setText(i++, r.getStalniGost() != null ? r.getStalniGost().getNaziv() : (r.getKomitent() != null ? "GotRac: " + r.getKomitent().getNaziv() : ""));
            ti.setText(i++, r.getBrojBI() != null ? r.getBrojBI() : "");
        }
    }

    public Map<NacinPlacanja, Double> makeMap() {
        EnumMap<NacinPlacanja, Double> mapa = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
        mapa.put(NacinPlacanja.GOTOVINA, 0.0);
        mapa.put(NacinPlacanja.CEK, 0.0);
        mapa.put(NacinPlacanja.KARTICA, 0.0);
        mapa.put(NacinPlacanja.FAKTURA, 0.0);
        return mapa;
    }

    public static class PregledOdlozenogInput2 {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo grupa;
        private Combo stalni;
        NacinPlacanja np = null;
        List<StalniGostiGrupa> grupe;
        List<StalniGost> gosti;
        SWTContainer parent;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();

        public PregledOdlozenogInput2(SWTContainer owner, Restoran r, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.grupe = this.server.readGrupeStGosti();
            this.gosti = this.server.readStalniGosti();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/pregledV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(barmasterText.getString("TEXT_PREGLED_ODLOZENOG_PLACANJA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 110;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Label gr = new Label((Composite)grupa2, 0);
            gr.setText(String.format(barmasterText.getString("TEXT_IZBOR_GRUPE"), new Object[0]) + ":");
            this.grupa = new Combo((Composite)grupa2, 8);
            this.grupa.add(String.format(barmasterText.getString("TEXT_SVE_GRUPE"), new Object[0]));
            for (StalniGostiGrupa stalniGostiGrupa : this.grupe) {
                this.grupa.add(stalniGostiGrupa.getNaziv());
            }
            this.grupa.select(0);
            this.grupa.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (grupa.getSelectionIndex() == 0) {
                        gosti = server.readStalniGosti();
                        stalni.removeAll();
                        stalni.add(String.format(barmasterText.getString("TEXT_SVI_STALNIGOSTI"), new Object[0]));
                        for (StalniGost sg : gosti) {
                            stalni.add(sg.getNaziv());
                        }
                        stalni.select(0);
                    } else {
                        StalniGostiGrupa sgg = grupe.get(grupa.getSelectionIndex() - 1);
                        gosti = server.readStalniGostiByGroup(sgg);
                        stalni.removeAll();
                        stalni.add("Izaberite stalnog gosta");
                        for (StalniGost sg : gosti) {
                            stalni.add(sg.getNaziv());
                        }
                        stalni.select(0);
                    }
                }
            });
            Label kon = new Label((Composite)grupa2, 0);
            kon.setText(String.format(barmasterText.getString("TEXT_STALNI_GOST"), new Object[0]) + ":");
            this.stalni = new Combo((Composite)grupa2, 8);
            this.stalni.add(String.format(barmasterText.getString("TEXT_SVI_STALNIGOSTI"), new Object[0]));
            for (StalniGost ko : this.gosti) {
                this.stalni.add(ko.getNaziv());
            }
            this.stalni.select(0);
            Button button = Dugmici.getCancelButton((Composite)grupa3);
            button.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            kon.setLayoutData((Object)data);
            gr.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            this.stalni.setLayoutData((Object)data);
            this.grupa.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                Date day1 = this.odDatuma.getResult();
                Date day2 = this.doDatuma.getResult();
                if (this.stalni.getSelectionIndex() == 0) {
                    sg = null;
                } else {
                    sg = this.gosti.get(this.stalni.getSelectionIndex() - 1);
                }
                this.server.log(String.format(barmasterText.getString("TEXT_PREGLED_ODLOZENOG_PLACANJA"), new Object[0]) + ": " + String.format(barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + " -> " + StatLogic.getDateString(day1) + " " + String.format(barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + " ->" + StatLogic.getDateString(day2));
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText(String.format(barmasterText.getString("TEXT_PREGLED_ODLOZENIH_RACUNA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(day1) + " -> " + StatLogic.getDateString(day2));
                SWTContainer parent2 = new SWTContainer((Composite)shell2);
                new PregledOdlozenog(parent2, this.restoran, day1, day2, sg);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

