/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.restoran.NabavneCene;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.ZD;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PodaciZaRealizaciju {
    RestoranServer server;
    Connection connection;

    public PodaciZaRealizaciju(RestoranServer server) {
        this.server = server;
        this.connection = server.getConnection();
    }

    public double ukupanPrometZaZdBroj(long zdBroj) {
        double promet = 0.0;
        String query = "SELECT ROUND(SUM(if(a.dozvoljenPopust = 1, \t\t(sr.kolicina *(sr.cena - (sr.cena * r.popust/100))), \t\t(sr.kolicina * sr.cena))),2) AS promet \tFROM stavkaracuna sr \t\tJOIN racun r ON sr.RACUN_ID = r.id \t\tJOIN artikal a ON sr.ARTIKAL_ID = a.id \t\t\tWHERE r.zdBroj = ? and r.zatvoren = 1 ";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setLong(1, zdBroj);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                promet = rs.getDouble("promet");
            }
            return promet;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return promet;
        }
    }

    public int brojRacunaZaZdBroj(long zdBroj) {
        int brojRacuna = 0;
        String query = "SELECT COUNT(r.id) AS brojRacuna  \t\tFROM racun r WHERE r.zdBroj = ? and r.zatvoren = 1";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setLong(1, zdBroj);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                brojRacuna = rs.getInt("brojRacuna");
            }
            return brojRacuna;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return brojRacuna;
        }
    }

    public double nabavnaVrednostZaZdBroj(long zdBroj, Date datumNbavneCene) {
        double nabavnaVrednost = 0.0;
        Map<Long, Double> stavkeKolicina = this.stavkeIKolicinaZaZdBroj(zdBroj);
        for (Map.Entry<Long, Double> e : stavkeKolicina.entrySet()) {
            Artikal a = this.server.getArtikal(e.getKey());
            Odeljenje o = a.getOdeljenje();
            Map<String, Double> nabavneCene = NabavneCene.getPosednjaNabavna(a, datumNbavneCene, o, false, 0, 1, this.server);
            double nabavnaCenaZaArtikal = nabavneCene.get("NCpoJMsaPDV");
            double kolicina = e.getValue();
            nabavnaVrednost += kolicina * nabavnaCenaZaArtikal;
        }
        return nabavnaVrednost;
    }

    public double sgPopustZaZdBroj(long zdBroj) {
        double SgPopust = 0.0;
        String query = "SELECT SUM(cena * kolicina * popust/100) AS SgPopust \tFROM(SELECT sr.naziv, sr.kolicina,sr.cena, r.popust,    \t\t\tsg.naziv AS SGNaziv FROM stavkaracuna sr  \t\tJOIN racun r ON sr.RACUN_ID = r.id \t\tJOIN konobar k ON r.KONOBAR_ID = k.id \t\tJOIN stalnigost sg ON k.sifra = sg.sifra \t\t\tWHERE r.zdBroj = ? AND r.STALNIGOST_ID = sg.id) AS trt ";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setLong(1, zdBroj);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                SgPopust = rs.getDouble("SgPopust");
            }
            return SgPopust;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return SgPopust;
        }
    }

    public double ukupanTrosakZaDatum(Date datumTroska) {
        double ukupanTrosak = 0.0;
        java.sql.Date datum = new java.sql.Date(datumTroska.getTime());
        String query = "SELECT round(SUM(tr.iznos),2) AS ukupanTrosakZaDan FROM trosak tr WHERE cast(tr.dan AS DATE) = ?";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setDate(1, datum);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ukupanTrosak = rs.getDouble("ukupanTrosakZaDan");
            }
            return ukupanTrosak;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return ukupanTrosak;
        }
    }

    public double ukupnaNabavkaZaDatum(Date datumNabavke) {
        double ukupnaNabavka = 0.0;
        java.sql.Date datum = new java.sql.Date(datumNabavke.getTime());
        String query = "SELECT  ROUND(SUM(ts.kolicina * ts.komad),2) as ukupnaNabavka FROM trebovanjestavka ts \r\nJOIN trebovanje t ON ts.TREBOVANJE_ID = t.id \r\nWHERE t.datumTrebovanja = ? AND t.tip IN ('DIREKTNO_SA_KNJIZ', 'DIREKTNO_BEZ_KNIZENJA')";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setDate(1, datum);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ukupnaNabavka = rs.getDouble("ukupnaNabavka");
            }
            return ukupnaNabavka;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return ukupnaNabavka;
        }
    }

    public double vrednostOtpisa(Date datumOtpisa) {
        double nabavnaVrednostOtpisTrebovanje = this.ukupanOtpisTrebovanjeZaDatum(datumOtpisa);
        double nabavnaVrednostOtpisUtrosak = this.ukupnaVrednostOtpisUtrosakZaDatum(datumOtpisa);
        double ukupnaVrednosOtpisa = nabavnaVrednostOtpisTrebovanje + nabavnaVrednostOtpisUtrosak;
        return ukupnaVrednosOtpisa;
    }

    private double ukupanOtpisTrebovanjeZaDatum(Date datumOtpisa) {
        double ukupnOtpisTrebovanje = 0.0;
        java.sql.Date datum = new java.sql.Date(datumOtpisa.getTime());
        String query = "SELECT ROUND(SUM(ts.kolicina * ts.komad),2) AS ukupanOtpis FROM trebovanjestavka ts  JOIN trebovanje t ON ts.TREBOVANJE_ID = t.id WHERE t.datumTrebovanja = ? AND t.tip = 'OTPIS'";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setDate(1, datum);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ukupnOtpisTrebovanje = rs.getDouble("ukupanOtpis");
            }
            return ukupnOtpisTrebovanje;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return ukupnOtpisTrebovanje;
        }
    }

    private double ukupnaVrednostOtpisUtrosakZaDatum(Date datumOtpisa) {
        double nabavnaVrednost = 0.0;
        Map<Long, Double> artikalKolicina = this.artikalKolicinaOtpisUtrosakZaDatum(datumOtpisa);
        for (Map.Entry<Long, Double> e : artikalKolicina.entrySet()) {
            Artikal a = this.server.getArtikal(e.getKey());
            Odeljenje o = a.getOdeljenje();
            Map<String, Double> nabavneCene = NabavneCene.getPosednjaNabavna(a, datumOtpisa, o, false, 0, 1, this.server);
            double nabavnaCenaZaArtikal = nabavneCene.get("NCpoJMsaPDV");
            double kolicina = e.getValue();
            nabavnaVrednost += kolicina * nabavnaCenaZaArtikal;
        }
        return nabavnaVrednost;
    }

    private Map<Long, Double> stavkeIKolicinaZaZdBroj(long zdBroj) {
        HashMap<Long, Double> stavkeKolicina = new HashMap<Long, Double>();
        String query = "SELECT du.ARTIKAL_ID, du.kolicina FROM dnevniutrosak du WHERE du.zdBroj = ?";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setLong(1, zdBroj);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                stavkeKolicina.put(rs.getLong("ARTIKAL_ID"), rs.getDouble("kolicina"));
            }
            return stavkeKolicina;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return stavkeKolicina;
        }
    }

    private Map<Long, Double> artikalKolicinaOtpisUtrosakZaDatum(Date datumOtpisa) {
        java.sql.Date datum = new java.sql.Date(datumOtpisa.getTime());
        HashMap<Long, Double> artikalKolicina = new HashMap<Long, Double>();
        String query = "SELECT otu.ARTIKAL_ID, otu.kolicina FROM otpisutrosak otu JOIN otpis o ON otu.OTPIS_ID = o.id WHERE o.datum = ? ";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setDate(1, datum);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                artikalKolicina.put(rs.getLong("ARTIKAL_ID"), rs.getDouble("kolicina"));
            }
            return artikalKolicina;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return artikalKolicina;
        }
    }

    public List<ZD> ZdDaniRealizacije(Date datumOd, Date datumDo) {
        java.sql.Date odDatuma = new java.sql.Date(datumOd.getTime());
        java.sql.Date doDatuma = new java.sql.Date(datumDo.getTime());
        ArrayList<ZD> zdDani = new ArrayList<ZD>();
        String query = "SELECT * FROM zd z WHERE z.datum BETWEEN ? AND ? AND z.pocetak = 1";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setDate(1, odDatuma);
            ps.setDate(2, doDatuma);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ZD zd = new ZD();
                zd.setDatum(rs.getDate("datum"));
                zd.setZdBroj(rs.getLong("zdBroj"));
                zdDani.add(zd);
            }
            return zdDani;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return zdDani;
        }
    }
}

