/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji.Normativi;

import Stampa.core.GridPrinter;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.NormativArtikal;
import com.dev63.restoran.sistem.XLSExporter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PregledIzmeneNormativa {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private RestoranServer server;
    private Shell shell1;
    private Artikal artikal;
    private Table table;
    private Display display;
    private String[] kolone = new String[]{"Naziv", "J.mere", "Koli\u010dina", "Odeljenje"};
    private GridData data;

    public PregledIzmeneNormativa(Artikal artikal, final RestoranServer server, Shell shell) {
        this.artikal = artikal;
        this.server = server;
        this.display = shell.getDisplay();
        this.shell1 = new Shell(this.display, 64);
        this.shell1.setText(String.format(this.barmasterText.getString("TEXT_ISTORIJA_NORMATIV_NASLOV"), new Object[0]));
        this.shell1.setLayout((Layout)new GridLayout(4, false));
        this.table = this.napraviTabelu(this.kolone);
        this.data = new GridData(120, 50);
        Button stampa = new Button((Composite)this.shell1, 0);
        stampa.setText(String.format(this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        stampa.setLayoutData((Object)this.data);
        stampa.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PrintHandler ph = new PrintHandler(10, false, false);
                GridPrinter gp = new GridPrinter(ph);
                gp.printTable(new TableWrapper(PregledIzmeneNormativa.this.table), false, true, String.format(PregledIzmeneNormativa.this.barmasterText.getString("TEXT_ISTORIJA_NORMATIV_NASLOV"), new Object[0]), PregledIzmeneNormativa.this.shell1, 9, server);
            }
        });
        Button excel = new Button((Composite)this.shell1, 0);
        excel.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        excel.setLayoutData((Object)this.data);
        excel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PregledIzmeneNormativa.this.table, PregledIzmeneNormativa.this.shell1);
                }
                catch (IOException ex) {
                    Logger.getLogger(PregledIzmeneNormativa.class.getName()).log(Level.WARNING, "Doslo je do greske prilikom kreiranja export fajla", ex);
                }
            }
        });
        this.popuniRedove();
        this.shell1.setParent((Composite)shell);
        this.shell1.setMaximized(true);
        this.shell1.open();
    }

    private Table napraviTabelu(String[] kolone) {
        Table table = new Table((Composite)this.shell1, 514);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 4;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        for (int i = 0; i < kolone.length; ++i) {
            TableColumn tColumn = new TableColumn(table, 0);
            if (i == 0) {
                tColumn.setWidth(200);
                continue;
            }
            if (i == 1 || i == 2) {
                tColumn.setWidth(70);
                continue;
            }
            tColumn.setWidth(120);
        }
        return table;
    }

    private void popuniRedove() {
        List<NormativArtikal> listaIzmena = this.getIzmeneNormativa();
        Font font1 = new Font((Device)this.display, "Tahoma", 10, 1);
        TableItem naziv = new TableItem(this.table, 0);
        naziv.setText(this.artikal.getName());
        naziv.setFont(font1);
        for (NormativArtikal na : listaIzmena) {
            RGB rgb = na.isAktivan() ? new RGB(0, 102, 0) : new RGB(255, 0, 0);
            Color color = new Color((Device)this.display, rgb);
            List<Normativ> normativi = this.getListaNormativa(na);
            List<String[]> redovi = this.getRedoviZaNormative(normativi);
            TableItem prazanRed = new TableItem(this.table, 0);
            TableItem datum = new TableItem(this.table, 0);
            datum.setText(this.getDatum(na));
            datum.setFont(font1);
            TableItem aktivan = new TableItem(this.table, 0);
            aktivan.setText(this.getAktivan(na));
            aktivan.setFont(font1);
            aktivan.setForeground(3, color);
            TableItem koloneSastojci = new TableItem(this.table, 0);
            koloneSastojci.setText(this.kolone);
            if (redovi.size() < 1) {
                String[] red = new String[]{String.format(this.barmasterText.getString("TEXT_ARTIKAL_NEMA_NORMATIV"), new Object[0])};
                TableItem item = new TableItem(this.table, 0);
                item.setText(red);
                continue;
            }
            for (String[] red : redovi) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(red);
            }
        }
    }

    private List<String[]> getRedoviZaNormative(List<Normativ> listaNormativa) {
        ArrayList<String[]> redovi = new ArrayList<String[]>();
        for (Normativ n : listaNormativa) {
            String[] red = new String[]{n.getSastojak().getName(), n.getSastojak().getJedinicaMere(), String.valueOf(n.getKolicina()), n.getOdeljenje().getNaziv()};
            redovi.add(red);
        }
        return redovi;
    }

    private String[] getAktivan(NormativArtikal na) {
        String aktivan = na.isAktivan() ? "Aktivan" : "Neaktivan";
        String[] red = new String[]{"", "", "", aktivan};
        return red;
    }

    private String[] getNaziv(NormativArtikal na) {
        String nazivArtikla = na.getArtikal().getName();
        String[] red = new String[]{nazivArtikla, "", "", ""};
        return red;
    }

    private String[] getDatum(NormativArtikal na) {
        String datumIzmene = String.valueOf(na.getDatum());
        String izmenio = na.getUname();
        String[] red = new String[]{"Datum izmene: " + datumIzmene, "", "", "Izmenio: " + izmenio};
        return red;
    }

    private List<NormativArtikal> getIzmeneNormativa() {
        String query = "SELECT * FROM normativartikal na WHERE na.ARTIKAL_ID =?";
        ArrayList<NormativArtikal> listaIzmena = new ArrayList<NormativArtikal>();
        try {
            PreparedStatement ps = this.server.getConnection().prepareStatement(query);
            ps.setLong(1, this.artikal.getId());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                NormativArtikal na = new NormativArtikal();
                na.setId(rs.getLong("id"));
                na.setAktivan(rs.getBoolean("aktivan"));
                na.setArtikal(this.server.getArtikal(rs.getLong("ARTIKAL_ID")));
                na.setDatum(rs.getDate("datum"));
                na.setUname(rs.getString("uname"));
                listaIzmena.add(na);
            }
            return listaIzmena;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<Normativ> getListaNormativa(NormativArtikal na) {
        String query = "SELECT * FROM normativ n WHERE n.NORMATIVARTIKAL_ID =? ";
        ArrayList<Normativ> listaNormativa = new ArrayList<Normativ>();
        try {
            PreparedStatement ps = this.server.getConnection().prepareStatement(query);
            ps.setLong(1, na.getId());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Normativ n = new Normativ();
                n.setArtikal(this.server.getArtikal(rs.getLong("ARTIKAL_ID")));
                n.setSastojak(this.server.getArtikal(rs.getLong("SASTOJAK_ID")));
                n.setOdeljenje(this.server.getOdeljenje(rs.getLong("ODELJENJE_ID")));
                n.setKolicina(rs.getDouble("kolicina"));
                listaNormativa.add(n);
            }
            return listaNormativa;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

