/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.XMLprintPrometPoKonobaru;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Sto;
import com.dev63.restoran.stampa.StringAlign;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.apache.commons.lang.StringUtils;

public class KonobarPrometFinansijski {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private RestoranServer server;
    private Konobar konobar;
    private Map<NacinPlacanja, Double> bela;
    private Map<String, Double> crna;
    private Double naplaceno = 0.0;
    private Double nenaplaceno = 0.0;
    private String stampac;

    public KonobarPrometFinansijski(RestoranServer server, Konobar konobar) {
        this.server = server;
        this.stampac = server.readIzvestajiStampac().toUpperCase();
        this.konobar = konobar;
        this.bela = new HashMap<NacinPlacanja, Double>();
        this.crna = new HashMap<String, Double>();
        this.generateData();
    }

    private void generateData() {
        List<Racun> racuni = this.getServer().getSviRacuniKonobari(Konstante.vremeOtvaranjaDana, new Date(), null, this.konobar);
        for (Racun racun : racuni) {
            if (racun.getCrnoPlacanje() != null) {
                String crno = racun.getCrnoPlacanje();
                if (crno.equalsIgnoreCase("MEDJUZBIR")) {
                    this.nenaplaceno = this.nenaplaceno + racun.total();
                    continue;
                }
                if (this.getCrna().containsKey(crno)) {
                    this.getCrna().put(crno, this.getCrna().get(crno) + racun.total());
                    continue;
                }
                this.getCrna().put(racun.getCrnoPlacanje(), racun.total());
                continue;
            }
            for (Placanje placanje : this.getServer().getPlacanja(racun)) {
                NacinPlacanja belo = placanje.getNacin();
                if (this.getBela().containsKey((Object)belo)) {
                    this.getBela().put(belo, this.getBela().get((Object)belo) + placanje.getIznos());
                    continue;
                }
                this.getBela().put(belo, placanje.getIznos());
            }
        }
        for (Double vrednost : this.bela.values()) {
            this.naplaceno = this.naplaceno + vrednost;
        }
        for (Double vrednost : this.crna.values()) {
            this.naplaceno = this.naplaceno + vrednost;
        }
        ArrayList<Integer> stolovi = new ArrayList<Integer>();
        for (Sto sto : this.server.getSto(this.konobar)) {
            stolovi.add(sto.getBroj());
        }
        if (stolovi.isEmpty()) {
            this.nenaplaceno = 0.0;
        } else {
            for (StavkaRacuna nenaplacena : this.server.readNenaplaceneStavkeKonobara(stolovi)) {
                this.nenaplaceno = this.nenaplaceno + nenaplacena.getVrednost();
            }
        }
    }

    public void uskaStampa() {
        String content = "";
        int bkur = 0;
        try {
            Stampac s = this.server.readIzvestajiStampacObject();
            bkur = s.getTip().getBrojKarakteraURedu();
            System.out.println("stampac je " + s.getTip().name());
        }
        catch (Exception ex) {
            Logger.getLogger(KonobarPrometFinansijski.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.server.getStampacTipByNaziv(this.stampac).equalsIgnoreCase("FP550")) {
            try {
                new XMLprintPrometPoKonobaru(this.konobar, this.bela, this.crna, this.naplaceno, this.nenaplaceno);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        content = content + StringUtils.center((String)String.format(this.barmasterText.getString("TEXT_PROMET_PO_KONOBARU_CAPS"), new Object[0]), (int)bkur) + "\n";
        content = content + StringUtils.center((String)String.format(this.barmasterText.getString("TEXT_SVA_PROIZVODNA_MESTA_CAPS"), new Object[0]), (int)bkur) + "\n";
        content = content + "\n";
        content = content + StringUtils.center((String)(String.format(this.barmasterText.getString("TEXT_KONOBAR"), new Object[0]) + ": " + this.konobar.getPunoime()), (int)bkur) + "\n";
        content = content + StringUtils.center((String)"---------------------------------", (int)bkur) + "\n";
        content = content + new StringAlign(28, 108).format((Object)String.format(this.barmasterText.getString("TEXT_INSTRUMENTI_CAPS"), new Object[0]));
        content = content + new StringAlign(4, 114).format((Object)String.format(this.barmasterText.getString("TEXT_NETO_CAPS"), new Object[0]));
        content = content + "\n";
        content = content + new StringAlign(27, 108).format((Object)String.format(this.barmasterText.getString("TEXT_PLACANJA_CAPS"), new Object[0]));
        content = content + new StringAlign(5, 114).format((Object)String.format(this.barmasterText.getString("TEXT_IZNOS_CAPS"), new Object[0]));
        content = content + "\n";
        content = content + StringUtils.center((String)"---------------------------------", (int)bkur) + "\n";
        for (NacinPlacanja instrumentBeli : this.bela.keySet()) {
            content = content + new StringAlign(23, 108).format((Object)instrumentBeli.getOpis().toUpperCase());
            content = content + new StringAlign(9, 114).format((Object)Konstante.getNumber2(this.bela.get((Object)instrumentBeli)));
            content = content + "\n";
        }
        for (String instrumentCrni : this.crna.keySet()) {
            content = content + new StringAlign(23, 108).format((Object)instrumentCrni.toUpperCase());
            content = content + new StringAlign(9, 114).format((Object)Konstante.getNumber2(this.crna.get(instrumentCrni)));
            content = content + "\n";
        }
        content = content + StringUtils.center((String)"---------------------------------", (int)bkur) + "\n";
        content = content + new StringAlign(9, 108).format((Object)String.format(this.barmasterText.getString("TEXT_NAPLACENO_CAPS"), new Object[0]));
        content = content + new StringAlign(23, 114).format((Object)Konstante.getNumber2(this.naplaceno));
        content = content + "\n";
        content = content + new StringAlign(11, 108).format((Object)String.format(this.barmasterText.getString("TEXT_NENAPLACENO_CAPS"), new Object[0]));
        content = content + new StringAlign(21, 114).format((Object)Konstante.getNumber2(this.nenaplaceno));
        content = content + "\n";
        content = content + new StringAlign(5, 108).format((Object)String.format(this.barmasterText.getString("TEXT_TOTAL_CAPS"), new Object[0]));
        content = content + new StringAlign(27, 114).format((Object)Konstante.getNumber2(this.nenaplaceno + this.naplaceno));
        content = content + "\n";
        content = content + StringUtils.center((String)"---------------------------------", (int)bkur) + "\n";
        if (this.server.getStampacTipByNaziv(this.stampac).equalsIgnoreCase("EPSONTMT")) {
            content = content + "\n\n\n\n";
        } else if (this.server.getStampacTipByNaziv(this.stampac).equalsIgnoreCase("POSBANK80MM")) {
            content = content + "\n\n\n\n";
        } else if (this.server.getStampacTipByNaziv(this.stampac).equalsIgnoreCase("DATECS1000")) {
            content = content + "\n\n\n\n";
        }
        content = content + StatLogic.getDateString(new Date()) + "\t\t" + StatLogic.getTimeString(new Date()) + "\n";
        content = content + "\n";
        content = content + "\n";
        content = content + "\n";
        content = content + "\n";
        try {
            Thread.sleep(500L);
            DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
            DocPrintJob pj = null;
            for (PrintService printer : pservices) {
                if (!printer.getName().toUpperCase().contains(this.stampac)) continue;
                pj = printer.createPrintJob();
            }
            byte[] bb = content.getBytes();
            byte[] out = new byte[bb.length + 2];
            System.arraycopy(bb, 0, out, 0, bb.length);
            out[out.length - 2] = 27;
            out[out.length - 1] = 105;
            ByteArrayInputStream is = new ByteArrayInputStream(out);
            SimpleDoc doc = new SimpleDoc(is, flavor, null);
            pj.print(doc, aset);
            ((InputStream)is).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Map<NacinPlacanja, Double> getBela() {
        return this.bela;
    }

    public Map<String, Double> getCrna() {
        return this.crna;
    }

    public RestoranServer getServer() {
        return this.server;
    }
}

