/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.DnevnoStanje;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.IzracunajDnevniPromet;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class KEPU {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    Composite composite;
    List<Kartica> kartica1 = new ArrayList<Kartica>();
    List<Kartica> kartica2 = new ArrayList<Kartica>();
    List<Kartica> kartica3 = new ArrayList<Kartica>();
    List<PodgrupaArtikala> podgrupe = new ArrayList<PodgrupaArtikala>();
    Date day1;
    double totalZaduzenje = 0.0;
    double totalRazduzenje = 0.0;
    double totalUplata = 0.0;
    double prodajnaVrednost;
    File dpu;
    String nazivUgostiteljskogPreduzeca;
    String naziPoslovneJedinice;
    String naziUgostiteljskogObjekta;
    String mesto;
    List<Prijemnica> prijemnice;
    List<String[]> zaduzenja;
    List<String[]> razduzenja;
    List<String[]> uplate;
    int count;
    boolean isBelo;
    boolean isCrno;
    boolean blic;
    boolean isMedjuzbir;
    boolean isDanasnji;
    Odeljenje odeljenje;
    Date pocetni1;
    Date krajnji1;
    Map<Long, Double> mapaPocetnoB;
    Map<Long, Double> mapaUlazB;
    Map<Long, Double> mapaIzlazB;
    Map<Long, Double> mapaPocetnoC;
    Map<Long, Double> mapaUlazC;
    Map<Long, Double> mapaIzlazC;
    List<DnevnoStanje> stanjaDanas = null;
    Map<Long, Artikal> artikli;
    List<Artikal> artikli2 = new ArrayList<Artikal>();
    List<Artikal> artikliDanas = new ArrayList<Artikal>();
    Map<Long, Double> kolicineDanas = new HashMap<Long, Double>();
    Map<Long, List<Normativ>> mapaNDanas;
    Map<Long, Artikal> mapaADanas;
    Odeljenje odeljenjeT;

    private KEPU(Shell s, Restoran r, Date d1, Odeljenje od, boolean b, boolean be, boolean cr, boolean mz) {
        this.shell = s;
        this.isBelo = be;
        this.isCrno = cr;
        this.blic = b;
        this.odeljenje = od;
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.isMedjuzbir = mz;
        boolean bl = this.isDanasnji = !Konstante.getOnlyDate(d1).before(Konstante.getOnlyDate(new Date()));
        if (this.server.isBeforeDateZD(d1)) {
            Konstante.getPoruka3(this.shell, "Za izbrani period nema podataka!");
            return;
        }
        if (this.server.isAfterDateZD(d1)) {
            Konstante.getPoruka3(this.shell, "Izve\u0161taj mogu\u0107 samo za zaklju\u010den dan");
            return;
        }
        Shell poruka = Konstante.getPoruka2(this.shell);
        this.shell.setEnabled(false);
        this.day1 = d1;
        this.dpu = new File("C:\\BarMaster\\Reports\\");
        this.dpu = new File(this.dpu, "KEPU.pdf");
        this.prijemnice = new ArrayList<Prijemnica>();
        this.pocetni1 = Konstante.getPocetniDatum(this.day1, this.server);
        this.krajnji1 = Konstante.getKrajnjiDatum(this.day1, this.server);
        if (this.isCrno) {
            this.artikliDanas = this.server.getArtikliStavkeCrno2(this.pocetni1, this.krajnji1);
            this.kolicineDanas = this.server.getArtikliKolicineCrno2(this.pocetni1, this.krajnji1);
            this.mapaNDanas = this.makeMap(this.server.getNormativiCrno(this.pocetni1, this.krajnji1), this.artikliDanas);
            this.mapaADanas = this.makeMap2(this.artikliDanas);
            for (Artikal a : this.server.getArtikliKarticeCrno2(this.pocetni1, this.krajnji1)) {
                this.mapaADanas.put(a.getId(), a);
            }
            for (Artikal a : this.server.getArtikliNormativiCrno2(this.pocetni1, this.krajnji1)) {
                this.mapaADanas.put(a.getId(), a);
            }
            for (Artikal ar : this.artikliDanas) {
                for (Kartica k : SkidanjeNormativa.napraviKartice2(SkidanjeNormativa.razloziArtikal2(ar, this.kolicineDanas.get(ar.getId()), this.server, this.mapaNDanas, this.mapaADanas), this.server, this.pocetni1)) {
                    this.kartica3.add(k);
                }
            }
        }
        if (this.isBelo) {
            this.prijemnice = this.server.readPrijemnice(this.pocetni1);
        }
        if (this.isDanasnji) {
            ArrayList<Odeljenje> odeljenja = new ArrayList<Odeljenje>();
            odeljenja.add(this.odeljenje);
            IzracunajDnevniPromet dp = new IzracunajDnevniPromet(new Date(), odeljenja, this.server);
            this.stanjaDanas = dp.getDnevnaStanja();
        }
        this.insertRows();
        this.naziUgostiteljskogObjekta = this.server.getSetting(Option.OBJEKAT_NAZIV) != null ? this.server.getSetting(Option.OBJEKAT_NAZIV).stringValue() : "";
        this.mesto = this.server.getSetting(Option.OBJEKAT_MESTO) != null ? this.server.getSetting(Option.OBJEKAT_MESTO).stringValue() : "";
        this.nazivUgostiteljskogPreduzeca = this.server.getSetting(Option.PREDUZECE_NAZIV) != null ? this.server.getSetting(Option.PREDUZECE_NAZIV).stringValue() : "";
        this.naziPoslovneJedinice = this.server.getSetting(Option.NAZIV_POSLOVNE_JEDINICE) != null ? this.server.getSetting(Option.NAZIV_POSLOVNE_JEDINICE).stringValue() : "";
        try {
            new HTMLStampa();
            poruka.close();
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(this.dpu);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public double izracunajPocetno(Artikal a) {
        double pocetno = 0.0;
        if (this.isBelo && this.mapaPocetnoB.get(a.getId()) != null) {
            pocetno += this.mapaPocetnoB.get(a.getId()).doubleValue();
        }
        if (this.isCrno && this.mapaPocetnoC.get(a.getId()) != null) {
            pocetno += this.mapaPocetnoC.get(a.getId()).doubleValue();
        }
        return pocetno;
    }

    public double izracunajUlaz(Artikal a) {
        double ulaz = 0.0;
        if (this.isBelo) {
            if (this.mapaUlazB.get(a.getId()) != null) {
                ulaz += this.mapaUlazB.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                ulaz += this.getDS(a).getBeloUlaz().doubleValue();
            }
        }
        if (this.isCrno) {
            if (this.mapaUlazC.get(a.getId()) != null) {
                ulaz += this.mapaUlazC.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                ulaz += this.getDS(a).getCrnoUlaz().doubleValue();
            }
        }
        for (Kartica k : this.kartica2) {
            if (!k.getArtikal().equals(a) || !k.getOdeljenje().equals(this.odeljenjeT) || !(k.getKolicina() > 0.0)) continue;
            ulaz += k.getKolicina().doubleValue();
        }
        return ulaz;
    }

    public double izracunajIzlaz(Artikal a) {
        double izlaz = 0.0;
        if (this.isBelo) {
            if (this.mapaIzlazB.get(a.getId()) != null) {
                izlaz += this.mapaIzlazB.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                izlaz += this.getDS(a).getBeloIzlaz().doubleValue();
            }
        }
        if (this.isCrno) {
            if (this.mapaIzlazC.get(a.getId()) != null) {
                izlaz += this.mapaIzlazC.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                izlaz += this.getDS(a).getCrnoIzlaz().doubleValue();
            }
        }
        return izlaz;
    }

    public double izarcunaIzlazKom(Artikal a) {
        double izlaz = 0.0;
        for (Kartica k : this.kartica3) {
            if (!k.getArtikal().equals(a) || k.getIzlazKOM() == null) continue;
            izlaz += (double)k.getIzlazKOM().intValue();
        }
        return izlaz;
    }

    public void insertRows() {
        this.zaduzenja = new ArrayList<String[]>();
        this.razduzenja = new ArrayList<String[]>();
        this.uplate = new ArrayList<String[]>();
        this.prijemnice = this.server.readPrijemnice(this.day1);
        for (Prijemnica p : this.prijemnice) {
            List<PrijemnicaStavka> stavke = this.server.readStavkePrijemnice(p);
            double suma = 0.0;
            for (PrijemnicaStavka ps : stavke) {
                if (ps.getArtikal().getBlokiran().booleanValue()) continue;
                suma += ps.getKolicina() * ps.getKomad();
            }
            if (!(suma > 0.0)) continue;
            this.zaduzenja.add(new String[]{Konstante.getDayMonth(p.getDatumPrijemnice()), p.getOznakaDokumenta() != null ? p.getOznakaDokumenta() : p.getOpis(), "" + Konstante.getNumber2(suma), "", ""});
            this.totalZaduzenje += suma;
        }
        List<Racun> racuni = this.server.getRacuni(Konstante.getPocetniDatum(this.day1, this.server), Konstante.getKrajnjiDatum(this.day1, this.server), null);
        double sumaGotovina = 0.0;
        double sumaFaktura = 0.0;
        double sumaKartica = 0.0;
        double sumaCek = 0.0;
        for (Racun r : racuni) {
            List<StavkaRacuna> stavke = r.getStavke();
            for (StavkaRacuna sr : stavke) {
                if (sr.getArtikal().getBlokiran().booleanValue()) continue;
                for (Placanje p : r.getPlacanja()) {
                    if (p.getNacin() == NacinPlacanja.GOTOVINA) {
                        sumaGotovina += sr.getKolicina() * sr.getCena();
                        continue;
                    }
                    if (p.getNacin() == NacinPlacanja.KARTICA) {
                        sumaKartica += sr.getKolicina() * sr.getCena();
                        continue;
                    }
                    if (p.getNacin() == NacinPlacanja.CEK) {
                        sumaCek += sr.getKolicina() * sr.getCena();
                        continue;
                    }
                    if (p.getNacin() != NacinPlacanja.FAKTURA) continue;
                    sumaFaktura += sr.getKolicina() * sr.getCena();
                }
            }
        }
        this.totalRazduzenje = sumaGotovina + sumaKartica + sumaCek + sumaFaktura;
        this.razduzenja.add(new String[]{"", "Gotovina", "", Konstante.getNumber2(sumaGotovina), ""});
        this.razduzenja.add(new String[]{"", "Kartica", "", Konstante.getNumber2(sumaKartica), ""});
        this.razduzenja.add(new String[]{"", "Cek", "", Konstante.getNumber2(sumaCek), ""});
        this.razduzenja.add(new String[]{"", "Faktura", "", Konstante.getNumber2(sumaFaktura), ""});
    }

    public String vratiPG(Artikal a) {
        if (a.getPoreskaGrupa().equals((Object)PoreskaGrupa.GRUPA_A)) {
            return "0 %";
        }
        if (a.getPoreskaGrupa().equals((Object)PoreskaGrupa.GRUPA_DJ)) {
            return "20 %";
        }
        if (a.getPoreskaGrupa().equals((Object)PoreskaGrupa.GRUPA_G)) {
            return "0 %";
        }
        if (a.getPoreskaGrupa().equals((Object)PoreskaGrupa.GRUPA_E)) {
            return "8 %";
        }
        return "";
    }

    DnevnoStanje getDS(Artikal a) {
        if (this.stanjaDanas == null) {
            return null;
        }
        for (DnevnoStanje ds : this.stanjaDanas) {
            if (!ds.getArtikalID().equals(a.getId())) continue;
            return ds;
        }
        return null;
    }

    public void sortiraj(List<Artikal> artikli) {
        Comparator<Artikal> SENIORITY_ORDER = null;
        SENIORITY_ORDER = new Comparator<Artikal>(){

            @Override
            public int compare(Artikal t1, Artikal t2) {
                return t1.getName().compareTo(t2.getName());
            }
        };
        Collections.sort(artikli, SENIORITY_ORDER);
    }

    Map<Long, List<Normativ>> makeMap(List<Normativ> normativi, List<Artikal> ar) {
        HashMap<Long, List<Normativ>> mapa = new HashMap<Long, List<Normativ>>();
        for (Artikal a : ar) {
            if (!a.getTip().equals((Object)TipArtikla.SLOZ)) continue;
            ArrayList<Normativ> no = new ArrayList<Normativ>();
            for (Normativ n : normativi) {
                if (!n.getArtikal().getId().equals(a.getId())) continue;
                no.add(n);
            }
            mapa.put(a.getId(), no);
        }
        return mapa;
    }

    Map<Long, Artikal> makeMap2(List<Artikal> ar) {
        HashMap<Long, Artikal> mapa = new HashMap<Long, Artikal>();
        for (Artikal a : ar) {
            mapa.put(a.getId(), a);
        }
        return mapa;
    }

    public void makeRows(PdfPTable table2, List<String[]> lista) {
        Font font8 = FontFactory.getFont((String)"Helvetica", (float)9.0f);
        for (String[] s : lista) {
            table2.addCell(new Phrase(s[0], font8));
            table2.addCell(new Phrase(s[1], font8));
            table2.addCell(new Phrase(s[2], font8));
            table2.addCell(new Phrase(s[3], font8));
            table2.addCell(new Phrase(s[4], font8));
        }
    }

    public class HTMLStampa {
        public HTMLStampa() throws Exception {
            Document document = new Document(PageSize.A4);
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(KEPU.this.dpu));
            document.open();
            Font font8 = FontFactory.getFont((String)"Helvetica", (float)9.0f);
            Font font8Bold = FontFactory.getFont((String)"Helvetica-Bold", (float)9.0f);
            PdfPTable table = new PdfPTable(2);
            table.getDefaultCell().setBorder(0);
            PdfPCell cell1 = new PdfPCell(new Phrase("OBVEZNIK: " + KEPU.this.nazivUgostiteljskogPreduzeca, font8Bold));
            cell1.setHorizontalAlignment(0);
            cell1.setBorder(0);
            table.addCell(cell1);
            cell1 = new PdfPCell(new Phrase("Obrazac KEPU", font8Bold));
            cell1.setBorder(0);
            cell1.setHorizontalAlignment(2);
            table.addCell(cell1);
            cell1 = new PdfPCell(new Phrase("OBJEKAT-PRODAJNO MESTO: " + KEPU.this.naziPoslovneJedinice, font8Bold));
            cell1.setHorizontalAlignment(0);
            cell1.setBorder(0);
            table.addCell(cell1);
            table.addCell("");
            cell1 = new PdfPCell(new Phrase("MESTO: " + KEPU.this.mesto, font8Bold));
            cell1.setBorder(0);
            cell1.setHorizontalAlignment(0);
            table.addCell(cell1);
            table.addCell("");
            table.setWidths(new float[]{7.0f, 3.0f});
            PdfPTable tableA = new PdfPTable(1);
            cell1 = new PdfPCell(new Phrase("KNjIGA EVIDENCIJE PROMETA I USLUGA \n ZA " + (1900 + KEPU.this.day1.getYear()) + " GODINU \n\n", font8Bold));
            cell1.setBorder(0);
            cell1.setHorizontalAlignment(1);
            tableA.addCell(cell1);
            tableA.addCell("");
            PdfPTable table2 = new PdfPTable(5);
            PdfPCell cell = table2.getDefaultCell();
            cell.setHorizontalAlignment(1);
            table2.addCell(new Phrase("Datum knjizenja \n (dan i mesec)", font8));
            table2.addCell(new Phrase("Opis knjizenja \n (naziv, broj i datum dokumenta)", font8));
            PdfPTable tableB = new PdfPTable(3);
            tableB.getDefaultCell().setHorizontalAlignment(1);
            PdfPCell c = new PdfPCell(new Phrase("Iznos dinara", font8));
            c.setColspan(3);
            c.setHorizontalAlignment(1);
            tableB.addCell(c);
            tableB.addCell(new Phrase("zaduzenje", font8));
            tableB.addCell(new Phrase("razduzenje", font8));
            tableB.addCell(new Phrase("uplata na \n racun", font8));
            PdfPCell add = new PdfPCell(tableB);
            add.setColspan(3);
            table2.addCell(add);
            table2.addCell(new Phrase("1", font8));
            table2.addCell(new Phrase("2", font8));
            table2.addCell(new Phrase("3", font8));
            table2.addCell(new Phrase("4", font8));
            table2.addCell(new Phrase("5", font8));
            KEPU.this.count = 1;
            KEPU.this.makeRows(table2, KEPU.this.zaduzenja);
            KEPU.this.makeRows(table2, KEPU.this.razduzenja);
            KEPU.this.makeRows(table2, KEPU.this.uplate);
            table2.addCell(new Phrase(""));
            table2.addCell(new Phrase("SVEGA ZA PRENOS", font8));
            PdfPCell cellP = new PdfPCell(new Phrase(Konstante.getNumber2(KEPU.this.totalZaduzenje), font8));
            cellP.setHorizontalAlignment(2);
            table2.addCell(cellP);
            cellP = new PdfPCell(new Phrase(Konstante.getNumber2(KEPU.this.totalRazduzenje), font8));
            cellP.setHorizontalAlignment(2);
            table2.addCell(cellP);
            cellP = new PdfPCell(new Phrase(Konstante.getNumber2(KEPU.this.totalUplata), font8));
            cellP.setHorizontalAlignment(2);
            table2.addCell(cellP);
            table2.setWidths(new float[]{20.0f, 40.0f, 11.0f, 11.0f, 11.0f});
            PdfPTable table3 = new PdfPTable(3);
            PdfPCell pc = table3.getDefaultCell();
            pc.setHorizontalAlignment(1);
            pc.setBorder(0);
            table3.addCell(new Phrase("\n\n"));
            table3.addCell(new Phrase(""));
            table3.addCell(new Phrase(""));
            table3.addCell(new Phrase(""));
            table3.addCell(new Phrase("M.P."));
            table3.addCell(new Phrase("ODGOVORNO LICE"));
            table3.addCell(new Phrase(""));
            table3.addCell(new Phrase(""));
            table3.addCell(new Phrase("____________________"));
            document.add((Element)table);
            document.add((Element)tableA);
            document.add((Element)table2);
            document.add((Element)table3);
            document.close();
        }
    }

    public static class KEPUInput {
        private DateInput2 odDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo odeljenje;
        Date day1;
        Odeljenje o;
        List<Odeljenje> odeljenja;
        SWTContainer parent;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();
        boolean saPromenama;
        private Button belo;
        private Button crno;
        private Button medjuzbir;
        boolean iscrno;
        boolean inspekcija;
        boolean bel;
        boolean cr;
        boolean medjz;

        public KEPUInput(SWTContainer owner, Restoran r, boolean ins) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.iscrno = this.server.readCrnaPlacanjaIzvestaji().size() > 0;
            this.inspekcija = ins;
            this.odeljenja = this.server.readOdeljenjeBezMag();
            for (Odeljenje od : this.odeljenja) {
                od.setArtikli(od.getArtikli());
            }
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/dpuV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 90;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText("KEPU");
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText("Ekran za unos, pregled i ispravku.\n Za vise informacija kliknite na ikonicu tehnickog uputstva ->");
            Button uputstvo = new Button(panel1, 0);
            uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText("Unos datuma");
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 110;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText("Filter izvestaja");
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 70;
            Group grupa21 = null;
            if (!this.inspekcija) {
                grupa21 = new Group(panel2, 0);
                grupa21.setLayout((Layout)new GridLayout(4, false));
                grupa21.setText("Filter nacina placanja");
                grupa21.setLayoutData((Object)data);
            }
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText("Za dan:");
            this.odDatuma = new DateInput2(parent2, "Od datuma", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label art = new Label((Composite)grupa2, 0);
            art.setText("Odeljenje:");
            this.odeljenje = new Combo((Composite)grupa2, 8);
            this.odeljenje.add("Sva proizvodna mesta");
            for (Odeljenje ode : this.odeljenja) {
                this.odeljenje.add(ode.getNaziv());
            }
            this.odeljenje.select(0);
            if (!this.inspekcija) {
                this.belo = new Button((Composite)grupa21, 32);
                this.belo.setText("Osnovna placanja");
                this.belo.setSelection(true);
                if (this.iscrno) {
                    this.crno = new Button((Composite)grupa21, 32);
                    this.crno.setText("Dodatna placanja");
                }
                this.medjuzbir = new Button((Composite)grupa21, 32);
                this.medjuzbir.setText("Medjuzbir");
            }
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            art.setLayoutData((Object)data);
            this.odeljenje.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.o = this.odeljenje.getSelectionIndex() == 0 ? null : this.odeljenja.get(this.odeljenje.getSelectionIndex() - 1);
                if (this.inspekcija) {
                    this.bel = true;
                    this.cr = false;
                    this.medjz = false;
                    if (this.day1.equals(Konstante.getOnlyDate(new Date()))) {
                        this.medjz = true;
                    }
                } else {
                    this.bel = this.belo.getSelection();
                    this.cr = false;
                    if (this.iscrno) {
                        this.cr = this.crno.getSelection();
                    }
                    this.medjz = this.medjuzbir.getSelection();
                }
                this.server.log("Pregled KEPU za dan -> " + this.day1);
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                new KEPU(shell2, this.restoran, this.day1, this.o, this.saPromenama, this.bel, this.cr, this.medjz);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), "Greska", 2);
            }
        }
    }
}

