/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometPoArtiklimaNovi;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.RekonstrukcijaSaPrikazom;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.stampa.NPrintUtils;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class IzvestajUtrosenihSirovina {
    private final ResourceBundle barmasterText = Konstante.getBundle();
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    private Date day1;
    private Date day2;
    private Boolean bela;
    private Boolean crna;
    private boolean blic;
    private Odeljenje odeljenje;
    private List<Racun> racuni = new LinkedList<Racun>();
    private List<StavkaRacuna> stavke = new LinkedList<StavkaRacuna>();
    private List<StavkaRacuna> stavkeKonacno = new LinkedList<StavkaRacuna>();
    Map<Artikal, Double> artikal_kolicina = new HashMap<Artikal, Double>();
    Map<Artikal, List<Artikal>> normativ_artikli = new HashMap<Artikal, List<Artikal>>();
    Map<Artikal, Double> sastojak_kolicina = new HashMap<Artikal, Double>();

    public IzvestajUtrosenihSirovina(Shell s, Restoran re, final Date d1, final Date d2, Odeljenje od, boolean blic, boolean bl, boolean cp, boolean poArtiklima) {
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.server.refresh();
        this.shell = new Shell(s, 34912);
        this.bela = bl;
        this.crna = cp;
        this.blic = blic;
        this.odeljenje = od;
        this.day1 = this.server.getPocetni(d1);
        this.day2 = this.server.getKrajnji(d2);
        this.racuni = this.server.getRacuni(this.day1, this.day2, this.odeljenje, this.bela, this.crna);
        if (this.racuni == null || this.racuni.isEmpty()) {
            Konstante.getPoruka3(this.shell, String.format(this.barmasterText.getString("PORUKA_ZA_IZBRANI_PERIOD_NEMA_PODATAKA"), new Object[0]));
            return;
        }
        if (this.server.isAfterDateZD(d1)) {
            Calendar c = Calendar.getInstance();
            c.setTime(d1);
            int dom = c.get(5);
            c.set(5, dom - 1);
            RekonstrukcijaSaPrikazom rek = new RekonstrukcijaSaPrikazom(this.shell, this.restoran, c.getTime());
            rek.reconstruct();
        }
        Shell poruka = Konstante.getPoruka2(this.shell);
        this.shell.setEnabled(false);
        for (Racun r : this.racuni) {
            this.stavke.addAll(r.getStavke1());
        }
        if (od != null) {
            for (StavkaRacuna st : this.stavke) {
                if (!st.getArtikal().getOdeljenje().equals(od)) continue;
                this.stavkeKonacno.add(st);
            }
        } else {
            this.stavkeKonacno.addAll(this.stavke);
        }
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_ANALIZA_UTROSENIH_SIROVINA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(d1) + " -> " + StatLogic.getDateString(d2));
        if (this.server.isEmptyDateZD(d1, d2) || this.server.isBeforeDateZD(d2)) {
            Konstante.getPoruka3(this.shell, String.format(this.barmasterText.getString("PORUKA_ZA_IZBRANI_PERIOD_NEMA_PODATAKA"), new Object[0]));
            return;
        }
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(7, false));
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 7;
        this.table.setLayoutData((Object)data);
        if (poArtiklima) {
            if (!blic) {
                this.makeHeadersPoArtiklima();
            } else {
                this.makeHeaders();
            }
        } else {
            this.makeHeaders();
        }
        try {
            if (poArtiklima) {
                if (!blic) {
                    this.insertRowsPoArtiklima();
                } else {
                    this.insertRows();
                }
            } else {
                this.insertRows();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(IzvestajUtrosenihSirovina.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
        GridData data1 = new GridData(16384, 8, false, false);
        data1.heightHint = 50;
        data1.widthHint = 120;
        Button printButton = new Button((Composite)this.shell, 72);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_A4"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(IzvestajUtrosenihSirovina.this.table), false, true, String.format(IzvestajUtrosenihSirovina.this.barmasterText.getString("TEXT_ANALIZA_UTROSENIH_SIROVINA"), new Object[0]) + ": " + StatLogic.getDateString(d1) + "-->" + StatLogic.getDateString(d2), IzvestajUtrosenihSirovina.this.shell, IzvestajUtrosenihSirovina.this.server);
            }
        });
        printButton.setLayoutData((Object)data1);
        Button export = new Button((Composite)this.shell, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception tc) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(IzvestajUtrosenihSirovina.this.table, IzvestajUtrosenihSirovina.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)data1);
        Button printButton2 = new Button((Composite)this.shell, 72);
        try {
            printButton2.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton2.setText(String.format(this.barmasterText.getString("TEXT_USKA_STAMPA"), new Object[0]));
        printButton2.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    Stampac stampac = IzvestajUtrosenihSirovina.this.server.readIzvestajiStampacObject();
                    String content = IzvestajUtrosenihSirovina.this.writeContent(IzvestajUtrosenihSirovina.this.sastojak_kolicina, IzvestajUtrosenihSirovina.this.day1, IzvestajUtrosenihSirovina.this.day2, stampac.getTip().getBrojKarakteraURedu());
                    NPrintUtils.printContent(content, stampac, 1);
                }
                catch (Exception ex) {
                    Logger.getLogger(PrometPoArtiklimaNovi.class.getName()).log(Level.SEVERE, null, ex);
                    SWTMessage.showLocalizedWarningDialog(IzvestajUtrosenihSirovina.this.shell, String.format(Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STAMPANJA_PROMETA_PO_ARTIKLIMA"), new Object[0]));
                }
            }
        });
        printButton2.setLayoutData((Object)data1);
        printButton2.setVisible(blic);
        GridData data2 = new GridData(131072, 8, true, false);
        data2.heightHint = 50;
        data2.widthHint = 150;
        data2.horizontalAlignment = 131072;
        Button izlaz = new Button((Composite)this.shell, 72);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                IzvestajUtrosenihSirovina.this.shell.close();
            }
        });
        izlaz.setLayoutData((Object)data2);
        poruka.close();
        this.shell.setEnabled(true);
        this.shell.setMaximized(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private String writeContent(Map<Artikal, Double> sastojak_kolicina, Date from, Date to, int bkur) {
        StringBuilder contentBuilder = new StringBuilder();
        contentBuilder.append(NPrintUtils.centerSplitToCenter(bkur, StatLogic.getDateString(new Date()), StatLogic.getTimeString(new Date()))).append("\n");
        contentBuilder.append(NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_ANALIZA_UTROSENIH_SIROVINA"), new Object[0]).toUpperCase())).append("\n");
        contentBuilder.append(NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_OD"), new Object[0]) + " " + StatLogic.getDateTimeString(from))).append("\n");
        contentBuilder.append(NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_DO"), new Object[0]) + " " + StatLogic.getDateTimeString(to))).append("\n");
        contentBuilder.append(NPrintUtils.spaceFill(bkur)).append("\n");
        for (Artikal row : sastojak_kolicina.keySet()) {
            String art = row.getName();
            Double quant = sastojak_kolicina.get(row);
            contentBuilder.append(NPrintUtils.leftText(bkur, art));
            contentBuilder.append(NPrintUtils.rightText(bkur, StatLogic.getNumber04NG(quant)));
            contentBuilder.append("\n");
        }
        return contentBuilder.toString();
    }

    private void makeHeaders() {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setText(String.format(this.barmasterText.getString("TEXT_SASTOJAK"), new Object[0]));
        tc0.setWidth(250);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText(String.format(this.barmasterText.getString("TEXT_UTROSENO"), new Object[0]));
        tc1.setWidth(75);
        if (!this.blic) {
            TableColumn tc2 = new TableColumn(this.table, 131072);
            tc2.setText(String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]));
            tc2.setWidth(150);
            TableColumn tc3 = new TableColumn(this.table, 131072);
            tc3.setText(String.format(this.barmasterText.getString("TEXT_PRODATO"), new Object[0]));
            tc3.setWidth(75);
            TableColumn tc4 = new TableColumn(this.table, 131072);
            tc4.setText(String.format(this.barmasterText.getString("TEXT_NORMATIV"), new Object[0]));
            tc4.setWidth(75);
            TableColumn tc5 = new TableColumn(this.table, 131072);
            tc5.setText(String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]));
            tc5.setWidth(75);
        }
    }

    private void makeHeadersPoArtiklima() {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setText(String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]));
        tc0.setWidth(250);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText(String.format(this.barmasterText.getString("TEXT_PRODATO"), new Object[0]));
        tc1.setWidth(75);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(String.format(this.barmasterText.getString("TEXT_NAZIV_SASTOJKA"), new Object[0]));
        tc2.setWidth(150);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText(String.format(this.barmasterText.getString("TEXT_NORMATIV"), new Object[0]));
        tc3.setWidth(75);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(String.format(this.barmasterText.getString("TEXT_UTROSENO"), new Object[0]));
        tc4.setWidth(75);
    }

    private void insertRows() {
        TableItem ti = new TableItem(this.table, 0);
        for (StavkaRacuna sr : this.stavkeKonacno) {
            if (!this.artikal_kolicina.containsKey(sr.getArtikal())) {
                this.artikal_kolicina.put(sr.getArtikal(), sr.getKolicina());
                continue;
            }
            double kolicina = this.artikal_kolicina.get(sr.getArtikal());
            this.artikal_kolicina.put(sr.getArtikal(), kolicina += sr.getKolicina().doubleValue());
        }
        for (Artikal a : this.artikal_kolicina.keySet()) {
            List<Normativ> normativi = this.server.readNormativ(a, new Date());
            for (Normativ n : normativi) {
                if (!this.sastojak_kolicina.containsKey(n.getSastojak())) {
                    this.sastojak_kolicina.put(n.getSastojak(), n.getKolicina());
                    continue;
                }
                double kolicina = this.sastojak_kolicina.get(n.getSastojak());
                this.sastojak_kolicina.put(n.getSastojak(), kolicina += n.getKolicina().doubleValue());
            }
        }
        for (Artikal ar : this.sastojak_kolicina.keySet()) {
            List<Normativ> art;
            ti = new TableItem(this.table, 0);
            double utr = 0.0;
            ti.setText(0, ar.getName());
            if (!this.blic) {
                art = this.server.readArtikleZaSastojak(ar);
                for (Normativ n : art) {
                    if (!this.artikal_kolicina.containsKey(n.getArtikal())) continue;
                    utr += n.getKolicina() * this.artikal_kolicina.get(n.getArtikal());
                    ti = new TableItem(this.table, 0);
                    ti.setText(2, n.getArtikal().getName());
                    ti.setText(3, "" + this.artikal_kolicina.get(n.getArtikal()));
                    ti.setText(4, Konstante.getNumber4(n.getKolicina()));
                    ti.setText(5, Konstante.getNumber4(n.getKolicina() * this.artikal_kolicina.get(n.getArtikal())));
                }
                ti = new TableItem(this.table, 0);
                ti.setText(new String[]{"\tUkupno: ", Konstante.getNumber4(utr)});
                ti.setBackground(this.shell.getDisplay().getSystemColor(15));
                ti = new TableItem(this.table, 0);
                ti.setText("");
                continue;
            }
            art = this.server.readArtikleZaSastojak(ar);
            for (Normativ n : art) {
                if (!this.artikal_kolicina.containsKey(n.getArtikal())) continue;
                utr += n.getKolicina() * this.artikal_kolicina.get(n.getArtikal());
            }
            ti.setText(1, Konstante.getNumber4(utr));
        }
    }

    private void insertRowsPoArtiklima() {
        for (StavkaRacuna sr : this.stavkeKonacno) {
            if (!this.artikal_kolicina.containsKey(sr.getArtikal())) {
                this.artikal_kolicina.put(sr.getArtikal(), sr.getKolicina());
                continue;
            }
            double kolicina = this.artikal_kolicina.get(sr.getArtikal());
            this.artikal_kolicina.put(sr.getArtikal(), kolicina += sr.getKolicina().doubleValue());
        }
        List<Normativ> sastojci = null;
        for (Artikal a : this.artikal_kolicina.keySet()) {
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(new String[]{a.getName(), "" + this.artikal_kolicina.get(a)});
            sastojci = this.server.getNormativiByLastNormativiArtikal(a.getId());
            for (Normativ n : sastojci) {
                ti = new TableItem(this.table, 0);
                ti.setText(2, n.getSastojak().getName());
                ti.setText(3, "" + n.getKolicina());
                ti.setText(4, "" + Konstante.getNumber4(n.getKolicina() * this.artikal_kolicina.get(a)));
            }
        }
    }

    public class NameComparator
    implements Comparator<Artikal> {
        @Override
        public int compare(Artikal o1, Artikal o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class IzvestajUtrosenihSirovinaInput {
        private final ResourceBundle barmasterText = Konstante.getBundle();
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo odeljenje;
        private Button blic;
        private Button poArtiklima;
        Date day1;
        Date day2;
        Odeljenje o;
        List<Odeljenje> odeljenja;
        SWTContainer parent;
        Shell shell;
        Composite mainComposite;
        Button bela;
        Button crna;

        public IzvestajUtrosenihSirovinaInput(SWTContainer owner, Restoran r, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.odeljenja = this.server.readOdeljenjeBezMag();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new FillLayout());
            ScrolledComposite sc = new ScrolledComposite((Composite)this.shell, 768);
            this.mainComposite = new Composite((Composite)sc, 0);
            sc.setContent((Control)this.mainComposite);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            this.mainComposite.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite(this.mainComposite, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            Composite panel2 = new Composite(this.mainComposite, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            GridData data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)this.mainComposite.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_ANALIZA_UTROSENIH_SIROVINA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData(4, 4, false, false);
            data.widthHint = 670;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, true));
            grupa2.setText(String.format(this.barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 80;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(8, false));
            grupa21.setText(String.format(this.barmasterText.getString("TEXT_FILTER_NACINA_PLACANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 55;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, this.shell));
            Label art = new Label((Composite)grupa2, 0);
            art.setText(String.format(this.barmasterText.getString("TEXT_ODELJENJE"), new Object[0]) + ":");
            this.odeljenje = new Combo((Composite)grupa2, 8);
            this.odeljenje.add(String.format(this.barmasterText.getString("TEXT_SVA_PROIZVODNA_MESTA"), new Object[0]));
            for (Odeljenje ode : this.odeljenja) {
                this.odeljenje.add(ode.getNaziv());
            }
            this.odeljenje.select(0);
            this.bela = new Button((Composite)grupa21, 32);
            this.bela.setText("Osnovna placanja");
            this.bela.setSelection(true);
            if (inspektor) {
                this.crna = new Button((Composite)grupa21, 32);
                this.crna.setText("Dodatna placanja");
            }
            Label bl = new Label((Composite)grupa2, 0);
            bl.setText(String.format(this.barmasterText.getString("TEXT_BLIC_PROMET"), new Object[0]) + ":");
            this.blic = new Button((Composite)grupa2, 32);
            Label pa = new Label((Composite)grupa2, 0);
            pa.setText(String.format(this.barmasterText.getString("TEXT_PO_ARTIKLIMA"), new Object[0]) + ":");
            this.poArtiklima = new Button((Composite)grupa2, 32);
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            art.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            bl.setLayoutData((Object)data);
            this.blic.setLayoutData((Object)data);
            pa.setLayoutData((Object)data);
            this.poArtiklima.setLayoutData((Object)data);
            this.odeljenje.setLayoutData((Object)data);
            this.mainComposite.layout();
            sc.setMinSize(this.mainComposite.computeSize(-1, -1));
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                this.o = this.odeljenje.getSelectionIndex() == 0 ? null : this.odeljenja.get(this.odeljenje.getSelectionIndex() - 1);
                this.server.log(String.format(this.barmasterText.getString("TEXT_ANALIZA_UTROSENIH_SIROVINA"), StatLogic.getDateString(this.day1), StatLogic.getDateString(this.day2)));
                new IzvestajUtrosenihSirovina(this.shell, this.restoran, this.day1, this.day2, this.o, this.blic.getSelection(), this.bela.getSelection(), this.crna == null ? false : this.crna.getSelection(), this.poArtiklima.getSelection());
            }
            catch (Exception ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

