/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.DnevnoStanje;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.PorukaDaNe;
import com.dev63.restoran.sistem.RekonstrukcijaSaPrikazom;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.stampa.StampaIzvestajZalihe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Query;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class IzvestajOStanjuZalihaBezPodgrupa {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    Composite composite;
    List<Kartica> kartica2 = new ArrayList<Kartica>();
    List<PodgrupaArtikala> podgrupe = new ArrayList<PodgrupaArtikala>();
    boolean blic;
    boolean blic2;
    boolean sifre;
    Date day1;
    Date day2;
    double ukupnoPoc = 0.0;
    double ukupnoUl = 0.0;
    double ukupnoPro = 0.0;
    double ukupno = 0.0;
    double ukupnoBezPDV = 0.0;
    double ukupnaProdVredn = 0.0;
    Odeljenje odeljenje;
    Odeljenje odeljenjeT;
    PodgrupaArtikala podgrupaArtikala;
    boolean finansijski;
    boolean isBelo;
    boolean isCrno;
    boolean isMedjuzbir;
    boolean isDanasnji;
    Map<Long, Artikal> artikli;
    List<Artikal> artikli2 = new ArrayList<Artikal>();
    Map<Long, Double> mapaPocetnoB;
    Map<Long, Double> mapaUlazB;
    Map<Long, Double> mapaIzlazB;
    Map<Long, Double> mapaPocetnoC;
    Map<Long, Double> mapaUlazC;
    Map<Long, Double> mapaIzlazC;
    List<DnevnoStanje> stanjaDanas = null;
    private boolean proba = true;

    private IzvestajOStanjuZalihaBezPodgrupa(Shell s, Restoran r, Date d1, Date d2, Odeljenje od, boolean finans, boolean bl, boolean bl2, boolean be, boolean cr, boolean mz, PodgrupaArtikala pga) {
        this.shell = s;
        this.restoran = r;
        this.server = this.restoran.getServer();
        if (this.server.isBeforeDateZD(d2)) {
            Konstante.getPoruka3(this.shell, "Za izbrani period nema podataka!");
            return;
        }
        this.day1 = Konstante.getOnlyDate(d1);
        this.day2 = Konstante.getOnlyDate(d2);
        this.finansijski = finans;
        this.isBelo = be;
        this.isCrno = cr;
        this.isMedjuzbir = mz;
        this.isDanasnji = !Konstante.getOnlyDate(this.day2).before(Konstante.getOnlyDate(new Date()));
        this.blic = bl;
        this.blic2 = bl2;
        this.odeljenje = od;
        if (this.server.isAfterDateZD(d1)) {
            if (this.odeljenje != null && this.odeljenje.getId() == 1L) {
                Konstante.getPoruka3(this.shell, "Ne postoji izve\u0161taj za date parametre");
                return;
            }
            PorukaDaNe pdn = new PorukaDaNe(this.shell, "Potrebno je pokrenuti rekonstrukciju za ovaj izve\u0161taj,\nkoja mo\u017ee trajati nekoliko minuta.\nDa li \u017eelite da pokrenete rekonstrukciju");
            if (pdn.isOdgovoreno() && pdn.isOdgovorPozitivan()) {
                RekonstrukcijaSaPrikazom rek = new RekonstrukcijaSaPrikazom(this.shell, this.restoran, d1);
                rek.reconstruct();
            } else {
                return;
            }
        }
        Shell poruka = Konstante.getPoruka2(this.shell);
        this.shell.setEnabled(false);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(4, false));
        this.shell.setText("Izvestaj o stanju zaliha za period: " + Konstante.getDate(this.day1) + " -> " + Konstante.getDate(this.day2));
        this.podgrupaArtikala = pga;
        this.blic = bl;
        this.sifre = this.server.getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 4;
        this.table.setLayoutData((Object)data);
        if (this.blic2) {
            this.makeHeadersBlicIzlaz();
            this.insertRowsBlicIzlaz(this.odeljenje);
        } else {
            this.makeHeaders();
            if (this.odeljenje != null && this.odeljenje.getId() == 1L) {
                this.insertRowsMagacin(this.odeljenje);
            } else {
                this.insertRows(this.odeljenje);
            }
        }
        data = new GridData(120, 50);
        Button printButton = new Button((Composite)this.shell, 8);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText("Stampa");
        printButton.setLayoutData((Object)data);
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PrintHandler ph = IzvestajOStanjuZalihaBezPodgrupa.this.blic ? new PrintHandler(9, true, true) : new PrintHandler();
                GridPrinter gp = new GridPrinter(ph);
                gp.printTable(new TableWrapper(IzvestajOStanjuZalihaBezPodgrupa.this.table), false, true, "Izvestaj o stanju zaliha: " + Konstante.getDate(IzvestajOStanjuZalihaBezPodgrupa.this.day1) + "-->" + Konstante.getDate(IzvestajOStanjuZalihaBezPodgrupa.this.day2), IzvestajOStanjuZalihaBezPodgrupa.this.shell, IzvestajOStanjuZalihaBezPodgrupa.this.server);
            }
        });
        Button printButton2 = new Button((Composite)this.shell, 8);
        printButton2.setEnabled(!this.blic2);
        printButton2.setLayoutData((Object)data);
        try {
            printButton2.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton2.setText("Uska stampa");
        printButton2.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int items = IzvestajOStanjuZalihaBezPodgrupa.this.table.getItemCount();
                String[][] ts = new String[items][4];
                for (int i = 0; i < items - 1; ++i) {
                    ts[i][0] = IzvestajOStanjuZalihaBezPodgrupa.this.table.getItem(i).getText(0);
                    ts[i][1] = IzvestajOStanjuZalihaBezPodgrupa.this.table.getItem(i).getText(1);
                    ts[i][2] = IzvestajOStanjuZalihaBezPodgrupa.this.table.getItem(i).getText(2);
                    ts[i][3] = IzvestajOStanjuZalihaBezPodgrupa.this.table.getItem(i).getText(6).equalsIgnoreCase("ukupno") ? "" : IzvestajOStanjuZalihaBezPodgrupa.this.table.getItem(i).getText(6);
                }
                new StampaIzvestajZalihe(IzvestajOStanjuZalihaBezPodgrupa.this.restoran, ts, "IZVESTAJ O STANJU ZALIHA", IzvestajOStanjuZalihaBezPodgrupa.this.day1, IzvestajOStanjuZalihaBezPodgrupa.this.day2);
            }
        });
        Button export = new Button((Composite)this.shell, 8);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText("Excel izvoz");
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(IzvestajOStanjuZalihaBezPodgrupa.this.table, IzvestajOStanjuZalihaBezPodgrupa.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)data);
        Button izlaz = new Button((Composite)this.shell, 8);
        izlaz.setText("Izlaz");
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                IzvestajOStanjuZalihaBezPodgrupa.this.shell.close();
            }
        });
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        poruka.close();
        this.shell.setEnabled(true);
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public double izracunajPocetno(Artikal a) {
        double pocetno = 0.0;
        if (this.isBelo && this.mapaPocetnoB.get(a.getId()) != null) {
            pocetno += this.mapaPocetnoB.get(a.getId()).doubleValue();
        }
        if (this.isCrno && this.mapaPocetnoC.get(a.getId()) != null) {
            pocetno += this.mapaPocetnoC.get(a.getId()).doubleValue();
        }
        return pocetno;
    }

    public double izracunajUlaz(Artikal a) {
        double ulaz = 0.0;
        if (this.isBelo) {
            if (this.mapaUlazB.get(a.getId()) != null) {
                ulaz += this.mapaUlazB.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                ulaz += this.getDS(a).getBeloUlaz().doubleValue();
            }
        }
        if (this.isCrno) {
            if (this.mapaUlazC.get(a.getId()) != null) {
                ulaz += this.mapaUlazC.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                ulaz += this.getDS(a).getCrnoUlaz().doubleValue();
            }
        }
        for (Kartica k : this.kartica2) {
            if (!k.getArtikal().equals(a) || !k.getOdeljenje().equals(this.odeljenjeT) || !(k.getKolicina() > 0.0)) continue;
            ulaz += k.getKolicina().doubleValue();
        }
        return ulaz;
    }

    public double izracunajIzlaz(Artikal a) {
        double izlaz = 0.0;
        if (this.isBelo) {
            if (this.mapaIzlazB.get(a.getId()) != null) {
                izlaz += this.mapaIzlazB.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                izlaz += this.getDS(a).getBeloIzlaz().doubleValue();
            }
        }
        if (this.isCrno) {
            if (this.mapaIzlazC.get(a.getId()) != null) {
                izlaz += this.mapaIzlazC.get(a.getId()).doubleValue();
            }
            if (this.getDS(a) != null) {
                izlaz += this.getDS(a).getCrnoIzlaz().doubleValue();
            }
        }
        for (Kartica k : this.kartica2) {
            if (!k.getArtikal().equals(a) || !k.getOdeljenje().equals(this.odeljenjeT) || !(k.getKolicina() < 0.0)) continue;
            izlaz += -k.getKolicina().doubleValue();
        }
        return izlaz;
    }

    public void makeHeadersMagacin() {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setWidth(120);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText("Artikal");
        tc1.setWidth(110);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText("J.M.");
        tc2.setWidth(50);
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText("Pocetno");
        tc9.setWidth(90);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText("Ulaz");
        tc3.setWidth(90);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText("Izlaz");
        tc4.setWidth(90);
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText("Zavrsno");
        tc5.setWidth(90);
        TableColumn tc6 = new TableColumn(this.table, 131072);
        tc6.setText("Vrednost");
        tc6.setWidth(90);
        if (this.finansijski) {
            TableColumn tx = new TableColumn(this.table, 131072, 4);
            tx.setText("Vrednost");
            tx.setWidth(90);
            TableColumn tx1 = new TableColumn(this.table, 131072, 6);
            tx1.setText("Vrednost");
            tx1.setWidth(90);
            TableColumn tx2 = new TableColumn(this.table, 131072, 8);
            tx2.setText("Vrednost");
            tx2.setWidth(90);
            TableColumn tx3 = new TableColumn(this.table, 131072, 11);
            tx3.setText("Prodajna vrednost");
            tx3.setWidth(90);
        }
    }

    public void makeHeaders() {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setWidth(120);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText("Artikal");
        tc1.setWidth(110);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText("J.M.");
        tc2.setWidth(50);
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText("Pocetno");
        tc9.setWidth(90);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText("Ulaz");
        tc3.setWidth(90);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText("Izlaz");
        tc4.setWidth(90);
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText("Zavrsno");
        tc5.setWidth(90);
        TableColumn tc6 = new TableColumn(this.table, 131072);
        tc6.setText("Vrednost");
        tc6.setWidth(90);
        if (this.finansijski) {
            TableColumn tx = new TableColumn(this.table, 131072, 4);
            tx.setText("Vrednost");
            tx.setWidth(90);
            TableColumn tx1 = new TableColumn(this.table, 131072, 6);
            tx1.setText("Vrednost");
            tx1.setWidth(90);
            TableColumn tx2 = new TableColumn(this.table, 131072, 8);
            tx2.setText("Vrednost");
            tx2.setWidth(90);
            int c = 11;
            if (this.odeljenje == null || this.odeljenje.getId() != 1L) {
                TableColumn tx4 = new TableColumn(this.table, 131072, c);
                tx4.setText("Vrednost bez PDV-a");
                tx4.setWidth(90);
                ++c;
            }
            TableColumn tx3 = new TableColumn(this.table, 131072, c);
            tx3.setText("Prodajna vrednost");
            tx3.setWidth(90);
        }
    }

    public void makeHeadersBlicIzlaz() {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setWidth(120);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText("Artikal");
        tc1.setWidth(110);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText("J.M.");
        tc2.setWidth(50);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText("Izlaz");
        tc4.setWidth(90);
    }

    public void insertRowsMagacin(Odeljenje od) {
        this.day1 = Konstante.getPocetniDatum(this.day1, this.server);
        this.day2 = Konstante.getKrajnjiDatum(this.day2, this.server);
        if (this.day2.before(this.day1)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.day2);
            cal.add(6, 1);
            this.day2 = cal.getTime();
        }
        Map<Artikal, Double> mp = this.server.getArtikalZavrsnoStanjeZaOdeljenje(this.day1, this.isBelo, this.isCrno, this.odeljenje);
        ArrayList<Artikal> ll = new ArrayList<Artikal>(mp.keySet());
        this.sortiraj(ll);
        Map<Artikal, Double> mu = this.server.getArtikalUlazZaOdeljenje(this.day1, this.day2, this.isBelo, this.isCrno, this.odeljenje);
        Map<Artikal, Double> mi = this.server.getArtikalIzlazZaOdeljenje(this.day1, this.day2, this.isBelo, this.isCrno, this.odeljenje);
        double ukupnoOdPo = 0.0;
        double ukupnoOdUl = 0.0;
        double ukupnoOdPr = 0.0;
        double ukupnoOdeljenje = 0.0;
        double ukupnoOdeljenjePr = 0.0;
        TableItem ti = new TableItem(this.table, 0);
        ti.setText(0, this.odeljenje.getNaziv());
        for (Artikal art : ll) {
            double izlaz;
            double pocetno = mp.get(art);
            double ulaz = mu.get(art) != null ? mu.get(art) : 0.0;
            double d = izlaz = mi.get(art) != null ? -1.0 * mi.get(art) : 0.0;
            if (this.blic && ulaz == 0.0 && izlaz == 0.0) continue;
            double nabavnaBezPDV = art.getTrenutnaNV() / (1.0 + Konstante.getPdvPoPG(art.getPoreskaGrupa()));
            double zavrsno = pocetno + ulaz - izlaz;
            double vrednost = zavrsno * nabavnaBezPDV;
            double vrednostPr = zavrsno * art.getCena();
            ukupnoOdeljenje += vrednost;
            ukupnoOdeljenjePr += vrednostPr;
            double vredPoc = pocetno * nabavnaBezPDV;
            ukupnoOdPo += vredPoc;
            double vredUl = ulaz * nabavnaBezPDV;
            ukupnoOdUl += vredUl;
            double vredPro = izlaz * nabavnaBezPDV;
            ukupnoOdPr += vredPro;
            this.ukupno += vrednost;
            this.ukupnoPoc += vredPoc;
            this.ukupnoUl += vredUl;
            this.ukupnoPro += vredPro;
            this.ukupnaProdVredn += vrednostPr;
            String name = "";
            if (this.sifre) {
                String s = art.getBarCode() != null ? art.getBarCode() : "";
                name = s + " (" + art.getName() + ")";
            } else {
                name = art.getName();
            }
            ti = new TableItem(this.table, 0);
            if (this.finansijski) {
                ti.setText(new String[]{"", name, art.getJedinicaMere(), Konstante.getNumber4(pocetno), Konstante.getNumber4(vredPoc), Konstante.getNumber4(ulaz), Konstante.getNumber4(vredUl), Konstante.getNumber4(izlaz), Konstante.getNumber4(vredPro), Konstante.getNumber4(zavrsno), Konstante.getNumber2(vrednost), Konstante.getNumber2(vrednostPr)});
                continue;
            }
            ti.setText(new String[]{"", name, art.getJedinicaMere(), Konstante.getNumber4(pocetno), Konstante.getNumber4(ulaz), Konstante.getNumber4(izlaz), Konstante.getNumber4(zavrsno), Konstante.getNumber2(vrednost)});
        }
        ti = new TableItem(this.table, 0);
        if (this.finansijski) {
            ti.setText(3, "UKUPNO");
            ti.setText(4, Konstante.getNumber2(ukupnoOdPo));
            ti.setText(5, "UKUPNO");
            ti.setText(6, Konstante.getNumber2(ukupnoOdUl));
            ti.setText(7, "UKUPNO");
            ti.setText(8, Konstante.getNumber2(ukupnoOdPr));
            ti.setText(9, "UKUPNO");
            ti.setText(10, Konstante.getNumber2(ukupnoOdeljenje));
            ti.setText(11, Konstante.getNumber2(ukupnoOdeljenjePr));
        } else {
            ti.setText(6, "UKUPNO");
            ti.setText(7, Konstante.getNumber2(ukupnoOdeljenje));
        }
        ti = new TableItem(this.table, 0);
        if (this.finansijski) {
            ti.setText(3, "Total");
            ti.setText(4, Konstante.getNumber2(this.ukupnoPoc));
            ti.setText(5, "Total");
            ti.setText(6, Konstante.getNumber2(this.ukupnoUl));
            ti.setText(7, "Total");
            ti.setText(8, Konstante.getNumber2(this.ukupnoPro));
            ti.setText(9, "Total");
            ti.setText(10, Konstante.getNumber2(this.ukupno));
            ti.setText(11, Konstante.getNumber2(this.ukupnaProdVredn));
        } else {
            ti.setText(0, "Ukupna vrednost zaliha");
            ti.setText(7, Konstante.getNumber2(this.ukupno));
        }
    }

    public void insertRows(Odeljenje od) {
        Query q = this.server.getBase().createNativeQuery("select CONCAT(o.kratkiNaziv,'-',pg.naziv) AS grupa, a.`name`, ROUND(COALESCE(SUM(ds.beloUlaz - ds.beloIzlaz) , 0), 4) FROM dnevnostanje ds LEFT JOIN odeljenje o ON ds.ODELJENJE_ID = o.id LEFT JOIN artikal a ON ds.artikalID = a.id  LEFT JOIN  podgrupaartikala pg ON a.PODGRUPA_ID = pg.id WHERE ds.datum < CURDATE() AND a.tip <> 'SLOZ'  AND ds.ODELJENJE_ID <> 1 AND a.blokiran = 0 GROUP BY artikalID ORDER BY grupa, a.`name`;");
        List rs = q.getResultList();
        for (Object[] objects : rs) {
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(0, objects[0].toString());
            ti.setText(1, objects[1].toString());
            ti.setText(2, objects[2].toString());
            ti.setText(3, objects[3].toString());
        }
    }

    public void insertRowsBlicIzlaz(Odeljenje od) {
        List<Odeljenje> odeljenja;
        if (od == null) {
            odeljenja = this.server.readOdeljenjeBezMag2();
        } else {
            odeljenja = new ArrayList<Odeljenje>();
            odeljenja.add(od);
        }
        if (this.podgrupaArtikala == null) {
            this.podgrupe = this.server.readPodgrupeArtikala();
        } else {
            this.podgrupe = new ArrayList<PodgrupaArtikala>();
            this.podgrupe.add(this.podgrupaArtikala);
        }
        Iterator<Odeljenje> iterator = odeljenja.iterator();
        while (iterator.hasNext()) {
            double izlaz;
            TableItem ti;
            Odeljenje o;
            this.odeljenjeT = o = iterator.next();
            List<DnevnoStanje> dsList = this.server.getDnevnaStanjaJPA(o);
            this.mapaPocetnoB = new HashMap<Long, Double>();
            this.mapaIzlazB = new HashMap<Long, Double>();
            this.mapaUlazB = new HashMap<Long, Double>();
            this.mapaPocetnoC = new HashMap<Long, Double>();
            this.mapaIzlazC = new HashMap<Long, Double>();
            this.mapaUlazC = new HashMap<Long, Double>();
            this.artikli = this.server.getArtikliZaIzvestajOStanjuZaliha(o);
            System.out.println("artikli size = " + this.artikli.size());
            for (Long aID : this.artikli.keySet()) {
                if (this.isBelo) {
                    this.mapaPocetnoB.put(aID, 0.0);
                    this.mapaIzlazB.put(aID, 0.0);
                    this.mapaUlazB.put(aID, 0.0);
                }
                if (!this.isCrno) continue;
                this.mapaPocetnoC.put(aID, 0.0);
                this.mapaIzlazC.put(aID, 0.0);
                this.mapaUlazC.put(aID, 0.0);
            }
            for (DnevnoStanje ds : dsList) {
                Double tUlaz;
                Double tIzlaz;
                Double temp;
                double crnoIzlaz;
                double beloUlaz = ds.getBeloUlaz() == null ? 0.0 : ds.getBeloUlaz();
                double beloIzlaz = ds.getBeloIzlaz() == null ? 0.0 : ds.getBeloIzlaz();
                double crnoUlaz = ds.getCrnoUlaz() == null ? 0.0 : ds.getCrnoUlaz();
                double d = crnoIzlaz = ds.getCrnoIzlaz() == null ? 0.0 : ds.getCrnoIzlaz();
                if (this.isBelo && this.mapaPocetnoB.containsKey(ds.getArtikalID()) && this.mapaIzlazB.containsKey(ds.getArtikalID()) && this.mapaUlazB.containsKey(ds.getArtikalID())) {
                    if (ds.getDatum().compareTo(this.day1) < 0) {
                        temp = this.mapaPocetnoB.get(ds.getArtikalID());
                        temp = temp + (beloUlaz - beloIzlaz);
                        this.mapaPocetnoB.put(ds.getArtikalID(), temp);
                    } else if (ds.getDatum().compareTo(this.day1) > 0 && ds.getDatum().compareTo(this.day2) < 0) {
                        tIzlaz = this.mapaIzlazB.get(ds.getArtikalID());
                        tIzlaz = tIzlaz + beloIzlaz;
                        this.mapaIzlazB.put(ds.getArtikalID(), tIzlaz);
                        tUlaz = this.mapaUlazB.get(ds.getArtikalID());
                        tUlaz = tUlaz + beloIzlaz;
                        this.mapaUlazB.put(ds.getArtikalID(), tUlaz);
                    }
                }
                if (!this.isCrno || !this.mapaPocetnoC.containsKey(ds.getArtikalID()) || !this.mapaIzlazC.containsKey(ds.getArtikalID()) || !this.mapaUlazC.containsKey(ds.getArtikalID())) continue;
                if (ds.getDatum().compareTo(this.day1) < 0) {
                    temp = this.mapaPocetnoC.get(ds.getArtikalID());
                    temp = temp + (crnoUlaz - crnoIzlaz);
                    this.mapaPocetnoC.put(ds.getArtikalID(), temp);
                    continue;
                }
                if (ds.getDatum().compareTo(this.day1) <= 0 || ds.getDatum().compareTo(this.day2) >= 0) continue;
                tIzlaz = this.mapaIzlazC.get(ds.getArtikalID());
                tIzlaz = tIzlaz + crnoIzlaz;
                this.mapaIzlazC.put(ds.getArtikalID(), tIzlaz);
                tUlaz = this.mapaUlazC.get(ds.getArtikalID());
                tUlaz = tUlaz + crnoIzlaz;
                this.mapaUlazC.put(ds.getArtikalID(), tUlaz);
            }
            this.artikli = this.server.readArtikliBezSlozISir(o);
            this.artikli2.clear();
            for (Artikal a : this.artikli.values()) {
                this.artikli2.add(a);
            }
            this.sortiraj(this.artikli2);
            if (!this.artikli2.isEmpty()) {
                ti = new TableItem(this.table, 0);
                ti.setText(0, o.getNaziv());
                for (Artikal a : this.artikli2) {
                    izlaz = this.izracunajIzlaz(a);
                    if (this.blic && izlaz == 0.0) continue;
                    ti = new TableItem(this.table, 0);
                    ti.setText(new String[]{"", a.getName(), a.getJedinicaMere(), Konstante.getNumber4(izlaz)});
                }
            }
            this.artikli = this.server.readArtikliSirovine(o);
            this.artikli2.clear();
            for (Artikal a : this.artikli.values()) {
                this.artikli2.add(a);
            }
            this.sortiraj(this.artikli2);
            if (this.artikli2.isEmpty()) continue;
            ti = new TableItem(this.table, 0);
            ti.setText(0, "SIROVINE " + o.getNaziv());
            for (Artikal a : this.artikli2) {
                izlaz = this.izracunajIzlaz(a);
                double ulaz = this.izracunajUlaz(a);
                if (this.blic && ulaz == 0.0 && izlaz == 0.0) continue;
                double pocetno = this.izracunajPocetno(a);
                double zavrsno = pocetno + ulaz - izlaz;
                double vrednost = zavrsno * a.getTrenutnaNV();
                this.ukupno += vrednost;
                String name = "";
                if (this.sifre) {
                    String s = a.getBarCode() != null ? a.getBarCode() : "";
                    name = s + " (" + a.getName() + ")";
                } else {
                    name = a.getName();
                }
                ti = new TableItem(this.table, 0);
                ti.setText(new String[]{"", name, a.getJedinicaMere(), Konstante.getNumber4(izlaz)});
            }
        }
        TableItem ti = new TableItem(this.table, 0);
        ti = new TableItem(this.table, 0);
        if (this.finansijski) {
            ti.setText(3, "Total");
            ti.setText(4, Konstante.getNumber2(this.ukupnoPoc));
            ti.setText(5, "Total");
            ti.setText(6, Konstante.getNumber2(this.ukupnoUl));
            ti.setText(7, "Total");
            ti.setText(8, Konstante.getNumber2(this.ukupnoPro));
            ti.setText(9, "Total");
            ti.setText(10, Konstante.getNumber2(this.ukupno));
        } else {
            ti.setText(0, "Ukupna vrednost zaliha");
            ti.setText(7, Konstante.getNumber2(this.ukupno));
        }
    }

    public void sortiraj(List<Artikal> artikli) {
        Comparator<Artikal> SENIORITY_ORDER = null;
        SENIORITY_ORDER = new Comparator<Artikal>(){

            @Override
            public int compare(Artikal t1, Artikal t2) {
                return t1.getName().compareTo(t2.getName());
            }
        };
        Collections.sort(artikli, SENIORITY_ORDER);
    }

    DnevnoStanje getDS(Artikal a) {
        if (this.stanjaDanas == null) {
            return null;
        }
        for (DnevnoStanje ds : this.stanjaDanas) {
            if (!ds.getArtikalID().equals(a.getId())) continue;
            return ds;
        }
        return null;
    }

    public static class IzvestajOStanjuZalihaBezPodgrupaInput {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo odeljenje;
        private Combo podgrupa;
        private Button finans;
        private Button blic;
        private Button blicIzlaz;
        Date day1;
        Date day2;
        private Button belo;
        private Button crno;
        private Button medjuzbir;
        boolean iscrno;
        boolean inspekcija;
        Odeljenje o;
        PodgrupaArtikala pgaSelected;
        List<Odeljenje> odeljenja;
        List<PodgrupaArtikala> podgrupe;
        SWTContainer parent;
        boolean bel;
        boolean cr;
        boolean medjz;

        public IzvestajOStanjuZalihaBezPodgrupaInput(SWTContainer owner, Restoran r, boolean ins) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.iscrno = this.server.readCrnaPlacanjaIzvestaji().size() > 0;
            this.inspekcija = ins;
            this.odeljenja = this.server.readOdeljenje();
            for (Odeljenje od : this.odeljenja) {
                od.setArtikli(od.getArtikli());
            }
            this.podgrupe = this.server.readPodgrupeArtikala();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/stanjeZalihaV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText("Izvestaj o stanju zaliha ");
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText("Ekran za unos, pregled i ispravku.\n Za vise informacija kliknite na ikonicu tehnickog uputstva ->");
            Button uputstvo = new Button(panel1, 8);
            uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText("Unos datuma");
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 180;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText("Filter izvestaja");
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 70;
            Group grupa21 = null;
            if (!this.inspekcija) {
                grupa21 = new Group(panel2, 0);
                grupa21.setLayout((Layout)new GridLayout(4, false));
                grupa21.setText("Filter nacina placanja");
                grupa21.setLayoutData((Object)data);
            }
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText("Od datuma:");
            this.odDatuma = new DateInput2(parent2, "Od datuma", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText("Do datuma:");
            this.doDatuma = new DateInput2(parent2, "Do datuma", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Label art = new Label((Composite)grupa2, 0);
            art.setText("Odeljenje:");
            this.odeljenje = new Combo((Composite)grupa2, 8);
            this.odeljenje.add("Sva proizvodna mesta");
            for (Odeljenje odeljenje : this.odeljenja) {
                this.odeljenje.add(odeljenje.getNaziv());
            }
            this.odeljenje.select(0);
            Label pgaLabel = new Label((Composite)grupa2, 0);
            pgaLabel.setText("Podgrupa artikala:");
            this.podgrupa = new Combo((Composite)grupa2, 8);
            this.podgrupa.add("Sve podgrupe artikala");
            for (PodgrupaArtikala pga : this.podgrupe) {
                this.podgrupa.add(pga.getNaziv());
            }
            this.podgrupa.select(0);
            Label label = new Label((Composite)grupa2, 0);
            label.setText("Finansijski prikaz:");
            this.finans = new Button((Composite)grupa2, 32);
            Label bl = new Label((Composite)grupa2, 0);
            bl.setText("Samo sa promenama:");
            this.blic = new Button((Composite)grupa2, 32);
            Label bl2 = new Label((Composite)grupa2, 0);
            bl2.setText("Blic izlaz:");
            this.blicIzlaz = new Button((Composite)grupa2, 32);
            if (!this.inspekcija) {
                this.belo = new Button((Composite)grupa21, 32);
                this.belo.setText("Osnovna placanja");
                this.belo.setSelection(true);
                if (this.iscrno) {
                    this.crno = new Button((Composite)grupa21, 32);
                    this.crno.setText("Dodatna placanja");
                }
                this.medjuzbir = new Button((Composite)grupa21, 32);
                this.medjuzbir.setText("Medjuzbir");
            }
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            bl.setLayoutData((Object)data);
            bl2.setLayoutData((Object)data);
            art.setLayoutData((Object)data);
            pgaLabel.setLayoutData((Object)data);
            this.finans.setLayoutData((Object)data);
            this.blic.setLayoutData((Object)data);
            this.blicIzlaz.setLayoutData((Object)data);
            this.odeljenje.setLayoutData((Object)data);
            this.podgrupa.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                this.o = this.odeljenje.getSelectionIndex() == 0 ? null : this.odeljenja.get(this.odeljenje.getSelectionIndex() - 1);
                this.pgaSelected = this.podgrupa.getSelectionIndex() == 0 ? null : this.podgrupe.get(this.podgrupa.getSelectionIndex() - 1);
                if (this.inspekcija) {
                    this.bel = true;
                    this.cr = false;
                    this.medjz = false;
                    if (this.day2.equals(Konstante.getOnlyDate(new Date()))) {
                        this.medjz = true;
                    }
                } else {
                    this.bel = this.belo.getSelection();
                    this.cr = false;
                    if (this.iscrno) {
                        this.cr = this.crno.getSelection();
                    }
                    this.medjz = this.medjuzbir.getSelection();
                }
                this.server.log("Pregled izvestaja zaliha: od datuma->" + this.day1 + " do datuma ->" + this.day2);
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                new IzvestajOStanjuZalihaBezPodgrupa(shell2, this.restoran, this.day1, this.day2, this.o, this.finans.getSelection(), this.blic.getSelection(), this.blicIzlaz.getSelection(), this.bel, this.cr, this.medjz, this.pgaSelected);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), "Greska", 2);
            }
        }
    }
}

