/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.nivelacija.NivelacijaRow;
import com.dev63.restoran.izvestaji.stampa.ReportPrintBuilder;
import com.dev63.restoran.izvestaji.stampa.StampaNivelacijeNPC;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.controller.NivelacijaController;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.swt.components.SWTMessage;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintJob;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class IzvestajNivelacije {
    private static final Logger logger = Logger.getLogger(IzvestajNivelacije.class.getName());
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    SWTContainer parent;
    Shell shell;
    Composite composite;
    MenuItem item1;
    Date day1;
    private List<NivelacijaRow> stavke;

    private IzvestajNivelacije(SWTContainer owner, Restoran r, final Date day1) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.shell = this.parent.getControl().getShell();
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout());
        this.day1 = day1;
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        Button printButton = new Button((Composite)this.shell, 8);
        printButton.setImage(ImageCache.getImage("print.gif"));
        printButton.setText("Stampa");
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                BusyIndicator.showWhile((Display)IzvestajNivelacije.this.shell.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String pib = IzvestajNivelacije.this.server.getSetting(Option.OBJEKAT_PIB_PREFIX).stringValue() + IzvestajNivelacije.this.server.getSetting(Option.OBJEKAT_PIB).stringValue();
                        String obveznik = IzvestajNivelacije.this.server.getSetting(Option.DOK_OBVEZNIK).stringValue();
                        String firmaRadnje = IzvestajNivelacije.this.server.getSetting(Option.DOK_FIRMA_RADNJE).stringValue();
                        String sediste = IzvestajNivelacije.this.server.getSetting(Option.DOK_SEDISTE).stringValue();
                        String sifraPoreskogObveznika = IzvestajNivelacije.this.server.getSetting(Option.DOK_SIFRA_PORESKOG_OBVEZNIKA).stringValue();
                        String logoPath = IzvestajNivelacije.this.server.getSetting(Option.DOK_LOGO).stringValue();
                        String sifraDelatnosti = IzvestajNivelacije.this.server.getSetting(Option.SIFRA_DELATNOSTI).stringValue();
                        EnumMap<StampaNivelacijeNPC.DataKey, String> data = new EnumMap<StampaNivelacijeNPC.DataKey, String>(StampaNivelacijeNPC.DataKey.class);
                        data.put(StampaNivelacijeNPC.DataKey.FIRMA_RADNJE, firmaRadnje);
                        data.put(StampaNivelacijeNPC.DataKey.OBVEZNIK, obveznik);
                        data.put(StampaNivelacijeNPC.DataKey.SEDISTE, sediste);
                        data.put(StampaNivelacijeNPC.DataKey.SIFRA_DELATNOSTI, sifraDelatnosti);
                        data.put(StampaNivelacijeNPC.DataKey.SIFRA_PORESKOG_OBVEZNIKA, sifraPoreskogObveznika);
                        data.put(StampaNivelacijeNPC.DataKey.LOGO_PATH, logoPath);
                        data.put(StampaNivelacijeNPC.DataKey.PIB, pib);
                        StampaNivelacijeNPC p = new StampaNivelacijeNPC(IzvestajNivelacije.this.stavke, data, day1);
                        GridPrinter gp = new GridPrinter(new PrintHandler());
                        ReportPrintBuilder.printPreview(IzvestajNivelacije.this.shell.getDisplay(), new PrintJob("Nivelacija", (Print)p), false);
                    }
                });
            }
        });
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    private void makeHeaders() {
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText("RB");
        tc1.setWidth(34);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText("Naziv");
        tc2.setWidth(200);
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText("Jed. mere");
        tc9.pack();
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText("Kolicina");
        tc3.pack();
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText("Stara cena");
        tc4.pack();
        TableColumn tc6 = new TableColumn(this.table, 131072);
        tc6.setText("Nova cena");
        tc6.pack();
        TableColumn tc7 = new TableColumn(this.table, 131072);
        tc7.setText("Povecanje cene");
        tc7.pack();
        TableColumn tc12 = new TableColumn(this.table, 131072);
        tc12.setText("PDV");
        tc12.setWidth(53);
        TableColumn tc13 = new TableColumn(this.table, 131072);
        tc13.setText("Povecanje pdva");
        tc13.pack();
        TableColumn tc14 = new TableColumn(this.table, 131072);
        tc14.setText("Stara cena sa pdv");
        tc14.pack();
        TableColumn tc8 = new TableColumn(this.table, 131072);
        tc8.setText("Nova cena sa pdv");
        tc8.pack();
        TableColumn tc16 = new TableColumn(this.table, 131072);
        tc16.setText("Povecanje razlike u ceni");
        tc16.pack();
        TableColumn tc10 = new TableColumn(this.table, 131072);
        tc10.setText("Povecanje poreza");
        tc10.pack();
    }

    private void insertRows() {
        TableItem item;
        try (NivelacijaController nc = new NivelacijaController();){
            this.stavke = nc.processData(nc.loadData(this.day1));
        }
        catch (Exception e) {
            this.stavke = Collections.emptyList();
            logger.log(Level.SEVERE, "Greska kod ucitavanja podataka o Nivelaciji!", e);
            SWTMessage.showLocalizedErrorDialog(this.shell, String.format(Konstante.getBundle().getString("PORUKA_GRESKA_KOD_UCITAVANJA_PODATAKA_O_NIVELACIJI"), new Object[0]));
            return;
        }
        BigDecimal uPovecanjeRazlikeUCeni = BigDecimal.ZERO;
        BigDecimal uPovecanjePoreza = BigDecimal.ZERO;
        for (NivelacijaRow row : this.stavke) {
            item = new TableItem(this.table, 0);
            int r = 0;
            item.setText(r++, Objects.toString(row.redniBroj));
            item.setText(r++, Objects.toString(row.naziv));
            item.setText(r++, Objects.toString(row.jedinicaMere));
            item.setText(r++, StatLogic.getNumber03NG(row.kolicina));
            item.setText(r++, StatLogic.getNumber02NG(row.staraCena));
            item.setText(r++, StatLogic.getNumber02NG(row.novaCena));
            item.setText(r++, StatLogic.getNumber02NG(row.povecanjeCene));
            item.setText(r++, StatLogic.getNumber02NG(row.PDV));
            item.setText(r++, StatLogic.getNumber02NG(row.povecanjePDVa));
            item.setText(r++, StatLogic.getNumber02NG(row.staraCenaSaPDVom));
            item.setText(r++, StatLogic.getNumber02NG(row.novaCenaSaPDVom));
            item.setText(r++, StatLogic.getNumber02NG(row.povecanjeRazlikeUCeni));
            item.setText(r++, StatLogic.getNumber02NG(row.povecanjePoreza));
            uPovecanjeRazlikeUCeni = uPovecanjeRazlikeUCeni.add(row.povecanjeRazlikeUCeni);
            uPovecanjePoreza = uPovecanjePoreza.add(row.povecanjePoreza);
        }
        item = new TableItem(this.table, 0);
        item.setText(1, "Ukupno:");
        item.setText(11, StatLogic.getNumber02NG(uPovecanjeRazlikeUCeni));
        item.setText(12, StatLogic.getNumber02NG(uPovecanjePoreza));
        item = new TableItem(this.table, 0);
        item.setText(11, "Ukupna razlika:");
        item.setText(12, StatLogic.getNumber02NG(uPovecanjePoreza.add(uPovecanjeRazlikeUCeni)));
    }

    public static class IzvestajNivelacijeInput {
        private DateInput2 zaDatum;
        private Restoran restoran;
        SWTContainer parent;

        public IzvestajNivelacijeInput(SWTContainer owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/izvestajV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText("Izvestaj nivelacije");
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText("Ekran za unos, pregled i ispravku.\n Za vise informacija kliknite na ikonicu tehnickog uputstva ->");
            Button uputstvo = new Button(panel1, 8);
            uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText("Unos datuma");
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText("Za datum:");
            this.zaDatum = new DateInput2(parent2, "Za datum", new Date(), false, this.restoran.getServer());
            this.zaDatum.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.zaDatum, shell));
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            this.zaDatum.getControl().setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            Date result = null;
            try {
                result = this.zaDatum.getResult();
            }
            catch (InputException ex) {
                ex.printStackTrace();
            }
            if (result == null) {
                return;
            }
            Shell frame = new Shell((Shell)this.parent.getComposite(), 34032);
            SWTContainer c = new SWTContainer((Composite)frame);
            new IzvestajNivelacije(c, this.restoran, result);
        }
    }
}

