/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.MeniPromet;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DpuUtrosciServer {
    int q = 6;
    int f = 8;

    public static List<Object> upisiSlozDodaOdPica(int redniBroj, String pdv, Artikal artikal, StavkaRacuna s) {
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + s.getName());
        podaciZaRedove.add(pdv);
        podaciZaRedove.add(artikal.getJedinicaMere());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(s.getCena());
        podaciZaRedove.add(s.getKolicina() * s.getCena());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina() * s.getCena());
        podaciZaRedove.add(artikal.getOdeljenjeNormativ());
        return podaciZaRedove;
    }

    public static List<Object> upisiSlozDodaOdPicaHotelski(int redniBroj, String pdv, Artikal artikal, StavkaRacuna s) {
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + s.getName() + "-Hotelski gost");
        podaciZaRedove.add(pdv);
        podaciZaRedove.add(artikal.getJedinicaMere());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina() * s.getCena());
        podaciZaRedove.add(artikal.getOdeljenjeNormativ());
        return podaciZaRedove;
    }

    public static List<Object> upisiSlozDodaOdJela(int redniBroj, String pdv, Artikal artikal, StavkaRacuna s) {
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + s.getName());
        podaciZaRedove.add(pdv);
        podaciZaRedove.add(artikal.getJedinicaMere());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(s.getCena());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina() * s.getCena());
        podaciZaRedove.add(s.getKolicina() * s.getCena());
        podaciZaRedove.add(artikal.getOdeljenjeNormativ());
        return podaciZaRedove;
    }

    public static List<Object> upisiSlozDodaOdJelaHotelski(int redniBroj, String pdv, Artikal artikal, StavkaRacuna s) {
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + s.getName() + " -Hotelski gost");
        podaciZaRedove.add(pdv);
        podaciZaRedove.add(artikal.getJedinicaMere());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(artikal.getOdeljenjeNormativ());
        return podaciZaRedove;
    }

    public static List<Object> upisiSlozDodaBezProdaje(int redniBroj, String pdv, Artikal artikal) {
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + artikal.getName());
        podaciZaRedove.add(pdv);
        podaciZaRedove.add(artikal.getJedinicaMere());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(artikal.getCena());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(artikal.getOdeljenjeNormativ());
        return podaciZaRedove;
    }

    public static List<Object> upisiProdajniOsnovni(int redniBroj, String pdv, Artikal artikal, double pocetno, double ulaz, double zavrsno, double utroseno) {
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + artikal.getName());
        podaciZaRedove.add(pdv);
        podaciZaRedove.add(artikal.getJedinicaMere());
        podaciZaRedove.add(pocetno);
        podaciZaRedove.add(ulaz);
        podaciZaRedove.add(pocetno + ulaz);
        podaciZaRedove.add(zavrsno);
        podaciZaRedove.add(utroseno);
        podaciZaRedove.add(artikal.getCena());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(ulaz * artikal.getCena());
        podaciZaRedove.add(artikal.getOdeljenjeNormativ());
        return podaciZaRedove;
    }

    public static List<Object> upisiProdajniSumarno(int redniBroj, String pdv, Artikal artikal, double pocetno, double ulaz, double zavrsno, double utroseno) {
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + artikal.getName());
        podaciZaRedove.add(pdv);
        podaciZaRedove.add(artikal.getJedinicaMere());
        podaciZaRedove.add(pocetno);
        podaciZaRedove.add(ulaz);
        podaciZaRedove.add(pocetno + ulaz);
        podaciZaRedove.add(zavrsno);
        podaciZaRedove.add(utroseno);
        podaciZaRedove.add(artikal.getCena());
        podaciZaRedove.add(utroseno * artikal.getCena());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(ulaz * artikal.getCena());
        podaciZaRedove.add(artikal.getOdeljenjeNormativ());
        return podaciZaRedove;
    }

    public static List<Object> upisiProdajniSumarnoHotelskiGost(int redniBroj, String pdv, Artikal artikal, double pocetno, double ulaz, double zavrsno, double utroseno) {
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + artikal.getName() + " - Hotelski gost");
        podaciZaRedove.add(pdv);
        podaciZaRedove.add(artikal.getJedinicaMere());
        podaciZaRedove.add(pocetno);
        podaciZaRedove.add(ulaz);
        podaciZaRedove.add(pocetno + ulaz);
        podaciZaRedove.add(zavrsno);
        podaciZaRedove.add(utroseno);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(ulaz * artikal.getCena());
        podaciZaRedove.add(artikal.getOdeljenjeNormativ());
        return podaciZaRedove;
    }

    public static List<Object> upisiProdajniOdPica(int redniBroj, String pdv, Artikal artikal, StavkaRacuna s) {
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + artikal.getName() + " - prodaja");
        podaciZaRedove.add(pdv);
        podaciZaRedove.add(artikal.getJedinicaMere());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(s.getCena());
        podaciZaRedove.add(s.getKolicina() * s.getCena());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(artikal.getOdeljenjeNormativ());
        return podaciZaRedove;
    }

    public static List<Object> upisiProdajniOdPicaHotelski(int redniBroj, String pdv, Artikal artikal, StavkaRacuna s) {
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + artikal.getName() + " - Hotelski gost");
        podaciZaRedove.add(pdv);
        podaciZaRedove.add(artikal.getJedinicaMere());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(artikal.getOdeljenjeNormativ());
        return podaciZaRedove;
    }

    public static List<Object> upisiProdajniOdJela(int redniBroj, String pdv, Artikal artikal, StavkaRacuna s) {
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + artikal.getName() + " - prodaja");
        podaciZaRedove.add(pdv);
        podaciZaRedove.add(artikal.getJedinicaMere());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(s.getCena());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina() * s.getCena());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(artikal.getOdeljenjeNormativ());
        return podaciZaRedove;
    }

    public static List<Object> upisiProdajniOdJelaHotelski(int redniBroj, String pdv, Artikal artikal, StavkaRacuna s) {
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + artikal.getName() + " -Hotelski gost ");
        podaciZaRedove.add(pdv);
        podaciZaRedove.add(artikal.getJedinicaMere());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(artikal.getOdeljenjeNormativ());
        return podaciZaRedove;
    }

    public static List<Object> upisiProdajniBezProdaje(int redniBroj, String pdv, Artikal artikal, double pocetno, double ulaz, double zavrsno, double utroseno) {
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + artikal.getName());
        podaciZaRedove.add(pdv);
        podaciZaRedove.add(artikal.getJedinicaMere());
        podaciZaRedove.add(pocetno);
        podaciZaRedove.add(ulaz);
        podaciZaRedove.add(pocetno + ulaz);
        podaciZaRedove.add(zavrsno);
        podaciZaRedove.add(utroseno);
        podaciZaRedove.add(artikal.getCena());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(ulaz * artikal.getCena());
        podaciZaRedove.add(artikal.getOdeljenjeNormativ());
        return podaciZaRedove;
    }

    public static List<Object> razloziUtroskeProdajnog(int redniBroj, String pdv, Artikal artikal, double utrosak, String opis) {
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + artikal.getName() + " " + opis);
        podaciZaRedove.add(pdv);
        podaciZaRedove.add(artikal.getJedinicaMere());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(Konstante.round(utrosak, 4));
        podaciZaRedove.add(artikal.getCena());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(artikal.getOdeljenjeNormativ());
        return podaciZaRedove;
    }

    public static List<Object> upisiArtikalKrozMeni(int redniBroj, String pdv, Artikal artikal, StavkaRacuna s) {
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + s.getName() + " - meni");
        podaciZaRedove.add(pdv);
        podaciZaRedove.add(artikal.getJedinicaMere());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(s.getKolicina());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(artikal.getOdeljenjeNormativ());
        return podaciZaRedove;
    }

    public static List<Object> upisiMeni(int redniBroj, MeniPromet m) {
        Odeljenje o = new Odeljenje();
        o.setNaziv("Meni");
        ArrayList<Object> podaciZaRedove = new ArrayList<Object>();
        podaciZaRedove.add(redniBroj);
        podaciZaRedove.add(" " + m.getNaziv() + " - meni");
        podaciZaRedove.add("20%");
        podaciZaRedove.add("KOM");
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(m.getKolicina());
        podaciZaRedove.add(m.getKolicina());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(m.getKolicina());
        podaciZaRedove.add(m.getCena());
        podaciZaRedove.add(0.0);
        podaciZaRedove.add(m.getKolicina() * m.getCena());
        podaciZaRedove.add(m.getKolicina() * m.getCena());
        podaciZaRedove.add(o);
        return podaciZaRedove;
    }

    public static double izlazOstaliDokumenti(RestoranServer server, Artikal artikal, Date d) {
        String query = "select sum(ts.kolicina) as izlaz from trebovanjestavka ts left join trebovanje t on ts.TREBOVANJE_ID = t.id where  t.tip in ('POVRAT_SA_KNJIZ', 'POVRAT_BEZ_KNJIZ', 'OTPREM_SA_KNJIZ', 'OTPREM_BEZ_KNJIZ', 'POVRAT_U_MAGACIN', 'OTPIS') AND t.crno = false and t.datumTrebovanja =? and ts.ARTIKAL_ID =? ";
        try {
            PreparedStatement pStatement = server.getConnection().prepareStatement(query);
            pStatement.setDate(1, d);
            pStatement.setLong(2, artikal.getId());
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            return rSet.getDouble("izlaz");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static boolean isBlokiran(Artikal a, double ulaz, double utroseno, double ukupanIzlazPoStavci) {
        if ((a.getTip() == TipArtikla.SLOZ || a.getTip() == TipArtikla.DODA) && ukupanIzlazPoStavci == 0.0 && a.getBlokiran().booleanValue()) {
            return true;
        }
        return (a.getTip() == TipArtikla.PROD || a.getTip() == TipArtikla.SIRO || a.getTip() == TipArtikla.POLU) && a.getBlokiran() != false && ulaz == 0.0 && utroseno == 0.0;
    }

    public static boolean nijeBiloPromena(Artikal a, double ulaz, double utroseno, double ukupanIzlazPoStavci) {
        if ((a.getTip() == TipArtikla.SLOZ || a.getTip() == TipArtikla.DODA) && ukupanIzlazPoStavci == 0.0) {
            return true;
        }
        return (a.getTip() == TipArtikla.PROD || a.getTip() == TipArtikla.SIRO || a.getTip() == TipArtikla.POLU) && ulaz == 0.0 && utroseno == 0.0;
    }

    public static Artikal getDPUArtikal(RestoranServer server, long id) {
        Connection connection = server.getConnection();
        String query = "select * from artikal where id = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            rs.next();
            Artikal a = new Artikal();
            a.setId(rs.getLong("id"));
            a.setBarCode(rs.getString("barCode"));
            a.setBlokiran(rs.getBoolean("blokiran"));
            a.setCena(rs.getDouble("cena"));
            a.setDozvoljenPopust(rs.getBoolean("dozvoljenPopust"));
            a.setJedinicaMere(rs.getString("jedinicaMere"));
            a.setJelo(rs.getBoolean("jelo"));
            a.setMera(rs.getDouble("mera"));
            a.setMinLager(rs.getDouble("minLager"));
            a.setName(rs.getString("name"));
            a.setNijeDeoSlozenog(rs.getBoolean("nijeDeoSlozenog"));
            a.setPice(rs.getBoolean("pice"));
            a.setPoreskaGrupa(PoreskaGrupa.values()[rs.getShort("poreskaGrupa")]);
            a.setPrioritet(rs.getInt("prioritet"));
            a.setSkrNaziv(rs.getString("skrNaziv"));
            a.setTip(TipArtikla.tipByName(rs.getString("tip")));
            a.setOdeljenjeNormativ(server.getOdeljenje(rs.getLong("ODELJENJENORMATIV_ID")));
            a.setPodgrupa(server.getpodgrupaById(rs.getLong("PODGRUPA_ID")));
            return a;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Double> iznosPoNacinimaPlacanja(RestoranServer server, long zdBroj) {
        HashMap<String, Double> iznosPoNacinimaPlacanja = new HashMap<String, Double>();
        String paramQuery = "set @zdBroj = ?";
        String query = "select nacin, sum(neto) as neto, sum(popust) as popust, sum(servis) as servis, sum(bruto) as bruto FROM ( \r\nselect \r\np.nacin as 'nacin',\r\nsum(sr.kolicina * sr.cena) as 'neto',\r\nROUND(sum(sr.kolicina * sr.cena)- sum(sr.kolicina * (sr.cena * (100 - coalesce(r.popust*(if(r.menipromet, 1 ,a.dozvoljenPopust)), 0))/100)),2) as 'popust',\r\nROUND(if(sum(sr.kolicina * (sr.cena * (100 - coalesce(r.popust*(if(r.menipromet, 1 ,a.dozvoljenPopust)), 0))/100)) > sum(sr.kolicina * sr.cena), \r\nsum(sr.kolicina * (sr.cena * (100 - coalesce(r.popust*(if(r.menipromet, 1 ,a.dozvoljenPopust)), 0))/100))-sum(sr.kolicina * sr.cena),  0),2) as 'servis',\r\nROUND(sum(sr.kolicina * (sr.cena * (100 - coalesce(r.popust*(if(r.menipromet, 1 ,a.dozvoljenPopust)), 0))/100)),2) as 'bruto'\r\nfrom racun r\r\nleft join placanje p on p.RACUN_ID = r.id \r\nleft join stavkaracuna sr on sr.RACUN_ID = r.id\r\nleft join artikal a on a.id = sr.ARTIKAL_ID\r\nINNER JOIN (SELECT RACUN_ID, COUNT(RACUN_ID) as cnt FROM placanje GROUP BY RACUN_ID) c ON r.id = c.RACUN_ID\r\nwhere  r.zdBroj BETWEEN @zdBroj AND @zdBroj \r\nand r.id in (select RACUN_ID from placanje where r.id= placanje.RACUN_ID and FIND_IN_SET(placanje.nacin, 'Gotovina,\u010cek,Kartica,Faktura' ) )\r\nAND c.cnt < 2 \r\ngroup by p.nacin\r\n\r\nunion\r\n\r\nselect distinct\r\np.nacin as 'nacin',\r\nsum(p.iznos) as 'neto',\r\nROUND(sum(p.iznos)- sum(p.iznos *( (100 - r.popust)/100)),2) as 'popust',\r\nROUND(if(sum(p.iznos *( (100 - r.popust)/100)) > sum(p.iznos), \r\nsum(p.iznos *( (100 - r.popust)/100))-sum(p.iznos),  0),2) as 'servis',\r\nROUND(sum(p.iznos *( (100 - r.popust)/100)),2) as 'bruto'\r\nfrom racun r\r\nLEFT JOIN placanje p ON r.id = p.RACUN_ID AND ( find_in_set(p.nacin,   'Gotovina,\u010cek,Kartica,Faktura'  ))\r\nINNER JOIN (SELECT RACUN_ID, COUNT(RACUN_ID) as cnt FROM placanje GROUP BY RACUN_ID) c ON r.id = c.RACUN_ID\r\nwhere  r.zdBroj BETWEEN  @zdBroj AND @zdBroj \r\nAND c.cnt > 1 \r\ngroup by p.nacin \r\n\r\n) as t \r\ngroup by nacin order by nacin";
        try {
            double ukupno = 0.0;
            PreparedStatement ps = server.getConnection().prepareStatement(paramQuery);
            ps.setLong(1, zdBroj);
            ps.executeUpdate();
            ps = server.getConnection().prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ukupno += rs.getDouble("bruto");
                iznosPoNacinimaPlacanja.put(rs.getString("nacin"), rs.getDouble("bruto"));
            }
            iznosPoNacinimaPlacanja.put("UKUPNO", ukupno);
            return iznosPoNacinimaPlacanja;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

