/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.izvestaji.DpuUtrosciServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.MeniPromet;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.reports.JasperModels.DpuJasperCall;
import com.dev63.restoran.sistem.CalendarAdapter;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class DPUUtrosci {
    private Restoran restoran;
    private RestoranServer server;
    private Shell shell;
    private Label photo;
    private Group dpuGroup;
    private Group dateGroup;
    private GridData gridData;
    private Label dateLabel;
    private DateInput2 datePick;
    private Group filterGroup;
    private Label odeljenjeLab;
    private Combo odeljenjCombo;
    private List<Odeljenje> odeljenja;
    private Button promeneCheck;
    private Label promeneLab;
    private Button prikazSirovinCheck;
    private Label prikazSirovinaLab;
    private Button cancelButton;
    private Button confirmButton;
    private Group buttonGroup;
    private Odeljenje odeljenje;
    LinkedHashMap<String, Long> prodajniArtikli = new LinkedHashMap();
    private Artikal artikal;
    private List<List<Object>> redovi;
    private List<StavkaRacuna> stavke;
    private java.util.Date day;
    private java.util.Date yesterday;
    private Calendar calendar;
    private Double odJela;
    private Double odPica;
    private Double pvKonzumacija;
    private int redniBroj;
    private String pdv;
    private String nazivFirme;
    private String adresaFirme;
    private String pibFirme;
    private List<MeniPromet> menipromet;
    private Display display;
    private boolean prikazSirovina;
    private boolean promene;
    private long zdBroj;
    private Map<String, Double> iznosPoNacinimaPlacanja;

    public DPUUtrosci(Shell shell, Restoran restoran) {
        this.restoran = restoran;
        this.server = restoran.getServer();
        this.odeljenja = this.server.getOdeljenjaBezMagacina();
        this.shell = shell;
        this.redniBroj = 0;
        this.nazivFirme = this.server.getSetting(Option.PREDUZECE_NAZIV).getActual();
        this.adresaFirme = this.server.getSetting(Option.PREDUZECE_ADRESA).getActual();
        this.pibFirme = this.server.getSetting(Option.OBJEKAT_PIB).getActual();
        this.display = shell.getDisplay();
        this.redovi = new ArrayList<List<Object>>();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        shell.setLayout((Layout)gridLayout);
        this.photo = new Label((Composite)shell, 0);
        this.photo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/dpuV.gif"));
        this.dpuGroup = new Group((Composite)shell, 0);
        this.dpuGroup.setText("Izbor za kreiranje DPU liste");
        this.gridData = new GridData();
        this.gridData.widthHint = 620;
        this.gridData.heightHint = 80;
        this.dpuGroup.setLayoutData((Object)this.gridData);
        this.dateGroup = new Group((Composite)shell, 0);
        this.dateGroup.setText("IzborDatuma:");
        this.gridData = new GridData();
        this.gridData.horizontalAlignment = 4;
        this.gridData.horizontalSpan = 2;
        this.gridData.heightHint = 80;
        this.dateGroup.setLayoutData((Object)this.gridData);
        this.dateGroup.setLayout((Layout)gridLayout);
        this.dateLabel = new Label((Composite)this.dateGroup, 0);
        this.dateLabel.setText("Datum:");
        SWTContainer container = new SWTContainer((Composite)this.dateGroup);
        this.datePick = new DateInput2(container, "Od datuma", new java.util.Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.datePick.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datePick, shell));
        this.filterGroup = new Group((Composite)shell, 0);
        this.filterGroup.setLayout((Layout)gridLayout);
        this.filterGroup.setText("Izbor filtera");
        this.gridData = new GridData();
        this.gridData.horizontalAlignment = 4;
        this.gridData.horizontalSpan = 2;
        this.gridData.heightHint = 80;
        this.filterGroup.setLayoutData((Object)this.gridData);
        this.odeljenjeLab = new Label((Composite)this.filterGroup, 0);
        this.odeljenjeLab.setText("odeljenje:");
        this.odeljenjCombo = new Combo((Composite)this.filterGroup, 8);
        this.odeljenjCombo.add("Sva proizvodna mesta");
        for (Odeljenje o : this.odeljenja) {
            this.odeljenjCombo.add(o.getNaziv());
        }
        this.odeljenjCombo.select(0);
        this.promeneCheck = new Button((Composite)this.filterGroup, 32);
        this.promeneLab = new Label((Composite)this.filterGroup, 0);
        this.promeneLab.setText("Samo sa promenama");
        this.prikazSirovinCheck = new Button((Composite)this.filterGroup, 32);
        this.prikazSirovinCheck.setSelection(true);
        this.prikazSirovinaLab = new Label((Composite)this.filterGroup, 0);
        this.prikazSirovinaLab.setText("prikaz sirovina");
        this.buttonGroup = new Group((Composite)shell, 0);
        this.buttonGroup.setLayout((Layout)gridLayout);
        this.gridData = new GridData();
        this.gridData.horizontalAlignment = 4;
        this.gridData.horizontalSpan = 2;
        this.gridData.heightHint = 80;
        this.buttonGroup.setLayoutData((Object)this.gridData);
        this.cancelButton = Dugmici.getCancelButton((Composite)this.buttonGroup);
        this.confirmButton = Dugmici.getOkButton((Composite)this.buttonGroup);
        this.confirmButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    DPUUtrosci.this.day = DPUUtrosci.this.datePick.getResult();
                    DPUUtrosci.this.yesterday = DPUUtrosci.this.getYesterdayDay(DPUUtrosci.this.day);
                    DPUUtrosci.this.menipromet = DPUUtrosci.this.server.getMeni(new Date(DPUUtrosci.this.day.getTime()));
                }
                catch (InputException e) {
                    e.printStackTrace();
                }
                DPUUtrosci.this.odJela = 0.0;
                DPUUtrosci.this.odPica = 0.0;
                DPUUtrosci.this.pvKonzumacija = 0.0;
                DPUUtrosci.this.prikazSirovina = DPUUtrosci.this.prikazSirovinCheck.getSelection();
                DPUUtrosci.this.promene = DPUUtrosci.this.promeneCheck.getSelection();
                if (DPUUtrosci.this.odeljenjCombo.getText().equals("Sva proizvodna mesta")) {
                    for (Odeljenje o : DPUUtrosci.this.odeljenja) {
                        DPUUtrosci.this.ok(o);
                    }
                } else {
                    DPUUtrosci.this.ok(DPUUtrosci.this.odeljenje = DPUUtrosci.this.server.getOdeljenje(DPUUtrosci.this.odeljenjCombo.getText()));
                }
                if (DPUUtrosci.this.menipromet != null) {
                    for (MeniPromet m : DPUUtrosci.this.menipromet) {
                        if (m.getRacun().getCrnoPlacanje() != null) continue;
                        DPUUtrosci.this.redovi.add(DpuUtrosciServer.upisiMeni(++DPUUtrosci.this.redniBroj, m));
                        DPUUtrosci.this.odJela = DPUUtrosci.this.odJela + m.getKolicina() * m.getCena();
                        DPUUtrosci.this.pvKonzumacija = DPUUtrosci.this.pvKonzumacija + m.getKolicina() * m.getCena();
                    }
                }
                DPUUtrosci.this.zdBroj = DPUUtrosci.this.server.getZDbyDatum(DPUUtrosci.this.day).getZdBroj();
                DPUUtrosci.this.iznosPoNacinimaPlacanja = DpuUtrosciServer.iznosPoNacinimaPlacanja(DPUUtrosci.this.server, DPUUtrosci.this.zdBroj);
                DpuJasperCall jasperCall = new DpuJasperCall(DPUUtrosci.this.redovi, DPUUtrosci.this.iznosPoNacinimaPlacanja, DPUUtrosci.this.server);
                jasperCall.jasperStart(String.valueOf(DPUUtrosci.this.odPica), String.valueOf(DPUUtrosci.this.odJela), String.valueOf(DPUUtrosci.this.odPica + DPUUtrosci.this.odJela), String.valueOf(DPUUtrosci.this.pvKonzumacija), DPUUtrosci.this.nazivFirme, DPUUtrosci.this.adresaFirme, DPUUtrosci.this.pibFirme, DPUUtrosci.this.formatDpuDate(DPUUtrosci.this.day, "dd.MM.yyyy."), DPUUtrosci.this.zdBroj);
                DPUUtrosci.this.redovi.clear();
                DPUUtrosci.this.redniBroj = 0;
            }
        });
        this.cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DPUUtrosci.this.cancel();
            }
        });
        shell.open();
    }

    private void cancel() {
        this.shell.close();
    }

    public void ok(Odeljenje o) {
        Date queryDate = new Date(this.day.getTime());
        this.prodajniArtikli.clear();
        this.prodajniArtikli = this.server.getArtikliZadpu(o.getId(), this.prikazSirovina);
        for (String key : this.prodajniArtikli.keySet()) {
            double ukupanIzlazPoStavci = 0.0;
            this.artikal = DpuUtrosciServer.getDPUArtikal(this.server, this.prodajniArtikli.get(key));
            this.artikal.setOdeljenjeNormativ(o);
            this.pdv = String.valueOf((int)(Konstante.getPdvPoPG(this.artikal.getPoreskaGrupa()) * 100.0)) + "%";
            double zavrsno = this.server.getSumBelo(queryDate, o, this.artikal, false, false);
            double pocetno = this.server.getSumBelo(new Date(this.yesterday.getTime()), o, this.artikal, false, true);
            double ulaz = this.server.getNabavljenaKolicina(this.artikal, queryDate, queryDate, o, false);
            double utroseno = this.server.round(pocetno + ulaz - zavrsno, 4);
            this.stavke = this.server.getStavkeZaDPU(new Date(this.day.getTime()), this.artikal, o.getId());
            double utrosakDocUtrosak = this.server.getUtrosakDocUtrosak(queryDate, queryDate, o, this.artikal, false);
            double utrosakProizvodnja = this.server.getProizvodnjaUtrosakLager(queryDate, queryDate, o, this.artikal, false);
            double utrosakOtpisSvih = this.server.getOtpisUtrosak(queryDate, queryDate, o, this.artikal, false);
            double utrosakOstaliDokumenti = DpuUtrosciServer.izlazOstaliDokumenti(this.server, this.artikal, new Date(this.day.getTime()));
            for (StavkaRacuna s : this.stavke) {
                ukupanIzlazPoStavci += s.getKolicina().doubleValue();
            }
            if (DpuUtrosciServer.isBlokiran(this.artikal, ulaz, utroseno, ukupanIzlazPoStavci) || this.promene && DpuUtrosciServer.nijeBiloPromena(this.artikal, ulaz, utroseno, ukupanIzlazPoStavci)) continue;
            double izlazKrozSlozeni = pocetno + ulaz - zavrsno - (utrosakDocUtrosak + utrosakProizvodnja + utrosakOtpisSvih + utrosakOstaliDokumenti) - ukupanIzlazPoStavci;
            if (this.artikal.getPice().booleanValue()) {
                if (this.artikal.getTip().equals((Object)TipArtikla.SLOZ) || this.artikal.getTip().equals((Object)TipArtikla.DODA)) {
                    if (this.stavke.size() >= 1) {
                        for (StavkaRacuna s : this.stavke) {
                            if (!s.isMenipromet()) {
                                if (s.getOpis().equals("HOTELSKI GOST")) {
                                    this.redovi.add(DpuUtrosciServer.upisiSlozDodaOdPicaHotelski(++this.redniBroj, this.pdv, this.artikal, s));
                                    continue;
                                }
                                this.redovi.add(DpuUtrosciServer.upisiSlozDodaOdPica(++this.redniBroj, this.pdv, this.artikal, s));
                                this.pvKonzumacija = this.pvKonzumacija + s.getCena() * s.getKolicina();
                                this.odPica = this.odPica + s.getCena() * s.getKolicina();
                                continue;
                            }
                            this.redovi.add(DpuUtrosciServer.upisiArtikalKrozMeni(++this.redniBroj, this.pdv, this.artikal, s));
                        }
                        continue;
                    }
                    if (this.prikazSirovina) continue;
                    this.redovi.add(DpuUtrosciServer.upisiSlozDodaBezProdaje(++this.redniBroj, this.pdv, this.artikal));
                    continue;
                }
                if (this.proveriProdajni(this.stavke, izlazKrozSlozeni, utrosakDocUtrosak, utrosakProizvodnja, utrosakOtpisSvih, utrosakOstaliDokumenti)) {
                    if (this.stavke.get(0).getOpis().equals("HOTELSKI GOST")) {
                        this.redovi.add(DpuUtrosciServer.upisiProdajniSumarnoHotelskiGost(++this.redniBroj, this.pdv, this.artikal, pocetno, ulaz, zavrsno, utroseno));
                        continue;
                    }
                    this.artikal.setCena(this.stavke.get(0).getCena());
                    this.redovi.add(DpuUtrosciServer.upisiProdajniSumarno(++this.redniBroj, this.pdv, this.artikal, pocetno, ulaz, zavrsno, utroseno));
                    this.odPica = this.odPica + this.stavke.get(0).getKolicina() * this.stavke.get(0).getCena();
                    this.pvKonzumacija = this.pvKonzumacija + ulaz * this.artikal.getCena();
                    continue;
                }
                if (this.stavke.size() >= 1) {
                    this.redovi.add(DpuUtrosciServer.upisiProdajniOsnovni(++this.redniBroj, this.pdv, this.artikal, pocetno, ulaz, zavrsno, utroseno));
                    this.pvKonzumacija = this.pvKonzumacija + ulaz * this.artikal.getCena();
                    for (StavkaRacuna s : this.stavke) {
                        if (!s.isMenipromet()) {
                            if (s.getOpis().equals("HOTELSKI GOST")) {
                                this.redovi.add(DpuUtrosciServer.upisiProdajniOdPicaHotelski(++this.redniBroj, this.pdv, this.artikal, s));
                                continue;
                            }
                            this.redovi.add(DpuUtrosciServer.upisiProdajniOdPica(++this.redniBroj, this.pdv, this.artikal, s));
                            this.odPica = this.odPica + s.getCena() * s.getKolicina();
                            continue;
                        }
                        this.redovi.add(DpuUtrosciServer.upisiArtikalKrozMeni(++this.redniBroj, this.pdv, this.artikal, s));
                    }
                    if (this.artikal.getTip() != TipArtikla.PROD) continue;
                    if (izlazKrozSlozeni > 0.0) {
                        this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, izlazKrozSlozeni, "- kao sastavni deo slozenog"));
                    }
                    if (utrosakDocUtrosak > 0.0) {
                        this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakDocUtrosak, "- dokument utro\u0161ak"));
                    }
                    if (utrosakProizvodnja > 0.0) {
                        this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakProizvodnja, "- dokument proizvodnja"));
                    }
                    if (utrosakOtpisSvih > 0.0) {
                        this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakOtpisSvih, "- dokument otpis artikala"));
                    }
                    if (!(utrosakOstaliDokumenti > 0.0)) continue;
                    this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakOstaliDokumenti, "- ostali dokumenti"));
                    continue;
                }
                this.redovi.add(DpuUtrosciServer.upisiProdajniBezProdaje(++this.redniBroj, this.pdv, this.artikal, pocetno, ulaz, zavrsno, utroseno));
                this.pvKonzumacija = this.pvKonzumacija + ulaz * this.artikal.getCena();
                if (this.artikal.getTip() != TipArtikla.PROD) continue;
                if (izlazKrozSlozeni > 0.0) {
                    this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, izlazKrozSlozeni, "- kao sastavni deo slozenog"));
                }
                if (utrosakDocUtrosak > 0.0) {
                    this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakDocUtrosak, "- dokument utro\u0161ak"));
                }
                if (utrosakProizvodnja > 0.0) {
                    this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakProizvodnja, "- dokument proizvodnja"));
                }
                if (utrosakOtpisSvih > 0.0) {
                    this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakOtpisSvih, "- dokument otpis artikala"));
                }
                if (!(utrosakOstaliDokumenti > 0.0)) continue;
                this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakOstaliDokumenti, "- ostali dokumenti"));
                continue;
            }
            if (!this.artikal.getJelo().booleanValue()) continue;
            if (this.artikal.getTip().equals((Object)TipArtikla.SLOZ) || this.artikal.getTip().equals((Object)TipArtikla.DODA)) {
                if (this.stavke.size() >= 1) {
                    for (StavkaRacuna s : this.stavke) {
                        if (!s.isMenipromet()) {
                            if (s.getOpis().equals("HOTELSKI GOST")) {
                                this.redovi.add(DpuUtrosciServer.upisiSlozDodaOdJelaHotelski(++this.redniBroj, this.pdv, this.artikal, s));
                                continue;
                            }
                            this.redovi.add(DpuUtrosciServer.upisiSlozDodaOdJela(++this.redniBroj, this.pdv, this.artikal, s));
                            this.pvKonzumacija = this.pvKonzumacija + s.getCena() * s.getKolicina();
                            this.odJela = this.odJela + s.getCena() * s.getKolicina();
                            continue;
                        }
                        this.redovi.add(DpuUtrosciServer.upisiArtikalKrozMeni(++this.redniBroj, this.pdv, this.artikal, s));
                    }
                    continue;
                }
                this.redovi.add(DpuUtrosciServer.upisiSlozDodaBezProdaje(++this.redniBroj, this.pdv, this.artikal));
                continue;
            }
            if (this.stavke.size() >= 1) {
                if (this.proveriProdajni(this.stavke, izlazKrozSlozeni, utrosakDocUtrosak, utrosakProizvodnja, utrosakOtpisSvih, utrosakOstaliDokumenti)) {
                    if (this.stavke.get(0).getOpis().equals("HOTELSKI GOST")) {
                        this.redovi.add(DpuUtrosciServer.upisiProdajniSumarnoHotelskiGost(++this.redniBroj, this.pdv, this.artikal, pocetno, ulaz, zavrsno, utroseno));
                        continue;
                    }
                    this.artikal.setCena(this.stavke.get(0).getCena());
                    this.redovi.add(DpuUtrosciServer.upisiProdajniSumarno(++this.redniBroj, this.pdv, this.artikal, pocetno, ulaz, zavrsno, utroseno));
                    this.odJela = this.odJela + this.stavke.get(0).getKolicina() * this.stavke.get(0).getCena();
                    this.pvKonzumacija = this.pvKonzumacija + ulaz * this.artikal.getCena();
                    continue;
                }
                this.redovi.add(DpuUtrosciServer.upisiProdajniOsnovni(++this.redniBroj, this.pdv, this.artikal, pocetno, ulaz, zavrsno, utroseno));
                this.pvKonzumacija = this.pvKonzumacija + ulaz * this.artikal.getCena();
                for (StavkaRacuna s : this.stavke) {
                    if (!s.isMenipromet()) {
                        if (s.getOpis().equals("HOTELSKI GOST")) {
                            this.redovi.add(DpuUtrosciServer.upisiProdajniOdJelaHotelski(++this.redniBroj, key, this.artikal, s));
                            continue;
                        }
                        this.redovi.add(DpuUtrosciServer.upisiProdajniOdJela(++this.redniBroj, this.pdv, this.artikal, s));
                        this.odJela = this.odJela + s.getCena() * s.getKolicina();
                        continue;
                    }
                    this.redovi.add(DpuUtrosciServer.upisiArtikalKrozMeni(++this.redniBroj, this.pdv, this.artikal, s));
                }
                if (this.artikal.getTip() != TipArtikla.PROD) continue;
                if (izlazKrozSlozeni > 0.0) {
                    this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, izlazKrozSlozeni, "- kao sastavni deo slozenog"));
                }
                if (utrosakDocUtrosak > 0.0) {
                    this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakDocUtrosak, "- dokument utro\u0161ak"));
                }
                if (utrosakProizvodnja > 0.0) {
                    this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakProizvodnja, "- dokument proizvodnja"));
                }
                if (utrosakOtpisSvih > 0.0) {
                    this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakOtpisSvih, "- dokument otpis artikala"));
                }
                if (!(utrosakOstaliDokumenti > 0.0)) continue;
                this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakOstaliDokumenti, "- ostali dokumenti"));
                continue;
            }
            this.redovi.add(DpuUtrosciServer.upisiProdajniBezProdaje(++this.redniBroj, this.pdv, this.artikal, pocetno, ulaz, zavrsno, utroseno));
            this.pvKonzumacija = this.pvKonzumacija + ulaz * this.artikal.getCena();
            if (this.artikal.getTip() != TipArtikla.PROD) continue;
            double izlazKrozSlozeniJelo = pocetno + ulaz - zavrsno - (utrosakDocUtrosak + utrosakProizvodnja + utrosakOtpisSvih + utrosakOstaliDokumenti);
            if (izlazKrozSlozeniJelo > 0.0) {
                this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, izlazKrozSlozeniJelo, "- kao sastavni deo slozenog"));
            }
            if (utrosakDocUtrosak > 0.0) {
                this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakDocUtrosak, "- dokument utro\u0161ak"));
            }
            if (utrosakProizvodnja > 0.0) {
                this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakProizvodnja, "- dokument proizvodnja"));
            }
            if (utrosakOtpisSvih > 0.0) {
                this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakOtpisSvih, "- dokument otpis artikala"));
            }
            if (!(utrosakOstaliDokumenti > 0.0)) continue;
            this.redovi.add(DpuUtrosciServer.razloziUtroskeProdajnog(++this.redniBroj, this.pdv, this.artikal, utrosakOstaliDokumenti, "- ostali dokumenti"));
        }
    }

    public java.util.Date getYesterdayDay(java.util.Date d) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(d);
        this.calendar.add(5, -1);
        return this.calendar.getTime();
    }

    public String formatDpuDate(java.util.Date dpuDate, String tip) {
        SimpleDateFormat formater = new SimpleDateFormat(tip);
        return formater.format(dpuDate);
    }

    private boolean proveriProdajni(List<StavkaRacuna> stavke, double izlazKrozSlozeni, double utrosakDocUtrosak, double utrosakProizvodnja, double utrosakOtpisSvih, double utrosakOstaliDokumenti) {
        return stavke.size() == 1 && izlazKrozSlozeni == 0.0 && utrosakDocUtrosak == 0.0 && utrosakProizvodnja == 0.0 && utrosakOtpisSvih == 0.0 && utrosakOstaliDokumenti == 0.0 && !stavke.get(0).isMenipromet();
    }
}

