/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.PrometArtikala;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StoPrikaz;
import com.dev63.restoran.model.Storno;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class AnanlizaPotrosnjePoGostu {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    Composite composite;
    List<PrometArtikala> artikli;
    List<String> crnaPl;
    List<NacinPlacanja> bela;
    Map<Konobar, Double> iznosStorno = new HashMap<Konobar, Double>();
    Map<Konobar, Double> kolicinaStorno = new HashMap<Konobar, Double>();
    Map<Konobar, Double> kolicinaRacun = new HashMap<Konobar, Double>();
    Map<Konobar, Double> promet = new HashMap<Konobar, Double>();
    Map<Konobar, Double> pazar = new HashMap<Konobar, Double>();
    Map<String, Double> nacinPCrno = new HashMap<String, Double>();
    Map<String, Integer> racuniBR = new HashMap<String, Integer>();
    Map<Konobar, Double> iznosMedjuzbir = new HashMap<Konobar, Double>();
    Map<Konobar, Map<NacinPlacanja, Double>> naciniB = new HashMap<Konobar, Map<NacinPlacanja, Double>>();
    Map<Konobar, Map<String, Double>> naciniC = new HashMap<Konobar, Map<String, Double>>();
    Map<String, LinkedList<Racun>> dan_Racun = new HashMap<String, LinkedList<Racun>>();
    Map<Integer, List<Racun>> stoloviGosti = new HashMap<Integer, List<Racun>>();
    boolean blic;
    List<Racun> racuni;
    List<Storno> storna;
    List<Konobar> konobari;
    List<StoPrikaz> stolovi;
    Date day1;
    Date day2;
    boolean crno;
    double mzUkupno = 0.0;
    private boolean poKonobaru;
    private boolean poSatima;
    double zbirGostiju = 0.0;

    public AnanlizaPotrosnjePoGostu(Shell sh, Restoran rest, final Date d1, final Date d2, List<NacinPlacanja> b, List<String> crnaPla, boolean poKonobaru, boolean poSatima) {
        this.restoran = rest;
        this.server = this.restoran.getServer();
        this.shell = sh;
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(4, false));
        this.bela = b;
        this.crnaPl = crnaPla;
        if (this.server.isEmptyDateZD(d1, d2) || this.server.isBeforeDateZD(d2)) {
            Konstante.getPoruka3(this.shell, String.format(this.barmasterText.getString("PORUKA_ZA_IZBRANI_PERIOD_NEMA_PODATAKA"), new Object[0]));
            return;
        }
        this.day1 = d1;
        this.day2 = d2;
        this.poKonobaru = poKonobaru;
        this.poSatima = poSatima;
        if (poSatima) {
            poKonobaru = true;
        }
        this.crno = this.crnaPl.size() > 0;
        this.konobari = this.server.readKonobar();
        this.racuni = new ArrayList<Racun>();
        this.racuniBR = new HashMap<String, Integer>();
        if (poKonobaru) {
            block4: for (Racun r : this.server.getSviRacuni(d1, d2)) {
                Konobar konobar = null;
                for (Konobar konobar2 : this.konobari) {
                    if (konobar2.getId() != r.getKonobar().getId()) continue;
                    konobar = konobar2;
                }
                if (r.getCrnoPlacanje() == null) {
                    if (this.bela.size() == 4) {
                        this.racuni.add(r);
                        if (r.getPlacanja() == null) continue;
                        if (this.getNacine(r).size() > 1) {
                            if (this.racuniBR.containsKey(String.format(this.barmasterText.getString("TEXT_KOMBINOVANO"), new Object[0]))) {
                                this.racuniBR.put(String.format(this.barmasterText.getString("TEXT_KOMBINOVANO"), new Object[0]), this.racuniBR.get(String.format(this.barmasterText.getString("TEXT_KOMBINOVANO"), new Object[0])) + 1);
                                continue;
                            }
                            this.racuniBR.put(String.format(this.barmasterText.getString("TEXT_KOMBINOVANO"), new Object[0]), 1);
                            continue;
                        }
                        if (this.getNacine(r).size() != 1) continue;
                        if (this.racuniBR.containsKey(this.getNacine(r).get(0).name())) {
                            this.racuniBR.put(this.getNacine(r).get(0).name(), this.racuniBR.get(this.getNacine(r).get(0).name()) + 1);
                            continue;
                        }
                        this.racuniBR.put(this.getNacine(r).get(0).name(), 1);
                        continue;
                    }
                    for (NacinPlacanja nacinPlacanja : this.bela) {
                        if (!this.getNacine(r).contains((Object)nacinPlacanja)) continue;
                        this.racuni.add(r);
                        if (this.getNacine(r).size() > 1) {
                            if (this.racuniBR.containsKey("KOMBINOVANO")) {
                                this.racuniBR.put("KOMBINOVANO", this.racuniBR.get("KOMBINOVANO") + 1);
                                continue;
                            }
                            this.racuniBR.put("KOMBINOVANO", 1);
                            continue;
                        }
                        if (this.getNacine(r).size() != 1) continue;
                        if (this.racuniBR.containsKey(this.getNacine(r).get(0).name())) {
                            this.racuniBR.put(this.getNacine(r).get(0).name(), this.racuniBR.get(this.getNacine(r).get(0).name()) + 1);
                            continue;
                        }
                        this.racuniBR.put(this.getNacine(r).get(0).name(), 1);
                    }
                    continue;
                }
                for (String string : this.crnaPl) {
                    if (!r.getCrnoPlacanje().equals(string)) continue;
                    if (this.racuniBR.containsKey(string)) {
                        this.racuniBR.put(string, this.racuniBR.get(string) + 1);
                    } else {
                        this.racuniBR.put(string, 1);
                    }
                    this.racuni.add(r);
                    continue block4;
                }
            }
        } else {
            block8: for (Racun r : this.server.getSviRacuniStolovi(this.day1, this.day2, null)) {
                int stoId = 0;
                if (r.getBrojStola() < 10000) {
                    stoId = r.getBrojStola();
                }
                if (r.getCrnoPlacanje() == null) {
                    this.stoloviGosti.put(stoId, new ArrayList());
                    if (this.bela.size() == 4) {
                        this.racuni.add(r);
                        if (r.getPlacanja() == null) continue;
                        if (this.getNacine(r).size() > 1) {
                            if (this.racuniBR.containsKey(String.format(this.barmasterText.getString("TEXT_KOMBINOVANO"), new Object[0]))) {
                                this.racuniBR.put(String.format(this.barmasterText.getString("TEXT_KOMBINOVANO"), new Object[0]), this.racuniBR.get(String.format(this.barmasterText.getString("TEXT_KOMBINOVANO"), new Object[0])) + 1);
                                continue;
                            }
                            this.racuniBR.put(String.format(this.barmasterText.getString("TEXT_KOMBINOVANO"), new Object[0]), 1);
                            continue;
                        }
                        if (this.getNacine(r).size() != 1) continue;
                        if (this.racuniBR.containsKey(this.getNacine(r).get(0).name())) {
                            this.racuniBR.put(this.getNacine(r).get(0).name(), this.racuniBR.get(this.getNacine(r).get(0).name()) + 1);
                            continue;
                        }
                        this.racuniBR.put(this.getNacine(r).get(0).name(), 1);
                        continue;
                    }
                    for (NacinPlacanja nacinPlacanja : this.bela) {
                        if (!this.getNacine(r).contains((Object)nacinPlacanja)) continue;
                        this.racuni.add(r);
                        if (this.getNacine(r).size() > 1) {
                            if (this.racuniBR.containsKey("KOMBINOVANO")) {
                                this.racuniBR.put("KOMBINOVANO", this.racuniBR.get("KOMBINOVANO") + 1);
                                continue;
                            }
                            this.racuniBR.put("KOMBINOVANO", 1);
                            continue;
                        }
                        if (this.getNacine(r).size() != 1) continue;
                        if (this.racuniBR.containsKey(this.getNacine(r).get(0).name())) {
                            this.racuniBR.put(this.getNacine(r).get(0).name(), this.racuniBR.get(this.getNacine(r).get(0).name()) + 1);
                            continue;
                        }
                        this.racuniBR.put(this.getNacine(r).get(0).name(), 1);
                    }
                    continue;
                }
                for (String string : this.crnaPl) {
                    if (!r.getCrnoPlacanje().equals(string)) continue;
                    this.stoloviGosti.put(stoId, new ArrayList());
                    if (this.racuniBR.containsKey(string)) {
                        this.racuniBR.put(string, this.racuniBR.get(string) + 1);
                    } else {
                        this.racuniBR.put(string, 1);
                    }
                    this.racuni.add(r);
                    continue block8;
                }
            }
        }
        for (Konobar k : this.konobari) {
            this.iznosStorno.put(k, 0.0);
            this.kolicinaStorno.put(k, 0.0);
            this.kolicinaRacun.put(k, 0.0);
            this.promet.put(k, 0.0);
            this.pazar.put(k, 0.0);
            this.iznosMedjuzbir.put(k, this.server.getMedjuzbir(k, this.day1, this.day2));
            HashMap<String, Double> mapaC = new HashMap<String, Double>();
            for (String string : this.crnaPl) {
                mapaC.put(string, 0.0);
            }
            HashMap<NacinPlacanja, Double> mapaB = new HashMap<NacinPlacanja, Double>();
            for (NacinPlacanja s3 : this.bela) {
                mapaB.put(s3, 0.0);
            }
            this.naciniC.put(k, mapaC);
            this.naciniB.put(k, mapaB);
        }
        for (Racun r : this.racuni) {
            Map<Object, Double> mapa;
            int stoId = 0;
            if (r.getBrojStola() < 10000) {
                stoId = r.getBrojStola();
            }
            double kr = this.kolicinaRacun.get(r.getKonobar());
            kr += 1.0;
            double pr = this.promet.get(r.getKonobar());
            pr += r.total();
            double pa = this.pazar.get(r.getKonobar());
            pa += r.total();
            String datum = r.getDatum().toString().substring(4, 10);
            this.dan_Racun.put(datum, new LinkedList());
            this.kolicinaRacun.put(r.getKonobar(), kr);
            this.promet.put(r.getKonobar(), pr);
            this.pazar.put(r.getKonobar(), pa);
            if (r.getCrnoPlacanje() != null) {
                mapa = this.naciniC.get(r.getKonobar());
                double d = mapa.get(r.getCrnoPlacanje());
                mapa.put(r.getCrnoPlacanje(), d + r.total());
                this.naciniC.put(r.getKonobar(), mapa);
                continue;
            }
            mapa = this.naciniB.get(r.getKonobar());
            for (Placanje p : r.getPlacanja()) {
                double d = mapa.get((Object)p.getNacin());
                mapa.put((Object)p.getNacin(), d + p.getIznos());
            }
            this.naciniB.put(r.getKonobar(), mapa);
        }
        for (Double d : this.iznosMedjuzbir.values()) {
            this.mzUkupno += d.doubleValue();
        }
        for (Konobar k : this.konobari) {
            double pr = this.promet.get(k);
            this.promet.put(k, pr += this.iznosMedjuzbir.get(k).doubleValue());
            double d = this.pazar.get(k);
            this.pazar.put(k, d += this.iznosMedjuzbir.get(k).doubleValue());
        }
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 4;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        Button printButton = new Button((Composite)this.shell, 72);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception pr) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(AnanlizaPotrosnjePoGostu.this.table), false, true, String.format(AnanlizaPotrosnjePoGostu.this.barmasterText.getString("TEXT_ANALIZA_POTROSNJE_PO_GOSTU"), new Object[0]) + ": " + Konstante.getDate(d1) + "-->" + Konstante.getDate(d2), AnanlizaPotrosnjePoGostu.this.shell, AnanlizaPotrosnjePoGostu.this.server);
            }
        });
        printButton.setLayoutData((Object)data);
        Button export = new Button((Composite)this.shell, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception kr) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(AnanlizaPotrosnjePoGostu.this.table, AnanlizaPotrosnjePoGostu.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(AnanlizaPotrosnjePoGostu.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)data);
        Button izlaz = new Button((Composite)this.shell, 8);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AnanlizaPotrosnjePoGostu.this.shell.close();
            }
        });
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public void makeHeaders() {
        TableColumn tc1;
        TableColumn tc4 = new TableColumn(this.table, 131072);
        if (this.poSatima) {
            tc4.setText(String.format(this.barmasterText.getString("TEXT_DATUM"), new Object[0]));
            tc4.setWidth(120);
        } else {
            tc4.setText(this.poKonobaru ? String.format(this.barmasterText.getString("TEXT_KONOBAR"), new Object[0]) : String.format(this.barmasterText.getString("TEXT_STOLOVI"), new Object[0]));
            tc4.setWidth(120);
        }
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText(String.format(this.barmasterText.getString("TEXT_BROJ_GOSTIJU"), new Object[0]));
        tc9.setWidth(80);
        if (this.poSatima) {
            tc1 = new TableColumn(this.table, 131072);
            tc1.setText("00-01");
            tc1.setWidth(50);
            TableColumn tc2 = new TableColumn(this.table, 131072);
            tc2.setText("01-02");
            tc2.setWidth(50);
            TableColumn tc3 = new TableColumn(this.table, 131072);
            tc3.setText("02-03");
            tc3.setWidth(50);
            TableColumn tc4c = new TableColumn(this.table, 131072);
            tc4c.setText("03-04");
            tc4c.setWidth(50);
            TableColumn tc5 = new TableColumn(this.table, 131072);
            tc5.setText("04-05");
            tc5.setWidth(50);
            TableColumn tc6 = new TableColumn(this.table, 131072);
            tc6.setText("05-06");
            tc6.setWidth(50);
            TableColumn tc7 = new TableColumn(this.table, 131072);
            tc7.setText("06-07");
            tc7.setWidth(50);
            TableColumn tc8 = new TableColumn(this.table, 131072);
            tc8.setText("07-08");
            tc8.setWidth(50);
            TableColumn tc9c = new TableColumn(this.table, 131072);
            tc9c.setText("08-09");
            tc9c.setWidth(50);
            TableColumn tc10 = new TableColumn(this.table, 131072);
            tc10.setText("09-10");
            tc10.setWidth(50);
            TableColumn tc11 = new TableColumn(this.table, 131072);
            tc11.setText("10-11");
            tc11.setWidth(50);
            TableColumn tc12 = new TableColumn(this.table, 131072);
            tc12.setText("11-12");
            tc12.setWidth(50);
            TableColumn tc13 = new TableColumn(this.table, 131072);
            tc13.setText("12-13");
            tc13.setWidth(50);
            TableColumn tc14 = new TableColumn(this.table, 131072);
            tc14.setText("13-14");
            tc14.setWidth(50);
            TableColumn tc15 = new TableColumn(this.table, 131072);
            tc15.setText("14-15");
            tc15.setWidth(50);
            TableColumn tc16 = new TableColumn(this.table, 131072);
            tc16.setText("15-16");
            tc16.setWidth(50);
            TableColumn tc17 = new TableColumn(this.table, 131072);
            tc17.setText("16-17");
            tc17.setWidth(50);
            TableColumn tc18 = new TableColumn(this.table, 131072);
            tc18.setText("17-18");
            tc18.setWidth(50);
            TableColumn tc19 = new TableColumn(this.table, 131072);
            tc19.setText("18-19");
            tc19.setWidth(50);
            TableColumn tc20 = new TableColumn(this.table, 131072);
            tc20.setText("19-20");
            tc20.setWidth(50);
            TableColumn tc21 = new TableColumn(this.table, 131072);
            tc21.setText("20-21");
            tc21.setWidth(50);
            TableColumn tc22 = new TableColumn(this.table, 131072);
            tc22.setText("21-22");
            tc22.setWidth(50);
            TableColumn tc23 = new TableColumn(this.table, 131072);
            tc23.setText("22-23");
            tc23.setWidth(50);
            TableColumn tc24 = new TableColumn(this.table, 131072);
            tc24.setText("23-24");
            tc24.setWidth(50);
        } else {
            tc1 = new TableColumn(this.table, 131072);
            tc1.setText(String.format(this.barmasterText.getString("TEXT_KOLICINA_RACUNA"), new Object[0]));
            tc1.setWidth(100);
            double ukupno = 0.0;
            for (Konobar k : this.konobari) {
                ukupno += Math.abs(this.iznosMedjuzbir.get(k));
            }
        }
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText(String.format(this.barmasterText.getString("TEXT_PAZAR"), new Object[0]));
        tc5.setWidth(90);
        TableColumn tc6 = new TableColumn(this.table, 131072);
        tc6.setText(String.format(this.barmasterText.getString("TEXT_PROMET_PO_GOSTU"), new Object[0]));
        tc6.setWidth(110);
        TableColumn tc7 = new TableColumn(this.table, 131072);
        tc7.setText(String.format(this.barmasterText.getString("TEXT_UCESCE_U_PROMETU"), new Object[0]));
        tc7.setWidth(140);
    }

    /*
     * WARNING - void declaration
     */
    public void insertRows() {
        double ks = 0.0;
        double is = 0.0;
        double kr = 0.0;
        if (!this.poSatima) {
            if (this.poKonobaru) {
                for (Konobar konobar : this.konobari) {
                    for (Racun r : this.racuni) {
                        if (!r.getKonobar().equals(konobar)) continue;
                        if (r.getBrojGostiju() != null) {
                            this.zbirGostiju += r.getBrojGostiju().isEmpty() ? 1.0 : Double.parseDouble(r.getBrojGostiju());
                            continue;
                        }
                        this.zbirGostiju += 1.0;
                    }
                    TableItem tableItem = new TableItem(this.table, 0);
                    tableItem.setText(0, konobar.getPunoime());
                    tableItem.setText(1, Konstante.getNumber02(this.zbirGostiju));
                    ks += this.zbirGostiju;
                    tableItem.setText(2, Konstante.getNumber1(this.kolicinaRacun.get(konobar)));
                    is += this.kolicinaRacun.get(konobar).doubleValue();
                    int i = 3;
                    tableItem.setText(i++, Konstante.getNumber2(this.pazar.get(konobar)));
                    kr += this.pazar.get(konobar).doubleValue();
                    tableItem.setText(i++, Konstante.getNumber2(this.pazar.get(konobar) != 0.0 ? this.pazar.get(konobar) / this.zbirGostiju : 0.0));
                    tableItem.setText(i++, Konstante.getNumber2(this.pazar.get(konobar) != 0.0 ? 100.0 * (this.pazar.get(konobar) / this.zbirGostiju) / this.pazar.get(konobar) : 0.0) + " %");
                    this.zbirGostiju = 0.0;
                }
            } else {
                for (Racun racun : this.racuni) {
                    if (racun.getBrojGostiju() == null) {
                        racun.setBrojGostiju("1");
                    }
                    int n = 0;
                    if (racun.getBrojStola() < 10000) {
                        n = racun.getBrojStola();
                    }
                    if (!this.stoloviGosti.containsKey(n)) continue;
                    this.stoloviGosti.get(n).add(racun);
                }
                for (Map.Entry entry : this.stoloviGosti.entrySet()) {
                    int n = (Integer)entry.getKey();
                    List values = (List)entry.getValue();
                    double zbir = 0.0;
                    int brRacuna = 0;
                    double pZbir = 0.0;
                    for (Racun r : values) {
                        pZbir += r.total();
                        int stoId = 0;
                        if (r.getBrojStola() < 10000) {
                            stoId = r.getBrojStola();
                        }
                        if (stoId != (Integer)entry.getKey()) continue;
                        ++brRacuna;
                        zbir += Double.parseDouble(r.getBrojGostiju());
                    }
                    TableItem ti = new TableItem(this.table, 0);
                    if ((Integer)entry.getKey() != 0) {
                        ti.setText(0, this.server.getNazivStola((Integer)entry.getKey()) != null ? this.server.getNazivStola((Integer)entry.getKey()) : "" + entry.getKey());
                    } else {
                        ti.setText(0, "Brza naplata");
                    }
                    ti.setText(1, Konstante.getNumber02(zbir));
                    ks += zbir;
                    ti.setText(2, "" + brRacuna);
                    is += (double)brRacuna;
                    int i = 3;
                    ti.setText(i++, Konstante.getNumber2(pZbir));
                    kr += pZbir;
                    ti.setText(i++, Konstante.getNumber2(pZbir / zbir));
                    ti.setText(i++, Konstante.getNumber2(pZbir != 0.0 ? 100.0 * (pZbir / zbir) / pZbir : 0.0) + "%");
                    zbir = 0.0;
                    brRacuna = 0;
                }
            }
        } else {
            for (Racun racun : this.racuni) {
                String string;
                if (racun.getBrojGostiju() == null) {
                    racun.setBrojGostiju("1");
                }
                if (!this.dan_Racun.containsKey(string = racun.getDatum().toString().substring(4, 10))) continue;
                this.dan_Racun.get(string).add(racun);
            }
            for (Map.Entry<String, LinkedList<Racun>> entry : this.dan_Racun.entrySet()) {
                String key = entry.getKey();
                List values = entry.getValue();
                double zbir = 0.0;
                double nula = 0.0;
                double jedan = 0.0;
                double dva = 0.0;
                double tri = 0.0;
                double cetiri = 0.0;
                double pet = 0.0;
                double sest = 0.0;
                double sedam = 0.0;
                double osam = 0.0;
                double devet = 0.0;
                double deset = 0.0;
                double jedanaest = 0.0;
                double dvanaest = 0.0;
                double trinaest = 0.0;
                double cetrnaest = 0.0;
                double petnaest = 0.0;
                double sesnaest = 0.0;
                double sedamnaest = 0.0;
                double osamnaest = 0.0;
                double devetnaest = 0.0;
                double dvadestet = 0.0;
                double dvadesetjedan = 0.0;
                double dvadesetdva = 0.0;
                double dvadesettri = 0.0;
                double pZbir = 0.0;
                for (Racun r : values) {
                    String vrem;
                    if (r.getDatum().toString().contains(key)) {
                        zbir += Double.parseDouble(r.getBrojGostiju());
                    }
                    pZbir += r.total();
                    switch (vrem = r.getDatum().toString().substring(11, 13)) {
                        case "00": {
                            nula += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "01": {
                            jedan += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "02": {
                            dva += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "03": {
                            tri += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "04": {
                            cetiri += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "05": {
                            pet += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "06": {
                            sest += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "07": {
                            sedam += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "08": {
                            osam += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "09": {
                            devet += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "10": {
                            deset += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "11": {
                            jedanaest += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "12": {
                            dvanaest += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "13": {
                            trinaest += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "14": {
                            cetrnaest += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "15": {
                            petnaest += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "16": {
                            sesnaest += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "17": {
                            sedamnaest += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "18": {
                            osamnaest += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "19": {
                            devetnaest += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "20": {
                            dvadestet += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "21": {
                            dvadesetjedan += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "22": {
                            dvadesetdva += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                        case "23": {
                            dvadesettri += Double.parseDouble(r.getBrojGostiju());
                            break;
                        }
                    }
                }
                TableItem t = new TableItem(this.table, 0);
                t.setText(0, key);
                t.setText(1, Konstante.getNumber02(zbir));
                ks += zbir;
                int i = 2;
                t.setText(i++, Konstante.getNumber1(nula));
                t.setText(i++, Konstante.getNumber1(jedan));
                t.setText(i++, Konstante.getNumber1(dva));
                t.setText(i++, Konstante.getNumber1(tri));
                t.setText(i++, Konstante.getNumber1(cetiri));
                t.setText(i++, Konstante.getNumber1(pet));
                t.setText(i++, Konstante.getNumber1(sest));
                t.setText(i++, Konstante.getNumber1(sedam));
                t.setText(i++, Konstante.getNumber1(osam));
                t.setText(i++, Konstante.getNumber1(devet));
                t.setText(i++, Konstante.getNumber1(deset));
                t.setText(i++, Konstante.getNumber1(jedanaest));
                t.setText(i++, Konstante.getNumber1(dvanaest));
                t.setText(i++, Konstante.getNumber1(trinaest));
                t.setText(i++, Konstante.getNumber1(cetrnaest));
                t.setText(i++, Konstante.getNumber1(petnaest));
                t.setText(i++, Konstante.getNumber1(sesnaest));
                t.setText(i++, Konstante.getNumber1(sedamnaest));
                t.setText(i++, Konstante.getNumber1(osamnaest));
                t.setText(i++, Konstante.getNumber1(devetnaest));
                t.setText(i++, Konstante.getNumber1(dvadestet));
                t.setText(i++, Konstante.getNumber1(dvadesetjedan));
                t.setText(i++, Konstante.getNumber1(dvadesetdva));
                t.setText(i++, Konstante.getNumber1(dvadesettri));
                t.setText(i++, Konstante.getNumber1(pZbir));
                is += pZbir;
                t.setText(i++, Konstante.getNumber1(pZbir / zbir));
                t.setText(i++, Konstante.getNumber1(pZbir / zbir != 0.0 ? 100.0 * (pZbir / zbir) / pZbir : 0.0) + "%");
            }
        }
        TableItem ti = new TableItem(this.table, 0);
        if (!this.poSatima) {
            void var8_13;
            ti = new TableItem(this.table, 0);
            ti.setText(0, String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]).toUpperCase());
            ti.setText(1, Konstante.getNumber02(ks));
            ti.setText(2, Konstante.getNumber2(is));
            int n = 3;
            ++var8_13;
            ti.setText(n, Konstante.getNumber02(kr));
        } else {
            ti = new TableItem(this.table, 0);
            ti.setText(0, String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]).toUpperCase());
            ti.setText(1, Konstante.getNumber02(ks));
            ti.setText(26, Konstante.getNumber2(is));
        }
    }

    private List<NacinPlacanja> getNacine(Racun t) {
        ArrayList<NacinPlacanja> n = new ArrayList<NacinPlacanja>();
        for (Placanje p : t.getPlacanja()) {
            n.add(p.getNacin());
        }
        return n;
    }

    public static class AnanlizaPotrosnjePoGostuInput {
        private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        Date day1;
        Date day2;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();
        SWTContainer parent;
        private Button poKonobarima;
        private Button poStolovima;
        private boolean poKonobaru;
        private Button poSatima;

        public AnanlizaPotrosnjePoGostuInput(SWTContainer owner, Restoran r, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_ANALIZA_POTROSNJE_PO_GOSTU"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 80;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(this.barmasterText.getString("TEXT_FILTER"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 80;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(8, false));
            grupa21.setText(String.format(this.barmasterText.getString("TEXT_FILTER_NACINA_PLACANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            for (int i = 0; i < NacinPlacanja.values().length; ++i) {
                Button b = new Button((Composite)grupa21, 32);
                b.setText(NacinPlacanja.values()[i].getOpis());
                b.setSelection(true);
                this.belaDugmici.add(b);
            }
            if (inspektor) {
                for (CrnoPlacanje cp : this.server.readCrnaPlacanjaIzvestaji()) {
                    Button b = new Button((Composite)grupa21, 32);
                    b.setText(cp.getNaziv());
                    this.crnaDugmici.add(b);
                }
            }
            Label poK = new Label((Composite)grupa2, 0);
            poK.setText(String.format(this.barmasterText.getString("TEXT_PO_KONOBARIMA"), new Object[0]) + ":");
            this.poKonobarima = new Button((Composite)grupa2, 16);
            this.poKonobarima.setSelection(true);
            Label poS = new Label((Composite)grupa2, 0);
            poS.setText(String.format(this.barmasterText.getString("TEXT_PO_STOLOVIMA"), new Object[0]) + ":");
            this.poStolovima = new Button((Composite)grupa2, 16);
            Label poSat = new Label((Composite)grupa2, 0);
            poSat.setText(String.format(this.barmasterText.getString("TEXT_PO_SATIMA"), new Object[0]) + ":");
            this.poSatima = new Button((Composite)grupa2, 32);
            this.poSatima.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (poSatima.getSelection()) {
                        poKonobarima.setEnabled(false);
                        poStolovima.setEnabled(false);
                    } else {
                        poKonobarima.setEnabled(true);
                        poStolovima.setEnabled(true);
                    }
                }
            });
            data = new GridData(16384, 0x1000000, false, false);
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 20;
            poK.setLayoutData((Object)data);
            poS.setLayoutData((Object)data);
            poSat.setLayoutData((Object)data);
            this.poKonobarima.setLayoutData((Object)data);
            this.poStolovima.setLayoutData((Object)data);
            this.poSatima.setLayoutData((Object)data);
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.server.getPocetni(this.odDatuma.getResult());
                this.day2 = this.server.getKrajnji(this.doDatuma.getResult());
                ArrayList<NacinPlacanja> bela = new ArrayList<NacinPlacanja>();
                for (int i = 0; i < this.belaDugmici.size(); ++i) {
                    Button b = this.belaDugmici.get(i);
                    if (!b.getSelection()) continue;
                    bela.add(NacinPlacanja.values()[i]);
                }
                this.poKonobaru = this.poKonobarima.getSelection();
                ArrayList<String> crna = new ArrayList<String>();
                for (Button b : this.crnaDugmici) {
                    if (!b.getSelection()) continue;
                    crna.add(b.getText());
                }
                this.server.log(String.format(this.barmasterText.getString("TEXT_ANALIZA_POTROSNJE_PO_GOSTU"), new Object[0]) + ": " + String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + " -> " + this.day1 + " " + String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + " -> " + this.day2);
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText(String.format(this.barmasterText.getString("TEXT_ANALIZA_POTROSNJE_PO_GOSTU"), new Object[0]) + ": " + Konstante.getDate(this.day1) + " -> " + Konstante.getDate(this.day2));
                new AnanlizaPotrosnjePoGostu(shell2, this.restoran, this.day1, this.day2, bela, crna, this.poKonobaru, this.poSatima.getSelection());
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

