/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class AnalizaProdajePoDanuUMesecu {
    private final ResourceBundle barmasterText = Konstante.getBundle();
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    boolean sifre;
    List<Map<String, Object>> ppaArtData;
    List<Map<String, Object>> ppaFinanceData;
    SimpleDateFormat format1 = new SimpleDateFormat("MM");
    SimpleDateFormat format2 = new SimpleDateFormat("yyyy");
    SimpleDateFormat format3 = new SimpleDateFormat("MMM");
    SimpleDateFormat format4 = new SimpleDateFormat("YYYY");

    public AnalizaProdajePoDanuUMesecu(Shell s, Restoran re, final String d1, String g1, String d2, String g2, List<NacinPlacanja> bela, List<CrnoPlacanje> cp, boolean mz) {
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.server.refresh();
        this.shell = new Shell(s, 34912);
        this.ppaArtData = new LinkedList<Map<String, Object>>();
        this.ppaFinanceData = new LinkedList<Map<String, Object>>();
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_ANALIZA_PRODAJE_PO_DANU_U_MESECU_ZA_PERIOD"), new Object[0]) + ": Prvi mesec/godina " + d1 + "/" + g1 + ", Drugi mesec/godina " + d2 + "/" + g2);
        try {
            this.sifre = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
        }
        catch (Exception e) {
            this.sifre = false;
        }
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(7, false));
        this.table = new Table((Composite)this.shell, 66370);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 7;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        try {
            this.insertRows(bela, cp, d1, g1, d2, g2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 120;
        data.horizontalAlignment = 16384;
        Button printButton = new Button((Composite)this.shell, 72);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_A4"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(AnalizaProdajePoDanuUMesecu.this.table), false, true, String.format(AnalizaProdajePoDanuUMesecu.this.barmasterText.getString("TEXT_ANALIZA_PRODAJE_PO_DANU_U_MESECU"), new Object[0]) + ": " + d1, AnalizaProdajePoDanuUMesecu.this.shell, AnalizaProdajePoDanuUMesecu.this.server);
            }
        });
        printButton.setLayoutData((Object)data);
        Button export = new Button((Composite)this.shell, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(AnalizaProdajePoDanuUMesecu.this.table, AnalizaProdajePoDanuUMesecu.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)data);
        Button izlaz = new Button((Composite)this.shell, 72);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AnalizaProdajePoDanuUMesecu.this.shell.close();
            }
        });
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        this.shell.setMaximized(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void makeHeaders() {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setText("Mesec");
        tc0.setWidth(150);
        TableColumn tc01 = new TableColumn(this.table, 131072);
        tc01.setText("Dan");
        tc01.setWidth(150);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText("Total");
        tc1.setWidth(120);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText("Broj Racuna");
        tc2.setWidth(100);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText("Prosecni racun");
        tc3.setWidth(100);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText("Mesec za poredjenje");
        tc4.setWidth(150);
        TableColumn tc41 = new TableColumn(this.table, 131072);
        tc41.setText("Dan");
        tc41.setWidth(150);
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText("Total");
        tc5.setWidth(120);
        TableColumn tc6 = new TableColumn(this.table, 131072);
        tc6.setText("Broj racuna");
        tc6.setWidth(100);
        TableColumn tc7 = new TableColumn(this.table, 131072);
        tc7.setText("Prosecni racun");
        tc7.setWidth(100);
    }

    public static List<Date> getDaysBetweenDates(Date startdate, Date enddate) {
        ArrayList<Date> dates = new ArrayList<Date>();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startdate);
        GregorianCalendar calendarNew = new GregorianCalendar();
        calendarNew.setTime(enddate);
        ((Calendar)calendarNew).add(5, 1);
        while (calendar.getTime().before(calendarNew.getTime())) {
            Date result = calendar.getTime();
            dates.add(result);
            ((Calendar)calendar).add(5, 1);
        }
        return dates;
    }

    private void insertRows(List<NacinPlacanja> belaPlacanja, List<CrnoPlacanje> cp, String from, String gFrom, String to, String gTo) throws Exception {
        this.popuniTabelu(belaPlacanja, cp, from, gFrom, to, gTo);
    }

    public void popuniTabelu(List<NacinPlacanja> belaPlacanja, List<CrnoPlacanje> cp, String from, String gFrom, String to, String gTo) {
        TableItem item;
        EnumSet<NacinPlacanja> bp = belaPlacanja.isEmpty() ? EnumSet.noneOf(NacinPlacanja.class) : EnumSet.copyOf(belaPlacanja);
        List<Map<String, Object>> listaVrednosti = this.server.getAnalizaProdajePoDanuUMesecu("'" + from + "'", "'" + gFrom + "'", "'" + to + "'", "'" + gTo + "'", bp, cp);
        YearMonth yearMonthObject = YearMonth.of(Integer.parseInt(gFrom), Integer.parseInt(from));
        YearMonth yearMonthObjectTo = YearMonth.of(Integer.parseInt(gTo), Integer.parseInt(to));
        double total1 = 0.0;
        double total2 = 0.0;
        double brRac1 = 0.0;
        double brRac2 = 0.0;
        if (yearMonthObject.lengthOfMonth() > yearMonthObjectTo.lengthOfMonth()) {
            for (int i = 0; i < yearMonthObject.lengthOfMonth(); ++i) {
                item = new TableItem(this.table, 0);
                for (int j = 0; j < listaVrednosti.size(); ++j) {
                    if ((Long)listaVrednosti.get(j).get("Dan") == (long)i && Long.valueOf(listaVrednosti.get(j).get("MesecBroj").toString()) == Long.parseLong(from + "" + gFrom)) {
                        total1 += listaVrednosti.get(j).get("Total") != null ? Double.valueOf(listaVrednosti.get(j).get("Total").toString()) : 0.0;
                        brRac1 += listaVrednosti.get(j).get("Broj Racuna") != null ? Double.valueOf(listaVrednosti.get(j).get("Broj Racuna").toString()) : 0.0;
                        item.setText(0, "" + listaVrednosti.get(j).get("Mesec") != null ? "" + listaVrednosti.get(j).get("Mesec") + "/" + gFrom : "" + i);
                        item.setText(1, "" + listaVrednosti.get(j).get("Dan") != null ? "" + listaVrednosti.get(j).get("Dan") : "" + i);
                        item.setText(2, "" + listaVrednosti.get(j).get("Total") != null ? "" + listaVrednosti.get(j).get("Total") : "0");
                        item.setText(3, "" + listaVrednosti.get(j).get("Broj Racuna") != null ? "" + listaVrednosti.get(j).get("Broj Racuna") : "0");
                        item.setText(4, "" + listaVrednosti.get(j).get("Prosecni racun") != null ? "" + listaVrednosti.get(j).get("Prosecni racun") : "0");
                    }
                    if ((Long)listaVrednosti.get(j).get("Dan") != (long)i || Long.valueOf(listaVrednosti.get(j).get("MesecBroj").toString()) != Long.parseLong(to + "" + gTo)) continue;
                    total2 += listaVrednosti.get(j).get("Total") != null ? Double.valueOf(listaVrednosti.get(j).get("Total").toString()) : 0.0;
                    brRac2 += listaVrednosti.get(j).get("Broj Racuna") != null ? Double.valueOf(listaVrednosti.get(j).get("Broj Racuna").toString()) : 0.0;
                    item.setText(5, "" + listaVrednosti.get(j).get("Mesec") != null ? "" + listaVrednosti.get(j).get("Mesec") + "/" + gTo : "" + i);
                    item.setText(6, "" + listaVrednosti.get(j).get("Dan") != null ? "" + listaVrednosti.get(j).get("Dan") : "" + i);
                    item.setText(7, "" + listaVrednosti.get(j).get("Total") != null ? "" + listaVrednosti.get(j).get("Total") : "0");
                    item.setText(8, "" + listaVrednosti.get(j).get("Broj Racuna") != null ? "" + listaVrednosti.get(j).get("Broj Racuna") : "0");
                    item.setText(9, "" + listaVrednosti.get(j).get("Prosecni racun") != null ? "" + listaVrednosti.get(j).get("Prosecni racun") : "0");
                }
            }
        } else {
            for (int i = 0; i < yearMonthObjectTo.lengthOfMonth(); ++i) {
                item = new TableItem(this.table, 0);
                for (int j = 0; j < listaVrednosti.size(); ++j) {
                    if ((Long)listaVrednosti.get(j).get("Dan") == (long)i && Long.valueOf(listaVrednosti.get(j).get("MesecBroj").toString()) == Long.parseLong(from + "" + gFrom)) {
                        total1 += listaVrednosti.get(j).get("Total") != null ? Double.valueOf(listaVrednosti.get(j).get("Total").toString()) : 0.0;
                        brRac1 += listaVrednosti.get(j).get("Broj Racuna") != null ? Double.valueOf(listaVrednosti.get(j).get("Broj Racuna").toString()) : 0.0;
                        item.setText(0, "" + listaVrednosti.get(j).get("Mesec") != null ? "" + listaVrednosti.get(j).get("Mesec") + "/" + gFrom : "" + i);
                        item.setText(1, "" + listaVrednosti.get(j).get("Dan") != null ? "" + listaVrednosti.get(j).get("Dan") : "" + i);
                        item.setText(2, "" + listaVrednosti.get(j).get("Total") != null ? "" + listaVrednosti.get(j).get("Total") : "0");
                        item.setText(3, "" + listaVrednosti.get(j).get("Broj Racuna") != null ? "" + listaVrednosti.get(j).get("Broj Racuna") : "0");
                        item.setText(4, "" + listaVrednosti.get(j).get("Prosecni racun") != null ? "" + listaVrednosti.get(j).get("Prosecni racun") : "0");
                    }
                    if ((Long)listaVrednosti.get(j).get("Dan") != (long)i || Long.valueOf(listaVrednosti.get(j).get("MesecBroj").toString()) != Long.parseLong(to + "" + gTo)) continue;
                    total2 += listaVrednosti.get(j).get("Total") != null ? Double.valueOf(listaVrednosti.get(j).get("Total").toString()) : 0.0;
                    brRac2 += listaVrednosti.get(j).get("Broj Racuna") != null ? Double.valueOf(listaVrednosti.get(j).get("Broj Racuna").toString()) : 0.0;
                    item.setText(5, "" + listaVrednosti.get(j).get("Mesec") != null ? "" + listaVrednosti.get(j).get("Mesec") + "/" + gTo : "" + i);
                    item.setText(6, "" + listaVrednosti.get(j).get("Dan") != null ? "" + listaVrednosti.get(j).get("Dan") : "" + i);
                    item.setText(7, "" + listaVrednosti.get(j).get("Total") != null ? "" + listaVrednosti.get(j).get("Total") : "0");
                    item.setText(8, "" + listaVrednosti.get(j).get("Broj Racuna") != null ? "" + listaVrednosti.get(j).get("Broj Racuna") : "0");
                    item.setText(9, "" + listaVrednosti.get(j).get("Prosecni racun") != null ? "" + listaVrednosti.get(j).get("Prosecni racun") : "0");
                }
            }
        }
        item = new TableItem(this.table, 0);
        item.setText("");
        item = new TableItem(this.table, 0);
        item.setBackground(Display.getCurrent().getSystemColor(15));
        item.setText(new String[]{"UKUPNO: ", "", Konstante.getNumber02(total1), String.valueOf(brRac1), "", "", "", Konstante.getNumber02(total2), String.valueOf(brRac2)});
    }

    public class NameComparator
    implements Comparator<Artikal> {
        @Override
        public int compare(Artikal o1, Artikal o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class AnalizaProdajePoSatimaInput {
        private final ResourceBundle barmasterText = Konstante.getBundle();
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        Date day1;
        Date day2;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();
        Odeljenje o;
        int totalPodgrupe = 0;
        SWTContainer parent;
        Shell shell;
        Composite mainComposite;
        Label bp;
        private boolean medjuzbir;
        private Combo mesec1;
        private Combo mesec2;
        private Spinner god1;
        private Spinner god2;

        public AnalizaProdajePoSatimaInput(SWTContainer owner, Restoran r, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new FillLayout());
            ScrolledComposite sc = new ScrolledComposite((Composite)this.shell, 768);
            this.mainComposite = new Composite((Composite)sc, 0);
            sc.setContent((Control)this.mainComposite);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            this.mainComposite.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite(this.mainComposite, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            Composite panel2 = new Composite(this.mainComposite, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            GridData data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)this.mainComposite.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_ANALIZA_PRODAJE_PO_DANU_U_MESECU"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_ODABETITE_MESEC_ZA_POREDJENJE"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData(4, 4, false, false);
            data.widthHint = 670;
            data.heightHint = 55;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(8, false));
            grupa21.setText(String.format(this.barmasterText.getString("TEXT_FILTER_NACINA_PLACANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 55;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            String[] meseci = new String[]{"Januar", "Februar", "Mart", "April", "Maj", "Jun", "Jul", "Avgust", "Septembar", "Oktobar", "Novembar", "Decembar"};
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            this.mesec1 = new Combo((Composite)grupa1, 4);
            for (String string : meseci) {
                this.mesec1.add(string);
            }
            this.mesec1.select(0);
            this.god1 = new Spinner((Composite)grupa1, 0);
            this.god1.setValues(c.get(1), 2000, 2050, 0, 1, 1);
            this.mesec2 = new Combo((Composite)grupa1, 4);
            for (String string : meseci) {
                this.mesec2.add(string);
            }
            this.mesec2.select(0);
            this.god2 = new Spinner((Composite)grupa1, 0);
            this.god2.setValues(c.get(1), 2000, 2050, 0, 1, 1);
            for (String string : NacinPlacanja.values()) {
                Button b = new Button((Composite)grupa21, 32);
                b.setText(((NacinPlacanja)((Object)string)).getOpis());
                b.setSelection(true);
                this.belaDugmici.add(b);
            }
            if (inspektor) {
                for (CrnoPlacanje cp : this.server.readCrnaPlacanjaIzvestaji()) {
                    Button b = new Button((Composite)grupa21, 32);
                    b.setText(cp.getNaziv());
                    b.setData((Object)cp);
                    this.crnaDugmici.add(b);
                }
            }
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 100;
            data.heightHint = 30;
            GridData data1 = new GridData();
            data1.horizontalAlignment = 16384;
            data1.horizontalIndent = 10;
            data1.widthHint = 80;
            data1.heightHint = 20;
            this.mesec1.setLayoutData((Object)data1);
            this.god1.setLayoutData((Object)data1);
            this.mesec2.setLayoutData((Object)data1);
            this.god2.setLayoutData((Object)data1);
            this.mainComposite.layout();
            sc.setMinSize(this.mainComposite.computeSize(-1, -1));
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                String m1 = String.valueOf(this.mesec1.getSelectionIndex() + 1);
                String g1 = this.god1.getText();
                String m2 = String.valueOf(this.mesec2.getSelectionIndex() + 1);
                String g2 = this.god2.getText();
                ArrayList<NacinPlacanja> bela = new ArrayList<NacinPlacanja>();
                for (int i = 0; i < this.belaDugmici.size(); ++i) {
                    Button b = this.belaDugmici.get(i);
                    if (!b.getSelection()) continue;
                    bela.add(NacinPlacanja.values()[i]);
                }
                this.medjuzbir = false;
                ArrayList<CrnoPlacanje> crna = new ArrayList<CrnoPlacanje>();
                for (Button b : this.crnaDugmici) {
                    CrnoPlacanje cp = (CrnoPlacanje)b.getData();
                    if (!b.getSelection()) continue;
                    if (cp.getMedjuZbir() != null && cp.getMedjuZbir().booleanValue()) {
                        this.medjuzbir = true;
                        continue;
                    }
                    crna.add(cp);
                }
                new AnalizaProdajePoDanuUMesecu(this.shell, this.restoran, m1, g1, m2, g2, bela, crna, this.medjuzbir);
            }
            catch (Exception ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

