/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.hosts;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Setting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class HostServers {
    private static final Properties hosts;
    private static final String HOSTS_FILE_NAME = "config/hosts.conf";

    public static boolean saveHost(HostEntry entry) {
        if (entry == null) {
            return false;
        }
        String oldLine = hosts.getProperty(entry.getName());
        try {
            hosts.setProperty(entry.getName(), new HostsLineProcessor(entry).toLine());
            File f = new File(HOSTS_FILE_NAME);
            FileOutputStream fos = new FileOutputStream(f);
            hosts.store(fos, "");
            return true;
        }
        catch (Exception e) {
            Logger.getLogger(HostServers.class.getName()).log(Level.SEVERE, MessageFormat.format("Greska kod pamcenja hosta: {0}", e.getMessage()), e);
            if (oldLine != null) {
                hosts.setProperty(entry.getName(), oldLine);
            }
            return false;
        }
    }

    public static String getHostAddress(String hostName) {
        String address = null;
        try {
            HostEntry entry = HostServers.getHostEntry(hostName);
            if (entry != null) {
                address = entry.getAddress();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(HostServers.class.getName()).log(Level.SEVERE, MessageFormat.format("Greska kod citanja adrese hosta {0}: {1}", hostName, ex.getMessage()), ex);
        }
        return address;
    }

    public static HostEntry getHostEntry(String hostName) {
        HostEntry entry = null;
        if (hostName != null && hosts.getProperty(hostName) != null) {
            try {
                entry = new HostsLineProcessor(hostName, hosts.getProperty(hostName), "").getEntry();
            }
            catch (Exception ex) {
                Logger.getLogger(HostServers.class.getName()).log(Level.SEVERE, MessageFormat.format("Greska kod citanja hosta {0}: {1}", hostName, ex.getMessage()), ex);
            }
        }
        return entry;
    }

    public static HostEntry getHostEntry(String hostAddress, String dbSchema, String user, String pass, String shorName) {
        String defaultHost = BMTerminalSettings.getSetting(OptionBO.DEFAULT_HOST).stringValue();
        for (HostEntry he : HostServers.getHosts()) {
            if (!he.getName().equals(defaultHost)) continue;
            return he;
        }
        return null;
    }

    public static List<HostEntry> getHosts() {
        LinkedList<HostEntry> hostList = new LinkedList<HostEntry>();
        Enumeration<?> hoste = hosts.propertyNames();
        while (hoste.hasMoreElements()) {
            String name = (String)hoste.nextElement();
            String shortName = HostServers.getHostEntry(name).getShortName();
            String line = hosts.getProperty(name);
            HostsLineProcessor hlp = new HostsLineProcessor(name, line, shortName);
            hostList.add(hlp.getEntry());
        }
        return hostList;
    }

    static {
        Properties tempH = new Properties();
        tempH.setProperty("LOCALHOST", "localhost");
        Charset defaultCS = Charset.forName("UTF-8");
        try {
            File f = new File(HOSTS_FILE_NAME);
            if (!f.exists()) {
                f.createNewFile();
                FileOutputStream fos = new FileOutputStream(f);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, defaultCS);
                tempH.store(osw, HOSTS_FILE_NAME);
                osw.close();
            } else {
                FileInputStream fis = new FileInputStream(f);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, defaultCS);
                tempH.clear();
                tempH.load(isr);
                isr.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        hosts = tempH;
    }

    private static class HostsLineProcessor {
        private HostEntry entry;

        public HostsLineProcessor(HostEntry entry) {
            this.entry = entry;
        }

        public HostsLineProcessor(String name, String line, String shortName) {
            if (line.contains("~")) {
                try {
                    this.processNewLine(name, line);
                }
                catch (IllegalBlockSizeException ex) {
                    Logger.getLogger(HostServers.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InvalidKeyException ex) {
                    Logger.getLogger(HostServers.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (BadPaddingException ex) {
                    Logger.getLogger(HostServers.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (NoSuchAlgorithmException ex) {
                    Logger.getLogger(HostServers.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (NoSuchPaddingException ex) {
                    Logger.getLogger(HostServers.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.getLogger(HostServers.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InvalidAlgorithmParameterException ex) {
                    Logger.getLogger(HostServers.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                this.processOldLine(name, line, shortName);
            }
        }

        private void processOldLine(String name, String line, String shortName) {
            this.entry = new HostEntry(name, line, shortName);
        }

        private void processNewLine(String name, String line) throws IllegalBlockSizeException, InvalidKeyException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException, InvalidAlgorithmParameterException {
            String[] lineParts = line.split("~");
            this.entry = new HostEntry(name, lineParts[1], lineParts[2], lineParts[3], Setting.decrypt(lineParts[4]), lineParts[0]);
        }

        public HostEntry getEntry() {
            return this.entry;
        }

        public void setEntry(HostEntry entry) {
            this.entry = entry;
        }

        public String toLine() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidAlgorithmParameterException {
            StringBuilder sb = new StringBuilder();
            sb = sb.append(this.entry.getShortName()).append("~");
            sb = sb.append(this.entry.getAddress()).append("~");
            sb = sb.append(this.entry.getSchemaName()).append("~");
            sb = sb.append(this.entry.getUser()).append("~");
            sb = sb.append(Setting.encrypt(this.entry.getPass()));
            return sb.toString();
        }
    }

    public static class HostEntry {
        private String address;
        private String schemaName;
        private String user;
        private String pass;
        private String name;
        private String shortName;

        public HostEntry(String name, String address, String schemaName, String user, String pass, String shortName) {
            this.shortName = shortName;
            this.address = address;
            this.schemaName = schemaName;
            this.user = user;
            this.pass = pass;
            this.name = name;
        }

        public HostEntry(String name, String address, String shortname) {
            this.shortName = shortname;
            this.name = name;
            this.address = address;
            this.schemaName = "restoran";
            this.user = "root";
            this.pass = "928374";
        }

        public String getAddress() {
            return this.address;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getUser() {
            return this.user;
        }

        public String getPass() {
            return this.pass;
        }

        public String getName() {
            return this.name;
        }

        public String getShortName() {
            return this.shortName;
        }

        public void setShortName(String shortName) {
            this.shortName = shortName;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.address != null ? this.address.hashCode() : 0);
            hash = 29 * hash + (this.schemaName != null ? this.schemaName.hashCode() : 0);
            hash = 29 * hash + (this.user != null ? this.user.hashCode() : 0);
            hash = 29 * hash + (this.pass != null ? this.pass.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HostEntry other = (HostEntry)obj;
            if (this.shortName == null ? other.shortName != null : !this.shortName.equals(other.shortName)) {
                return false;
            }
            if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
                return false;
            }
            if (this.schemaName == null ? other.schemaName != null : !this.schemaName.equals(other.schemaName)) {
                return false;
            }
            if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
                return false;
            }
            return !(this.pass == null ? other.pass != null : !this.pass.equals(other.pass));
        }
    }
}

