/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.frontoffice;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.GrafikSale;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Rezervacija;
import com.dev63.restoran.model.Sto;
import com.dev63.restoran.model.StoPrikaz;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.sistem.parts.TwoTypeWrapper;
import com.dev63.restoran.swt.components.ImageButton;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.resources.FontCache;
import java.io.Serializable;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.SerializationUtils;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class GrafikSalePrikaz {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private RestoranServer server;
    private Display display;
    private Integer brojStola = null;
    private Integer output = null;
    private Map<Integer, String> naziviStolova;
    private String ekranText = "";
    private String fontName = "Arial";
    private Color buttFgCol;
    private String tablePrefix = "";
    private boolean withPrefix = true;
    private Integer firstWarningOffset = null;
    private Integer secondWarningOffset = null;
    private Integer reservationLasting = null;
    private boolean transparentTables = false;
    private boolean checkReservations = true;
    private boolean prikazZaduzenja = false;
    Color pozadina;
    Restoran restoran;
    Time time;
    private boolean fastfood;

    public GrafikSalePrikaz(Shell parent, RestoranServer serverica, Map<Integer, String> naziviAstala, Konobar konobar) {
        this.server = serverica;
        this.display = parent.getDisplay();
        this.naziviStolova = naziviAstala;
        List<GrafikSale> sale = this.server.getGrafikeJPA();
        this.fastfood = BMTerminalSettings.getSetting(OptionBO.FAST_FOOD).booleanValue();
        RGB rgb = new RGB(34, 37, 46);
        this.pozadina = new Color((Device)parent.getDisplay(), rgb);
        this.fontName = BMTerminalSettings.getFOTheme().getTextFont().getName();
        this.buttFgCol = new Color((Device)parent.getDisplay(), BMTerminalSettings.getFOTheme().getButtonFontColor());
        try {
            this.withPrefix = this.server.getSetting(Option.GRAFIK_DODAJ_PREFIX_STOLA).booleanValue();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        try {
            this.prikazZaduzenja = this.server.getSetting(Option.PRIKAZ_ZADUZENJA_STOLA).booleanValue();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        try {
            this.transparentTables = BMTerminalSettings.getSetting(OptionBO.GRAFIK_SALE_TRANSPARENTAN).booleanValue();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        try {
            this.checkReservations = this.server.getSetting(Option.REZERVACIJE).booleanValue();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        if (this.checkReservations) {
            try {
                this.firstWarningOffset = this.server.getSetting(Option.REZERVACIJA_UPOZORENJE_PRVO).intValue();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
            try {
                this.firstWarningOffset = this.server.getSetting(Option.REZERVACIJA_UPOZORENJE_DRUGO).intValue();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
            try {
                this.reservationLasting = this.server.getSetting(Option.TRAJANJE_REZERVACIJE).intValue();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
        this.tablePrefix = this.fastfood ? "" : Konstante.getBundle().getString("TEXT_STO");
        GrafikSale g = null;
        final Shell shell3 = new Shell(parent, 32768);
        shell3.setLayout((Layout)new GridLayout(2, false));
        shell3.setBackground(this.pozadina);
        Font f = FontCache.getFont(this.fontName, 15, 1);
        final Font f2 = FontCache.getFont(this.fontName, 10, 1);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.heightHint = 60;
        Composite c1 = new Composite((Composite)shell3, 0);
        c1.setBackground(this.pozadina);
        GridLayout gl = new GridLayout(3, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c1.setLayout((Layout)gl);
        c1.setLayoutData((Object)data);
        Composite c1l = new Composite(c1, 0);
        c1l.setBackground(this.pozadina);
        GridData lrData = new GridData(4, 4, false, true);
        lrData.exclude = true;
        c1l.setLayoutData((Object)lrData);
        final Composite c1s = new Composite(c1, 0);
        c1s.setBackground(this.pozadina);
        c1s.setLayoutData((Object)new GridData(4, 4, true, true));
        final StackLayout stack = new StackLayout();
        c1s.setLayout((Layout)stack);
        Composite c1r = new Composite(c1, 0);
        c1r.setBackground(this.pozadina);
        c1r.setLayoutData((Object)lrData);
        data = new GridData();
        data.heightHint = 60;
        data.widthHint = 60;
        Composite c12 = new Composite((Composite)shell3, 0);
        c12.setBackground(this.pozadina);
        c12.setLayout((Layout)new GridLayout(1, false));
        c12.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 50;
        data.heightHint = 50;
        data.verticalIndent = 5;
        data.horizontalIndent = 5;
        Label x = new Label(c12, 0x1000000);
        x.setText("\r\nX");
        x.setFont(f);
        System.out.println(this.buttFgCol);
        x.setForeground(this.buttFgCol);
        x.setLayoutData((Object)data);
        x.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                shell3.close();
            }
        });
        data = new GridData(1808);
        data.horizontalSpan = 2;
        Composite c22 = new Composite((Composite)shell3, 0);
        GridLayout glC22 = new GridLayout();
        glC22.marginBottom = 0;
        glC22.marginLeft = 0;
        glC22.marginTop = 0;
        glC22.marginRight = 0;
        glC22.marginWidth = 0;
        glC22.marginHeight = 0;
        c22.setLayout((Layout)new GridLayout());
        c22.setLayoutData((Object)data);
        c22.setBackground(this.pozadina);
        final Composite c2 = new Composite(c22, 0);
        data = new GridData(0x1000000, 0x1000000, true, true);
        c2.setLayoutData((Object)data);
        c2.setLayout((Layout)new FillLayout());
        shell3.setBounds(shell3.getMonitor().getClientArea());
        shell3.setMaximized(true);
        shell3.layout();
        Kasa k = (Kasa)SerializationUtils.clone((Serializable)this.server.getCurrentCounter());
        List<Object> gsList = new LinkedList();
        List<Long> idGs = this.server.getListGrafiksKasa(k);
        try {
            if (idGs.isEmpty()) {
                if (konobar == null || (gsList = this.server.findGrafiksForKonobar(konobar)) == null || gsList.isEmpty()) {
                    gsList = sale;
                }
            } else {
                for (Long l : idGs) {
                    for (GrafikSale gs : sale) {
                        if (!l.equals(gs.getId())) continue;
                        gsList.add(gs);
                    }
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(GrafikSalePrikaz.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            SWTMessage.showLocalizedErrorDialog(shell3, Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_KOD_UCITAVANJA_PRIKAZA_STOLOVA"));
            shell3.dispose();
            return;
        }
        RowLayout rl = new RowLayout(256);
        rl.center = true;
        rl.wrap = false;
        rl.spacing = 10;
        rl.marginHeight = 5;
        rl.marginWidth = 10;
        RowData rd = new RowData(150, 50);
        int gsSize = gsList.size();
        int cw = rd.width + rl.spacing;
        int sw = c1s.getBounds().width - rl.marginWidth * 2 - rl.marginLeft - rl.marginRight;
        int elInStrip = sw / cw;
        int leftSpace = sw % cw;
        rl.spacing += leftSpace / elInStrip;
        rl.marginLeft += (leftSpace %= elInStrip) / 2;
        rl.marginRight += leftSpace - leftSpace / 2;
        elInStrip = gsList.size() <= elInStrip ? elInStrip : elInStrip - 1;
        final int numOfStacks = (int)Math.round(Math.ceil((double)gsSize / (double)elInStrip));
        final int[] currStackC = new int[]{0};
        int cc = 0;
        block18: for (int s = 0; s < numOfStacks; ++s) {
            if (s == 1) {
                lrData.exclude = false;
                RowData rdd = new RowData(50, 50);
                RowLayout rlt = new RowLayout();
                rlt.marginWidth = 0;
                rlt.marginHeight = 5;
                rlt.marginWidth = (rd.width - rdd.width * 2) / 4;
                c1l.setLayout((Layout)rlt);
                c1r.setLayout((Layout)rlt);
                ImageButton ibl = new ImageButton(c1l, 16388);
                ibl.setLayoutData(rdd);
                ibl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        currStackC[0] = (numOfStacks + currStackC[0] - 1) % numOfStacks;
                        stack.topControl = c1s.getChildren()[currStackC[0]];
                        c1s.layout();
                    }
                });
                ImageButton ibr = new ImageButton(c1r, 131076);
                ibr.setLayoutData(rdd);
                ibr.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        currStackC[0] = (numOfStacks + currStackC[0] + 1) % numOfStacks;
                        stack.topControl = c1s.getChildren()[currStackC[0]];
                        c1s.layout();
                    }
                });
            }
            Composite temp = new Composite(c1s, 0);
            temp.setBackground(this.pozadina);
            temp.setLayout((Layout)rl);
            if (s == 0) {
                stack.topControl = temp;
            }
            while (cc - s * elInStrip < elInStrip) {
                if (cc >= gsSize) break block18;
                final GrafikSale gs = (GrafikSale)gsList.get(cc);
                if (cc == 0) {
                    g = gs;
                }
                Label bgs = new Label(temp, 0x1000000);
                bgs.setForeground(this.buttFgCol);
                bgs.setLayoutData((Object)rd);
                bgs.setText("\r\n" + gs.getNaziv());
                bgs.setFont(f);
                bgs.addListener(4, new Listener(){

                    public void handleEvent(Event e) {
                        for (Control c : c2.getChildren()) {
                            c.dispose();
                        }
                        GrafikSalePrikaz.this.activeGrafik(gs, c2, f2, shell3);
                    }
                });
                ++cc;
            }
        }
        shell3.open();
        this.activeGrafik(g, c2, f2, shell3);
        while (!shell3.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.buttFgCol.dispose();
    }

    private void activeGrafik(GrafikSale gs, Composite c2, Font f2, final Shell shell3) {
        final Image[] bgImage = new Image[1];
        try {
            bgImage[0] = new Image((Device)this.display, gs.getSlika());
        }
        catch (Exception e) {
            return;
        }
        GridData data = (GridData)c2.getLayoutData();
        data.widthHint = bgImage[0].getImageData().width;
        data.heightHint = bgImage[0].getImageData().height;
        c2.setLayoutData((Object)data);
        c2.getParent().layout();
        c2.layout();
        c2.setBackgroundImage(bgImage[0]);
        c2.setBackgroundMode(2);
        c2.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (bgImage[0] != null && !bgImage[0].isDisposed()) {
                    bgImage[0].dispose();
                }
            }
        });
        List<StoPrikaz> sps = gs.getStolovi();
        if (sps == null) {
            try {
                sps = this.server.getPrikazStolovaForGrafikSale(gs);
            }
            catch (Exception ex) {
                Logger.getLogger(GrafikSalePrikaz.class.getName()).log(Level.SEVERE, null, ex);
                SWTMessage.showLocalizedErrorDialog(shell3, Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_KOD_UCITAVANJA_PRIKAZA_STOLOVA"));
                return;
            }
        }
        Calendar nowCal = null;
        Calendar lastCal = null;
        Calendar firstCal = null;
        Calendar secondCal = null;
        if (this.reservationLasting != null && (this.firstWarningOffset != null || this.secondWarningOffset != null)) {
            nowCal = Calendar.getInstance();
            lastCal = Calendar.getInstance();
            lastCal.add(12, this.reservationLasting);
            if (this.firstWarningOffset != null) {
                firstCal = Calendar.getInstance();
                firstCal.add(12, -this.firstWarningOffset.intValue());
            }
            if (this.secondWarningOffset != null) {
                secondCal = Calendar.getInstance();
                secondCal.add(12, -this.secondWarningOffset.intValue());
            }
        }
        final String sPref = this.getStoPrefix();
        for (final StoPrikaz sp : sps) {
            this.brojStola = sp.getBroj();
            Sto st = sp.getSto();
            String bs = sp.getNaziv();
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            final Rezervacija[] r = new Rezervacija[1];
            Integer warnType = 0;
            if (nowCal != null) {
                TwoTypeWrapper<Rezervacija, Integer> resWarn = this.getRezervacijaWithWarning(sp, nowCal, lastCal, firstCal, secondCal);
                Rezervacija rezervacija = r[0] = resWarn != null ? resWarn.getA() : null;
            }
            String rez = r[0] != null ? sdf.format(r[0].getVreme().getTime()) + "\n" + (r[0].getIme().length() > 10 ? r[0].getIme().substring(0, 10) : r[0].getIme()) : "";
            RoundedLabel label = new RoundedLabel(c2, 0x1000000, sp, st, r);
            boolean gsTrans = false;
            try {
                gsTrans = this.transparentTables;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!gsTrans) {
                label.setBackground(this.display.getSystemColor(1));
            }
            if (st != null) {
                if (r[0] != null) {
                    if (warnType == 3) {
                        label.setForeground(this.display.getSystemColor(9));
                    } else if (warnType == 2) {
                        label.setForeground(this.display.getSystemColor(11));
                    } else if (warnType == 1) {
                        label.setForeground(this.display.getSystemColor(13));
                    }
                } else {
                    label.setForeground(this.display.getSystemColor(2));
                }
                label.setFont(f2);
                if (sPref.equals("")) {
                    label.setText(rez + bs + "\n" + sp.getKonobarIme() + "\n" + (this.prikazZaduzenja ? Konstante.getNumber2(this.server.getStoZaduzenje(this.brojStola)) : ""));
                } else {
                    label.setText(rez + sPref + bs + "\n" + sp.getKonobarIme() + "\n" + (this.prikazZaduzenja ? Konstante.getNumber2(this.server.getStoZaduzenje(this.brojStola)) : ""));
                }
            } else {
                if (r[0] != null) {
                    label.setForeground(this.display.getSystemColor(8));
                } else {
                    label.setForeground(this.display.getSystemColor(2));
                }
                label.setText(rez + "\n " + bs);
                label.setFont(f2);
            }
            label.setBounds(sp.getX(), sp.getY(), sp.getSirina(), sp.getVisina());
            label.addListener(4, new Listener(){

                public void handleEvent(Event e) {
                    shell3.close();
                    GrafikSalePrikaz.this.napraviTuru();
                    GrafikSalePrikaz.this.output = sp.getBroj();
                    String broj = String.valueOf(GrafikSalePrikaz.this.brojStola);
                    GrafikSalePrikaz.this.ekranText = r[0] == null ? sPref + " :   " + broj : (GrafikSalePrikaz.this.fastfood ? "" : GrafikSalePrikaz.this.barmasterText.getString("TEXT_BROJ_STOLA") + " :   " + broj + "\n" + GrafikSalePrikaz.this.barmasterText.getString("TEXT_REZERVISAN_U") + " " + r[0].getVreme() + " " + GrafikSalePrikaz.this.barmasterText.getString("TEXT_ZA") + " " + r[0].getIme());
                }
            });
        }
    }

    public Long napraviTuru() {
        Tura t = new Tura();
        return t.getId();
    }

    public Integer getBrojStola() {
        return this.output;
    }

    public String getEkranText() {
        return this.ekranText;
    }

    public String getStoPrefix() {
        return this.withPrefix ? this.tablePrefix : "";
    }

    public TwoTypeWrapper<Rezervacija, Integer> getRezervacijaWithWarning(StoPrikaz sp, Calendar nowCal, Calendar resLasting, Calendar firstCal, Calendar secondCal) {
        if (sp == null || resLasting == null || firstCal == null && secondCal == null || sp.getRezervacije() == null || sp.getRezervacije().isEmpty()) {
            return null;
        }
        Rezervacija rTemp = null;
        Integer type = 0;
        for (Rezervacija r : sp.getRezervacije()) {
            if (r == null || r.getVreme() == null || r.getVreme().before(firstCal == null ? secondCal : firstCal) || r.getVreme().after(resLasting) || rTemp != null && r.getVreme().after(rTemp.getVreme())) continue;
            rTemp = r;
            if (nowCal.before(r.getVreme())) {
                type = 3;
                continue;
            }
            if (secondCal != null && secondCal.before(r.getVreme())) {
                type = 2;
                continue;
            }
            type = 1;
        }
        if (rTemp != null) {
            return new TwoTypeWrapper<Object, Integer>(rTemp, type);
        }
        return null;
    }

    private class RoundedLabel
    extends Canvas {
        private String text;
        private static final int MARGIN = 2;
        private StoPrikaz sp;
        private Sto st;
        private Rezervacija[] r;

        public RoundedLabel(Composite parent, int style, StoPrikaz sp, Sto st, Rezervacija[] r) {
            super(parent, style);
            this.text = "";
            this.sp = sp;
            this.st = st;
            this.r = r;
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    RoundedLabel.this.paintControl(e);
                }
            });
        }

        void paintControl(PaintEvent e) {
            int broj;
            try {
                broj = this.r[0].getBrStola();
            }
            catch (NullPointerException e1) {
                broj = 0;
            }
            if (this.sp.isKrug()) {
                if (this.st == null) {
                    if (broj == this.sp.getBroj()) {
                        e.gc.setForeground(GrafikSalePrikaz.this.display.getSystemColor(2));
                        e.gc.setBackground(new Color((Device)GrafikSalePrikaz.this.display, new RGB(58, 115, 156)));
                    } else {
                        e.gc.setBackground(new Color((Device)GrafikSalePrikaz.this.display, new RGB(47, 171, 24)));
                    }
                } else {
                    e.gc.setBackground(new Color((Device)GrafikSalePrikaz.this.display, new RGB(196, 15, 24)));
                }
                e.gc.fillRoundRectangle(0, 0, this.getBounds().width - 2, this.getBounds().height - 2, 150, 150);
                e.gc.drawRoundRectangle(0, 0, this.getBounds().width - 2, this.getBounds().height - 2, 150, 150);
                e.gc.drawText(this.text, this.sp.getSirina() / 4, 0);
            } else {
                if (broj == this.sp.getBroj()) {
                    e.gc.setForeground(new Color((Device)GrafikSalePrikaz.this.display, new RGB(196, 15, 24)));
                    e.gc.setBackground(new Color((Device)GrafikSalePrikaz.this.display, new RGB(58, 115, 156)));
                }
                if (this.st == null) {
                    if (broj == this.sp.getBroj()) {
                        e.gc.setForeground(GrafikSalePrikaz.this.display.getSystemColor(2));
                        e.gc.setBackground(new Color((Device)GrafikSalePrikaz.this.display, new RGB(58, 115, 156)));
                    } else {
                        e.gc.setBackground(new Color((Device)GrafikSalePrikaz.this.display, new RGB(47, 171, 24)));
                    }
                } else {
                    e.gc.setBackground(new Color((Device)GrafikSalePrikaz.this.display, new RGB(196, 15, 24)));
                }
                e.gc.fillRectangle(0, 0, this.getBounds().width - 2, this.getBounds().height - 2);
                e.gc.drawRectangle(0, 0, this.getBounds().width - 2, this.getBounds().height - 2);
                e.gc.drawText(this.text, this.sp.getSirina() / 4, 0);
            }
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
            this.redraw();
        }
    }
}

