/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.fiscalprint.einis;

import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StavkaRacuna;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class EINisWriter {
    private static String POSLINK_DIR;
    private static String RECEIPT_DIR;
    private static String COMMAND_DIR;
    private static String RESPONSE_DIR;
    private static String ARCHIVE_DIR;
    private static String WORKING_DIR;
    private static String ARTICLE_NAME_LENGTH;
    private static String ARTICLE_PRICE_LENGTH;
    private static final String ZERO_FILLER = "0000000000000000000000000000000000000000";
    private static final String WHITESPACE_FILLER = "                                        ";
    private static int COUNTER;
    private static Properties prop;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean printReceipt(Racun r, RestoranServer server) {
        File recDir = new File(POSLINK_DIR + RECEIPT_DIR);
        if (recDir.exists()) {
            if (!recDir.isDirectory()) {
                server.info("Direktorijum " + POSLINK_DIR + RECEIPT_DIR + " postoji u sistemu ali nije direktorijum !");
                System.out.println("Direktorijum " + POSLINK_DIR + RECEIPT_DIR + " postoji u sistemu ali nije direktorijum !");
                return false;
            }
            File wDir = new File(POSLINK_DIR + WORKING_DIR);
            if (wDir.isFile()) {
                System.out.println("Radni je fajl");
                return false;
            }
            if (!wDir.exists()) {
                wDir.mkdir();
            }
            if (!wDir.canRead()) {
                System.out.println("Radni nije citljiv");
                return false;
            }
            FileWriter fw = null;
            BufferedWriter bw = null;
            String fileNumS = "" + COUNTER;
            while (fileNumS.length() != 5) {
                if (fileNumS.length() > 5) {
                    fileNumS = fileNumS.substring(0, fileNumS.length() - 1);
                    continue;
                }
                if (fileNumS.length() >= 5) continue;
                fileNumS = "0" + fileNumS;
            }
            File f = new File(wDir, fileNumS + ".bon");
            if (f.exists() && !f.delete()) {
                System.out.println("Fajl vec postoji");
                return false;
            }
            try {
                fw = new FileWriter(f);
                bw = new BufferedWriter(fw);
                String line100 = EINisWriter.makeLine100(r, fileNumS);
                bw.write(line100, 0, line100.length());
                bw.newLine();
                bw.flush();
                for (StavkaRacuna sr : r.getStavke()) {
                    double popust = r.getPopust() == null ? 0.0 : r.getPopust();
                    String line200 = EINisWriter.makeLine200(sr, popust);
                    bw.write(line200, 0, line200.length());
                    bw.newLine();
                    bw.flush();
                }
                for (Placanje p : r.getPlacanja()) {
                    String line300 = EINisWriter.makeLine300(p);
                    bw.write(line300, 0, line300.length());
                    bw.newLine();
                    bw.flush();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(EINisWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    bw.close();
                    fw.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(EINisWriter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (f.exists()) {
                System.out.println("Fajl postoji");
                ++COUNTER;
                File ff = new File(POSLINK_DIR + RECEIPT_DIR, f.getName());
                if (!ff.exists()) {
                    try {
                        f.renameTo(ff);
                        EINisWriter.openDrawer();
                        return true;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(EINisWriter.class.getName()).log(Level.SEVERE, null, ex);
                        return false;
                    }
                }
                System.out.println("Fajl u bon folderu vec postoji");
                return false;
            }
            return false;
        }
        server.log("Direktorijum " + POSLINK_DIR + RECEIPT_DIR + " postoji u sistemu ali nije direktorijum !");
        System.out.println("Direktorijum " + POSLINK_DIR + RECEIPT_DIR + " postoji u sistemu ali nije direktorijum !");
        return false;
    }

    private static String makeLine100(Racun r, String fileNumS) {
        String line100 = "100";
        Date d = r.getDatum();
        SimpleDateFormat sdfd = new SimpleDateFormat("ddMMyyyy");
        SimpleDateFormat sdft = new SimpleDateFormat("HHmmss");
        line100 = line100 + sdfd.format(d);
        line100 = line100 + sdft.format(d);
        line100 = line100 + fileNumS;
        line100 = line100 + "01";
        return line100;
    }

    private static String makeLine200(StavkaRacuna sr, double popust) {
        String line200 = "200";
        int aNameLen = 36;
        int aPriceLen = 8;
        try {
            aNameLen = Integer.parseInt(ARTICLE_NAME_LENGTH);
        }
        catch (Exception e) {
            System.out.println("Nemoguce je ocitati duzinu imena artikla");
        }
        try {
            aPriceLen = Integer.parseInt(ARTICLE_PRICE_LENGTH);
        }
        catch (Exception e) {
            System.out.println("Nemoguce je ocitati duzinu cene artikla");
        }
        String aName = sr.getNaziv();
        if (aName.length() > aNameLen) {
            aName = aName.substring(0, aNameLen);
        } else if (aName.length() < aNameLen) {
            aName = aName.concat(WHITESPACE_FILLER.substring(0, aNameLen - aName.length()));
        }
        line200 = line200 + aName;
        long aPrice = Math.round(sr.getArtikal().getCena() * (100.0 - popust) / 100.0 * 100.0);
        String aPriceS = "" + aPrice;
        if (aPriceS.length() > aPriceLen) {
            aPriceS = aPriceS.substring(aPriceS.length() - aPriceLen);
        } else if (aPriceS.length() < aPriceLen) {
            aPriceS = ZERO_FILLER.substring(0, aPriceLen - aPriceS.length()).concat(aPriceS);
        }
        line200 = line200 + aPriceS;
        long aQuant = Math.round(sr.getKolicina() * 1000.0);
        String aQuantS = "" + aQuant;
        if (aQuantS.length() > 8) {
            aQuantS = aQuantS.substring(aQuantS.length() - 8);
        } else if (aQuantS.length() < 8) {
            aQuantS = ZERO_FILLER.substring(0, 8 - aQuantS.length()).concat(aQuantS);
        }
        line200 = line200 + aQuantS;
        line200 = line200 + "00";
        long aCode = sr.getArtikal().getId();
        String aCodeS = "" + aCode;
        if (aCodeS.length() > 13) {
            aCodeS = aCodeS.substring(aCodeS.length() - 13);
        } else if (aCodeS.length() < 13) {
            aCodeS = ZERO_FILLER.substring(0, 13 - aCodeS.length()).concat(aCodeS);
        }
        line200 = line200 + aCodeS;
        String aPG = "";
        switch (sr.getArtikal().getPoreskaGrupa()) {
            case GRUPA_A: {
                aPG = "00";
                break;
            }
            case GRUPA_G: {
                aPG = "01";
                break;
            }
            case GRUPA_D: {
                aPG = "02";
                break;
            }
            case GRUPA_DJ: {
                aPG = "03";
                break;
            }
            case GRUPA_E: {
                aPG = "04";
                break;
            }
            case GRUPA_ZJ: {
                aPG = "05";
                break;
            }
            case GRUPA_I: {
                aPG = "06";
                break;
            }
            case GRUPA_J: {
                aPG = "07";
                break;
            }
            case GRUPA_K: {
                aPG = "08";
            }
        }
        line200 = line200 + aPG;
        return line200;
    }

    private static String makeLine300(Placanje p) {
        String line300 = "300";
        long aAmount = Math.round(p.getIznos() * 100.0);
        String pAmountS = "" + aAmount;
        if (pAmountS.length() > 11) {
            pAmountS = pAmountS.substring(pAmountS.length() - 11);
        } else if (pAmountS.length() < 11) {
            pAmountS = ZERO_FILLER.substring(0, 11 - pAmountS.length()).concat(pAmountS);
        }
        line300 = line300 + pAmountS;
        String pType = "";
        switch (p.getNacin()) {
            case GOTOVINA: {
                pType = "00";
                break;
            }
            case KARTICA: {
                pType = "02";
                break;
            }
            case CEK: 
            case FAKTURA: {
                pType = "01";
            }
        }
        line300 = line300 + pType;
        return line300;
    }

    public static boolean openDrawer() throws IOException {
        try {
            return EINisWriter.sendNoTextCommand("of");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public static boolean emptyArticles() throws IOException {
        try {
            return EINisWriter.sendNoTextCommand("ik");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public static boolean printZReport() {
        try {
            return EINisWriter.sendNoTextCommand("di");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public static boolean printXReport() {
        try {
            return EINisWriter.sendNoTextCommand("ps");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public static boolean showDispLine1(String line1) throws IOException {
        try {
            if (line1 == null) {
                return false;
            }
            EINisWriter.sendTextCommand("pd1", new String[]{line1});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public static boolean showDispLine2(String line2) throws IOException {
        try {
            if (line2 == null) {
                return false;
            }
            EINisWriter.sendTextCommand("pd2", new String[]{line2});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public static boolean showDefaultDispLine() {
        try {
            return EINisWriter.sendNoTextCommand("pd0");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public static boolean printNonFiscalText(List<String> lines) throws IOException {
        try {
            if (lines == null) {
                return false;
            }
            EINisWriter.sendTextCommand("ft", (String[])lines.toArray());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public static boolean printPeriodicalReport(Date dateFrom, Date dateTo) throws IOException {
        try {
            if (dateFrom == null || dateTo == null) {
                return false;
            }
            DateFormat df = DateFormat.getDateInstance(2, Locale.getDefault());
            EINisWriter.sendTextCommand("pi", new String[]{df.format(dateFrom), df.format(dateTo)});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public static boolean printArticleReportWithClearing(int startArticleNumber, int endArticleNumber) throws IOException {
        try {
            EINisWriter.sendTextCommand("ai", new String[]{"" + startArticleNumber, "" + endArticleNumber});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public static boolean printArticleReportWithoutClearing(int startArticleNumber, int endArticleNumber) throws IOException {
        try {
            EINisWriter.sendTextCommand("aib", new String[]{"" + startArticleNumber, "" + endArticleNumber});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public static boolean printDepartmentReport(int startDepartmentNumber, int endDepartmentNumber) throws IOException {
        try {
            EINisWriter.sendTextCommand("oi", new String[]{"" + startDepartmentNumber, "" + endDepartmentNumber});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public static boolean printOperaterReport(int startOperaterNumber, int endOperaterNumber) throws IOException {
        try {
            EINisWriter.sendTextCommand("aib", new String[]{"" + startOperaterNumber, "" + endOperaterNumber});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    private static boolean sendTextCommand(String command, String[] lines) throws IOException {
        File wDir;
        File cmDir;
        File plDir = new File(POSLINK_DIR);
        if (plDir.exists() && plDir.isDirectory() && (cmDir = new File(plDir, COMMAND_DIR)).exists() && cmDir.isDirectory() && (wDir = new File(plDir, WORKING_DIR)).exists()) {
            File cmd = new File(wDir, command + ".sys");
            if (cmd.exists()) {
                try {
                    if (!cmd.delete()) {
                        System.out.println("Fajl u radnom direktorijumu vec postoji");
                        return false;
                    }
                }
                catch (Exception e) {
                    System.out.println("Greska prilikom brisanja fajla");
                    return false;
                }
            }
            if (!cmd.exists()) {
                File errFile;
                File respDir;
                FileWriter fw = new FileWriter(cmd);
                BufferedWriter bw = new BufferedWriter(fw);
                for (String line : lines) {
                    bw.write(line, 0, line.length());
                    bw.newLine();
                    bw.flush();
                }
                bw.close();
                fw.close();
                boolean succ = false;
                boolean created = false;
                File ff = new File(cmDir, cmd.getName());
                cmd.renameTo(ff);
                created = ff.exists();
                long start = new Date().getTime();
                while (new Date().getTime() - start < 2000L && created && !succ) {
                    if (ff.exists()) continue;
                    succ = true;
                }
                if (succ && (respDir = new File(plDir, RESPONSE_DIR)).exists() && respDir.isDirectory() && (errFile = new File(respDir, command.replaceAll("[^a-zA-Z]", "") + ".err")).exists()) {
                    System.out.println("Greska kod komande " + command);
                    succ = false;
                    errFile.delete();
                    File errMessFile = new File(respDir, command + ".sys.opis");
                    if (errMessFile.exists()) {
                        List<String> response = Files.readAllLines(errMessFile.toPath(), Charset.defaultCharset());
                        String message = "";
                        for (String string : response) {
                            if ((message = message.concat(string.trim())).length() <= 0) continue;
                            message = message.concat("\n");
                        }
                        if (message.trim().length() > 0) {
                            System.out.println("Poruka greske za komandu " + command + " je " + message);
                            EINisWriter.showErrorMessage(message);
                        }
                        errMessFile.delete();
                    }
                }
                return succ;
            }
        }
        return false;
    }

    private static boolean sendNoTextCommand(String command) throws IOException {
        File cmd;
        File cmDir;
        File plDir = new File(POSLINK_DIR);
        if (plDir.exists() && plDir.isDirectory() && (cmDir = new File(plDir, COMMAND_DIR)).exists() && cmDir.isDirectory() && !(cmd = new File(cmDir, command + ".sys")).exists()) {
            File errFile;
            File respDir;
            boolean created = cmd.createNewFile();
            boolean succ = false;
            long start = new Date().getTime();
            while (new Date().getTime() - start < 2000L && created && !succ) {
                if (cmd.exists()) continue;
                succ = true;
            }
            if (succ && (respDir = new File(plDir, RESPONSE_DIR)).exists() && respDir.isDirectory() && (errFile = new File(respDir, command.replaceAll("[^a-zA-Z]", "") + ".err")).exists()) {
                System.out.println("Greska kod komande " + command);
                succ = false;
                errFile.delete();
                File errMessFile = new File(respDir, command + ".sys.opis");
                if (errMessFile.exists()) {
                    List<String> response = Files.readAllLines(errMessFile.toPath(), Charset.defaultCharset());
                    String message = "";
                    for (String string : response) {
                        message = message.concat(string.trim());
                    }
                    if (message.trim().length() > 0) {
                        System.out.println("Poruka greske za komandu " + command + " je " + message);
                        EINisWriter.showErrorMessage(message);
                    }
                    errMessFile.delete();
                }
            }
            return succ;
        }
        return false;
    }

    private static void showErrorMessage(String error) {
        JOptionPane.showMessageDialog(null, error, "Gre\u0161ka", 0);
    }

    public static int getCOUNTER() {
        return COUNTER;
    }

    public static void setCOUNTER(int aCOUNTER) {
        COUNTER = aCOUNTER;
    }

    static {
        COUNTER = 1;
        prop = new Properties();
        InputStream in = EINisWriter.class.getResourceAsStream("EINis.properties");
        if (in != null) {
            try {
                prop.load(in);
                String temp = null;
                temp = prop.getProperty("POSLINK_DIR");
                POSLINK_DIR = temp == null ? "C:/Ipos/" : temp;
                temp = null;
                temp = prop.getProperty("RECEIPT_DIR");
                RECEIPT_DIR = temp == null ? "Bon/" : temp;
                temp = null;
                temp = prop.getProperty("COMMAND_DIR");
                COMMAND_DIR = temp == null ? "UKasu/" : temp;
                temp = null;
                temp = prop.getProperty("RESPONSE_DIR");
                RESPONSE_DIR = temp == null ? "IzKase/" : temp;
                temp = null;
                temp = prop.getProperty("ARCHIVE_DIR");
                ARCHIVE_DIR = temp == null ? "Arhiva/" : temp;
                temp = null;
                temp = prop.getProperty("WORKING_DIR");
                WORKING_DIR = temp == null ? "Radni/" : temp;
                temp = null;
                temp = prop.getProperty("ARTICLE_NAME_LENGTH");
                ARTICLE_NAME_LENGTH = temp == null ? "36" : temp;
                temp = null;
                temp = prop.getProperty("ARTICLE_PRICE_LENGTH");
                ARTICLE_PRICE_LENGTH = temp == null ? "8" : temp;
            }
            catch (IOException ex) {
                Logger.getLogger(EINisWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(EINisWriter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            try {
                File[] bons;
                SimpleDateFormat aTDirName;
                File arTodayDir;
                File arDir = new File(POSLINK_DIR + ARCHIVE_DIR);
                if (arDir.exists() && arDir.isDirectory() && (arTodayDir = new File(arDir, (aTDirName = new SimpleDateFormat("d-M-yyyy")).format(new Date()))).exists() && arTodayDir.isDirectory() && (bons = arTodayDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".bon");
                    }
                })).length > 0) {
                    List<File> bonList = Arrays.asList(bons);
                    Collections.sort(bonList);
                    File lastFile = bonList.get(bonList.size() - 1);
                    String lfName = lastFile.getName();
                    String lfNum = lfName.split("\\.")[0];
                    try {
                        int lastCount = Integer.parseInt(lfNum);
                        COUNTER = lastCount + 1;
                    }
                    catch (Exception e) {
                        System.out.println("Brojac nije moguce podesiti !");
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(EINisWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

