/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.cenovnikzadan;

import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CenaZaDan;
import com.dev63.restoran.model.CenovnikZaDan;
import com.dev63.restoran.model.dao.ArtikalDAO;
import com.dev63.restoran.model.dao.CenovnikZaDanDAO;
import com.dev63.restoran.utils.LogUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.NoResultException;

public class CenovnikZaDanController {
    private static final Logger log = Logger.getLogger(CenovnikZaDanController.class.getName());
    private CenovnikZaDanDAO czdDAO;
    private ArtikalDAO artDAO;

    public CenovnikZaDanController(CenovnikZaDanDAO czdDAO, ArtikalDAO artDAO) {
        this.czdDAO = czdDAO;
        this.artDAO = artDAO;
    }

    public void zakljuciCenovnikZaDan(Calendar dan) {
        LogUtils.logEntering(log, dan);
        if (!this.dateAfterLastClosedPriceList(dan)) {
            log.log(Level.INFO, "Poslednji zakljucen cenovnik je noviji od datuma {0}", new Object[]{dan.getTime()});
            LogUtils.logExiting(log);
            return;
        }
        CenovnikZaDan cenovnik = null;
        try {
            cenovnik = this.czdDAO.findCenovnikZaDanForDateInSingleton(dan);
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        if (cenovnik != null && cenovnik.getZakljucen().booleanValue()) {
            log.log(Level.INFO, "Cenovnik za dan {0} je vec zakljucen", new Object[]{dan.getTime()});
            LogUtils.logExiting(log);
            return;
        }
        List allArticles = this.artDAO.findAllFromSingleton();
        LinkedList leftArticles = new LinkedList(allArticles);
        if (cenovnik != null) {
            List<CenaZaDan> cene = cenovnik.getCene();
            if (cene != null && !cene.isEmpty()) {
                for (CenaZaDan cena : cene) {
                    Artikal art = cena.getArtikal();
                    art.setCena(cena.getProdajnaCena().doubleValue());
                    leftArticles.remove(art);
                }
            }
        } else {
            cenovnik = new CenovnikZaDan(dan);
        }
        for (Artikal artikal : leftArticles) {
            BigDecimal price = artikal.getCena() == null ? BigDecimal.ZERO : BigDecimal.valueOf(artikal.getCena());
            cenovnik.getCene().add(new CenaZaDan(artikal, price, cenovnik));
        }
        cenovnik.setZakljucen(Boolean.TRUE);
        this.czdDAO.persistInSingleton(cenovnik);
    }

    protected boolean dateAfterLastClosedPriceList(Calendar date) {
        CenovnikZaDan lastCenovnikZaDan = null;
        try {
            lastCenovnikZaDan = this.czdDAO.findLastCenovnikZakljucenTrueNoFetchCene();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return lastCenovnikZaDan == null || lastCenovnikZaDan.getZaDan().compareTo(date) < 0;
    }

    public void zakljuciCenovnikZaDan(Date dan) {
        Calendar date = Calendar.getInstance();
        date.setTime(dan);
        this.zakljuciCenovnikZaDan(date);
    }
}

