/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.backup;

import com.dev63.restoran.backup.MySQLBackupException;
import com.dev63.restoran.backup.MySQLBackupParams;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import swt.proba.EnvTEst;

public class MySQLBackup {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void backup(MySQLBackupParams params) throws IllegalArgumentException, MySQLBackupException {
        if (params == null) {
            throw new IllegalArgumentException("MySQL backup params cannot be null");
        }
        LinkedList<String> cmd = new LinkedList<String>();
        cmd.add("mysqldump --routines");
        if (params.getHost() != null && !params.getHost().isEmpty()) {
            String[] hostParts = params.getHost().split(":");
            if (hostParts.length > 1) {
                if (hostParts.length != 2) throw new IllegalArgumentException(MessageFormat.format("Host with value {0} is invalid because it contains more than one colon (:) character", params.getHost()));
                cmd.add("-h" + hostParts[0]);
                cmd.add("-P" + hostParts[1]);
            } else {
                cmd.add("-h" + hostParts[0]);
            }
        }
        if (params.getUsername() != null && !params.getUsername().isEmpty()) {
            cmd.add("-u" + params.getUsername());
            if (params.getPassword() != null && !params.getPassword().isEmpty()) {
                cmd.add("-p" + params.getPassword());
            }
        }
        if (params.getSchemaName() != null && !params.getSchemaName().isEmpty()) {
            cmd.add(params.getSchemaName());
        } else {
            cmd.add("restoran");
        }
        System.out.println(cmd);
        File output = params.getFilePath() != null && !params.getFilePath().isEmpty() ? new File(params.getFilePath()) : new File("C:\\Barmaster\\Backup\\restoran" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + ".sql");
        output.mkdir();
        System.out.println(output);
        if (!(output.getParentFile() == null || output.getParentFile().exists() && output.getParentFile().isDirectory() || output.getParentFile().mkdirs())) {
            throw new MySQLBackupException(MessageFormat.format("Output file parent dir with path {0} doesn't exist and could not be created", output.getParentFile().getAbsolutePath()));
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        try {
            File tempOutput = File.createTempFile("MSB", ".sql.tmp");
            Process backup = pb.redirectOutput(tempOutput).command(cmd).start();
            int exitValue = backup.waitFor();
            if (exitValue == 0) {
                if (tempOutput.renameTo(output)) return;
                Logger.getLogger(MySQLBackup.class.getName()).log(Level.WARNING, "Preimenovanje BU fajla neuspesno! Temp fajl ostao na lokaciji{0}", tempOutput.getAbsolutePath());
                return;
            }
            tempOutput.delete();
            InputStream errorStream = backup.getErrorStream();
            BufferedReader r = new BufferedReader(new InputStreamReader(errorStream));
            String errorMessage = "";
            String temp = r.readLine();
            while (temp != null) {
                errorMessage = errorMessage + temp;
                temp = r.readLine();
                if (temp == null) continue;
                errorMessage = errorMessage + System.lineSeparator();
            }
            throw new MySQLBackupException(MessageFormat.format("MySQLDump process failed with exitValue = {0} and error message:\n{1}", exitValue, errorMessage));
        }
        catch (InterruptedException ex) {
            Logger.getLogger(EnvTEst.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        catch (IOException ex) {
            throw new MySQLBackupException("MySQLDump process failed with IOException", ex);
        }
    }
}

