/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.backup;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.backup.MySQLBackupException;
import com.dev63.restoran.backup.MySQLBackupParams;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.OptionBO;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BackUp {
    static Shell shelll;
    private final String host = BMTerminalSettings.getSetting(OptionBO.ADRESA).stringValue();
    private final String user = BMTerminalSettings.getSetting(OptionBO.USER).stringValue();
    private final String pass = BMTerminalSettings.getSetting(OptionBO.PASS).stringValue();
    private final String filePath = BMTerminalSettings.getSetting(OptionBO.BACKUP_PUTANJA).stringValue();
    private final String schemaName = BMTerminalSettings.getSetting(OptionBO.BAZA).stringValue();
    private String preduzece;

    public static synchronized boolean makeBackUp(Shell shell, RestoranServer server, File dir) {
        boolean[] success = new boolean[]{false};
        if (shell == null || shell.isDisposed()) {
            shell = Display.getCurrent().getActiveShell();
        }
        shelll = shell;
        if (dir == null) {
            DirectoryDialog dd = new DirectoryDialog(shell, 4);
            dd.setMessage("Izaberite folder");
            String path = dd.open();
            if (path == null) {
                return false;
            }
            dir = new File(path);
        }
        File buDir = dir;
        Date tDate = new Date();
        Date datum = tDate;
        if (datum != null) {
            BackUp rb = new BackUp();
            try {
                success[0] = rb.doBackupToDir(buDir, server);
            }
            catch (Exception ex) {
                Logger.getLogger(BackUp.class.getName()).warning("Backup neuspesan, procedura nastavljena bez backupa!!!");
            }
        }
        return success[0];
    }

    public boolean doBackupToDir(File dir, RestoranServer server) throws Exception {
        boolean success = false;
        this.preduzece = server.getSetting(Option.OBJEKAT_NAZIV).stringValue();
        if (dir == null) {
            dir = new File(this.filePath);
        }
        try {
            String buPath = new File(dir, "restoran" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date())).getAbsolutePath();
            this.backup(new MySQLBackupParams(this.host, this.user, this.pass, this.schemaName, buPath), this.preduzece);
            success = true;
        }
        catch (Exception e) {
            Logger.getLogger(BackUp.class.getName()).log(Level.SEVERE, "Greska kod iniciranja backupa baze", e);
            throw e;
        }
        return success;
    }

    public synchronized void backup(MySQLBackupParams params, String preduzece) throws IllegalArgumentException, MySQLBackupException {
        File output = params.getFilePath() != null && !params.getFilePath().isEmpty() ? new File(params.getFilePath()) : new File("C:\\Barmaster\\Backup\\restoran" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + ".sql");
        output.mkdir();
        String savePath = "\"" + output + "\\" + preduzece.toUpperCase() + "backup.sql\"";
        String command = "mysqldump -u " + params.getUsername() + " -p" + params.getPassword() + " " + params.getSchemaName() + " -r " + savePath;
        System.out.println(command);
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", command});
            int processComplete = p.waitFor();
            if (processComplete == 0) {
                Konstante.getPoruka3(shelll, "Uspesno kreirana kopija baze u folderu \r\n" + params.getFilePath());
                System.out.println("Backup created successfully");
            } else {
                Konstante.getPoruka3(shelll, "Nije kreirana kopija baze");
                System.out.println("Could not create the backup");
            }
        }
        catch (IOException | InterruptedException ex) {
            ex.printStackTrace();
        }
    }
}

