/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.backoffice.rokovnik;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Rokovnik;
import com.dev63.restoran.model.RokovnikTipUnosa;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.sistem.BarmasterEmailer;
import com.dev63.restoran.swt.resources.FontCache;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ZakljucenjeRokovnikUnos {
    private Shell shell;
    private Shell parent;
    private GridLayout mainGl;
    private Text comment;
    private Text emails;
    private Font labelFont;
    private String charsLeft;
    private Label lCharsLeft;
    private int maxChars = 1024;
    private boolean forwarding = false;
    private Restoran restoran;
    private RestoranServer server;
    private static final Logger log = Logger.getLogger(ZakljucenjeRokovnikUnos.class.getName());
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private boolean potvrdjen = false;
    private String adrese;
    private Setting sAdrese;

    public ZakljucenjeRokovnikUnos(Shell s, Restoran rest) {
        this.restoran = rest;
        this.server = this.restoran.getServer();
        this.parent = s;
        this.adrese = "";
        try {
            this.sAdrese = this.server.getSetting(Option.BM_EMAILER_ADRESE_PRIMAOCA);
            this.adrese = this.sAdrese.stringValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.shell = new Shell(this.parent, 34912);
        this.shell.setBackgroundMode(1);
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_ZAKLJUCENJE_DANA"), new Object[0]));
        this.mainGl = new GridLayout();
        this.mainGl.numColumns = 2;
        this.mainGl.makeColumnsEqualWidth = false;
        this.shell.setLayout((Layout)this.mainGl);
        this.labelFont = FontCache.getFont("Arial", 10, 0);
        this.charsLeft = String.format(this.barmasterText.getString("TEXT_PREOSTALO_KARAKTERA"), new Object[0]);
        Group group = new Group((Composite)this.shell, 4);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText(this.barmasterText.getString("TEXT_NAPOMENA"));
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        group.setFont(this.labelFont);
        GridData gdLbl = new GridData(130);
        Label l1 = new Label((Composite)group, 131072);
        l1.setText(this.barmasterText.getString("TEXT_TEKST_NAPOMENE") + ":");
        l1.setLayoutData((Object)gdLbl);
        l1.setFont(this.labelFont);
        GridData gdComment = new GridData(1844);
        this.comment = new Text((Composite)group, 2114);
        this.comment.setFont(this.labelFont);
        this.comment.setLayoutData((Object)gdComment);
        this.comment.setTextLimit(this.maxChars);
        Label lEmpty = new Label((Composite)group, 0);
        this.lCharsLeft = new Label((Composite)group, 131072);
        this.lCharsLeft.setLayoutData((Object)new GridData(640));
        this.lCharsLeft.setText(this.charsLeft + ": " + (this.maxChars - this.comment.getText().length()));
        this.comment.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZakljucenjeRokovnikUnos.this.lCharsLeft.setText(ZakljucenjeRokovnikUnos.this.charsLeft + ": " + (ZakljucenjeRokovnikUnos.this.maxChars - ZakljucenjeRokovnikUnos.this.comment.getText().length()));
            }
        });
        Group emailG = new Group((Composite)this.shell, 4);
        emailG.setFont(this.labelFont);
        emailG.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        emailG.setText(String.format(this.barmasterText.getString("TEXT_PROSLEDJIVANJE"), new Object[0]));
        emailG.setLayout((Layout)new GridLayout(2, false));
        Button bForward = new Button((Composite)emailG, 32);
        bForward.setText(String.format(this.barmasterText.getString("TEXT_PROSLEDI_NAPOMENU_NA_EMAIL_ADRESE"), new Object[0]));
        bForward.setSelection(this.forwarding);
        bForward.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        final Label lEmails = new Label((Composite)emailG, 131072);
        lEmails.setText(String.format(this.barmasterText.getString("TEXT_EMAIL_ADRESE"), new Object[0]) + ":");
        lEmails.setLayoutData((Object)new GridData(131072, 1, false, false, 1, 1));
        lEmails.setFont(this.labelFont);
        lEmails.setEnabled(this.forwarding);
        this.emails = new Text((Composite)emailG, 2114);
        this.emails.setFont(this.labelFont);
        this.emails.setEnabled(this.forwarding);
        this.emails.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.emails.setToolTipText(String.format(this.barmasterText.getString("PORUKA_UNESITE_EMAIL_ADRESE_RAZDVOJENE_ZNAKOM"), new Object[0]));
        this.emails.setText(this.adrese);
        bForward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                ZakljucenjeRokovnikUnos.this.forwarding = b.getSelection();
                lEmails.setEnabled(ZakljucenjeRokovnikUnos.this.forwarding);
                ZakljucenjeRokovnikUnos.this.emails.setEnabled(ZakljucenjeRokovnikUnos.this.forwarding);
            }
        });
        Button bCancel = new Button((Composite)this.shell, 8);
        bCancel.setText(String.format(this.barmasterText.getString("TEXT_OTKAZI"), new Object[0]));
        GridData gdBut = new GridData(0x1000000, 0x1000000, true, false, 1, 1);
        gdBut.heightHint = 50;
        gdBut.widthHint = 200;
        bCancel.setLayoutData((Object)gdBut);
        bCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZakljucenjeRokovnikUnos.this.shell.close();
            }
        });
        Button bOk = new Button((Composite)this.shell, 8);
        bOk.setText(String.format(this.barmasterText.getString("TEXT_POTVRDI"), new Object[0]));
        bOk.setLayoutData((Object)gdBut);
        bOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ZakljucenjeRokovnikUnos.this.comment.getText().length() > 0) {
                    String[] adresses = ZakljucenjeRokovnikUnos.this.emails.getText().split(";");
                    for (int i = 0; i < adresses.length; ++i) {
                        String string = adresses[i];
                        adresses[i] = string.trim();
                    }
                    String subject = String.format(ZakljucenjeRokovnikUnos.this.barmasterText.getString("TEXT_ZAKLJU\u010cENJE_DANA"), new Object[0]) + StatLogic.getDateString(new Date());
                    Date d = new Date();
                    String user = ZakljucenjeRokovnikUnos.this.server.getUser() == null ? String.format(ZakljucenjeRokovnikUnos.this.barmasterText.getString("TEXT_BARMASTER"), new Object[0]) : ZakljucenjeRokovnikUnos.this.server.getUser().getName();
                    Rokovnik rok = new Rokovnik(d, d, d, user, RokovnikTipUnosa.ZAKLJUCENJE_DANA, false, ZakljucenjeRokovnikUnos.this.comment.getText() == null ? "" : ZakljucenjeRokovnikUnos.this.comment.getText());
                    try {
                        ZakljucenjeRokovnikUnos.this.server.addRokovnik(rok);
                    }
                    catch (Exception ex) {
                        log.log(Level.WARNING, ex.getMessage(), ex);
                        ZakljucenjeRokovnikUnos.this.potvrdjen = false;
                        return;
                    }
                    if (ZakljucenjeRokovnikUnos.this.forwarding) {
                        String commentum = ZakljucenjeRokovnikUnos.this.comment.getText() + "\n\n" + String.format(ZakljucenjeRokovnikUnos.this.barmasterText.getString("TEXT_UNEO"), new Object[0]) + ": " + user;
                        if (ZakljucenjeRokovnikUnos.this.sAdrese == null) {
                            ZakljucenjeRokovnikUnos.this.sAdrese = new Setting();
                            ZakljucenjeRokovnikUnos.this.sAdrese.setName(Option.BM_EMAILER_ADRESE_PRIMAOCA.getName());
                        }
                        ZakljucenjeRokovnikUnos.this.sAdrese.setActual(ZakljucenjeRokovnikUnos.this.emails.getText());
                        ZakljucenjeRokovnikUnos.this.server.changeSetting(ZakljucenjeRokovnikUnos.this.sAdrese);
                        new BarmasterEmailer(ZakljucenjeRokovnikUnos.this.restoran).sendEmail(adresses, subject, commentum);
                    }
                }
                ZakljucenjeRokovnikUnos.this.potvrdjen = true;
                ZakljucenjeRokovnikUnos.this.shell.close();
            }
        });
        this.shell.setSize(new Point(600, 400));
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    public static void main(String[] args) {
        Display d = new Display();
        d.disposeExec(new Runnable(){

            @Override
            public void run() {
                FontCache.dispose();
            }
        });
        Shell s = new Shell(d, 1264);
        s.pack();
        s.open();
        new ZakljucenjeRokovnikUnos(s, null);
        while (!s.isDisposed()) {
            if (d.readAndDispatch()) continue;
            d.sleep();
        }
        d.dispose();
    }

    public boolean isPotvrdjen() {
        return this.potvrdjen;
    }
}

